(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[   1265076,      24888]
NotebookOptionsPosition[   1237057,      24568]
NotebookOutlinePosition[   1237477,      24585]
CellTagsIndexPosition[   1237434,      24582]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Include", " ", "FEM", " ", "tools"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"<<", "NDSolve`FEM`"}], "\[IndentingNewLine]", 
   RowBox[{"<<", "NumericalDifferentialEquationAnalysis`"}], "\[IndentingNewLine]", 
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
   "Get", "[", \
"\"\</home/diogo/Dropbox/mathematica/Plasticidade/CPP/mohr-coulomb-perf.m\>\"",
     "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IntegrationRule", "[", 
      RowBox[{"order_", ",", "dim_"}], "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"pts", ",", "ws", ",", "matpsts"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"dim", "==", "1"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"pts", "=", 
            RowBox[{"ElementIntegrationPoints", "[", 
             RowBox[{"LineElement", ",", 
              RowBox[{"order", "+", "1"}]}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"ws", "=", 
            RowBox[{"ElementIntegrationWeights", "[", 
             RowBox[{"LineElement", ",", 
              RowBox[{"order", "+", "1"}]}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"matpsts", "=", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"pts", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "0", ",", "0", ",", 
                RowBox[{"ws", "[", 
                 RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", 
                RowBox[{"Length", "[", "ws", "]"}]}], "}"}]}], "]"}]}], 
           ";"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"dim", "==", "2"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"pts", "=", 
            RowBox[{"ElementIntegrationPoints", "[", 
             RowBox[{"TriangleElement", ",", 
              RowBox[{"order", "+", "3"}]}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"ws", "=", 
            RowBox[{"ElementIntegrationWeights", "[", 
             RowBox[{"TriangleElement", ",", 
              RowBox[{"order", "+", "3"}]}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"matpsts", "=", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"pts", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
                RowBox[{"pts", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", "0", ",", 
                RowBox[{"ws", "[", 
                 RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", 
                RowBox[{"Length", "[", "ws", "]"}]}], "}"}]}], "]"}]}], 
           ";"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        "matpsts"}]}], "\[IndentingNewLine]", "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"ComputeShape", "[", 
      RowBox[{"order_", ",", "dim_"}], "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"psis", ",", "dpsis", ",", "xi", ",", "eta", ",", "zeta"}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"!", 
           RowBox[{"MemberQ", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "dim"}], "]"}]}],
           ",", 
          RowBox[{
           RowBox[{
           "Print", 
            "[", "\"\<Erro: 'dim' inv\[AAcute]lido. Dimens\[OTilde]es v\
\[AAcute]lidas: 1, 2 ou 3.\>\"", "]"}], ";", 
           RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"dim", "==", "1"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"psis", "=", 
            RowBox[{
             RowBox[{"ElementShapeFunction", "[", 
              RowBox[{"LineElement", ",", "order"}], "]"}], "[", "xi", 
             "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"dpsis", "=", 
            RowBox[{"D", "[", 
             RowBox[{"psis", ",", "xi"}], "]"}]}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"dim", "==", "2"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"psis", "=", 
            RowBox[{
             RowBox[{"ElementShapeFunction", "[", 
              RowBox[{"TriangleElement", ",", "order"}], "]"}], "[", 
             RowBox[{"xi", ",", "eta"}], "]"}]}], ";", "\[IndentingNewLine]", 
           
           RowBox[{"dpsis", "=", 
            RowBox[{"Transpose", "[", 
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"D", "[", 
                  RowBox[{
                   RowBox[{"psis", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], ",", "xi"}], "]"}], ",", 
                 RowBox[{"D", "[", 
                  RowBox[{
                   RowBox[{"psis", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], ",", "eta"}], "]"}]}], 
                "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"i", ",", 
                 RowBox[{"Length", "[", "psis", "]"}]}], "}"}]}], "]"}], 
             "]"}]}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"psis", ",", "dpsis"}], "}"}]}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ComputeBN", "[", 
      RowBox[{"psis_", ",", "GradPhi_"}], "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"nnodes", "=", 
          RowBox[{"Length", "[", "psis", "]"}]}], ",", "B", ",", "NShapes"}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"B", "=", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Flatten", "[", 
            RowBox[{
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"GradPhi", "[", 
                  RowBox[{"[", 
                   RowBox[{"1", ",", "i"}], "]"}], "]"}], ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"i", ",", "nnodes"}], "}"}]}], "]"}], ",", "1"}], 
            "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Flatten", "[", 
            RowBox[{
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", 
                 RowBox[{"GradPhi", "[", 
                  RowBox[{"[", 
                   RowBox[{"2", ",", "i"}], "]"}], "]"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"i", ",", "nnodes"}], "}"}]}], "]"}], ",", "1"}], 
            "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Flatten", "[", 
            RowBox[{
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"GradPhi", "[", 
                  RowBox[{"[", 
                   RowBox[{"2", ",", "i"}], "]"}], "]"}], ",", 
                 RowBox[{"GradPhi", "[", 
                  RowBox[{"[", 
                   RowBox[{"1", ",", "i"}], "]"}], "]"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"i", ",", "nnodes"}], "}"}]}], "]"}], ",", "1"}], 
            "]"}]}], "\[IndentingNewLine]", "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"NShapes", "=", "\[IndentingNewLine]", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Flatten", "[", 
            RowBox[{
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"psis", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"i", ",", "nnodes"}], "}"}]}], "]"}], ",", "1"}], 
            "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Flatten", "[", 
            RowBox[{
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", 
                 RowBox[{"psis", "[", 
                  RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"i", ",", "nnodes"}], "}"}]}], "]"}], ",", "1"}], 
            "]"}]}], "\[IndentingNewLine]", "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"B", ",", "NShapes"}], "}"}]}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"ApplyStrainComputeSigmaDepInt", "[", 
      RowBox[{"epst_", ",", " ", "epsp_"}], "]"}], " ", ":=", "\n", "  ", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"epbarint", ",", " ", 
         RowBox[{"epbarn1", " ", "=", " ", "0"}], ",", " ", "val", ",", " ", 
         "epspr", ",", " ", "cmat", ",", "epstint", ",", " ", "epspint", ",", 
         "sigprojvoigth", ",", " ", "Dep", ",", " ", "Dep2D", ",", " ", 
         "sigproj2D", ",", " ", "epse2D", ",", "sigproj3D", ",", " ", "Dep3D",
          ",", " ", "epse3D", ",", "permOut"}], "}"}], ",", "\n", "   ", 
       RowBox[{
        RowBox[{"epstint", "  ", "=", " ", "epst"}], ";", "\n", "   ", 
        RowBox[{"epspint", "  ", "=", " ", "epsp"}], ";", "\n", "   ", 
        RowBox[{"epbarint", " ", "=", " ", "0"}], ";", "\n", "    ", 
        RowBox[{"epstint", " ", "=", " ", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"epst", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
            RowBox[{"epst", "[", 
             RowBox[{"[", "3", "]"}], "]"}], ",", " ", "0.", ",", " ", 
            RowBox[{"epst", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", " ", "0.", ",", " ", "0."}],
            "}"}], "//", "N"}]}], ";", "\n", "    ", 
        RowBox[{"epspint", " ", "=", " ", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"epsp", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
            RowBox[{"epsp", "[", 
             RowBox[{"[", "3", "]"}], "]"}], ",", " ", "0.", ",", " ", 
            RowBox[{"epsp", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", " ", "0.", ",", " ", "0."}],
            "}"}], "//", "N"}]}], ";", "\n", "   ", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "sigprojvoigth", ",", " ", "Dep", ",", " ", "epspr", ",", " ", 
           "epbarn1"}], "}"}], " ", "=", 
         RowBox[{"ApplyStrainComputeSigmaDep", "[", 
          RowBox[{
          "epstint", ",", " ", "epspint", ",", " ", "epbarint", ",", " ", 
           "substtotal"}], "]"}]}], ";", "\n", "    ", 
        RowBox[{"sigproj2D", " ", "=", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"sigprojvoigth", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
           RowBox[{"sigprojvoigth", "[", 
            RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
           RowBox[{"sigprojvoigth", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], ";", "\n", "    ", 
        RowBox[{"epse2D", "    ", "=", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"epspr", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", "         ", 
           RowBox[{"epspr", "[", 
            RowBox[{"[", "4", "]"}], "]"}], ",", "         ", 
           RowBox[{"epspr", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], ";", "\n", "    ", 
        RowBox[{"Dep2D", " ", "=", " ", 
         RowBox[{"{", "\n", "      ", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Dep", "[", 
              RowBox[{"[", 
               RowBox[{"1", ",", " ", "1"}], "]"}], "]"}], ",", " ", 
             RowBox[{"Dep", "[", 
              RowBox[{"[", 
               RowBox[{"1", ",", " ", "4"}], "]"}], "]"}], ",", " ", 
             RowBox[{"Dep", "[", 
              RowBox[{"[", 
               RowBox[{"1", ",", " ", "2"}], "]"}], "]"}]}], "}"}], ",", "\n",
            "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Dep", "[", 
              RowBox[{"[", 
               RowBox[{"4", ",", " ", "1"}], "]"}], "]"}], ",", " ", 
             RowBox[{"Dep", "[", 
              RowBox[{"[", 
               RowBox[{"4", ",", " ", "4"}], "]"}], "]"}], ",", " ", 
             RowBox[{"Dep", "[", 
              RowBox[{"[", 
               RowBox[{"4", ",", " ", "2"}], "]"}], "]"}]}], "}"}], ",", "\n",
            "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Dep", "[", 
              RowBox[{"[", 
               RowBox[{"2", ",", " ", "1"}], "]"}], "]"}], ",", " ", 
             RowBox[{"Dep", "[", 
              RowBox[{"[", 
               RowBox[{"2", ",", " ", "4"}], "]"}], "]"}], ",", " ", 
             RowBox[{"Dep", "[", 
              RowBox[{"[", 
               RowBox[{"2", ",", " ", "2"}], "]"}], "]"}]}], "}"}]}], "\n", 
          "      ", "}"}]}], ";", "\n", "    ", 
        RowBox[{"val", " ", "=", " ", 
         RowBox[{"{", 
          RowBox[{"sigproj2D", ",", " ", "Dep2D", ",", " ", "epse2D"}], 
          "}"}]}], ";", "\n", "   ", 
        RowBox[{"Return", "[", "val", "]"}], ";"}]}], "\n", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ContributePlasticity", "[", "data_", "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "NShapes", ",", "gamma", ",", "psis", ",", "GradPsi", ",", "Jacs", ",",
          "x", ",", "y", ",", "nnodes", ",", "GradPhi", ",", "DetJ", ",", 
         "InvJac", ",", "B", ",", "C", ",", "ek", ",", "ef", ",", "elcoords", 
         ",", "weight", ",", "stress", ",", "Dep", ",", "eldisplacement", ",",
          "gradu", ",", "epst", ",", "epsp", ",", "epse", ",", "epspeint", ",",
          "ef1", ",", "ef2", ",", "xycoords"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "psis", ",", "GradPsi", ",", "elcoords", ",", "weight", ",", 
           "eldisplacement"}], "}"}], "=", "data"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Jacs", "=", 
         RowBox[{"GradPsi", ".", "elcoords"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"nnodes", "=", 
         RowBox[{"Length", "[", "psis", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"DetJ", "=", 
         RowBox[{"Det", "[", "Jacs", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"InvJac", "=", 
         RowBox[{"Inverse", "[", "Jacs", "]"}]}], ";", "\[IndentingNewLine]", 
        
        RowBox[{"GradPhi", "=", 
         RowBox[{"InvJac", ".", "GradPsi"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"xycoords", "=", 
         RowBox[{"psis", ".", "elcoords"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"B", ",", "NShapes"}], "}"}], "=", 
         RowBox[{"ComputeBN", "[", 
          RowBox[{"psis", ",", "GradPhi"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"gradu", "=", 
         RowBox[{"GradPhi", ".", "eldisplacement"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"epst", "=", 
         RowBox[{"CoumpteStrain", "[", "gradu", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"epsp", "=", 
         RowBox[{"epspsolitern", "[", 
          RowBox[{"[", "globalcounter", "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"stress", ",", "Dep", ",", "epse"}], "}"}], "=", 
         RowBox[{"ApplyStrainComputeSigmaDepInt", "[", 
          RowBox[{"epst", ",", "epsp"}], "]"}]}], ";", "\[IndentingNewLine]", 
        
        RowBox[{"epspeint", "=", 
         RowBox[{"epst", "-", "epse"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"epspvec", "[", 
          RowBox[{"[", "globalcounter", "]"}], "]"}], "=", "epspeint"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"globalcounter", "++"}], ";", "\[IndentingNewLine]", 
        RowBox[{"ek", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Transpose", "[", "B", "]"}], ".", "Dep", ".", "B"}], 
           ")"}], "weight", " ", "DetJ"}]}], " ", ";", "\[IndentingNewLine]", 
        
        RowBox[{"ef1", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Transpose", "[", "B", "]"}], ".", "stress"}], ")"}], " ",
           "weight", " ", "DetJ"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"ef2", "=", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Transpose", "[", "NShapes", "]"}], ".", 
            RowBox[{"(", "bodyforce", ")"}]}], ")"}], " ", "weight", " ", 
          "DetJ"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"ek", ",", "ef1", ",", "ef2"}], "}"}], "//", "N"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CoumpteStrain", "[", "gradprevsol_", "]"}], ":=", 
    RowBox[{"Block", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "val", ",", "eyz", ",", "exz", ",", "ez", ",", "dvdz", ",", "dudz", ",",
         "dudx", ",", "dudy", ",", "dvdx", ",", "dvdy", ",", 
        RowBox[{"gradu", "=", "gradprevsol"}], ",", "strain", ",", "ex", ",", 
        "ey", ",", "exy", ",", "ux", ",", "uy", ",", "kk", ",", "dwdx", ",", 
        "dwdy", ",", "dwdz"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"strain", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"gradu", "+", 
           RowBox[{"Transpose", "[", "gradu", "]"}]}], ")"}], "/", "2"}]}], ";",
        "\[IndentingNewLine]", 
       RowBox[{"val", "=", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"strain", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
          RowBox[{"strain", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "2"}], "]"}], "]"}], ",", 
          RowBox[{"2", 
           RowBox[{"strain", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "2"}], "]"}], "]"}]}]}], "}"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "val", "]"}], ";"}]}], "\[IndentingNewLine]", 
     "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CalcStiffPlasticity", "[", 
      RowBox[{"order_", ",", "elcoords_", ",", "eldisplacement_"}], "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "zeta", ",", "nnodes", ",", "ek", ",", "ef", ",", "intrule", ",", 
         "psis", ",", "GradPsi", ",", "xi", ",", "eta", ",", "data", ",", "w",
          ",", "npts", ",", "ef1", ",", "ef2", ",", "ipt"}], "}"}], ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"nnodes", "=", 
         RowBox[{"Length", "[", "elcoords", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"ek", "=", 
         RowBox[{"Table", "[", 
          RowBox[{"0.", ",", 
           RowBox[{"{", 
            RowBox[{"nnodes", " ", "dim"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"nnodes", " ", "dim"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"ef", "=", 
         RowBox[{"Table", "[", 
          RowBox[{"0.", ",", 
           RowBox[{"{", 
            RowBox[{"nnodes", " ", "dim"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"ef1", "=", 
         RowBox[{"Table", "[", 
          RowBox[{"0.", ",", 
           RowBox[{"{", 
            RowBox[{"nnodes", " ", "dim"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"ef2", "=", 
         RowBox[{"Table", "[", 
          RowBox[{"0.", ",", 
           RowBox[{"{", 
            RowBox[{"nnodes", " ", "dim"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"intrule", "=", 
         RowBox[{"IntegrationRule", "[", 
          RowBox[{"order", ",", "dim"}], "]"}]}], ";", "\[IndentingNewLine]", 
        
        RowBox[{
         RowBox[{"{", 
          RowBox[{"psis", ",", "GradPsi"}], "}"}], "=", 
         RowBox[{"ComputeShape", "[", 
          RowBox[{"order", ",", "dim"}], "]"}]}], ";", "\[IndentingNewLine]", 
        
        RowBox[{"npts", "=", 
         RowBox[{"Length", "[", "intrule", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"ipt", "=", "1"}], ",", 
          RowBox[{"ipt", "<=", "npts"}], ",", 
          RowBox[{"ipt", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{"xi", ",", "eta", ",", "zeta", ",", "w"}], "}"}], "=", 
            RowBox[{"intrule", "[", 
             RowBox[{"[", "ipt", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"data", "=", 
            RowBox[{"{", 
             RowBox[{
             "psis", ",", "GradPsi", ",", "elcoords", ",", "w", ",", 
              "eldisplacement"}], "}"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"ek", ",", "ef1", ",", "ef2"}], "}"}], "+=", 
            RowBox[{"ContributePlasticity", "[", "data", "]"}]}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"ek", ",", "ef1", ",", "ef2"}], "}"}], "//", "N"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"AssemblePlasticity", "[", 
      RowBox[{"mesh_", ",", "displacement_"}], "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "elcoords", ",", "ibcel", ",", "nebcels", ",", "bcelementsids", ",", 
         "ibc", ",", "nbcconds", ",", "order", ",", "hhatv", ",", "allcoords",
          ",", "nodes", ",", "topol", ",", "inode", ",", "eltopology", ",", 
         "nels", ",", "rows", ",", "sz", ",", "cols", ",", "Kglob", ",", 
         "Fglob1", ",", "Fglob2", ",", "co", ",", "Ke", ",", "Fe", ",", "fu", 
         ",", "rowglob", ",", "colglob", ",", "Fglob", ",", "uglob", ",", 
         "ek1", ",", "ef1", ",", "ef2"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"globalcounter", "=", "1"}], ";", "\[IndentingNewLine]", 
        RowBox[{"nodes", "=", 
         RowBox[{"mesh", "[", "\"\<Coordinates\>\"", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"order", "=", 
         RowBox[{"mesh", "[", "\"\<MeshOrder\>\"", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"topol", "=", 
         RowBox[{
          RowBox[{"mesh", "[", "\"\<MeshElements\>\"", "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"allcoords", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"nodes", "[", 
            RowBox[{"[", 
             RowBox[{"topol", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", 
             RowBox[{"Length", "[", "topol", "]"}]}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"nels", "=", 
         RowBox[{"Length", "[", "allcoords", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"rows", "=", 
         RowBox[{"Length", "[", 
          RowBox[{"allcoords", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"sz", "=", 
         RowBox[{"dim", " ", 
          RowBox[{"Length", "[", "nodes", "]"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"cols", "=", "rows"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Kglob", "=", 
         RowBox[{"Table", "[", 
          RowBox[{"0.", ",", 
           RowBox[{"{", "sz", "}"}], ",", 
           RowBox[{"{", "sz", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Fglob", "=", 
         RowBox[{"Table", "[", 
          RowBox[{"0.", ",", 
           RowBox[{"{", "sz", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Fglob1", "=", 
         RowBox[{"Table", "[", 
          RowBox[{"0.", ",", 
           RowBox[{"{", "sz", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Fglob2", "=", 
         RowBox[{"Table", "[", 
          RowBox[{"0.", ",", 
           RowBox[{"{", "sz", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"uglob", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"displacement", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"dim", " ", 
                   RowBox[{"topol", "[", 
                    RowBox[{"[", 
                    RowBox[{"k", ",", "j"}], "]"}], "]"}]}], " ", "-", "1"}], 
                 "]"}], "]"}], ",", 
               RowBox[{"displacement", "[", 
                RowBox[{"[", 
                 RowBox[{"dim", " ", 
                  RowBox[{"topol", "[", 
                   RowBox[{"[", 
                    RowBox[{"k", ",", "j"}], "]"}], "]"}]}], " ", "]"}], 
                "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"j", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{"topol", "[", 
                 RowBox[{"[", "k", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"k", ",", "1", ",", "nels"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"k", "=", "1"}], ",", 
          RowBox[{"k", "<=", "nels"}], ",", 
          RowBox[{"k", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"co", "=", 
            RowBox[{
             RowBox[{"allcoords", "[", 
              RowBox[{"[", "k", "]"}], "]"}], "//", "N"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"eltopology", "=", 
            RowBox[{"topol", "[", 
             RowBox[{"[", "k", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Ke", ",", "ef1", ",", "ef2"}], "}"}], "=", 
            RowBox[{"CalcStiffPlasticity", "[", 
             RowBox[{"order", ",", "co", ",", 
              RowBox[{"uglob", "[", 
               RowBox[{"[", "k", "]"}], "]"}]}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"For", "[", 
            RowBox[{
             RowBox[{"i", "=", "1"}], ",", 
             RowBox[{"i", "<=", "rows"}], ",", 
             RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"rowglob", "=", 
               RowBox[{"topol", "[", 
                RowBox[{"[", 
                 RowBox[{"k", ",", "i"}], "]"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"For", "[", 
               RowBox[{
                RowBox[{"j", "=", "1"}], ",", 
                RowBox[{"j", "<=", "rows"}], ",", 
                RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"colglob", "=", 
                  RowBox[{"topol", "[", 
                   RowBox[{"[", 
                    RowBox[{"k", ",", "j"}], "]"}], "]"}]}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"Table", "[", 
                  RowBox[{
                   RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Kglob", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"dim", " ", "rowglob"}], "-", "kk"}], ",", 
                    RowBox[{
                    RowBox[{"dim", " ", "colglob"}], "-", "ll"}]}], "]"}], 
                    "]"}], "+=", 
                    RowBox[{"Ke", "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"dim", " ", "i"}], "-", "kk"}], ",", 
                    RowBox[{
                    RowBox[{"dim", " ", "j"}], "-", "ll"}]}], "]"}], "]"}]}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"ll", ",", 
                    RowBox[{"dim", "-", "1"}], ",", "0", ",", 
                    RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"kk", ",", 
                    RowBox[{"dim", "-", "1"}], ",", "0", ",", 
                    RowBox[{"-", "1"}]}], "}"}]}], "]"}], ";"}]}], 
               "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"Fglob1", "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"dim", " ", "rowglob"}], "-", "ll"}], "]"}], 
                   "]"}], "+=", 
                  RowBox[{"ef1", "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"dim", " ", "i"}], "-", "ll"}], "]"}], "]"}]}], 
                 ";"}], ",", 
                RowBox[{"{", 
                 RowBox[{"ll", ",", 
                  RowBox[{"dim", "-", "1"}], ",", "0", ",", 
                  RowBox[{"-", "1"}]}], "}"}]}], "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"Fglob2", "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"dim", " ", "rowglob"}], "-", "ll"}], "]"}], 
                   "]"}], "+=", 
                  RowBox[{"ef2", "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"dim", " ", "i"}], "-", "ll"}], "]"}], "]"}]}], 
                 ";"}], ",", 
                RowBox[{"{", 
                 RowBox[{"ll", ",", 
                  RowBox[{"dim", "-", "1"}], ",", "0", ",", 
                  RowBox[{"-", "1"}]}], "}"}]}], "]"}], ";"}]}], 
            "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
         "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"Kglob", ",", "Fglob1", ",", "Fglob2"}], "}"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ImposeDirichlet", "[", 
      RowBox[{"K_", ",", "F_", ",", 
       RowBox[{"{", 
        RowBox[{"id_", ",", "dir_", ",", "val_"}], "}"}]}], "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Kg", "=", "K"}], ",", 
         RowBox[{"Fg", "=", "F"}], ",", "eq"}], "}"}], ",", 
       RowBox[{
        RowBox[{"eq", "=", 
         RowBox[{
          RowBox[{"dim", "*", 
           RowBox[{"(", 
            RowBox[{"id", "-", "1"}], ")"}]}], "+", "dir"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Fg", "-=", 
         RowBox[{"val", "*", 
          RowBox[{"Kg", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "eq"}], "]"}], "]"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Kg", "[", 
          RowBox[{"[", 
           RowBox[{"eq", ",", "All"}], "]"}], "]"}], "=", "0."}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Kg", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", "eq"}], "]"}], "]"}], "=", "0."}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Kg", "[", 
          RowBox[{"[", 
           RowBox[{"eq", ",", "eq"}], "]"}], "]"}], "=", "1."}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Fg", "[", 
          RowBox[{"[", "eq", "]"}], "]"}], "=", "val"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"Kg", ",", "Fg"}], "}"}]}]}], "\[IndentingNewLine]", "]"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ImposeDirichletList", "[", 
      RowBox[{"K_", ",", "F_", ",", 
       RowBox[{"{", 
        RowBox[{"idlist_", ",", "dir_", ",", "val_"}], "}"}]}], "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Kg", "=", "K"}], ",", 
         RowBox[{"Fg", "=", "F"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Do", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Kg", ",", "Fg"}], "}"}], "=", 
            RowBox[{"ImposeDirichlet", "[", 
             RowBox[{"Kg", ",", "Fg", ",", 
              RowBox[{"{", 
               RowBox[{"id", ",", "dir", ",", "val"}], "}"}]}], "]"}]}], 
           ";"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"id", ",", "idlist"}], "}"}]}], "\[IndentingNewLine]", 
         "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"Kg", ",", "Fg"}], "}"}]}]}], "\[IndentingNewLine]", "]"}]}],
     ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"ApplyNeumann", "[", 
      RowBox[{"mesh_", ",", "faceNodes_", ",", "loadFunc_"}], "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "xyPt", ",", "Fm", ",", "coords", ",", "order", ",", "psis", ",", 
         "GradPsi", ",", "intrule", ",", "npts", ",", "elCoords", ",", "xi", ",",
          "w", ",", "Jac", ",", "detJ", ",", "load", ",", "dof", ",", 
         "psiVals", ",", "gradVals"}], "}"}], ",", 
       RowBox[{
        RowBox[{"coords", "=", 
         RowBox[{"mesh", "[", "\"\<Coordinates\>\"", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Fm", "=", 
         RowBox[{"Table", "[", 
          RowBox[{"0.", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Length", "[", "coords", "]"}], "*", "dim"}], "}"}]}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"order", "=", 
         RowBox[{"mesh", "[", "\"\<MeshOrder\>\"", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"elCoords", "=", 
         RowBox[{"coords", "[", 
          RowBox[{"[", "faceNodes", "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"intrule", "=", 
         RowBox[{"IntegrationRule", "[", 
          RowBox[{"order", ",", 
           RowBox[{"dim", "-", "1"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"psis", ",", "GradPsi"}], "}"}], "=", 
         RowBox[{"ComputeShape", "[", 
          RowBox[{"order", ",", 
           RowBox[{"dim", "-", "1"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"npts", "=", 
         RowBox[{"Length", "[", "intrule", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Do", "[", 
         RowBox[{"(*", 
          RowBox[{
          "Ponto", " ", "e", " ", "peso", " ", "de", " ", 
           "integra\[CCedilla]\[ATilde]o"}], "*)"}], 
         RowBox[{
          RowBox[{
           RowBox[{"w", "=", 
            RowBox[{"intrule", "[", 
             RowBox[{"[", 
              RowBox[{"ipt", ",", 
               RowBox[{"-", "1"}]}], "]"}], "]"}]}], ";", 
           RowBox[{"(*", 
            RowBox[{
            "\[CapitalUAcute]ltimo", " ", "elemento", " ", "\[EAcute]", " ", 
             "o", " ", "peso"}], "*)"}], 
           RowBox[{"(*", 
            RowBox[{
            "Substituir", " ", "coordenada", " ", "param\[EAcute]trica"}], 
            "*)"}], 
           RowBox[{"psiVals", "=", 
            RowBox[{"psis", "/.", "  ", 
             RowBox[{"xi", "->", 
              RowBox[{"intrule", "[", 
               RowBox[{"[", 
                RowBox[{"ipt", ",", "1"}], "]"}], "]"}]}]}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"gradVals", "=", 
            RowBox[{"GradPsi", "/.", " ", 
             RowBox[{"xi", "->", 
              RowBox[{"intrule", "[", 
               RowBox[{"[", 
                RowBox[{"ipt", ",", "1"}], "]"}], "]"}]}]}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{"Jacobiano", " ", "1", "D"}], "*)"}], 
           RowBox[{"Jac", "=", 
            RowBox[{"gradVals", ".", "elCoords"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"detJ", "=", 
            RowBox[{"Norm", "[", "Jac", "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{"Ponto", " ", "f\[IAcute]sico"}], "*)"}], 
           RowBox[{"xyPt", "=", 
            RowBox[{"psiVals", ".", "elCoords"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"(*", "Carga", "*)"}], 
           RowBox[{"load", "=", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Head", "[", "loadFunc", "]"}], "===", "List"}], ",", 
              "loadFunc", ",", 
              RowBox[{"loadFunc", "[", "xyPt", "]"}]}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"(*", "Assemblar", "*)"}], 
           RowBox[{"Do", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"dof", "=", 
               RowBox[{
                RowBox[{"dim", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"faceNodes", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "-", "1"}], ")"}]}], "+", 
                "d"}]}], ";", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"Fm", "[", 
                RowBox[{"[", "dof", "]"}], "]"}], "+=", 
               RowBox[{
                RowBox[{"psiVals", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "*", 
                RowBox[{"load", "[", 
                 RowBox[{"[", "d", "]"}], "]"}], "*", "w", "*", "detJ"}]}], 
              ";"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", 
               RowBox[{"Length", "[", "faceNodes", "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"d", ",", "dim"}], "}"}]}], "]"}], ";"}], ",", 
          RowBox[{"{", 
           RowBox[{"ipt", ",", "npts"}], "}"}]}], "]"}], ";", 
        "\[IndentingNewLine]", "Fm"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ApplyNeumannByMarker", "[", 
      RowBox[{"mesh_", ",", "marker_", ",", "loadFunc_"}], "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "Fm", ",", "bcels", ",", "indices", ",", "elements", ",", "faceNodes",
          ",", "coords"}], "}"}], ",", 
       RowBox[{
        RowBox[{"coords", "=", 
         RowBox[{"mesh", "[", "\"\<Coordinates\>\"", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Fm", "=", 
         RowBox[{"Table", "[", 
          RowBox[{"0.", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Length", "[", "coords", "]"}], "*", "dim"}], "}"}]}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"bcels", "=", 
         RowBox[{
          RowBox[{"mesh", "[", "\"\<BoundaryElements\>\"", "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"indices", "=", 
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"bcels", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", "marker"}], "]"}], "//", 
          "Flatten"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"elements", "=", 
         RowBox[{
          RowBox[{"bcels", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "[", 
          RowBox[{"[", "indices", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        
        RowBox[{"Do", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"faceNodes", "=", 
            RowBox[{"elements", "[", 
             RowBox[{"[", "iel", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"Fm", "+=", 
            RowBox[{"ApplyNeumann", "[", 
             RowBox[{"mesh", ",", "faceNodes", ",", "loadFunc"}], "]"}]}], 
           ";"}], ",", 
          RowBox[{"{", 
           RowBox[{"iel", ",", 
            RowBox[{"Length", "[", "elements", "]"}]}], "}"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", "Fm"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"TakeIds", "[", 
     RowBox[{"side_", ",", "mesh_"}], "]"}], ":=", 
    RowBox[{"DeleteCases", "[", 
     RowBox[{
      RowBox[{"Flatten", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"mesh", "[", "\"\<BoundaryElements\>\"", "]"}], "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "2", ",", "i"}], "]"}], "]"}], "==", "side"}],
            ",", 
           RowBox[{
            RowBox[{"mesh", "[", "\"\<BoundaryElements\>\"", "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1", ",", "i"}], "]"}], "]"}], ",", "0"}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", 
            RowBox[{
             RowBox[{"mesh", "[", "\"\<BoundaryElements\>\"", "]"}], "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "2"}], "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
       "]"}], ",", "0"}], "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Dot2", "[", 
      RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
     RowBox[{"a", ".", "b"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"Norm2", "[", "a_", "]"}], ":=", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", ".", "a"}], "]"}]}], ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"computeDlambda0Riks", "[", 
      RowBox[{"dwb_", ",", "dw_", ",", "L_"}], "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "a", ",", "b", ",", "c", ",", "disc", ",", "sq", ",", "dl1", ",", 
         "dl2"}], "}"}], ",", 
       RowBox[{
        RowBox[{"a", "=", 
         RowBox[{"Dot2", "[", 
          RowBox[{"dwb", ",", "dwb"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"a", "<", "1*^-14"}], ",", 
          RowBox[{"Return", "[", "L", "]"}]}], "]"}], ";", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{
           RowBox[{"Se", " ", "dwb"}], "\[TildeTilde]", "0"}], ",", 
          RowBox[{"retorna", " ", "L"}]}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"b", "=", 
         RowBox[{"2.0", "*", 
          RowBox[{"Dot2", "[", 
           RowBox[{"dwb", ",", "dw"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
        
        RowBox[{"c", "=", 
         RowBox[{
          RowBox[{"Dot2", "[", 
           RowBox[{"dw", ",", "dw"}], "]"}], "-", 
          RowBox[{"L", "^", "2"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"disc", "=", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"4", "*", "a", "*", "c"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"disc", "<", "0"}], ",", 
          RowBox[{"disc", "=", "0"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"sq", "=", 
         RowBox[{"Sqrt", "[", "disc", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"dl1", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "b"}], "-", "sq"}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"2", "*", "a"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"dl2", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "b"}], "+", "sq"}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"2", "*", "a"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Abs", "[", 
            RowBox[{"Dot2", "[", 
             RowBox[{"dw", ",", "dw"}], "]"}], "]"}], "<", "1*^-14"}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"dl2", ">", "0"}], ",", "dl2", ",", "dl1"}], "]"}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"dl1", "*", 
              RowBox[{"Dot2", "[", 
               RowBox[{"dwb", ",", "dw"}], "]"}]}], ">", "0"}], ",", "dl1", ",",
             "dl2"}], "]"}]}], "]"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"computeDlambdaRiks", "[", 
      RowBox[{"dwb_", ",", "dws_", ",", "dw_", ",", "L_", ",", "dwPrev_"}], 
      "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "aa", ",", "bb", ",", "cc", ",", "t", ",", "disc", ",", "sq", ",", 
         "dl1", ",", "dl2", ",", "s1", ",", "s2", ",", "ref"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"aa", "=", 
         RowBox[{"Dot2", "[", 
          RowBox[{"dwb", ",", "dwb"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"t", "=", 
         RowBox[{"dw", "+", "dws"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"bb", "=", 
         RowBox[{"2.0", "*", 
          RowBox[{"Dot2", "[", 
           RowBox[{"dwb", ",", "t"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"cc", "=", 
         RowBox[{
          RowBox[{"Dot2", "[", 
           RowBox[{"t", ",", "t"}], "]"}], "-", 
          RowBox[{"L", "^", "2"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"aa", "<", "1*^-14"}], ",", 
          RowBox[{"Return", "[", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Abs", "[", "bb", "]"}], ">", "1*^-14"}], ",", 
             RowBox[{
              RowBox[{"-", "cc"}], "/", "bb"}], ",", "0."}], "]"}], "]"}]}], 
         "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"disc", "=", 
         RowBox[{
          RowBox[{"bb", "^", "2"}], "-", 
          RowBox[{"4", "*", "aa", "*", "cc"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"disc", "<", "0"}], ",", 
          RowBox[{"disc", "=", "0"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"sq", "=", 
         RowBox[{"Sqrt", "[", "disc", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"dl1", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "bb"}], "-", "sq"}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"2", "*", "aa"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"dl2", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "bb"}], "+", "sq"}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"2", "*", "aa"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"ref", "=", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Dot2", "[", 
             RowBox[{"dw", ",", "dw"}], "]"}], ">", "1*^-14"}], ",", "dw", ",",
            "dwPrev"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"s1", "=", 
         RowBox[{"Dot2", "[", 
          RowBox[{
           RowBox[{"dw", "+", "dws", "+", 
            RowBox[{"dl1", "*", "dwb"}]}], ",", "ref"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"s2", "=", 
         RowBox[{"Dot2", "[", 
          RowBox[{
           RowBox[{"dw", "+", "dws", "+", 
            RowBox[{"dl2", "*", "dwb"}]}], ",", "ref"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"s1", ">", "s2"}], ",", "dl1", ",", "dl2"}], "]"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IterativeProcessArc", "[", 
      RowBox[{"m_", ",", "bcDirichlet_", ",", 
       RowBox[{"bcNeumann_", ":", 
        RowBox[{"{", "}"}]}]}], "]"}], ":=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "dw", ",", "fext0", ",", "kg", ",", "fint", ",", "fext", ",", "fbc", ",",
          "steps", ",", "r", ",", "\[Delta]u", ",", "\[Lambda]", ",", "conv", 
         ",", "convOld", ",", "norm\[Delta]u", ",", "counter", ",", 
         RowBox[{"tol", "=", "1*^-8"}], ",", 
         RowBox[{"maxIter", "=", "30"}], ",", 
         RowBox[{"tolMachine", "=", 
          RowBox[{"100", "*", "$MachineEpsilon"}]}], ",", "bcids", ",", 
         "markers", ",", "dir", ",", "val", ",", "loadFunc", ",", 
         RowBox[{"solsvec", "=", 
          RowBox[{"{", "}"}]}], ",", 
         RowBox[{"epspsolsvec", "=", 
          RowBox[{"{", "}"}]}], ",", 
         RowBox[{"plot", "=", 
          RowBox[{"{", "}"}]}], ",", 
         RowBox[{"lambda0", "=", "0.0001"}], ",", 
         RowBox[{"L0", "=", "0.005"}], ",", "L", ",", "dwb", ",", "dws", ",", 
         "dl", ",", "dwtot", ",", "Lmin", ",", "Lmax", ",", 
         RowBox[{"dlmax", "=", "0.1"}], ",", "kgMod", ",", "fextMod", ",", 
         RowBox[{"(*", 
          RowBox[{"Para", " ", "rollback"}], "*)"}], "displacePrev", ",", 
         "epspvecPrev", ",", "epbarvecPrev", ",", "\[Lambda]prev", ",", 
         "okConv", ",", 
         RowBox[{"cutCount", "=", "0"}], ",", 
         RowBox[{"maxCuts", "=", "10"}], ",", 
         RowBox[{"(*", 
          RowBox[{"Para", " ", "crit\[EAcute]rio", " ", "de", " ", "parada"}],
           "*)"}], 
         RowBox[{"\[Lambda]old", "=", "0"}], ",", 
         RowBox[{"tolLambda", "=", "1*^-3"}], ",", 
         RowBox[{"maxSteps", "=", "200"}], ",", 
         RowBox[{"(*", 
          RowBox[{"Para", " ", "taxa", " ", "de", " ", "converg\[EHat]ncia"}],
           "*)"}], "taxa", ",", 
         RowBox[{"targetIter", "=", "7"}], ",", "fac", ",", "stepCount", ",", 
         "convOldOld"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"L", "=", "L0"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Lmin", "=", "0.00001"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Lmax", "=", "10"}], ";", "\[IndentingNewLine]", 
        RowBox[{"convOldOld", "=", "100"}], ";", "\[IndentingNewLine]", 
        RowBox[{"convOld", "=", "100"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"meshnodes", "=", 
         RowBox[{"m", "[", "\"\<Coordinates\>\"", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"topol", "=", 
         RowBox[{
          RowBox[{"m", "[", "\"\<MeshElements\>\"", "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"intrule", "=", 
         RowBox[{"IntegrationRule", "[", 
          RowBox[{"order", ",", "dim"}], "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"warning", ":", " ", 
          RowBox[{"global", " ", "variables"}]}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"Clear", "[", 
         RowBox[{
         "npts", ",", "nglobalpts", ",", "nDofs", ",", "displace", ",", 
          "epspvec", ",", "epspsolitern", ",", "epbarsolintern", ",", 
          "accumulatedplasticstrain", ",", "epbarvec"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"npts", "=", 
         RowBox[{"Length", "[", "intrule", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"nglobalpts", "=", 
         RowBox[{
          RowBox[{"Length", "[", "topol", "]"}], "*", "npts"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"nDofs", "=", 
         RowBox[{"dim", "*", 
          RowBox[{"Length", "[", "meshnodes", "]"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"displace", "=", 
         RowBox[{"Table", "[", 
          RowBox[{"0.", ",", 
           RowBox[{"{", "nDofs", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"epspvec", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{"0.", ",", 
             RowBox[{"{", "3", "}"}]}], "]"}], ",", 
           RowBox[{"{", "nglobalpts", "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"epspsolitern", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{"0.", ",", 
             RowBox[{"{", "3", "}"}]}], "]"}], ",", 
           RowBox[{"{", "nglobalpts", "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"epbarsolintern", "=", 
         RowBox[{"Table", "[", 
          RowBox[{"0.", ",", 
           RowBox[{"{", "nglobalpts", "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"accumulatedplasticstrain", "=", 
         RowBox[{"Table", "[", 
          RowBox[{"0.", ",", 
           RowBox[{"{", "nglobalpts", "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"epbarvec", "=", 
         RowBox[{"Table", "[", 
          RowBox[{"0.", ",", 
           RowBox[{"{", "nglobalpts", "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"fbc", "=", 
         RowBox[{"Table", "[", 
          RowBox[{"0.", ",", 
           RowBox[{"{", "nDofs", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Do", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"markers", "=", 
            RowBox[{"bc", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"loadFunc", "=", 
            RowBox[{"bc", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"Do", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"fbc", "+=", 
               RowBox[{"ApplyNeumannByMarker", "[", 
                RowBox[{"m", ",", "mk", ",", "loadFunc"}], "]"}]}], ";"}], ",", 
             RowBox[{"{", 
              RowBox[{"mk", ",", "markers"}], "}"}]}], "]"}], ";"}], ",", 
          RowBox[{"{", 
           RowBox[{"bc", ",", "bcNeumann"}], "}"}]}], "\[IndentingNewLine]", 
         "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"kg", ",", "fint", ",", "fext"}], "}"}], "=", 
         RowBox[{"AssemblePlasticity", "[", 
          RowBox[{"m", ",", "displace"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"fext0", "=", 
         RowBox[{"fext", "+", "fbc"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"dw", "=", "displace"}], ";", "\[IndentingNewLine]", 
        RowBox[{"\[Lambda]", "=", "lambda0"}], ";", "\[IndentingNewLine]", 
        RowBox[{"\[Lambda]old", "=", "lambda0"}], ";", "\[IndentingNewLine]", 
        
        RowBox[{"stepCount", "=", "1"}], ";", "\[IndentingNewLine]", 
        RowBox[{"dwPrev", "=", 
         RowBox[{"Table", "[", 
          RowBox[{"0.", ",", 
           RowBox[{"{", "nDofs", "}"}]}], "]"}]}], ";", "  ", 
        "\[IndentingNewLine]", 
        RowBox[{"While", "[", 
         RowBox[{
          RowBox[{"stepCount", "<", "maxSteps"}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{
           "accumulatedplasticstrainPrev", "=", "accumulatedplasticstrain"}], 
           ";", "\[IndentingNewLine]", 
           RowBox[{"displacePrev", "=", "displace"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"epspvecPrev", "=", "epspvec"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"epbarvecPrev", "=", "epbarvec"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"\[Lambda]prev", "=", "\[Lambda]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"Print", "[", 
            
            RowBox[{"\"\<=== Step \>\"", ",", "stepCount", 
             ",", "\"\< | \[Lambda] = \>\"", ",", "\[Lambda]", 
             ",", "\"\< | L = \>\"", ",", 
             RowBox[{"ScientificForm", "[", 
              RowBox[{"L", ",", "3"}], "]"}], ",", "\"\< ===\>\""}], "]"}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"counter", "=", "1"}], ";", "\[IndentingNewLine]", 
           RowBox[{"conv", "=", "100"}], ";", "\[IndentingNewLine]", 
           RowBox[{"convOld", "=", "1*^10"}], ";", 
           RowBox[{"(*", 
            RowBox[{"Para", " ", "calcular", " ", "taxa"}], "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{"norm\[Delta]u", "=", "100"}], ";", "\[IndentingNewLine]", 
           
           RowBox[{"dw", "=", 
            RowBox[{"Table", "[", 
             RowBox[{"0.", ",", 
              RowBox[{"{", "nDofs", "}"}]}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"okConv", "=", "False"}], ";", "\[IndentingNewLine]", 
           "\[IndentingNewLine]", 
           RowBox[{"While", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"conv", ">", "tol"}], "&&", 
              RowBox[{"norm\[Delta]u", ">", "tolMachine"}], "&&", 
              RowBox[{"counter", "<=", "maxIter"}]}], ",", 
             "\[IndentingNewLine]", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{
               RowBox[{"{", 
                RowBox[{"kg", ",", "fint", ",", "fext"}], "}"}], "=", 
               RowBox[{"AssemblePlasticity", "[", 
                RowBox[{"m", ",", "displace"}], "]"}]}], ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"r", "=", 
               RowBox[{
                RowBox[{"\[Lambda]", " ", "fext0"}], "-", "fint"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"kgMod", "=", "kg"}], ";", "\[IndentingNewLine]", 
              RowBox[{"fextMod", "=", "fext0"}], ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              RowBox[{"Do", "[", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{
                 RowBox[{"markers", "=", 
                  RowBox[{"bc", "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"dir", "=", 
                  RowBox[{"bc", "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"val", "=", 
                  RowBox[{"bc", "[", 
                   RowBox[{"[", "3", "]"}], "]"}]}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"bcids", "=", 
                  RowBox[{"DeleteDuplicates", "[", 
                   RowBox[{"Flatten", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"TakeIds", "[", 
                    RowBox[{"mk", ",", "m"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"mk", ",", "markers"}], "}"}]}], "]"}], "]"}], 
                   "]"}]}], ";", "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"kgMod", ",", "r"}], "}"}], "=", 
                  RowBox[{"ImposeDirichletList", "[", 
                   RowBox[{"kgMod", ",", "r", ",", 
                    RowBox[{"{", 
                    RowBox[{"bcids", ",", "dir", ",", "val"}], "}"}]}], 
                   "]"}]}], ";", "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"kgMod", ",", "fextMod"}], "}"}], "=", 
                  RowBox[{"ImposeDirichletList", "[", 
                   RowBox[{"kgMod", ",", "fextMod", ",", 
                    RowBox[{"{", 
                    RowBox[{"bcids", ",", "dir", ",", "0"}], "}"}]}], "]"}]}],
                  ";"}], "\[IndentingNewLine]", ",", 
                RowBox[{"{", 
                 RowBox[{"bc", ",", "bcDirichlet"}], "}"}]}], 
               "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              RowBox[{"dws", "=", 
               RowBox[{"LinearSolve", "[", 
                RowBox[{"kgMod", ",", "r", ",", 
                 RowBox[{"Method", "->", "\"\<Banded\>\""}]}], "]"}]}], ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"dwb", "=", 
               RowBox[{"LinearSolve", "[", 
                RowBox[{"kgMod", ",", "fextMod", ",", 
                 RowBox[{"Method", "->", "\"\<Banded\>\""}]}], "]"}]}], ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"dl", "=", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"counter", "==", "1"}], ",", 
                 RowBox[{"computeDlambda0Riks", "[", 
                  RowBox[{"dwb", ",", "dw", ",", "L"}], "]"}], ",", 
                 RowBox[{"computeDlambdaRiks", "[", 
                  RowBox[{
                  "dwb", ",", "dws", ",", "dw", ",", "L", ",", "dwPrev"}], 
                  "]"}]}], " ", "]"}]}], ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              RowBox[{"dwtot", "=", 
               RowBox[{
                RowBox[{"dl", "*", "dwb"}], "+", "dws"}]}], ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"displace", "+=", "dwtot"}], ";", "\[IndentingNewLine]",
               "\[IndentingNewLine]", 
              RowBox[{"dw", "+=", "dwtot"}], ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              RowBox[{"\[Lambda]", "+=", "dl"}], ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              RowBox[{"norm\[Delta]u", "=", 
               RowBox[{"Norm", "[", "dwtot", "]"}]}], ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"kg", ",", "fint", ",", "fext"}], "}"}], "=", 
               RowBox[{"AssemblePlasticity", "[", 
                RowBox[{"m", ",", "displace"}], "]"}]}], ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"r", "=", 
               RowBox[{
                RowBox[{"\[Lambda]", "*", "fext0"}], "-", "fint"}]}], ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"Do", "[", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{
                 RowBox[{"markers", "=", 
                  RowBox[{"bc", "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"dir", "=", 
                  RowBox[{"bc", "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"bcids", "=", 
                  RowBox[{"DeleteDuplicates", "[", 
                   RowBox[{"Flatten", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"TakeIds", "[", 
                    RowBox[{"mk", ",", "m"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"mk", ",", "markers"}], "}"}]}], "]"}], "]"}], 
                   "]"}]}], ";", "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"r", "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"dim", "*", 
                    RowBox[{"(", 
                    RowBox[{"bcids", "-", "1"}], ")"}]}], "+", "dir"}], "]"}],
                    "]"}], "=", "0"}], ";"}], ",", 
                RowBox[{"{", 
                 RowBox[{"bc", ",", "bcDirichlet"}], "}"}]}], 
               "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
              RowBox[{"conv", "=", 
               RowBox[{"Norm", "[", "r", "]"}]}], ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              RowBox[{"taxa", "=", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"counter", ">=", "4"}], ",", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Log", "[", "conv", "]"}], "-", 
                    RowBox[{"Log", "[", "convOld", "]"}]}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Log", "[", "convOld", "]"}], "-", 
                    RowBox[{"Log", "[", "convOldOld", "]"}]}], ")"}]}], ",", 
                 "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              RowBox[{"AppendTo", "[", 
               RowBox[{"convergencepostdata", ",", 
                RowBox[{"{", 
                 RowBox[{"stepCount", ",", "counter", ",", "\[Lambda]", ",", 
                  RowBox[{"N", "[", "dl", "]"}], ",", "conv", ",", 
                  "norm\[Delta]u", ",", "taxa"}], "}"}]}], "]"}], ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"Print", "[", 
               
               RowBox[{"\"\<iter \>\"", ",", "counter", 
                ",", "\"\< | \[Lambda] = \>\"", ",", "\[Lambda]", 
                ",", "\"\< | \[CapitalDelta]\[Lambda] = \>\"", ",", 
                RowBox[{"N", "[", "dl", "]"}], 
                ",", "\"\< | \:2016r\:2016 = \>\"", ",", "conv", 
                ",", "\"\< | \:2016\[Delta]u\:2016 = \>\"", ",", 
                "norm\[Delta]u", ",", "\"\< | p = \>\"", ",", "taxa"}], "]"}],
               ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"convOldOld", "=", "convOld"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"convOld", "=", "conv"}], ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"conv", ">=", "10000"}], ",", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"Print", "[", "\"\<divergent method\>\"", "]"}], ";",
                  "\[IndentingNewLine]", 
                 RowBox[{"okConv", "=", "False"}], ";", "\[IndentingNewLine]", 
                 RowBox[{"Break", "[", "]"}], ";"}]}], "\[IndentingNewLine]", 
               "]"}], ";", "\[IndentingNewLine]", 
              RowBox[{"counter", "++"}], ";"}]}], "\[IndentingNewLine]", 
            "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"okConv", "=", 
            RowBox[{"(", 
             RowBox[{"conv", "<=", "tol"}], ")"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{"okConv", ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{
               RowBox[{"cutCount", "=", "0"}], ";", "\[IndentingNewLine]", 
               RowBox[{"fac", "=", 
                RowBox[{"targetIter", "/", 
                 RowBox[{"Max", "[", 
                  RowBox[{
                   RowBox[{"counter", "-", "1"}], ",", "1"}], "]"}]}]}], ";", 
               "\[IndentingNewLine]", 
               RowBox[{"fac", "=", 
                RowBox[{
                 RowBox[{"Clip", "[", 
                  RowBox[{"fac", ",", 
                   RowBox[{"{", 
                    RowBox[{"0.5", ",", "2.0"}], "}"}]}], "]"}], "//", 
                 "N"}]}], ";"}], "\[IndentingNewLine]", 
              RowBox[{"(*", 
               RowBox[{
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"fac", "<", "1"}], ",", "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"L", "=", 
                    RowBox[{"Clip", "[", 
                    RowBox[{
                    RowBox[{"L", "*", "fac"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"Lmin", ",", "Lmax"}], "}"}]}], "]"}]}], ";"}]}], 
                 "\[IndentingNewLine]", "]"}], ";"}], "*)"}], ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"epspsolitern", "=", "epspvec"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"epbarsolintern", "=", "epbarvec"}], ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"deps", "=", 
               RowBox[{"epspsolitern", "-", "epspvecPrev"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"accumulatedplasticstrain", "+=", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"Sqrt", "[", 
                  RowBox[{
                   RowBox[{"deps", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], ".", 
                   RowBox[{"deps", "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"i", ",", "1", ",", 
                   RowBox[{"Length", "[", "deps", "]"}]}], "}"}]}], "]"}]}], ";",
               "\[IndentingNewLine]", 
              RowBox[{"AppendTo", "[", 
               RowBox[{"cumplasticstrain", ",", "accumulatedplasticstrain"}], 
               "]"}], ";", "\[IndentingNewLine]", 
              RowBox[{"AppendTo", "[", 
               RowBox[{"solsvec", ",", "displace"}], "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"AppendTo", "[", 
               RowBox[{"epspsolsvec", ",", "epspsolitern"}], "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"AppendTo", "[", 
               RowBox[{"plot", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", 
                   RowBox[{"displace", "[", 
                    RowBox[{"[", "idpostproc", "]"}], "]"}]}], ",", 
                  "\[Lambda]"}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              RowBox[{"Print", "[", 
               RowBox[{"\"\<ACEITO em \>\"", ",", 
                RowBox[{"counter", "-", "1"}], 
                ",", "\"\< iter | \[CapitalDelta]\[Lambda]_step = \>\"", ",", 
                
                RowBox[{"Abs", "[", 
                 RowBox[{"\[Lambda]", "-", "\[Lambda]old"}], "]"}], 
                ",", "\"\< | fac = \>\"", ",", "fac", 
                ",", "\"\< | L_novo = \>\"", ",", "L"}], "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"(*", 
               RowBox[{
               "Verifica", " ", "estabiliza\[CCedilla]\[ATilde]o", " ", "de", 
                " ", "\[Lambda]"}], "*)"}], "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"Abs", "[", 
                   RowBox[{"\[Lambda]", "-", "\[Lambda]old"}], "]"}], "<", 
                  "tolLambda"}], " ", "||", 
                 RowBox[{"\[Lambda]old", ">", "\[Lambda]"}]}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{
                 "Print", 
                  "[", "\"\<\\n\:2550\:2550\:2550\:2550\:2550\:2550\:2550\
\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\
\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\
\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\>\"", "]"}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"Print", "[", 
                  
                  RowBox[{"\"\<  \[Lambda] ESTABILIZOU!    \[CapitalDelta]\
\[Lambda] = \>\"", ",", 
                   RowBox[{"Abs", "[", 
                    RowBox[{"\[Lambda]", "-", "\[Lambda]old"}], "]"}], 
                   ",", "\"\< < \>\"", ",", "tolLambda"}], "]"}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"Print", "[", 
                  RowBox[{"\"\<  \[Lambda]_final = \>\"", ",", "\[Lambda]"}], 
                  "]"}], ";", "\[IndentingNewLine]", 
                 RowBox[{
                 "Print", 
                  "[", "\"\<\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\
\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\
\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\
\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\>\"", "]"}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"Break", "[", "]"}], ";"}]}], "\[IndentingNewLine]", 
               "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"\[Lambda]old", "=", "\[Lambda]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"stepCount", "++"}], ";"}], "\[IndentingNewLine]", ",", 
             "\[IndentingNewLine]", 
             RowBox[{"(*", 
              RowBox[{"REJEITA", "-", "ROLLBACK"}], "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{
              "accumulatedplasticstrain", "=", 
               "accumulatedplasticstrainPrev"}], ";", "\[IndentingNewLine]", 
              RowBox[{"displace", "=", "displacePrev"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"epspvec", "=", "epspvecPrev"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"epbarvec", "=", "epbarvecPrev"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"\[Lambda]", "=", "\[Lambda]prev"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"L", "=", 
               RowBox[{"L", "*", "0.5"}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"cutCount", "++"}], ";", "\[IndentingNewLine]", 
              RowBox[{"Print", "[", 
               
               RowBox[{"\"\<REJEITADO - Corte #\>\"", ",", "cutCount", 
                ",", "\"\< | L_novo = \>\"", ",", 
                RowBox[{"ScientificForm", "[", 
                 RowBox[{"L", ",", "3"}], "]"}]}], "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"cutCount", ">", "maxCuts"}], "||", 
                 RowBox[{"L", "<", "Lmin"}]}], ",", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{
                 "Print", 
                  "[", "\"\<M\[AAcute]ximo de cortes atingido.Parando.\>\"", 
                  "]"}], ";", "\[IndentingNewLine]", 
                 RowBox[{"Break", "[", "]"}], ";"}]}], "\[IndentingNewLine]", 
               "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<\\n=== CONCLU\[CapitalIAcute]DO: \>\"", ",", 
          "stepCount", ",", "\"\< steps | \[Lambda]_final = \>\"", ",", 
          "\[Lambda]", ",", "\"\< ===\>\""}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
         "plot", ",", "solsvec", ",", "epspsolsvec", ",", 
          "cumplasticstrain"}], "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
    ";"}], "\n", "\n"}]}]], "Input",
 CellChangeTimes->{{3.86379991697583*^9, 3.8637999198787746`*^9}, {
   3.863845970355838*^9, 3.863845991846875*^9}, {3.863846148885696*^9, 
   3.863846149384054*^9}, {3.863846723954434*^9, 3.863846852128745*^9}, {
   3.863846899468795*^9, 3.8638469977905912`*^9}, {3.863847037129655*^9, 
   3.863847168964868*^9}, {3.863847541250247*^9, 3.863847558067357*^9}, {
   3.863850562157105*^9, 3.8638507570891047`*^9}, 3.863850890660018*^9, {
   3.863850967949259*^9, 3.863850970757533*^9}, {3.863851007053434*^9, 
   3.863851011789052*^9}, {3.863852610898703*^9, 3.863852640978396*^9}, {
   3.863852687203166*^9, 3.863852723682247*^9}, {3.863852800785858*^9, 
   3.863852850802367*^9}, {3.8638528912264442`*^9, 3.863852892786036*^9}, {
   3.863852926658081*^9, 3.863853013049884*^9}, {3.863853052410347*^9, 
   3.863853159883101*^9}, {3.863853196219658*^9, 3.8638532078666286`*^9}, {
   3.8638533506603727`*^9, 3.86385345397307*^9}, {3.863853488332473*^9, 
   3.8638534895561037`*^9}, {3.8638543197289543`*^9, 3.863854359067062*^9}, {
   3.863854424215486*^9, 3.863854425422617*^9}, {3.86385450557864*^9, 
   3.863854506153451*^9}, {3.863854660017675*^9, 3.863854697818768*^9}, {
   3.863854736197178*^9, 3.863854764046401*^9}, {3.863854824496471*^9, 
   3.863854825225157*^9}, {3.863854871090979*^9, 3.863854877707172*^9}, {
   3.8638550886530046`*^9, 3.863855105667369*^9}, {3.863855137676587*^9, 
   3.863855192543223*^9}, {3.863855227544348*^9, 3.863855227783649*^9}, {
   3.863855266445965*^9, 3.863855660295228*^9}, {3.863855795563664*^9, 
   3.863855906471168*^9}, {3.863855977309251*^9, 3.8638560508987093`*^9}, {
   3.863856563039042*^9, 3.863856601703437*^9}, {3.863856803105633*^9, 
   3.863856803312201*^9}, {3.8638570129633427`*^9, 3.8638570219083347`*^9}, {
   3.8638583173837023`*^9, 3.863858342125414*^9}, {3.86385837965051*^9, 
   3.863858384665454*^9}, {3.863858417632423*^9, 3.863858422287712*^9}, {
   3.863864307500597*^9, 3.86386431046767*^9}, {3.863864355318137*^9, 
   3.8638643575697947`*^9}, {3.863864407758408*^9, 3.863864420285665*^9}, {
   3.8638654223447227`*^9, 3.863865572747142*^9}, {3.863865613652184*^9, 
   3.8638656880930243`*^9}, {3.863865758903693*^9, 3.8638657864705563`*^9}, {
   3.863865934034068*^9, 3.863865956840917*^9}, {3.863865993913889*^9, 
   3.863865997993355*^9}, {3.8638660535004168`*^9, 3.863866063395608*^9}, {
   3.863866138760103*^9, 3.8638661530902147`*^9}, {3.863866227791123*^9, 
   3.86386623173367*^9}, {3.863866275640521*^9, 3.863866276352659*^9}, {
   3.8638663735495377`*^9, 3.863866454872593*^9}, {3.863866555350236*^9, 
   3.863866581359618*^9}, {3.8638666203049173`*^9, 3.86386663846486*^9}, {
   3.8638667251156397`*^9, 3.863866745411993*^9}, {3.863878715556645*^9, 
   3.863878770648991*^9}, {3.8638788140261993`*^9, 3.86387881434149*^9}, {
   3.863949411718727*^9, 3.863949431920053*^9}, {3.863949499072175*^9, 
   3.863949500160099*^9}, {3.8639495986569633`*^9, 3.8639495997456512`*^9}, {
   3.863949641381674*^9, 3.863949751390271*^9}, {3.86394978594313*^9, 
   3.863949852040063*^9}, {3.86395055873282*^9, 3.863950613676607*^9}, {
   3.863950645875127*^9, 3.86395079489417*^9}, {3.863950851472876*^9, 
   3.863950885738845*^9}, {3.863950920249773*^9, 3.863951004829166*^9}, {
   3.863951133229609*^9, 3.863951154620749*^9}, {3.8639512493835897`*^9, 
   3.8639512535421877`*^9}, {3.8639513723749*^9, 3.863951382495318*^9}, {
   3.863953554147921*^9, 3.863953580293537*^9}, {3.863953840930821*^9, 
   3.863953849670021*^9}, 3.863953893789505*^9, {3.86395519187256*^9, 
   3.8639553037943287`*^9}, {3.863955486962071*^9, 3.8639554878414297`*^9}, {
   3.863955560459127*^9, 3.863955588867371*^9}, {3.863955717168096*^9, 
   3.8639557176871233`*^9}, {3.86395576331151*^9, 3.863955789550599*^9}, {
   3.8639559428686666`*^9, 3.8639561622670927`*^9}, {3.8639561933470917`*^9, 
   3.863956379768896*^9}, {3.863962459817134*^9, 3.86396246241609*^9}, {
   3.863962499709813*^9, 3.863962604211135*^9}, {3.863962645233622*^9, 
   3.8639627847339*^9}, {3.863962816321583*^9, 3.863962850257745*^9}, {
   3.863962892532754*^9, 3.863963920542766*^9}, {3.8639639576335573`*^9, 
   3.863964080956539*^9}, {3.8639642952422857`*^9, 3.86396435029179*^9}, {
   3.863964412042815*^9, 3.863964412553618*^9}, 3.863964496943025*^9, {
   3.8639646856237307`*^9, 3.863964711993093*^9}, {3.863964832692966*^9, 
   3.8639648992892523`*^9}, 3.863964938959241*^9, {3.863965023354986*^9, 
   3.863965060757715*^9}, {3.863965127011075*^9, 3.863965159239966*^9}, {
   3.8639651948009357`*^9, 3.863965268974861*^9}, {3.863965316267724*^9, 
   3.863965332983357*^9}, {3.863965398495297*^9, 3.863965425986197*^9}, {
   3.863965552580762*^9, 3.863965612470566*^9}, {3.863965658160013*^9, 
   3.863965660775179*^9}, {3.863965697888826*^9, 3.863965718872252*^9}, {
   3.863965854699121*^9, 3.8639658618738117`*^9}, {3.863966048662135*^9, 
   3.863966100823996*^9}, {3.863966132556835*^9, 3.86396613403393*^9}, {
   3.864035864859189*^9, 3.8640358650645523`*^9}, {3.864037313700719*^9, 
   3.8640373152889223`*^9}, {3.864116803989011*^9, 3.864116864502842*^9}, {
   3.8641172208294992`*^9, 3.8641172246965837`*^9}, {3.864118542854889*^9, 
   3.8641185541330137`*^9}, {3.864118686896851*^9, 3.8641187315532637`*^9}, {
   3.864118837797111*^9, 3.8641188391172743`*^9}, {3.864119859177843*^9, 
   3.864119934787771*^9}, {3.864720565127771*^9, 3.864720568515049*^9}, {
   3.864720623057097*^9, 3.86472063712396*^9}, {3.864721222401767*^9, 
   3.864721226704321*^9}, {3.867145093451353*^9, 3.867145113074725*^9}, 
   3.867145171688422*^9, {3.917184973089797*^9, 3.917184974524534*^9}, {
   3.91718500771552*^9, 3.917185015701858*^9}, {3.917185080013129*^9, 
   3.917185142754534*^9}, 3.917249169271447*^9, {3.917249223736805*^9, 
   3.917249314671229*^9}, {3.9172493798255672`*^9, 3.917249478395459*^9}, {
   3.917249532834857*^9, 3.917249658338274*^9}, {3.917249705142043*^9, 
   3.917249827276635*^9}, {3.9172500342601643`*^9, 3.917250072056513*^9}, {
   3.917255223100803*^9, 3.917255332475382*^9}, {3.917256574457686*^9, 
   3.917256581208858*^9}, {3.917258844487377*^9, 3.917258865840474*^9}, {
   3.917258916848031*^9, 3.9172590894022417`*^9}, {3.917259129168943*^9, 
   3.9172591749368773`*^9}, {3.917259233319495*^9, 3.917259235921472*^9}, 
   3.9172593078900633`*^9, {3.9172593399352922`*^9, 3.91725941010105*^9}, {
   3.917259447103022*^9, 3.9172594669179487`*^9}, {3.9172597114649153`*^9, 
   3.917259784256381*^9}, {3.917259839184416*^9, 3.917259873022335*^9}, 
   3.917259920408931*^9, {3.9172606186643972`*^9, 3.917260628383287*^9}, {
   3.917261495836296*^9, 3.917261510612447*^9}, {3.9172618330236197`*^9, 
   3.917261928745006*^9}, {3.917262564829256*^9, 3.917262577394767*^9}, {
   3.9172654802613583`*^9, 3.917265482427371*^9}, {3.91726599229104*^9, 
   3.917265993457531*^9}, {3.9172661644079237`*^9, 3.917266240070117*^9}, {
   3.917266278572742*^9, 3.9172663478692408`*^9}, {3.9172672739936438`*^9, 
   3.91726727542523*^9}, {3.917272065299963*^9, 3.917272091916251*^9}, {
   3.917272122117155*^9, 3.917272154834865*^9}, {3.917272207018454*^9, 
   3.9172722324939528`*^9}, 3.917272304468453*^9, {3.9172724826988497`*^9, 
   3.917272516933433*^9}, {3.9172725875408382`*^9, 3.917272604725402*^9}, {
   3.917272641006764*^9, 3.917272642504238*^9}, {3.9172726906856737`*^9, 
   3.917272720500368*^9}, {3.917272878494028*^9, 3.917272879073415*^9}, {
   3.917272939386209*^9, 3.917272969022428*^9}, {3.9172730742154284`*^9, 
   3.917273097980006*^9}, {3.9172731296415367`*^9, 3.91727315826055*^9}, {
   3.917273256501642*^9, 3.9172732777398453`*^9}, {3.917273339820747*^9, 
   3.917273385513708*^9}, {3.9172734155842037`*^9, 3.9172734298647738`*^9}, {
   3.917273506688615*^9, 3.917273514423274*^9}, {3.917273740387961*^9, 
   3.917273799289796*^9}, {3.9172743603973007`*^9, 3.917274386847817*^9}, {
   3.917274470793106*^9, 3.9172745521697617`*^9}, {3.9172747845118837`*^9, 
   3.9172747957779818`*^9}, 3.9172751858143673`*^9, {3.917275345157661*^9, 
   3.917275346559081*^9}, {3.9172762113232117`*^9, 3.9172762239206553`*^9}, {
   3.917276417493758*^9, 3.917276420524575*^9}, {3.917276555204749*^9, 
   3.917276559187109*^9}, {3.917276738046351*^9, 3.9172767573313704`*^9}, {
   3.917276970782633*^9, 3.9172769941773*^9}, {3.9172771119818487`*^9, 
   3.917277115365055*^9}, {3.917277405536076*^9, 3.917277437577898*^9}, {
   3.917277834112171*^9, 3.9172778889454613`*^9}, {3.917277959147459*^9, 
   3.917277963788093*^9}, {3.917278087219431*^9, 3.917278131247098*^9}, {
   3.917340504506311*^9, 3.917340521178669*^9}, {3.917340598620677*^9, 
   3.9173406809106913`*^9}, {3.917340771107493*^9, 3.9173408759968567`*^9}, {
   3.917340950615684*^9, 3.917340954531054*^9}, {3.91734137430823*^9, 
   3.917341411763926*^9}, {3.917341494462661*^9, 3.9173415238720303`*^9}, {
   3.917341730259575*^9, 3.917341764842559*^9}, {3.917341817040451*^9, 
   3.917341922642673*^9}, {3.9173419569286633`*^9, 3.917341961065987*^9}, {
   3.917341992793887*^9, 3.917342056943551*^9}, {3.917342145769205*^9, 
   3.917342148968709*^9}, {3.9173422217541647`*^9, 3.91734226456322*^9}, {
   3.9173424787973843`*^9, 3.917342489235314*^9}, {3.917342532629703*^9, 
   3.9173425667346153`*^9}, {3.9173429883438177`*^9, 3.917343011762642*^9}, {
   3.9173430662271633`*^9, 3.9173430715620337`*^9}, {3.917343130639284*^9, 
   3.917343179178516*^9}, {3.9173433272197247`*^9, 3.917343335780002*^9}, {
   3.917343371702832*^9, 3.9173434106683817`*^9}, {3.917343643921496*^9, 
   3.9173436573178997`*^9}, {3.917343708328114*^9, 3.917343732968586*^9}, {
   3.9173437637725887`*^9, 3.917343765183572*^9}, {3.9173438585656443`*^9, 
   3.917343862843831*^9}, {3.917343893082903*^9, 3.917343893545754*^9}, {
   3.91734393571638*^9, 3.917343938321933*^9}, {3.917344057474291*^9, 
   3.9173440587823772`*^9}, {3.917344106174871*^9, 3.917344138135777*^9}, {
   3.917344193607048*^9, 3.9173442014139423`*^9}, {3.917344284411641*^9, 
   3.9173444072122507`*^9}, {3.917344444983119*^9, 3.9173444605785*^9}, {
   3.917344490875307*^9, 3.917344496665409*^9}, {3.917344558179041*^9, 
   3.917344593046432*^9}, {3.917344626866262*^9, 3.917344650199548*^9}, {
   3.9173452043512897`*^9, 3.917345296554653*^9}, {3.917345363488307*^9, 
   3.917345457969245*^9}, {3.917345519838141*^9, 3.917345573405079*^9}, {
   3.917345604273418*^9, 3.917345613107246*^9}, {3.917345647576921*^9, 
   3.9173456677311573`*^9}, {3.917345704206862*^9, 3.917345725468552*^9}, {
   3.917345760589181*^9, 3.91734577884444*^9}, {3.917345870956319*^9, 
   3.917345879563035*^9}, {3.917345911997775*^9, 3.917345915706092*^9}, {
   3.9173460157462997`*^9, 3.9173460362631702`*^9}, {3.917346073413069*^9, 
   3.917346163630748*^9}, {3.9173463415003366`*^9, 3.917346462920628*^9}, {
   3.917346498473131*^9, 3.917346503171357*^9}, {3.917346547839889*^9, 
   3.9173465797058067`*^9}, {3.91734666984787*^9, 3.917346702400309*^9}, {
   3.917346741774316*^9, 3.917346743116474*^9}, {3.9173467792345753`*^9, 
   3.9173468007478523`*^9}, {3.917346833387059*^9, 3.917346877197731*^9}, {
   3.917346913477495*^9, 3.917346914697269*^9}, {3.917346981138545*^9, 
   3.917346988998865*^9}, {3.9173470629111547`*^9, 3.9173470679502687`*^9}, {
   3.9173471362362328`*^9, 3.91734713766321*^9}, {3.961588337330544*^9, 
   3.961588427801525*^9}, {3.9615884951458073`*^9, 3.961588550794022*^9}, {
   3.961588955561248*^9, 3.961588987690016*^9}, {3.973330377919767*^9, 
   3.973330450049366*^9}, {3.973332238191684*^9, 3.97333223850288*^9}, 
   3.973332701773995*^9, {3.973332796581359*^9, 3.973332817982388*^9}, {
   3.973333766016099*^9, 3.973333929475864*^9}, {3.973334328546791*^9, 
   3.973334334915296*^9}, 3.9733343793397503`*^9, {3.973334421162594*^9, 
   3.973334423117835*^9}, {3.973334463518252*^9, 3.973334464146863*^9}, {
   3.973334567673401*^9, 3.973334609001956*^9}, {3.973334719475185*^9, 
   3.97333486906673*^9}, {3.97333490210571*^9, 3.973334902457692*^9}, {
   3.973334947991885*^9, 3.9733349807527447`*^9}, 3.973335015896681*^9, {
   3.973335248323607*^9, 3.973335250338641*^9}, {3.973335291113957*^9, 
   3.973335292209687*^9}, {3.973335390411523*^9, 3.973335406171385*^9}, 
   3.973335442005958*^9, {3.9733355872134523`*^9, 3.9733355920001907`*^9}, {
   3.973335651816841*^9, 3.9733356800235567`*^9}, {3.973335716732451*^9, 
   3.973335734199873*^9}, {3.9733357662472963`*^9, 3.973335781581605*^9}, {
   3.973335812026224*^9, 3.973335848324421*^9}, {3.9733358888802767`*^9, 
   3.973335913065631*^9}, {3.973336077959485*^9, 3.973336087900807*^9}, {
   3.973336223511075*^9, 3.973336223961194*^9}, {3.9733362570168037`*^9, 
   3.973336273976453*^9}, {3.973336306053698*^9, 3.973336308068877*^9}, {
   3.97333644866471*^9, 3.973336510799122*^9}, {3.973336583673436*^9, 
   3.973336586128826*^9}, 3.9733368014153843`*^9, {3.973336869440321*^9, 
   3.9733369194554358`*^9}, {3.973337527225095*^9, 3.9733375454561577`*^9}, {
   3.973337579218508*^9, 3.973337579424522*^9}, {3.973337636246458*^9, 
   3.9733376400573387`*^9}, {3.973337761322029*^9, 3.9733377622536373`*^9}, {
   3.973352210244678*^9, 3.973352219791525*^9}, {3.9733523212735357`*^9, 
   3.973352352708808*^9}, {3.973352449801837*^9, 3.9733524709438334`*^9}, {
   3.973352502496048*^9, 3.973352600624834*^9}, {3.973352660401639*^9, 
   3.973352690755961*^9}, {3.9733527727725353`*^9, 3.9733527777479877`*^9}, {
   3.973352861117508*^9, 3.973352870053111*^9}, 3.973352945945814*^9, {
   3.973353004127739*^9, 3.973353023918961*^9}, {3.973353189224147*^9, 
   3.973353200216361*^9}, {3.973353332806411*^9, 3.973353344710163*^9}, {
   3.973404911478755*^9, 3.973404921047468*^9}, {3.973405164027857*^9, 
   3.973405243940465*^9}, {3.973405338378766*^9, 3.9734054003852243`*^9}, {
   3.973405564410141*^9, 3.973405639967868*^9}, {3.973405714982958*^9, 
   3.973405715572557*^9}, {3.9734057637010603`*^9, 3.9734058043359747`*^9}, {
   3.973406121741086*^9, 3.9734061250835857`*^9}, 3.9734063393710213`*^9, {
   3.9734063796936817`*^9, 3.973406397908938*^9}, {3.9734069924456873`*^9, 
   3.973407009432712*^9}, {3.973407120251914*^9, 3.973407121968567*^9}, {
   3.973407205914625*^9, 3.973407206873802*^9}, {3.973407397362372*^9, 
   3.973407402602552*^9}, {3.9734074455323887`*^9, 3.973407452048663*^9}, 
   3.973407930624591*^9, {3.973418829969777*^9, 3.973418855490734*^9}, {
   3.9734189088848867`*^9, 3.973418922533681*^9}, {3.97341909646916*^9, 
   3.973419110173596*^9}, {3.9734191491688337`*^9, 3.9734191494183493`*^9}, {
   3.973419653854803*^9, 3.973419654140992*^9}, {3.973493620403822*^9, 
   3.973493677336904*^9}, {3.9734937076897573`*^9, 3.973493731551827*^9}, {
   3.973493798256716*^9, 3.973493988429826*^9}, {3.973578710985341*^9, 
   3.973578720948468*^9}, {3.97358792400701*^9, 3.973587936416547*^9}, {
   3.9735961313654327`*^9, 3.973596131707679*^9}, {3.9735964067511578`*^9, 
   3.973596413771847*^9}, {3.9735965433577433`*^9, 3.973596552964888*^9}, {
   3.973596653850453*^9, 3.9735966571946*^9}, {3.9735967282883387`*^9, 
   3.973596732816544*^9}, {3.973596845349921*^9, 3.973596889442869*^9}, {
   3.973599243165854*^9, 3.9735992451494303`*^9}, {3.973599304407255*^9, 
   3.973599305551268*^9}, {3.9735995170338593`*^9, 3.973599517717585*^9}, {
   3.9735996733014708`*^9, 3.9735996741647*^9}, {3.9735999411272306`*^9, 
   3.973599942289132*^9}, {3.9736000315069838`*^9, 3.973600032245447*^9}, {
   3.9736002546161423`*^9, 3.973600255751092*^9}, 3.973600915708247*^9, {
   3.973601732046913*^9, 3.973601734351191*^9}, {3.973607759191267*^9, 
   3.973607760245468*^9}, {3.973607912878888*^9, 3.973607913220771*^9}, {
   3.973610706635778*^9, 3.973610708695314*^9}, {3.973610795594936*^9, 
   3.973610841995471*^9}, 3.97374914015769*^9, {3.973749222403365*^9, 
   3.9737492267217627`*^9}, {3.973749298134727*^9, 3.97374930278126*^9}, {
   3.973749383179367*^9, 3.973749392439159*^9}, 3.973749423240684*^9, {
   3.973749459255574*^9, 3.9737495007092323`*^9}, {3.973749538368466*^9, 
   3.973749576033717*^9}, {3.973749695871759*^9, 3.973749699618558*^9}, {
   3.9737499571645527`*^9, 3.9737500069404707`*^9}, {3.973750054662961*^9, 
   3.973750055451166*^9}, {3.973750105360993*^9, 3.973750153940629*^9}, {
   3.973750195201249*^9, 3.973750197250844*^9}, {3.973750257980157*^9, 
   3.97375028346837*^9}, {3.973750314527956*^9, 3.9737503432051353`*^9}, {
   3.973750555962573*^9, 3.9737505723159313`*^9}, {3.973750644535524*^9, 
   3.973750668994042*^9}, {3.973750700643058*^9, 3.973750706377092*^9}, 
   3.9737508465135813`*^9, {3.973750908476087*^9, 3.973750976874378*^9}, {
   3.9737512561176023`*^9, 3.973751266994954*^9}, {3.9737514870233192`*^9, 
   3.9737515056176357`*^9}, 3.9737515650554543`*^9, {3.9737516240421667`*^9, 
   3.9737516503448277`*^9}, {3.9737516840921907`*^9, 
   3.9737516847491703`*^9}, {3.9737518317083893`*^9, 3.973751835411145*^9}, {
   3.973752217186613*^9, 3.973752235556642*^9}, {3.97375335826847*^9, 
   3.973753385044387*^9}, {3.9737535508635674`*^9, 3.9737535683585587`*^9}, {
   3.973753687114544*^9, 3.9737537310224113`*^9}, {3.9737538248168383`*^9, 
   3.973753853965047*^9}, {3.973753888406137*^9, 3.973753892685315*^9}, {
   3.973753950050107*^9, 3.973753981970924*^9}, {3.973754199965173*^9, 
   3.9737542134391737`*^9}, {3.97375427300138*^9, 3.973754299432735*^9}, {
   3.9737544196629763`*^9, 3.973754434879265*^9}, {3.973755326272073*^9, 
   3.973755344197365*^9}, {3.9737553887682943`*^9, 3.973755390338408*^9}, {
   3.973755782192095*^9, 3.9737557976740637`*^9}, {3.973755859186117*^9, 
   3.973755861203473*^9}, {3.97375590037805*^9, 3.9737559248636093`*^9}, {
   3.973756301332294*^9, 3.973756331605714*^9}, {3.973756432251162*^9, 
   3.973756461881949*^9}, 3.973756567586287*^9, {3.973756659519066*^9, 
   3.973756683832856*^9}, {3.973756752645187*^9, 3.973756783532782*^9}, 
   3.973756833012967*^9, {3.973756866204851*^9, 3.973756873373727*^9}, {
   3.973756932690154*^9, 3.973756975173737*^9}, {3.973757407790722*^9, 
   3.973757410483715*^9}, 3.9737579061372347`*^9, {3.9737590573602343`*^9, 
   3.9737590655449142`*^9}, {3.973764235119117*^9, 3.97376424881399*^9}, 
   3.9737644006644297`*^9, {3.97376445917449*^9, 3.973764463430539*^9}, {
   3.9737737709911957`*^9, 3.973773802126361*^9}, {3.9737743871390133`*^9, 
   3.973774388475027*^9}, 3.973774440832931*^9, {3.973775966555813*^9, 
   3.9737759668381453`*^9}, {3.9738555356092997`*^9, 3.973855536972176*^9}, {
   3.973922495707601*^9, 3.9739224974535313`*^9}, {3.9739335020367126`*^9, 
   3.9739335223190804`*^9}, {3.973935393792584*^9, 3.973935404899132*^9}, {
   3.9741076485850677`*^9, 3.974107651446878*^9}, 3.9741093955901747`*^9, 
   3.97410966247795*^9, {3.974183172890802*^9, 3.974183176892241*^9}, 
   3.9741837477010527`*^9, {3.974186774709179*^9, 3.9741867858146973`*^9}, {
   3.974186851725428*^9, 3.9741868561559553`*^9}, {3.974186953558771*^9, 
   3.9741870336671267`*^9}, 3.97418742244622*^9, {3.9741903677803392`*^9, 
   3.974190372392542*^9}, {3.9741928476697693`*^9, 3.974192850661434*^9}, {
   3.974197880929441*^9, 3.974197885732473*^9}, {3.9742004320977697`*^9, 
   3.974200715774766*^9}, {3.974277877406652*^9, 3.974277918989107*^9}, {
   3.9742779551435137`*^9, 3.9742779653073483`*^9}, {3.9742781528679247`*^9, 
   3.974278214597373*^9}, {3.974278247768289*^9, 3.974278287182906*^9}, {
   3.9742830980280533`*^9, 3.9742830982492733`*^9}, {3.9742858372724047`*^9, 
   3.9742858955457487`*^9}, {3.974285929210403*^9, 3.9742859298300953`*^9}, 
   3.9742921819750977`*^9, {3.97429288899505*^9, 3.9742928986518583`*^9}, {
   3.974292969919335*^9, 3.974292992876979*^9}, {3.974293053983595*^9, 
   3.97429305726304*^9}, {3.9742942843208237`*^9, 3.974294300570327*^9}, {
   3.974393826179132*^9, 3.974393828242402*^9}, {3.974450944270371*^9, 
   3.974450944380147*^9}, 3.974457480894286*^9, {3.97445847825124*^9, 
   3.974458493263151*^9}, {3.974623461585487*^9, 3.9746234651333313`*^9}, 
   3.974623675717931*^9, {3.9747882722781477`*^9, 3.9747886506341333`*^9}, {
   3.974788753558879*^9, 3.97478883402085*^9}, {3.974788876445653*^9, 
   3.9747889603271427`*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"c3fd58ea-8bbc-43f1-b980-07d332d166b8"],

Cell[BoxData["\<\"/home/diogo/Dropbox/mathematica/Plasticidade/CPP\"\>"], \
"Output",
 CellChangeTimes->{3.9742754728385887`*^9, 3.974277968578003*^9, 
  3.974278304393293*^9, 3.9742830790100737`*^9, 3.974283192212797*^9, 
  3.974285931323592*^9, 3.974285974902267*^9, 3.974289450946186*^9, 
  3.97429218431495*^9, 3.974294303522284*^9, 3.974373976400332*^9, 
  3.974375420908472*^9, 3.974393829093975*^9, 3.9744439854534693`*^9, 
  3.974444097892284*^9, 3.97445094600674*^9, 3.974457482394567*^9, 
  3.974458496645419*^9, 3.974623377302582*^9, 3.974623465958393*^9, 
  3.974788991010498*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"b6bd93b3-342d-483f-83a7-da3779dea08d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"order", "=", "2"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p", "=", 
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.5", ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "5"}], "}"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"ff", "=", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"vertices", ",", "area"}], "}"}], ",", 
       RowBox[{"Block", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x", ",", "y"}], "}"}], "=", 
           RowBox[{"Mean", "[", "vertices", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"x", "-", "0.5"}], ")"}], "^", "2"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"y", "-", "5"}], ")"}], "^", "2"}]}], "<=", 
             RowBox[{"0.5", "^", "2"}]}], ",", 
            RowBox[{"area", ">", "0.005"}], ",", 
            RowBox[{"area", ">", "1"}]}], "]"}]}]}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"emesh", "=", 
     RowBox[{"ToElementMesh", "[", 
      RowBox[{"p", ",", 
       RowBox[{"MeshRefinementFunction", "->", "ff"}], ",", 
       RowBox[{"\"\<NodeReordering\>\"", "->", "True"}], ",", 
       RowBox[{"\"\<MeshOrder\>\"", "->", "order"}], ",", 
       RowBox[{"MeshQualityGoal", "->", "\"\<Maximal\>\""}], ",", 
       RowBox[{"MaxCellMeasure", "->", "1"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"emesh", "=", 
     RowBox[{"MeshOrderAlteration", "[", 
      RowBox[{"emesh", ",", "order"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"AddBoundaryMarker", "[", 
      RowBox[{"mesh_", ",", "condition_", ",", "newMarker_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "coords", ",", "boundaryElements", ",", "newBoundaryElements", ",", 
         "elementType"}], "}"}], ",", 
       RowBox[{
        RowBox[{"coords", "=", 
         RowBox[{"mesh", "[", "\"\<Coordinates\>\"", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"boundaryElements", "=", 
         RowBox[{
          RowBox[{"mesh", "[", "\"\<BoundaryElements\>\"", "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"elementType", "=", 
         RowBox[{"Head", "[", 
          RowBox[{
           RowBox[{"mesh", "[", "\"\<BoundaryElements\>\"", "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"markers", "=", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Length", "[", 
             RowBox[{
              RowBox[{"mesh", "[", "\"\<BoundaryElements\>\"", "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], ">=", "2"}], ",", 
           RowBox[{
            RowBox[{"mesh", "[", "\"\<BoundaryElements\>\"", "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", 
           RowBox[{"Table", "[", 
            RowBox[{"1", ",", 
             RowBox[{"{", 
              RowBox[{"Length", "[", "boundaryElements", "]"}], "}"}]}], 
            "]"}]}], "]"}]}], ";", 
        RowBox[{"newMarkers", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"nodeCoords", ",", "midpoint"}], "}"}], ",", 
             RowBox[{
              RowBox[{"nodeCoords", "=", 
               RowBox[{
                RowBox[{
                 RowBox[{"coords", "[", 
                  RowBox[{"[", "#", "]"}], "]"}], "&"}], "/@", 
                RowBox[{"boundaryElements", "[", 
                 RowBox[{"[", "i", "]"}], "]"}]}]}], ";", 
              RowBox[{"midpoint", "=", 
               RowBox[{"Mean", "[", "nodeCoords", "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"condition", "[", "midpoint", "]"}], ",", "newMarker",
                 ",", 
                RowBox[{"markers", "[", 
                 RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", 
             RowBox[{"Length", "[", "boundaryElements", "]"}]}], "}"}]}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"ToElementMesh", "[", 
         RowBox[{
          RowBox[{"\"\<Coordinates\>\"", "->", "coords"}], ",", 
          RowBox[{"\"\<MeshElements\>\"", "->", 
           RowBox[{"mesh", "[", "\"\<MeshElements\>\"", "]"}]}], ",", 
          RowBox[{"\"\<BoundaryElements\>\"", "->", 
           RowBox[{"{", 
            RowBox[{"elementType", "[", 
             RowBox[{"boundaryElements", ",", "newMarkers"}], "]"}], "}"}]}], 
          ",", 
          RowBox[{"\"\<PointElements\>\"", "->", 
           RowBox[{"mesh", "[", "\"\<PointElements\>\"", "]"}]}]}], "]"}]}]}],
       "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{
      "Aplica", " ", "o", " ", "marker", " ", "5", " ", "onde", " ", "x"}], "\[Element]", 
      RowBox[{
       RowBox[{"[", 
        RowBox[{"0", ",", "0.5"}], "]"}], " ", "e", " ", "y"}]}], "=", "5"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"emesh", "=", 
     RowBox[{"AddBoundaryMarker", "[", 
      RowBox[{"emesh", ",", 
       RowBox[{"Function", "[", 
        RowBox[{"pt", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"pt", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ">=", "0"}], "&&", 
          RowBox[{
           RowBox[{"pt", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<=", "0.5"}], "&&", 
          RowBox[{
           RowBox[{"Abs", "[", 
            RowBox[{
             RowBox[{"pt", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "-", "5"}], "]"}], "<", 
           "0.01"}]}]}], "]"}], ",", "5"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Verificar", " ", "os", " ", "markers"}], "*)"}], "\n", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Boundary markers \[UAcute]nicos: \>\"", ",", 
      RowBox[{"DeleteDuplicates", "[", 
       RowBox[{
        RowBox[{"emesh", "[", "\"\<BoundaryElements\>\"", "]"}], "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "2"}], "]"}], "]"}], "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"emesh", "[", "\"\<Wireframe\>\"", "]"}], ",", 
     RowBox[{"emesh", "[", 
      RowBox[{"\"\<Wireframe\>\"", "[", 
       RowBox[{
        RowBox[{"\"\<MeshElement\>\"", 
         "\[Rule]", "\"\<BoundaryElements\>\""}], ",", 
        RowBox[{"\"\<MeshElementMarkerStyle\>\"", "\[Rule]", 
         RowBox[{"Directive", "[", 
          RowBox[{"Red", ",", 
           RowBox[{"PointSize", "[", "0.1", "]"}]}], "]"}]}]}], "]"}], 
      "]"}]}], "]"}], "\n", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"emesh", "[", "\"\<Wireframe\>\"", "]"}], ",", 
     RowBox[{"emesh", "[", 
      RowBox[{"\"\<Wireframe\>\"", "[", 
       RowBox[{
        RowBox[{"\"\<MeshElement\>\"", "\[Rule]", "\"\<PointElements\>\""}], ",", 
        RowBox[{"\"\<MeshElementIDStyle\>\"", "\[Rule]", "Red"}]}], "]"}], 
      "]"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"emesh", "[", "\"\<Wireframe\>\"", "]"}], ",", 
     RowBox[{"emesh", "[", 
      RowBox[{"\"\<Wireframe\>\"", "[", 
       RowBox[{
        RowBox[{"\"\<MeshElement\>\"", "\[Rule]", "\"\<PointElements\>\""}], ",", 
        RowBox[{"\"\<MeshElementIDStyle\>\"", "\[Rule]", "Red"}]}], "]"}], 
      "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.973759534119031*^9, 3.973759550290506*^9}, {
   3.97376008807054*^9, 3.973760115763523*^9}, {3.973760152604127*^9, 
   3.973760183258168*^9}, {3.973760228078272*^9, 3.9737603479901*^9}, {
   3.9737606192028627`*^9, 3.973760650262657*^9}, 3.973760690221096*^9, {
   3.973760790141*^9, 3.973760812244705*^9}, 3.9737608619502707`*^9, {
   3.97376984278262*^9, 3.973769926682308*^9}, 3.973774373324778*^9, 
   3.9737745135243998`*^9, 3.973775233759592*^9, {3.973775541553179*^9, 
   3.973775620752047*^9}, 3.973855570587639*^9, {3.9739351061449413`*^9, 
   3.9739351071909237`*^9}, {3.973936129115856*^9, 3.973936175306937*^9}, {
   3.97393620539741*^9, 3.9739362598225946`*^9}, 3.973936296863995*^9, {
   3.973936408143548*^9, 3.97393640974337*^9}, 3.9741073746611567`*^9, {
   3.9741074568514843`*^9, 3.9741074868109417`*^9}, {3.97410752340792*^9, 
   3.974107528085578*^9}, {3.97418704481695*^9, 3.974187049185017*^9}, {
   3.974200751009144*^9, 3.974200805988063*^9}, {3.974788997655471*^9, 
   3.974788998087976*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"c3cc9b2e-cb4c-4730-963e-c814de57e9d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Boundary markers \[UAcute]nicos: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "5", ",", "4", ",", "3"}], "}"}]}],
  SequenceForm["Boundary markers \[UAcute]nicos: ", {1, 2, 5, 4, 3}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.973759527139715*^9, 3.973759550611614*^9}, {
   3.9737601005556583`*^9, 3.9737601166171293`*^9}, {3.973760165332109*^9, 
   3.973760184320692*^9}, {3.973760229854772*^9, 3.9737603492923517`*^9}, {
   3.9737606287314873`*^9, 3.973760651425695*^9}, 3.973760690609726*^9, {
   3.973760802378091*^9, 3.9737608131138773`*^9}, 3.973760862252488*^9, 
   3.973764267037272*^9, 3.973764474577787*^9, {3.97376985179078*^9, 
   3.9737699276730824`*^9}, 3.973773837363248*^9, 3.973774395728217*^9, 
   3.973774513925118*^9, {3.9737755328342247`*^9, 3.973775621394747*^9}, 
   3.973775840008829*^9, 3.973845419288095*^9, 3.973846520366272*^9, {
   3.9738555752639837`*^9, 3.973855603133477*^9}, 3.9739225023052187`*^9, 
   3.973922698612042*^9, 3.97393356347122*^9, 3.973934069811297*^9, 
   3.973935111193467*^9, 3.9739355100453157`*^9, 3.9739360554632463`*^9, {
   3.973936165337098*^9, 3.9739361760285063`*^9}, {3.973936208228647*^9, 
   3.9739362605825043`*^9}, 3.973936297432726*^9, 3.973936410477247*^9, 
   3.974023509831012*^9, 3.974024126870919*^9, {3.974107371310899*^9, 
   3.9741073750269747`*^9}, {3.974107462058648*^9, 3.974107487777133*^9}, 
   3.974107528564047*^9, 3.974183182392666*^9, 3.974186800497233*^9, {
   3.974187040811496*^9, 3.974187060599215*^9}, 3.9741903767410097`*^9, {
   3.9741978888454857`*^9, 3.9741979074932947`*^9}, 3.974200746541766*^9, 
   3.974200808765479*^9, 3.974275473185741*^9, 3.974283081009698*^9, 
   3.974285933466547*^9, 3.974289454038916*^9, 3.9742943091395407`*^9, 
   3.974373981435535*^9, 3.974375423177286*^9, 3.974393832713852*^9, 
   3.974443987786314*^9, 3.974450948461824*^9, 3.9744574844831257`*^9, 
   3.9744584992178392`*^9, 3.974623379793597*^9, 3.974623467820582*^9, 
   3.974789000234527*^9},
 CellLabel->
  "During evaluation of \
In[24]:=",ExpressionUUID->"3a6e88d9-ddc6-46f9-9778-c6de3d853f90"],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[RGBColor[
    0.00010000076130382223`, 0.00010000076130382223`, 
     0.00010000076130382223`]], FaceForm[None], 
    GraphicsComplexBox[CompressedData["
1:eJxlenc8l+/3v73H63XfUigl7VB2JOeUoghtUoqMShqKykhSpCLaKSQNoxLZ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     "], PolygonBox[CompressedData["
1:eJwNxWdDIQwAAOCsukKLhro2Msuo0ETLKAoNXXUR7qqLzMgKIbKFbDJ+5/s+
X54ZpU6iBHZ0dMwBOjpA/4/Boq1OF4I8AIKUAkZDri8LAZYg4OpAP2KOQCT3
kmaImMxg/9wnYZxMGiATCf0DRMJAhvDZhxjM9BP6BxHZjCidimWyg4hecoKS
HiXlkYi+QhuZ7RvMFZCZA5EnmS2UgFgcPofsKwDb7TwJ2e4tfw3jSKMoPG4W
PT/7cwI7Nl4czZeLMOYKAwjIDw+hcNjxEdwoaqSMR2Pn8UPzaPwkBl0cGcWj
hnAjqMnZiTEimTgzhxsnjWExxDEMeXysCKgW8wBUebhYHpnCTE7PzeQWC1UA
pA3MU2hJwe4eEAKgJprfPfDmcmV5idla/15uJjrrDTAEVKuCQRUwo1HfXN9i
Miqtxlqtq1qvgeOrkS4orMGIrDBZzQqowqhXlpncyCq4UqckqMwlFmspHWGs
sLc4oFKT2iwtJ5bSSwloz496Z63R6oR3tkqLVFpuIUqPfUR5hcUSlUahLtJE
nuxijkZbSKaSR5RkCtmLIPW26ax0V7Gayy6E3jc2v9ezyYUatAvW/VXrhHdD
f5RhX/AeaDcMWuyC1eDQb3grvsJihzbWOK01Lmc1zN3a2ORsrW9ssVuc9Qh3
Lbz6weZww2zu5sY7b5/PC4V54Y8Q/z0cYvNDvA969J2//RGnR/d5jchaPLJC
j7M+VuOUVHqbL5ianjk4FP2cnpidRE9NTkxPTcxgpjKfB3vbglfxoehQLIgK
Y/R0NOYXCHejgn0Bf19+eiYSe1594qTnSHbkPY5J5Ce+I1nK4z3yumVir8cr
9p14fS6nVCpzp2SSlCTmDwrdJw6/MCqTSo4lUuexNHbsdztcO7uBY6c/6Hd6
T9xy36nv9VR+7nCc290u6bn8zHEi/2V/OX+xq5S287OXC6srIAzu7O06rRqd
0RQIGneFgbedgP3C4XJcXF1f2qwXF3bb9ZUqqDHarlXPFrXq6vbafmn/dWm/
tv1W3JpNmqBTY9SYbGar2aa8eVb/vlForGalSmExqxWqW4Va+aTV63Wm+7u/
ZqX60aDV/3ky6gxqxY3+/o/l+cFktlj0pn+PWr3l7s7y8PfuQX93/0/7pNXp
DY9vhreATmv4Dy61KNs=
      "]]]}, 
   {EdgeForm[RGBColor[
    0.00010000076130382223`, 0.00010000076130382223`, 
     0.00010000076130382223`]], FaceForm[None], 
    GraphicsComplexBox[CompressedData["
1:eJxlenc8l+/3v73H63XfUigl7VB2JOeUoghtUoqMShqKykhSpCLaKSQNoxLZ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     "], {LineBox[{{107, 104}, {96, 119}, {95, 96}, {119, 107}}], 
      LineBox[{{99, 95}, {122, 91}, {77, 128}, {35, 148}, {32, 35}, {28, 
       32}, {76, 77}, {148, 76}, {86, 87}, {128, 86}, {87, 122}, {93, 99}, {
       92, 93}, {91, 92}}], 
      LineBox[{{9, 152}, {109, 132}, {68, 70}, {67, 136}, {62, 162}, {10, 
       8}, {136, 62}, {162, 10}, {8, 9}, {70, 67}, {132, 68}, {108, 109}}], 
      LineBox[{{112, 108}, {106, 103}, {103, 112}, {104, 106}}], 
      LineBox[{{34, 28}, {21, 39}, {152, 22}, {39, 34}, {22, 21}}], {
       {RGBColor[1, 0, 0], PointSize[0.1], 
        InsetBox["1", {4.375, 0.}, ImageScaled[{1, 1}]], 
        InsetBox["1", {1.875, 0.}, ImageScaled[{1, 1}]], 
        InsetBox["1", {0.625, 0.}, ImageScaled[{1, 1}]], 
        InsetBox["1", {3.125, 0.}, ImageScaled[{1, 1}]]}, 
       {RGBColor[1, 0, 0], PointSize[0.1], 
        InsetBox["2", {0., 0.75}, ImageScaled[{1, 1}]], 
        InsetBox["2", {0., 3.125}, ImageScaled[{1, 1}]], 
        InsetBox["2", {0., 4.125}, ImageScaled[{1, 1}]], 
        InsetBox["2", {0., 4.625}, ImageScaled[{1, 1}]], 
        InsetBox["2", {0., 4.8125}, ImageScaled[{1, 1}]], 
        InsetBox["2", {0., 4.9375}, ImageScaled[{1, 1}]], 
        InsetBox["2", {0., 4.3125}, ImageScaled[{1, 1}]], 
        InsetBox["2", {0., 4.4375}, ImageScaled[{1, 1}]], 
        InsetBox["2", {0., 3.625}, ImageScaled[{1, 1}]], 
        InsetBox["2", {0., 3.875}, ImageScaled[{1, 1}]], 
        InsetBox["2", {0., 3.375}, ImageScaled[{1, 1}]], 
        InsetBox["2", {0., 1.875}, ImageScaled[{1, 1}]], 
        InsetBox["2", {0., 2.4375}, ImageScaled[{1, 1}]], 
        InsetBox["2", {0., 2.8125}, ImageScaled[{1, 1}]]}, 
       {RGBColor[1, 0, 0], PointSize[0.1], 
        InsetBox["3", {0.53515625, 5.}, ImageScaled[{1, 1}]], 
        InsetBox["3", {3.3125, 5.}, ImageScaled[{1, 1}]], 
        InsetBox["3", {1.90625, 5.}, ImageScaled[{1, 1}]], 
        InsetBox["3", {1.203125, 5.}, ImageScaled[{1, 1}]], 
        InsetBox["3", {0.8515625, 5.}, ImageScaled[{1, 1}]], 
        InsetBox["3", {0.67578125, 5.}, ImageScaled[{1, 1}]], 
        InsetBox["3", {0.9921875, 5.}, ImageScaled[{1, 1}]], 
        InsetBox["3", {0.74609375, 5.}, ImageScaled[{1, 1}]], 
        InsetBox["3", {0.60546875, 5.}, ImageScaled[{1, 1}]], 
        InsetBox["3", {1.484375, 5.}, ImageScaled[{1, 1}]], 
        InsetBox["3", {2.46875, 5.}, ImageScaled[{1, 1}]], 
        InsetBox["3", {4.4375, 5.}, ImageScaled[{1, 1}]]}, 
       {RGBColor[1, 0, 0], PointSize[0.1], 
        InsetBox["4", {5., 4.375}, ImageScaled[{1, 1}]], 
        InsetBox["4", {5., 1.875}, ImageScaled[{1, 1}]], 
        InsetBox["4", {5., 3.125}, ImageScaled[{1, 1}]], 
        InsetBox["4", {5., 0.625}, ImageScaled[{1, 1}]]}, 
       {RGBColor[1, 0, 0], PointSize[0.1], 
        InsetBox["5", {0.0625, 5.}, ImageScaled[{1, 1}]], 
        InsetBox["5", {0.28125, 5.}, ImageScaled[{1, 1}]], 
        InsetBox["5", {0.4375, 5.}, ImageScaled[{1, 1}]], 
        InsetBox["5", {0.1875, 5.}, ImageScaled[{1, 1}]], 
        InsetBox["5", {0.34375, 5.}, ImageScaled[{1, 1}]]}}}]}},
  DefaultBaseStyle->{
   LightDarkAutoColorRules -> <|"MarkedColors" -> True|>}]], "Output",
 CellChangeTimes->{
  3.97377584037035*^9, 3.9738454196368227`*^9, 3.973846520730446*^9, {
   3.9738555756315813`*^9, 3.9738556034986258`*^9}, 3.973922502680922*^9, 
   3.973922698981865*^9, 3.9739335638424873`*^9, 3.97393407018967*^9, 
   3.9739351115637836`*^9, 3.9739355104004297`*^9, 3.973936055821265*^9, {
   3.9739361653361483`*^9, 3.973936176027534*^9}, {3.9739362082276907`*^9, 
   3.973936260562463*^9}, 3.9739362974317904`*^9, 3.9739364106293163`*^9, 
   3.974023510001601*^9, 3.974024127022134*^9, {3.974107371480473*^9, 
   3.974107375196476*^9}, {3.974107462236061*^9, 3.97410748793258*^9}, 
   3.974107528721943*^9, 3.974183182554763*^9, 3.97418680065434*^9, {
   3.97418704097646*^9, 3.9741870607460127`*^9}, 3.974190376908227*^9, {
   3.9741978889929247`*^9, 3.974197907659976*^9}, 3.974200746700838*^9, 
   3.974200808923317*^9, 3.974275473337804*^9, 3.974283081176545*^9, 
   3.9742859336131687`*^9, 3.974289454263878*^9, 3.97429430930829*^9, 
   3.974373981610866*^9, 3.974375423335209*^9, 3.9743938328652697`*^9, 
   3.974443987975672*^9, 3.9744509486134644`*^9, 3.974457484642008*^9, 
   3.974458499402548*^9, 3.974623379962351*^9, 3.974623467987441*^9, 
   3.9747890003972073`*^9},
 CellLabel->"Out[32]=",ExpressionUUID->"f62a3df1-84df-4267-adca-c9b81684c4e1"],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[RGBColor[
    0.00010000076130382223`, 0.00010000076130382223`, 
     0.00010000076130382223`]], FaceForm[None], 
    GraphicsComplexBox[CompressedData["
1:eJxlenc8l+/3v73H63XfUigl7VB2JOeUoghtUoqMShqKykhSpCLaKSQNoxLZ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     "], PolygonBox[CompressedData["
1:eJwNxWdDIQwAAOCsukKLhro2Msuo0ETLKAoNXXUR7qqLzMgKIbKFbDJ+5/s+
X54ZpU6iBHZ0dMwBOjpA/4/Boq1OF4I8AIKUAkZDri8LAZYg4OpAP2KOQCT3
kmaImMxg/9wnYZxMGiATCf0DRMJAhvDZhxjM9BP6BxHZjCidimWyg4hecoKS
HiXlkYi+QhuZ7RvMFZCZA5EnmS2UgFgcPofsKwDb7TwJ2e4tfw3jSKMoPG4W
PT/7cwI7Nl4czZeLMOYKAwjIDw+hcNjxEdwoaqSMR2Pn8UPzaPwkBl0cGcWj
hnAjqMnZiTEimTgzhxsnjWExxDEMeXysCKgW8wBUebhYHpnCTE7PzeQWC1UA
pA3MU2hJwe4eEAKgJprfPfDmcmV5idla/15uJjrrDTAEVKuCQRUwo1HfXN9i
Miqtxlqtq1qvgeOrkS4orMGIrDBZzQqowqhXlpncyCq4UqckqMwlFmspHWGs
sLc4oFKT2iwtJ5bSSwloz496Z63R6oR3tkqLVFpuIUqPfUR5hcUSlUahLtJE
nuxijkZbSKaSR5RkCtmLIPW26ax0V7Gayy6E3jc2v9ezyYUatAvW/VXrhHdD
f5RhX/AeaDcMWuyC1eDQb3grvsJihzbWOK01Lmc1zN3a2ORsrW9ssVuc9Qh3
Lbz6weZww2zu5sY7b5/PC4V54Y8Q/z0cYvNDvA969J2//RGnR/d5jchaPLJC
j7M+VuOUVHqbL5ianjk4FP2cnpidRE9NTkxPTcxgpjKfB3vbglfxoehQLIgK
Y/R0NOYXCHejgn0Bf19+eiYSe1594qTnSHbkPY5J5Ce+I1nK4z3yumVir8cr
9p14fS6nVCpzp2SSlCTmDwrdJw6/MCqTSo4lUuexNHbsdztcO7uBY6c/6Hd6
T9xy36nv9VR+7nCc290u6bn8zHEi/2V/OX+xq5S287OXC6srIAzu7O06rRqd
0RQIGneFgbedgP3C4XJcXF1f2qwXF3bb9ZUqqDHarlXPFrXq6vbafmn/dWm/
tv1W3JpNmqBTY9SYbGar2aa8eVb/vlForGalSmExqxWqW4Va+aTV63Wm+7u/
ZqX60aDV/3ky6gxqxY3+/o/l+cFktlj0pn+PWr3l7s7y8PfuQX93/0/7pNXp
DY9vhreATmv4Dy61KNs=
      "]]]}, 
   {EdgeForm[RGBColor[
    0.00010000076130382223`, 0.00010000076130382223`, 
     0.00010000076130382223`]], FaceForm[None], 
    GraphicsComplexBox[CompressedData["
1:eJxlenc8l+/3v73H63XfUigl7VB2JOeUoghtUoqMShqKykhSpCLaKSQNoxLZ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     "], {PointBox[{96, 107, 119, 583, 585, 609, 618}], 
      PointBox[{32, 35, 76, 77, 86, 87, 91, 92, 93, 99, 122, 128, 148, 204, 
       307, 460, 462, 465, 469, 479, 525, 534, 539, 557, 569, 573, 576}], 
      PointBox[{8, 9, 10, 21, 22, 34, 39, 62, 67, 68, 70, 109, 132, 136, 152, 
       162, 254, 262, 263, 280, 292, 321, 382, 414, 417, 421, 441, 452, 466, 
       544, 551, 613, 621}], PointBox[{103, 106, 112, 600, 605, 608, 619}], 
      PointBox[{95}], PointBox[{104}], PointBox[{28}], PointBox[{108}], 
      {RGBColor[1, 0, 0], InsetBox["8", {0.640625, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["9", {0.5703125, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["10", {0.7109375, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["21", {0.3125, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["22", {0.375, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["28", {0., 5.}, ImageScaled[{0, 0}]], 
       InsetBox["32", {0., 4.875}, ImageScaled[{0, 0}]], 
       InsetBox["34", {0.125, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["35", {0., 4.75}, ImageScaled[{0, 0}]], 
       InsetBox["39", {0.25, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["62", {0.921875, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["67", {1.34375, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["68", {2.1875, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["70", {1.625, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["76", {0., 4.375}, ImageScaled[{0, 0}]], 
       InsetBox["77", {0., 4.25}, ImageScaled[{0, 0}]], 
       InsetBox["86", {0., 3.75}, ImageScaled[{0, 0}]], 
       InsetBox["87", {0., 3.5}, ImageScaled[{0, 0}]], 
       InsetBox["91", {0., 3.}, ImageScaled[{0, 0}]], 
       InsetBox["92", {0., 2.625}, ImageScaled[{0, 0}]], 
       InsetBox["93", {0., 2.25}, ImageScaled[{0, 0}]], 
       InsetBox["95", {0., 0.}, ImageScaled[{0, 0}]], 
       InsetBox["96", {1.25, 0.}, ImageScaled[{0, 0}]], 
       InsetBox["99", {0., 1.5}, ImageScaled[{0, 0}]], 
       InsetBox["103", {5., 2.5}, ImageScaled[{0, 0}]], 
       InsetBox["104", {5., 0.}, ImageScaled[{0, 0}]], 
       InsetBox["106", {5., 1.25}, ImageScaled[{0, 0}]], 
       InsetBox["107", {3.75, 0.}, ImageScaled[{0, 0}]], 
       InsetBox["108", {5., 5.}, ImageScaled[{0, 0}]], 
       InsetBox["109", {3.875, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["112", {5., 3.75}, ImageScaled[{0, 0}]], 
       InsetBox["119", {2.5, 0.}, ImageScaled[{0, 0}]], 
       InsetBox["122", {0., 3.25}, ImageScaled[{0, 0}]], 
       InsetBox["128", {0., 4.}, ImageScaled[{0, 0}]], 
       InsetBox["132", {2.75, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["136", {1.0625, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["148", {0., 4.5}, ImageScaled[{0, 0}]], 
       InsetBox["152", {0.5, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["162", {0.78125, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["204", {0., 4.625}, ImageScaled[{0, 0}]], 
       InsetBox["254", {0.4375, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["262", {0.1875, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["263", {0.0625, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["280", {0.34375, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["292", {0.28125, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["307", {0., 4.8125}, ImageScaled[{0, 0}]], 
       InsetBox["321", {0.74609375, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["382", {0.67578125, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["414", {0.8515625, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["417", {0.53515625, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["421", {0.60546875, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["441", {0.9921875, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["452", {1.203125, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["460", {0., 4.3125}, ImageScaled[{0, 0}]], 
       InsetBox["462", {0., 4.9375}, ImageScaled[{0, 0}]], 
       InsetBox["465", {0., 4.4375}, ImageScaled[{0, 0}]], 
       InsetBox["466", {1.484375, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["469", {0., 4.125}, ImageScaled[{0, 0}]], 
       InsetBox["479", {0., 3.625}, ImageScaled[{0, 0}]], 
       InsetBox["525", {0., 3.875}, ImageScaled[{0, 0}]], 
       InsetBox["534", {0., 3.125}, ImageScaled[{0, 0}]], 
       InsetBox["539", {0., 3.375}, ImageScaled[{0, 0}]], 
       InsetBox["544", {1.90625, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["551", {2.46875, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["557", {0., 2.4375}, ImageScaled[{0, 0}]], 
       InsetBox["569", {0., 1.875}, ImageScaled[{0, 0}]], 
       InsetBox["573", {0., 2.8125}, ImageScaled[{0, 0}]], 
       InsetBox["576", {0., 0.75}, ImageScaled[{0, 0}]], 
       InsetBox["583", {1.875, 0.}, ImageScaled[{0, 0}]], 
       InsetBox["585", {0.625, 0.}, ImageScaled[{0, 0}]], 
       InsetBox["600", {5., 0.625}, ImageScaled[{0, 0}]], 
       InsetBox["605", {5., 3.125}, ImageScaled[{0, 0}]], 
       InsetBox["608", {5., 1.875}, ImageScaled[{0, 0}]], 
       InsetBox["609", {3.125, 0.}, ImageScaled[{0, 0}]], 
       InsetBox["613", {4.4375, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["618", {4.375, 0.}, ImageScaled[{0, 0}]], 
       InsetBox["619", {5., 4.375}, ImageScaled[{0, 0}]], 
       InsetBox["621", {3.3125, 5.}, ImageScaled[{0, 0}]]}}]}},
  DefaultBaseStyle->{
   LightDarkAutoColorRules -> <|"MarkedColors" -> True|>}]], "Output",
 CellChangeTimes->{
  3.97377584037035*^9, 3.9738454196368227`*^9, 3.973846520730446*^9, {
   3.9738555756315813`*^9, 3.9738556034986258`*^9}, 3.973922502680922*^9, 
   3.973922698981865*^9, 3.9739335638424873`*^9, 3.97393407018967*^9, 
   3.9739351115637836`*^9, 3.9739355104004297`*^9, 3.973936055821265*^9, {
   3.9739361653361483`*^9, 3.973936176027534*^9}, {3.9739362082276907`*^9, 
   3.973936260562463*^9}, 3.9739362974317904`*^9, 3.9739364106293163`*^9, 
   3.974023510001601*^9, 3.974024127022134*^9, {3.974107371480473*^9, 
   3.974107375196476*^9}, {3.974107462236061*^9, 3.97410748793258*^9}, 
   3.974107528721943*^9, 3.974183182554763*^9, 3.97418680065434*^9, {
   3.97418704097646*^9, 3.9741870607460127`*^9}, 3.974190376908227*^9, {
   3.9741978889929247`*^9, 3.974197907659976*^9}, 3.974200746700838*^9, 
   3.974200808923317*^9, 3.974275473337804*^9, 3.974283081176545*^9, 
   3.9742859336131687`*^9, 3.974289454263878*^9, 3.97429430930829*^9, 
   3.974373981610866*^9, 3.974375423335209*^9, 3.9743938328652697`*^9, 
   3.974443987975672*^9, 3.9744509486134644`*^9, 3.974457484642008*^9, 
   3.974458499402548*^9, 3.974623379962351*^9, 3.974623467987441*^9, 
   3.974789000557033*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"238065c5-8f75-45d5-9f04-4ca997292514"],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[RGBColor[
    0.00010000076130382223`, 0.00010000076130382223`, 
     0.00010000076130382223`]], FaceForm[None], 
    GraphicsComplexBox[CompressedData["
1:eJxlenc8l+/3v73H63XfUigl7VB2JOeUoghtUoqMShqKykhSpCLaKSQNoxLZ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     "], PolygonBox[CompressedData["
1:eJwNxWdDIQwAAOCsukKLhro2Msuo0ETLKAoNXXUR7qqLzMgKIbKFbDJ+5/s+
X54ZpU6iBHZ0dMwBOjpA/4/Boq1OF4I8AIKUAkZDri8LAZYg4OpAP2KOQCT3
kmaImMxg/9wnYZxMGiATCf0DRMJAhvDZhxjM9BP6BxHZjCidimWyg4hecoKS
HiXlkYi+QhuZ7RvMFZCZA5EnmS2UgFgcPofsKwDb7TwJ2e4tfw3jSKMoPG4W
PT/7cwI7Nl4czZeLMOYKAwjIDw+hcNjxEdwoaqSMR2Pn8UPzaPwkBl0cGcWj
hnAjqMnZiTEimTgzhxsnjWExxDEMeXysCKgW8wBUebhYHpnCTE7PzeQWC1UA
pA3MU2hJwe4eEAKgJprfPfDmcmV5idla/15uJjrrDTAEVKuCQRUwo1HfXN9i
Miqtxlqtq1qvgeOrkS4orMGIrDBZzQqowqhXlpncyCq4UqckqMwlFmspHWGs
sLc4oFKT2iwtJ5bSSwloz496Z63R6oR3tkqLVFpuIUqPfUR5hcUSlUahLtJE
nuxijkZbSKaSR5RkCtmLIPW26ax0V7Gayy6E3jc2v9ezyYUatAvW/VXrhHdD
f5RhX/AeaDcMWuyC1eDQb3grvsJihzbWOK01Lmc1zN3a2ORsrW9ssVuc9Qh3
Lbz6weZww2zu5sY7b5/PC4V54Y8Q/z0cYvNDvA969J2//RGnR/d5jchaPLJC
j7M+VuOUVHqbL5ianjk4FP2cnpidRE9NTkxPTcxgpjKfB3vbglfxoehQLIgK
Y/R0NOYXCHejgn0Bf19+eiYSe1594qTnSHbkPY5J5Ce+I1nK4z3yumVir8cr
9p14fS6nVCpzp2SSlCTmDwrdJw6/MCqTSo4lUuexNHbsdztcO7uBY6c/6Hd6
T9xy36nv9VR+7nCc290u6bn8zHEi/2V/OX+xq5S287OXC6srIAzu7O06rRqd
0RQIGneFgbedgP3C4XJcXF1f2qwXF3bb9ZUqqDHarlXPFrXq6vbafmn/dWm/
tv1W3JpNmqBTY9SYbGar2aa8eVb/vlForGalSmExqxWqW4Va+aTV63Wm+7u/
ZqX60aDV/3ky6gxqxY3+/o/l+cFktlj0pn+PWr3l7s7y8PfuQX93/0/7pNXp
DY9vhreATmv4Dy61KNs=
      "]]]}, 
   {EdgeForm[RGBColor[
    0.00010000076130382223`, 0.00010000076130382223`, 
     0.00010000076130382223`]], FaceForm[None], 
    GraphicsComplexBox[CompressedData["
1:eJxlenc8l+/3v73H63XfUigl7VB2JOeUoghtUoqMShqKykhSpCLaKSQNoxLZ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     "], {PointBox[{96, 107, 119, 583, 585, 609, 618}], 
      PointBox[{32, 35, 76, 77, 86, 87, 91, 92, 93, 99, 122, 128, 148, 204, 
       307, 460, 462, 465, 469, 479, 525, 534, 539, 557, 569, 573, 576}], 
      PointBox[{8, 9, 10, 21, 22, 34, 39, 62, 67, 68, 70, 109, 132, 136, 152, 
       162, 254, 262, 263, 280, 292, 321, 382, 414, 417, 421, 441, 452, 466, 
       544, 551, 613, 621}], PointBox[{103, 106, 112, 600, 605, 608, 619}], 
      PointBox[{95}], PointBox[{104}], PointBox[{28}], PointBox[{108}], 
      {RGBColor[1, 0, 0], InsetBox["8", {0.640625, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["9", {0.5703125, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["10", {0.7109375, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["21", {0.3125, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["22", {0.375, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["28", {0., 5.}, ImageScaled[{0, 0}]], 
       InsetBox["32", {0., 4.875}, ImageScaled[{0, 0}]], 
       InsetBox["34", {0.125, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["35", {0., 4.75}, ImageScaled[{0, 0}]], 
       InsetBox["39", {0.25, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["62", {0.921875, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["67", {1.34375, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["68", {2.1875, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["70", {1.625, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["76", {0., 4.375}, ImageScaled[{0, 0}]], 
       InsetBox["77", {0., 4.25}, ImageScaled[{0, 0}]], 
       InsetBox["86", {0., 3.75}, ImageScaled[{0, 0}]], 
       InsetBox["87", {0., 3.5}, ImageScaled[{0, 0}]], 
       InsetBox["91", {0., 3.}, ImageScaled[{0, 0}]], 
       InsetBox["92", {0., 2.625}, ImageScaled[{0, 0}]], 
       InsetBox["93", {0., 2.25}, ImageScaled[{0, 0}]], 
       InsetBox["95", {0., 0.}, ImageScaled[{0, 0}]], 
       InsetBox["96", {1.25, 0.}, ImageScaled[{0, 0}]], 
       InsetBox["99", {0., 1.5}, ImageScaled[{0, 0}]], 
       InsetBox["103", {5., 2.5}, ImageScaled[{0, 0}]], 
       InsetBox["104", {5., 0.}, ImageScaled[{0, 0}]], 
       InsetBox["106", {5., 1.25}, ImageScaled[{0, 0}]], 
       InsetBox["107", {3.75, 0.}, ImageScaled[{0, 0}]], 
       InsetBox["108", {5., 5.}, ImageScaled[{0, 0}]], 
       InsetBox["109", {3.875, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["112", {5., 3.75}, ImageScaled[{0, 0}]], 
       InsetBox["119", {2.5, 0.}, ImageScaled[{0, 0}]], 
       InsetBox["122", {0., 3.25}, ImageScaled[{0, 0}]], 
       InsetBox["128", {0., 4.}, ImageScaled[{0, 0}]], 
       InsetBox["132", {2.75, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["136", {1.0625, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["148", {0., 4.5}, ImageScaled[{0, 0}]], 
       InsetBox["152", {0.5, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["162", {0.78125, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["204", {0., 4.625}, ImageScaled[{0, 0}]], 
       InsetBox["254", {0.4375, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["262", {0.1875, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["263", {0.0625, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["280", {0.34375, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["292", {0.28125, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["307", {0., 4.8125}, ImageScaled[{0, 0}]], 
       InsetBox["321", {0.74609375, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["382", {0.67578125, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["414", {0.8515625, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["417", {0.53515625, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["421", {0.60546875, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["441", {0.9921875, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["452", {1.203125, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["460", {0., 4.3125}, ImageScaled[{0, 0}]], 
       InsetBox["462", {0., 4.9375}, ImageScaled[{0, 0}]], 
       InsetBox["465", {0., 4.4375}, ImageScaled[{0, 0}]], 
       InsetBox["466", {1.484375, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["469", {0., 4.125}, ImageScaled[{0, 0}]], 
       InsetBox["479", {0., 3.625}, ImageScaled[{0, 0}]], 
       InsetBox["525", {0., 3.875}, ImageScaled[{0, 0}]], 
       InsetBox["534", {0., 3.125}, ImageScaled[{0, 0}]], 
       InsetBox["539", {0., 3.375}, ImageScaled[{0, 0}]], 
       InsetBox["544", {1.90625, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["551", {2.46875, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["557", {0., 2.4375}, ImageScaled[{0, 0}]], 
       InsetBox["569", {0., 1.875}, ImageScaled[{0, 0}]], 
       InsetBox["573", {0., 2.8125}, ImageScaled[{0, 0}]], 
       InsetBox["576", {0., 0.75}, ImageScaled[{0, 0}]], 
       InsetBox["583", {1.875, 0.}, ImageScaled[{0, 0}]], 
       InsetBox["585", {0.625, 0.}, ImageScaled[{0, 0}]], 
       InsetBox["600", {5., 0.625}, ImageScaled[{0, 0}]], 
       InsetBox["605", {5., 3.125}, ImageScaled[{0, 0}]], 
       InsetBox["608", {5., 1.875}, ImageScaled[{0, 0}]], 
       InsetBox["609", {3.125, 0.}, ImageScaled[{0, 0}]], 
       InsetBox["613", {4.4375, 5.}, ImageScaled[{0, 0}]], 
       InsetBox["618", {4.375, 0.}, ImageScaled[{0, 0}]], 
       InsetBox["619", {5., 4.375}, ImageScaled[{0, 0}]], 
       InsetBox["621", {3.3125, 5.}, ImageScaled[{0, 0}]]}}]}},
  DefaultBaseStyle->{
   LightDarkAutoColorRules -> <|"MarkedColors" -> True|>}]], "Output",
 CellChangeTimes->{
  3.97377584037035*^9, 3.9738454196368227`*^9, 3.973846520730446*^9, {
   3.9738555756315813`*^9, 3.9738556034986258`*^9}, 3.973922502680922*^9, 
   3.973922698981865*^9, 3.9739335638424873`*^9, 3.97393407018967*^9, 
   3.9739351115637836`*^9, 3.9739355104004297`*^9, 3.973936055821265*^9, {
   3.9739361653361483`*^9, 3.973936176027534*^9}, {3.9739362082276907`*^9, 
   3.973936260562463*^9}, 3.9739362974317904`*^9, 3.9739364106293163`*^9, 
   3.974023510001601*^9, 3.974024127022134*^9, {3.974107371480473*^9, 
   3.974107375196476*^9}, {3.974107462236061*^9, 3.97410748793258*^9}, 
   3.974107528721943*^9, 3.974183182554763*^9, 3.97418680065434*^9, {
   3.97418704097646*^9, 3.9741870607460127`*^9}, 3.974190376908227*^9, {
   3.9741978889929247`*^9, 3.974197907659976*^9}, 3.974200746700838*^9, 
   3.974200808923317*^9, 3.974275473337804*^9, 3.974283081176545*^9, 
   3.9742859336131687`*^9, 3.974289454263878*^9, 3.97429430930829*^9, 
   3.974373981610866*^9, 3.974375423335209*^9, 3.9743938328652697`*^9, 
   3.974443987975672*^9, 3.9744509486134644`*^9, 3.974457484642008*^9, 
   3.974458499402548*^9, 3.974623379962351*^9, 3.974623467987441*^9, 
   3.974789000712679*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"27c8cb51-a68e-4295-b37d-3711891b7ead"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"epspsolsvec", "[", 
  RowBox[{"[", "5", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.974276286952404*^9, 3.974276308018152*^9}},
 CellLabel->
  "In[147]:=",ExpressionUUID->"945db6b6-fbea-40e1-8253-65610f4a9608"],

Cell[BoxData[
 TemplateBox[<|"shortenedBoxes" -> TagBox[
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"0.00004203708010750995`", ",", 
             RowBox[{"-", "0.00004203708010751012`"}], ",", 
             "0.00008809193508487576`"}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"0.00007175669400934185`", ",", 
             RowBox[{"-", "0.00007175669400934189`"}], ",", 
             RowBox[{"-", "0.000014099216756314884`"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"0.000017601144066020855`", ",", 
             RowBox[{"-", "0.00001760114406602106`"}], ",", 
             RowBox[{"-", "4.053567620285991`*^-6"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"0.00005760413927349123`", ",", 
             RowBox[{"-", "0.00005760413927349141`"}], ",", 
             "0.000040940355108908876`"}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"0.00004501570610390042`", ",", 
             RowBox[{"-", "0.00004501570610390049`"}], ",", 
             RowBox[{"-", "0.000014624073350617942`"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"0.000026754822259364955`", ",", 
             RowBox[{"-", "0.00002675482225936511`"}], ",", 
             "0.000044436088617677953`"}], "}"}], ",", 
         TemplateBox[{"2025"}, "OutputSizeLimit`Skeleton"], ",", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{"-", "6.098637220230962`*^-20"}], ",", 
             "2.0328790734103208`*^-20", ",", "0.000011362288955677615`"}], 
           "}"}], ",", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{"-", "1.0842021724855044`*^-19"}], ",", 
             "7.453889935837843`*^-20", ",", "0.00001856379431349459`"}], 
           "}"}], ",", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{"-", "8.809142651444724`*^-20"}], ",", 
             "8.809142651444724`*^-20", ",", "0.00001980888067196693`"}], 
           "}"}], ",", 
         RowBox[{"{", 
           
           RowBox[{"6.776263578034403`*^-21", ",", "2.0328790734103208`*^-20",
              ",", "0.000014177652072485929`"}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{"-", "6.098637220230962`*^-20"}], ",", 
             "8.131516293641283`*^-20", ",", "0.00002405469960683623`"}], 
           "}"}], ",", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{"-", "4.0657581468206416`*^-20"}], ",", 
             "4.0657581468206416`*^-20", ",", "0.000019347077450429685`"}], 
           "}"}]}], "}"}], Short[#, 8]& ], "line" -> 147, "sessionID" -> 
   34786614259291958803, "byteCount" -> 244528, "size" -> 8, "stored" -> 
   False, "expr" -> Missing["NotAvailable", "NewSessionID"], "wrap" -> 
   OutputSizeLimit`Defer, "version" -> 1|>,
  "OutputSizeLimitTemplate"]], "Output",
 CellChangeTimes->{{3.9742762884697447`*^9, 3.9742763082654257`*^9}},
 CellLabel->
  "Out[147]=",ExpressionUUID->"bd5f69a7-a2f0-4321-9460-a2eb162596cd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sqrt", "[", "3", "]"}], "490."}]], "Input",
 CellLabel->"In[35]:=",ExpressionUUID->"998603dc-7de4-4ad9-849d-00081aff6afd"],

Cell[BoxData["848.7048957087499`"], "Output",
 CellChangeTimes->{3.974373997350713*^9},
 CellLabel->"Out[35]=",ExpressionUUID->"671d3aa9-8449-4ee9-a03a-98219f7747d3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"plot", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"solsvec", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"epspsolsvec", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cumplasticstrain", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"coords", "=", 
     RowBox[{"emesh", "[", "\"\<Coordinates\>\"", "]"}]}], ";"}], "\n", 
   RowBox[{"nodeId", "=", 
    RowBox[{
     RowBox[{"FirstPosition", "[", 
      RowBox[{"coords", ",", 
       RowBox[{"{", 
        RowBox[{"0.", ",", "5."}], "}"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "\n", 
   RowBox[{"nodeId", "=", 
    RowBox[{
     RowBox[{"FirstPosition", "[", 
      RowBox[{"coords", ",", 
       RowBox[{"pt_", "/;", 
        RowBox[{
         RowBox[{"Norm", "[", 
          RowBox[{"pt", "-", 
           RowBox[{"{", 
            RowBox[{"0", ",", "5"}], "}"}]}], "]"}], "<", "1*^-6"}]}]}], 
      "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "\n", 
   RowBox[{
    RowBox[{"nf", "=", 
     RowBox[{"Nearest", "[", 
      RowBox[{"coords", "->", "\"\<Index\>\""}], "]"}]}], ";"}], "\n", 
   RowBox[{"nodeId", "=", 
    RowBox[{
     RowBox[{"nf", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "5"}], "}"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "\[IndentingNewLine]", "\n", "\n", 
   RowBox[{
    RowBox[{"idpostproc", "=", "nodeId"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dim", "=", "2"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"thick", "=", "1."}], ";"}], "\n", 
   RowBox[{
    RowBox[{"globalcounter", "=", "1"}], ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"young2", "=", 
     RowBox[{"10", "^", "7"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"nu2", "=", "0.48"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"substtotal", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"young2", ",", "nu2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"20", " ", 
          RowBox[{"Pi", "/", "180"}]}], ",", "490."}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bodyforce", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bcDirichlet", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", "4"}], "}"}], ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{
          RowBox[{"Marker", " ", "1", " ", 
           RowBox[{"(", 
            RowBox[{"face", " ", "esquerda"}], ")"}]}], ":", "ux"}], "=", 
         "0"}], "*)"}], 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "1", "}"}], ",", "2", ",", "0"}], "}"}]}], "     ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
         RowBox[{"Marker", " ", "3", " ", 
          RowBox[{"(", 
           RowBox[{"face", " ", "inferior"}], ")"}]}], ":", "uy"}], "=", 
        "0"}], "*)"}], "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bcNeumann", "=", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "5", "}"}], ",", 
        RowBox[{"Function", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"-", "490"}]}], "}"}]}], "]"}]}], "}"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"convergencepostdata", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "plot", ",", "solsvec", ",", "epspsolsvec", ",", "cumplasticstrain"}], 
      "}"}], "=", 
     RowBox[{"IterativeProcessArc", "[", 
      RowBox[{"emesh", ",", "bcDirichlet", ",", "bcNeumann"}], "]"}]}], ";"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", "Plotar", "*)"}], "\n", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"plot", ",", 
     RowBox[{"AxesLabel", "->", 
      RowBox[{"{", 
       RowBox[{"\"\<uy_max\>\"", ",", "\"\<\[Lambda]\>\""}], "}"}]}], ",", 
     RowBox[{"PlotMarkers", "->", "Automatic"}]}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.9737487963660192`*^9, 3.973748843551755*^9}, {
   3.973748905009975*^9, 3.973748928201705*^9}, {3.973748998754162*^9, 
   3.973749037680987*^9}, 3.973751141039559*^9, {3.973751382236631*^9, 
   3.973751393345573*^9}, {3.9737517677051773`*^9, 3.973751778693125*^9}, {
   3.9737524861211653`*^9, 3.973752508198017*^9}, {3.973752541811982*^9, 
   3.9737525680094843`*^9}, {3.973752616824461*^9, 3.9737527559004517`*^9}, {
   3.973752853455174*^9, 3.973752930575053*^9}, {3.9737529984865227`*^9, 
   3.973753010988851*^9}, {3.973753041388145*^9, 3.9737530975951977`*^9}, {
   3.973753163146369*^9, 3.97375317536517*^9}, {3.973753220089752*^9, 
   3.973753225798519*^9}, {3.973753583869136*^9, 3.973753591855547*^9}, {
   3.973754971001459*^9, 3.973754977298683*^9}, 3.973757425130436*^9, 
   3.973759516301903*^9, {3.973764271070712*^9, 3.973764288127522*^9}, {
   3.973764340374754*^9, 3.973764344451716*^9}, {3.9737644811146317`*^9, 
   3.973764482945047*^9}, {3.97384542540942*^9, 3.973845427504879*^9}, {
   3.973845505918497*^9, 3.9738455184341593`*^9}, {3.9738555842743187`*^9, 
   3.9738555905891523`*^9}, 3.973922592306986*^9, {3.973933585071204*^9, 
   3.973933588638682*^9}, {3.974183730108656*^9, 3.974183732505694*^9}, {
   3.974186937554253*^9, 3.974186944453767*^9}, {3.974190380662219*^9, 
   3.974190381875352*^9}, 3.974196883032641*^9, {3.974197893362877*^9, 
   3.974197894642132*^9}, 3.974200416848518*^9, {3.9742777947966423`*^9, 
   3.974277807723694*^9}, 3.974278296507332*^9, {3.974283205028124*^9, 
   3.974283211714018*^9}, {3.974294315203442*^9, 3.974294315723424*^9}, {
   3.974458506414192*^9, 3.9744585123576813`*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"c53829e7-3152-46e6-87ae-64596e29f341"],

Cell[BoxData["28"], "Output",
 CellChangeTimes->CompressedData["
1:eJwV0F1IUwEcBfA5ZdtDRhqEsDQaRKmxzJRUbrLryLSPmc611nTKyNXS/BhU
JmQSjlXOCrKoLMS7dceiTYcPI3uQqNCIctIwplEmIVu1LYMgtFb/83D4cR7P
2Wxsq2lKEggEVZSDM6aNmsEoOy/pyIVzhdqdsMJf3ACTA+oOOPuCH4Ax6ycP
5Donx6FCL0o9gt53hYGZFa0K+JAp64XxEvMYzDhr8EN+V8ok/KNKD8L3VTOL
sC4u/AbNgje/4NTn06twE/NMrCV7YvtKoaWoes1R0nGSn4VZ7euXoLJS8h06
20ruHCMZX+EQ1PmcLig73DMKJWfcunry6qmvbAP53PLTBoumpdegXdtb3kgG
x9IOwdT+qd2XyJZ8ZRm07zdNwIg6KLeRj/YaQi4y8G/DF1jQPbQMG1eESg/+
cg3bveTt1sgN2NL39BYM8G8dcDr97vkQdvgtxcL7UfbHXFyaTC6q3jHw8YF7
sq3ka2+2GYatpqVt5DjniMKucps4m5QZFQXQWi3nc8gP6wzzuWT3K1+NnMwz
iid2kBmlXH4tmdgubdaQH89dH4CShH1FS651jqh1pEKVJNKTJ15y+jqydjXU
VE9yTzQCK9mZ1f63n4wMLnTxZE6l+zIcvRBecJPH2d9pHrL54pabMLYnnJkg
RSneZdWDKPsfT9BJdA==
  "],
 CellLabel->"Out[40]=",ExpressionUUID->"6a066eda-6b64-4f74-8069-5165452a14ed"],

Cell[BoxData["28"], "Output",
 CellChangeTimes->CompressedData["
1:eJwV0F1IUwEcBfA5w+0hIw1CWBoNotRYZkoqN9l1ZLOPmc611nTKyNXS/BhU
JmQSjlXOCrKoLMS7dceiTYcPI4MkKjSinDSMaZRJyFZtyyAIrdX/PBx+nMdz
NhlbqxuTBAJBJeXAtGmDZiDKzonbc+FsoXYHVPqL62FyQN0OZ17w/TBm/eSB
XMfEGJTrU1IPo/deZmCmskUOHzBlPTBeYh6FGWcMfsjvXDUB/6jSg/B95fQC
rI0Lv0Gz4M0vOPn51ArcyDwTacnu2N5SaCmqWn2EdJzgZ2BW27pFqKgQf4fO
1pLbR0nGVzgIdT6nC0oPdY9A8Wm3ro68cvIrW08+t/y0waIpyVVo1/aUN5DB
0bSDMLVvctdFsjlfUQbt+0zjMKIOymzkwz2GkIsM/Fv/BRZ0DS7BhmWhwoO/
XEN2L3mrJXIdNvc+uQkD/FsHnEq/cy6EHX5LsfBelP0xG5ckkwuqdwx8tP+u
dAv52ptthmGraXErOcY5orCz3CbKJqVGeQG0Vsn4HPLDWsNcLtn1ylctI/OM
ovHtZEYpl19DJrZJmjTkx7PX+qE4YV/Wkmucw2odKVclpejJ4y85fS1ZsxJq
rCO5xxqBlezIavvbR0YG5jt5MqfCfQmOnA/Pu8lj7O80D9l0YfMNGNsdzkyQ
T5XeJdX9KPsfV2xKcA==
  "],
 CellLabel->"Out[41]=",ExpressionUUID->"ef25b3c4-ee90-456c-8f18-bb93b4351c32"],

Cell[BoxData["28"], "Output",
 CellChangeTimes->CompressedData["
1:eJwV0F1IUwEcBfDrDLeHjDQIYWk0iFJjlSmp3GRzZNrHNZ1rremUkaul+TGo
TMgkHKucFWRRWUh3645FWw4fRvYgUaER5aRhTKNMQrZqWwZBzFr9z8Phx3k8
Z4OxvbY5hWGYasr+adM6zVBUOSfpzIezRdrtsNJf0ghTA+pOOPNCGIQx6ycP
5LsmxqBCn5Z+CL3/EguzK9sU8AFb3gfjpeZRmHXa4IfCjhUT8A+XGYTvq6cX
YH1c9A2amTe/4OTnk8twPftMrCV7Y3vKoKW4ZuVh0nFcmIE5HWsWoapK8h06
20tvHSFZX9Ew1PmcLig72DsCJafcugby8omvykbyueWnDRZPSa9Au7avookM
jmYcgOkDkzsvkK0FqnJo32sahxF1UG4jH+42hFxk4N/aL7CwZ3gJNiVEKg/+
ct23e8mbbZFrsLX/6Q0YEN464FTm7bMh7PBbSkR3o8ofs3FpKrnAvWPho313
ZJvI195cMwxbTYubyTHeEYXdFTZxLikzKgqhtUYu5JEfVhvm8smeV75aObnN
KB7fSmaV8QV1ZHKLtEVDfjxzdRBKkvaEllzlfKzWkQouJU1PHnvJ6+vJuuVQ
cwPJP9EwVrIrp+PvABkZmu8WyLwq90U4ci487yaPKn9neMiW8xuvw9iucHaS
THDeJe5eVPkfWXZKsg==
  "],
 CellLabel->"Out[43]=",ExpressionUUID->"f5ca1f49-f582-4157-b7a6-2fe1eff15ba8"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"=== Step \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "0.0001`", "\[InvisibleSpace]", "\<\" | L = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"5.\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-3\"\>"]}],
      ShowStringCharacters->False],
     0.005,
     AutoDelete->True],
    ScientificForm[#, 3]& ], "\[InvisibleSpace]", "\<\" ===\"\>"}],
  SequenceForm["=== Step ", 1, " | \[Lambda] = ", 0.0001, " | L = ", 
   ScientificForm[0.005, 3], " ==="],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.9747890061993113`*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"9dcb58cf-76bb-4266-a36f-e3a5cf672549"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "6.588317605112561`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]",
    "6.588217605112561`", "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", 
   "\[InvisibleSpace]", "45.05761118685344`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.005000075893060911`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm[
  "iter ", 1, " | \[Lambda] = ", 6.588317605112561, 
   " | \[CapitalDelta]\[Lambda] = ", 6.588217605112561, " | \:2016r\:2016 = ",
    45.05761118685344, " | \:2016\[Delta]u\:2016 = ", 0.005000075893060911, 
   " | p = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.9747890089909077`*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"f97b7f07-e0f3-4048-b055-6f5d009b5be8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "6.566670572986541`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.02164703212601957`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "50.676267588124965`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.00007602317983563235`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm[
  "iter ", 2, " | \[Lambda] = ", 6.566670572986541, 
   " | \[CapitalDelta]\[Lambda] = ", -0.02164703212601957, 
   " | \:2016r\:2016 = ", 50.676267588124965`, " | \:2016\[Delta]u\:2016 = ", 
   0.00007602317983563235, " | p = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789012536872*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"98f79f2f-a128-4c32-ac67-b814cabee160"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "6.5624830304619755`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.004187542524565364`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "7.971656373117965`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.000017693892620333867`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm[
  "iter ", 3, " | \[Lambda] = ", 6.5624830304619755`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.004187542524565364, 
   " | \:2016r\:2016 = ", 7.971656373117965, " | \:2016\[Delta]u\:2016 = ", 
   0.000017693892620333867`, " | p = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789016130677*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"5bec973f-9caf-4d90-a6c3-0ee40c320e0f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "6.5623261185502235`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.0001569119117515319`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "0.8619292118394452`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "1.992302912411592`*^-6", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "1.2027011421263665`"}],
  SequenceForm[
  "iter ", 4, " | \[Lambda] = ", 6.5623261185502235`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.0001569119117515319, 
   " | \:2016r\:2016 = ", 0.8619292118394452, " | \:2016\[Delta]u\:2016 = ", 
   1.992302912411592*^-6, " | p = ", 1.2027011421263665`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789019743903*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"bb717c77-14f0-4937-a97a-19572fc538b1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "6.5623224891710725`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "3.6293791513584794`*^-6"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "0.00004635878720502543`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "2.4161178999881625`*^-8", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "4.419254020783506`"}],
  SequenceForm[
  "iter ", 5, " | \[Lambda] = ", 6.5623224891710725`, 
   " | \[CapitalDelta]\[Lambda] = ", -3.6293791513584794`*^-6, 
   " | \:2016r\:2016 = ", 0.00004635878720502543, 
   " | \:2016\[Delta]u\:2016 = ", 2.4161178999881625`*^-8, " | p = ", 
   4.419254020783506],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789023364058*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"73247c59-0a69-4a45-83bb-e00c178cb238"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "6.562322489296535`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]",
    "1.254619396152451`*^-10", 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "7.86867945389029`*^-11", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "7.598612965184064`*^-12", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "1.351551022398226`"}],
  SequenceForm[
  "iter ", 6, " | \[Lambda] = ", 6.562322489296535, 
   " | \[CapitalDelta]\[Lambda] = ", 1.254619396152451*^-10, 
   " | \:2016r\:2016 = ", 7.86867945389029*^-11, 
   " | \:2016\[Delta]u\:2016 = ", 7.598612965184064*^-12, " | p = ", 
   1.351551022398226],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.9747890269988747`*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"520b330a-740d-4da4-88b9-8673116de4a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"ACEITO em \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" iter | \[CapitalDelta]\[Lambda]_step = \"\>", "\[InvisibleSpace]",
    "6.562222489296535`", "\[InvisibleSpace]", "\<\" | fac = \"\>", "\[InvisibleSpace]",
    "1.1666666666666667`", "\[InvisibleSpace]", "\<\" | L_novo = \"\>", "\[InvisibleSpace]",
    "0.005`"}],
  SequenceForm[
  "ACEITO em ", 6, " iter | \[CapitalDelta]\[Lambda]_step = ", 
   6.562222489296535, " | fac = ", 1.1666666666666667`, " | L_novo = ", 0.005],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.9747890269997683`*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"a0abdb2e-a8b3-4771-b488-c61d1012b9d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"=== Step \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "6.562322489296535`", "\[InvisibleSpace]", "\<\" | L = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"5.\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-3\"\>"]}],
      ShowStringCharacters->False],
     0.005,
     AutoDelete->True],
    ScientificForm[#, 3]& ], "\[InvisibleSpace]", "\<\" ===\"\>"}],
  SequenceForm[
  "=== Step ", 2, " | \[Lambda] = ", 6.562322489296535, " | L = ", 
   ScientificForm[0.005, 3], " ==="],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789027000782*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"8dcdc7fb-a126-4449-baf7-f97da03bd9bb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "13.150540094409095`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]",
    "6.588217605112561`", "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", 
   "\[InvisibleSpace]", "287.7870057683028`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.00593427468956805`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm[
  "iter ", 1, " | \[Lambda] = ", 13.150540094409095`, 
   " | \[CapitalDelta]\[Lambda] = ", 6.588217605112561, " | \:2016r\:2016 = ",
    287.7870057683028, " | \:2016\[Delta]u\:2016 = ", 0.00593427468956805, 
   " | p = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789030917781*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"7bff241d-6d6a-4190-bed4-cfc5af3bceed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "10.724680929167054`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "2.4258591652420405`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "1650.9829513170425`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.0019060464541787202`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm[
  "iter ", 2, " | \[Lambda] = ", 10.724680929167054`, 
   " | \[CapitalDelta]\[Lambda] = ", -2.4258591652420405`, 
   " | \:2016r\:2016 = ", 1650.9829513170425`, " | \:2016\[Delta]u\:2016 = ", 
   0.0019060464541787202`, " | p = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789036652852*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"2b7b5c88-4af5-4f06-88aa-da1c96103f35"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "10.474238196556628`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.25044273261042466`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "252.85516808100923`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.00043325390081336296`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm[
  "iter ", 3, " | \[Lambda] = ", 10.474238196556628`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.25044273261042466`, 
   " | \:2016r\:2016 = ", 252.85516808100923`, " | \:2016\[Delta]u\:2016 = ", 
   0.00043325390081336296`, " | p = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789042256616*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"1caa855d-f513-415e-b1b7-2effaaadcba7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "10.415199441473586`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.0590387550830417`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "74.13818446244595`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.00013176523237594062`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0.6538826989991482`"}],
  SequenceForm[
  "iter ", 4, " | \[Lambda] = ", 10.415199441473586`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.0590387550830417, 
   " | \:2016r\:2016 = ", 74.13818446244595, " | \:2016\[Delta]u\:2016 = ", 
   0.00013176523237594062`, " | p = ", 0.6538826989991482],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789047872603*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"98b02fe3-c64c-4f4b-9a0d-b91ce4b3b105"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "10.409526971995966`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.005672469477620663`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "15.709747791854596`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.000018960241184484417`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "1.2647052069480254`"}],
  SequenceForm[
  "iter ", 5, " | \[Lambda] = ", 10.409526971995966`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.005672469477620663, 
   " | \:2016r\:2016 = ", 15.709747791854596`, " | \:2016\[Delta]u\:2016 = ", 
   0.000018960241184484417`, " | p = ", 1.2647052069480254`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789053684188*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"0583d879-71ad-4346-8afc-7b71216ea8c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "10.408948440543586`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.000578531452379381`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "1.2169527107937095`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "2.890500044879139`*^-6", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "1.6485242016043362`"}],
  SequenceForm[
  "iter ", 6, " | \[Lambda] = ", 10.408948440543586`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.000578531452379381, 
   " | \:2016r\:2016 = ", 1.2169527107937095`, " | \:2016\[Delta]u\:2016 = ", 
   2.890500044879139*^-6, " | p = ", 1.6485242016043362`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789059373392*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"3a612494-3109-4c92-9026-3bdd2a3b4f00"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "10.408935761906147`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.000012678637438640894`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "0.015494044377069086`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "1.8594672666571837`*^-7", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "1.7059290358116932`"}],
  SequenceForm[
  "iter ", 7, " | \[Lambda] = ", 10.408935761906147`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.000012678637438640894`, 
   " | \:2016r\:2016 = ", 0.015494044377069086`, 
   " | \:2016\[Delta]u\:2016 = ", 1.8594672666571837`*^-7, " | p = ", 
   1.7059290358116932`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789065070115*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"293cb12c-c591-4307-841e-1c6489fa72a1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "10.408935534686158`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "2.2721998827794542`*^-7"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "0.000010190162741379721`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "3.848429739383329`*^-9", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "1.67905056218553`"}],
  SequenceForm[
  "iter ", 8, " | \[Lambda] = ", 10.408935534686158`, 
   " | \[CapitalDelta]\[Lambda] = ", -2.2721998827794542`*^-7, 
   " | \:2016r\:2016 = ", 0.000010190162741379721`, 
   " | \:2016\[Delta]u\:2016 = ", 3.848429739383329*^-9, " | p = ", 
   1.67905056218553],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789070750308*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"28defa01-c19b-4e0a-8318-5a6ec900a3b4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "10.408935534549569`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1.3658928863832292`*^-10"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "1.1356427761643095`*^-10", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "2.369191503534576`*^-12", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "1.5565571298358172`"}],
  SequenceForm[
  "iter ", 9, " | \[Lambda] = ", 10.408935534549569`, 
   " | \[CapitalDelta]\[Lambda] = ", -1.3658928863832292`*^-10, 
   " | \:2016r\:2016 = ", 1.1356427761643095`*^-10, 
   " | \:2016\[Delta]u\:2016 = ", 2.369191503534576*^-12, " | p = ", 
   1.5565571298358172`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789076560836*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"933b71f9-e2c7-4baf-b094-0ea2db7d2d1c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"ACEITO em \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" iter | \[CapitalDelta]\[Lambda]_step = \"\>", "\[InvisibleSpace]",
    "3.846613045253034`", "\[InvisibleSpace]", "\<\" | fac = \"\>", "\[InvisibleSpace]",
    "0.7777777777777778`", "\[InvisibleSpace]", "\<\" | L_novo = \"\>", "\[InvisibleSpace]",
    "0.005`"}],
  SequenceForm[
  "ACEITO em ", 9, " iter | \[CapitalDelta]\[Lambda]_step = ", 
   3.846613045253034, " | fac = ", 0.7777777777777778, " | L_novo = ", 0.005],
  
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789076561952*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"87ed8a1d-cdf3-49fd-9dd6-01908d9643c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"=== Step \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "10.408935534549569`", "\[InvisibleSpace]", "\<\" | L = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"5.\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-3\"\>"]}],
      ShowStringCharacters->False],
     0.005,
     AutoDelete->True],
    ScientificForm[#, 3]& ], "\[InvisibleSpace]", "\<\" ===\"\>"}],
  SequenceForm[
  "=== Step ", 3, " | \[Lambda] = ", 10.408935534549569`, " | L = ", 
   ScientificForm[0.005, 3], " ==="],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789076562607*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"0830ae85-d298-484a-84d0-ab80256c000b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "16.99715313966213`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]",
    "6.588217605112561`", "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", 
   "\[InvisibleSpace]", "376.4178700903393`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.006406285165744991`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm[
  "iter ", 1, " | \[Lambda] = ", 16.99715313966213, 
   " | \[CapitalDelta]\[Lambda] = ", 6.588217605112561, " | \:2016r\:2016 = ",
    376.4178700903393, " | \:2016\[Delta]u\:2016 = ", 0.006406285165744991, 
   " | p = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789081015931*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"c392babd-aa84-41a7-92f8-fc1f8a6c4995"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "13.413491244354898`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "3.583661895307233`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "1227.906747091902`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.0025551443878975306`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm[
  "iter ", 2, " | \[Lambda] = ", 13.413491244354898`, 
   " | \[CapitalDelta]\[Lambda] = ", -3.583661895307233, 
   " | \:2016r\:2016 = ", 1227.906747091902, " | \:2016\[Delta]u\:2016 = ", 
   0.0025551443878975306`, " | p = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789088972554*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"f09715c4-f70b-43a8-bd3c-d124048c65ff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "12.985023723103053`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.4284675212518446`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "851.8033157833482`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.0008257437075798182`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm[
  "iter ", 3, " | \[Lambda] = ", 12.985023723103053`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.4284675212518446, 
   " | \:2016r\:2016 = ", 851.8033157833482, " | \:2016\[Delta]u\:2016 = ", 
   0.0008257437075798182, " | p = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.9747890948558693`*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"638ae3e8-1873-4c4f-b894-ed2bf97502c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "12.883318461725178`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.10170526137787504`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "184.44163025449572`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.0002401467559627054`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "4.1836986730635175`"}],
  SequenceForm[
  "iter ", 4, " | \[Lambda] = ", 12.883318461725178`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.10170526137787504`, 
   " | \:2016r\:2016 = ", 184.44163025449572`, " | \:2016\[Delta]u\:2016 = ", 
   0.0002401467559627054, " | p = ", 4.1836986730635175`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789101367462*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"d37cf9d9-b833-4fde-af7b-62bd024dc789"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "12.867907159787864`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.015411301937314685`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "23.010768123455037`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.000041793037342586886`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "1.360352948553461`"}],
  SequenceForm[
  "iter ", 5, " | \[Lambda] = ", 12.867907159787864`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.015411301937314685`, 
   " | \:2016r\:2016 = ", 23.010768123455037`, " | \:2016\[Delta]u\:2016 = ", 
   0.000041793037342586886`, " | p = ", 1.360352948553461],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.97478910791681*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"67295066-562f-497b-a1d8-0d30ac216448"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "12.865165817435788`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.0027413423520753918`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "7.585567604965039`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "7.962287347123556`*^-6", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0.5331653850903915`"}],
  SequenceForm[
  "iter ", 6, " | \[Lambda] = ", 12.865165817435788`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.0027413423520753918`, 
   " | \:2016r\:2016 = ", 7.585567604965039, " | \:2016\[Delta]u\:2016 = ", 
   7.962287347123556*^-6, " | p = ", 0.5331653850903915],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789114458878*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"d8c46f84-d31f-4944-a32b-5e0521cec16c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "12.864642748742964`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.00052306869282308`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "0.4779194753073997`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "2.653396762278506`*^-6", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "2.4912350070492075`"}],
  SequenceForm[
  "iter ", 7, " | \[Lambda] = ", 12.864642748742964`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.00052306869282308, 
   " | \:2016r\:2016 = ", 0.4779194753073997, " | \:2016\[Delta]u\:2016 = ", 
   2.653396762278506*^-6, " | p = ", 2.4912350070492075`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789120994536*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"13666d3f-8a2d-42ce-a638-44fe987cfba0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "12.864614153677328`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.000028595065635543306`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "0.00043704014540304706`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "1.3877704419819`*^-7", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "2.5310252995104427`"}],
  SequenceForm[
  "iter ", 8, " | \[Lambda] = ", 12.864614153677328`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.000028595065635543306`, 
   " | \:2016r\:2016 = ", 0.00043704014540304706`, 
   " | \:2016\[Delta]u\:2016 = ", 1.3877704419819*^-7, " | p = ", 
   2.5310252995104427`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789127721423*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"117bd5fa-10aa-4ac0-ac24-e3c459db8e5d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "12.864614113220572`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "4.0456756373410456`*^-8"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "1.780990189751781`*^-9", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "2.1121925467498152`*^-10", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "1.7736608433431724`"}],
  SequenceForm[
  "iter ", 9, " | \[Lambda] = ", 12.864614113220572`, 
   " | \[CapitalDelta]\[Lambda] = ", -4.0456756373410456`*^-8, 
   " | \:2016r\:2016 = ", 1.780990189751781*^-9, 
   " | \:2016\[Delta]u\:2016 = ", 2.1121925467498152`*^-10, " | p = ", 
   1.7736608433431724`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789134406226*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"829b44f0-c2f2-4f85-a9ab-54ab9483e9e1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"ACEITO em \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" iter | \[CapitalDelta]\[Lambda]_step = \"\>", "\[InvisibleSpace]",
    "2.4556785786710034`", "\[InvisibleSpace]", "\<\" | fac = \"\>", "\[InvisibleSpace]",
    "0.7777777777777778`", "\[InvisibleSpace]", "\<\" | L_novo = \"\>", "\[InvisibleSpace]",
    "0.005`"}],
  SequenceForm[
  "ACEITO em ", 9, " iter | \[CapitalDelta]\[Lambda]_step = ", 
   2.4556785786710034`, " | fac = ", 0.7777777777777778, " | L_novo = ", 
   0.005],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.9747891344072104`*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"4e5e290b-85ad-499d-a425-47d1229a214a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"=== Step \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "12.864614113220572`", "\[InvisibleSpace]", "\<\" | L = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"5.\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-3\"\>"]}],
      ShowStringCharacters->False],
     0.005,
     AutoDelete->True],
    ScientificForm[#, 3]& ], "\[InvisibleSpace]", "\<\" ===\"\>"}],
  SequenceForm[
  "=== Step ", 4, " | \[Lambda] = ", 12.864614113220572`, " | L = ", 
   ScientificForm[0.005, 3], " ==="],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.9747891344078608`*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"ded4618d-6caf-49a6-b14d-3ecc2cc55076"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "19.452831718333133`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]",
    "6.588217605112561`", "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", 
   "\[InvisibleSpace]", "410.9420143085327`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.006609204958167188`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm[
  "iter ", 1, " | \[Lambda] = ", 19.452831718333133`, 
   " | \[CapitalDelta]\[Lambda] = ", 6.588217605112561, " | \:2016r\:2016 = ",
    410.9420143085327, " | \:2016\[Delta]u\:2016 = ", 0.006609204958167188, 
   " | p = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789138886869*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"073c5a11-4dfd-4f70-a221-22e323db36a4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "15.351944695575828`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "4.1008870227573055`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "1777.7301539328496`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.0029836169711253287`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm[
  "iter ", 2, " | \[Lambda] = ", 15.351944695575828`, 
   " | \[CapitalDelta]\[Lambda] = ", -4.1008870227573055`, 
   " | \:2016r\:2016 = ", 1777.7301539328496`, " | \:2016\[Delta]u\:2016 = ", 
   0.0029836169711253287`, " | p = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789146071858*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"acb860bc-cdcb-4dbc-97b7-8b9d17892699"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.589736348215647`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.7622083473601804`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "287.85006149706754`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.001268523698776154`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm[
  "iter ", 3, " | \[Lambda] = ", 14.589736348215647`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.7622083473601804, 
   " | \:2016r\:2016 = ", 287.85006149706754`, " | \:2016\[Delta]u\:2016 = ", 
   0.001268523698776154, " | p = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789153757595*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"538b238a-faed-4a52-9a1d-24e601afa604"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.427925712320041`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.16181063589560474`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "379.49118918400086`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.00035623944326150357`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.15180908635797927`"}]}],
  SequenceForm[
  "iter ", 4, " | \[Lambda] = ", 14.427925712320041`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.16181063589560474`, 
   " | \:2016r\:2016 = ", 379.49118918400086`, " | \:2016\[Delta]u\:2016 = ", 
   0.00035623944326150357`, " | p = ", -0.15180908635797927`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789161186756*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"8da37d5a-bfc2-454b-ba25-ec3a0409a178"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.389386740997216`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.03853897132282486`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "53.145435947848036`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.00012138023263508724`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "7.1123679564945705`"}]}],
  SequenceForm[
  "iter ", 5, " | \[Lambda] = ", 14.389386740997216`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.03853897132282486, 
   " | \:2016r\:2016 = ", 53.145435947848036`, " | \:2016\[Delta]u\:2016 = ", 
   0.00012138023263508724`, " | p = ", -7.1123679564945705`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.9747891684927692`*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"f6b6e11f-6128-41c9-8728-56ec3e3976f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.381922655247804`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.007464085749410957`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "29.208920582653093`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.00003330200233075346`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0.30448587181540765`"}],
  SequenceForm[
  "iter ", 6, " | \[Lambda] = ", 14.381922655247804`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.007464085749410957, 
   " | \:2016r\:2016 = ", 29.208920582653093`, " | \:2016\[Delta]u\:2016 = ", 
   0.00003330200233075346, " | p = ", 0.30448587181540765`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.9747891758302794`*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"c0bdb0ef-2a40-469b-881f-d70ffb3c7b51"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.380377530179823`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.001545125067980858`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "1.8820712618214783`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.000011106315865855439`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "4.581178341113368`"}],
  SequenceForm[
  "iter ", 7, " | \[Lambda] = ", 14.380377530179823`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.001545125067980858, 
   " | \:2016r\:2016 = ", 1.8820712618214783`, " | \:2016\[Delta]u\:2016 = ", 
   0.000011106315865855439`, " | p = ", 4.581178341113368],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.9747891830173817`*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"51b479ae-5d1a-468c-9ccd-6d9c5ad0e3e2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.380268689455795`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.00010884072402872697`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "0.018204623301615663`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "8.329304435724053`*^-7", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "1.6915686770358849`"}],
  SequenceForm[
  "iter ", 8, " | \[Lambda] = ", 14.380268689455795`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.00010884072402872697`, 
   " | \:2016r\:2016 = ", 0.018204623301615663`, 
   " | \:2016\[Delta]u\:2016 = ", 8.329304435724053*^-7, " | p = ", 
   1.6915686770358849`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.9747891902529078`*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"d20eec96-ec7f-4c0d-adaf-327cebc1196e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.38026779197481`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "8.974809853113992`*^-7"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "2.535581324242048`*^-6", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "6.993054636584051`*^-9", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "1.9142176742267099`"}],
  SequenceForm[
  "iter ", 9, " | \[Lambda] = ", 14.38026779197481, 
   " | \[CapitalDelta]\[Lambda] = ", -8.974809853113992*^-7, 
   " | \:2016r\:2016 = ", 2.535581324242048*^-6, 
   " | \:2016\[Delta]u\:2016 = ", 6.993054636584051*^-9, " | p = ", 
   1.9142176742267099`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789197686946*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"9a20c323-536f-4149-8549-2abaf983213f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.380267791858003`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1.1680635796542857`*^-10"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "1.9594350471956496`*^-10", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "9.883999470690887`*^-13", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "1.0663474092143572`"}],
  SequenceForm[
  "iter ", 10, " | \[Lambda] = ", 14.380267791858003`, 
   " | \[CapitalDelta]\[Lambda] = ", -1.1680635796542857`*^-10, 
   " | \:2016r\:2016 = ", 1.9594350471956496`*^-10, 
   " | \:2016\[Delta]u\:2016 = ", 9.883999470690887*^-13, " | p = ", 
   1.0663474092143572`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789204998334*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"53b858d0-2644-4214-8ba7-2c17f2e38b11"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"ACEITO em \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" iter | \[CapitalDelta]\[Lambda]_step = \"\>", "\[InvisibleSpace]",
    "1.515653678637431`", "\[InvisibleSpace]", "\<\" | fac = \"\>", "\[InvisibleSpace]",
    "0.7`", "\[InvisibleSpace]", "\<\" | L_novo = \"\>", "\[InvisibleSpace]", 
   "0.005`"}],
  SequenceForm[
  "ACEITO em ", 10, " iter | \[CapitalDelta]\[Lambda]_step = ", 
   1.515653678637431, " | fac = ", 0.7, " | L_novo = ", 0.005],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789204999453*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"e4d9be5f-3310-46ed-8128-ae6d612d99d0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"=== Step \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.380267791858003`", "\[InvisibleSpace]", "\<\" | L = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"5.\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-3\"\>"]}],
      ShowStringCharacters->False],
     0.005,
     AutoDelete->True],
    ScientificForm[#, 3]& ], "\[InvisibleSpace]", "\<\" ===\"\>"}],
  SequenceForm[
  "=== Step ", 5, " | \[Lambda] = ", 14.380267791858003`, " | L = ", 
   ScientificForm[0.005, 3], " ==="],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789205000293*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"d87d2c92-1a69-449d-944e-e473e74b0de0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "20.968485396970564`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]",
    "6.588217605112561`", "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", 
   "\[InvisibleSpace]", "465.57126727511195`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.006639948842138976`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm[
  "iter ", 1, " | \[Lambda] = ", 20.968485396970564`, 
   " | \[CapitalDelta]\[Lambda] = ", 6.588217605112561, " | \:2016r\:2016 = ",
    465.57126727511195`, " | \:2016\[Delta]u\:2016 = ", 0.006639948842138976, 
   " | p = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.9747892097355556`*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"92e8c316-8dc7-4789-9537-cfe820576e30"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "16.221606810212357`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "4.746878586758207`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "1625.9717388129238`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.0034527336788817376`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm[
  "iter ", 2, " | \[Lambda] = ", 16.221606810212357`, 
   " | \[CapitalDelta]\[Lambda] = ", -4.746878586758207, 
   " | \:2016r\:2016 = ", 1625.9717388129238`, " | \:2016\[Delta]u\:2016 = ", 
   0.0034527336788817376`, " | p = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789217193681*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"55ecc242-e36f-4940-acc0-6031f7026c59"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "15.272049198542405`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.9495576116699528`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "859.6461924709671`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.0014540491438764815`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm[
  "iter ", 3, " | \[Lambda] = ", 15.272049198542405`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.9495576116699528, 
   " | \:2016r\:2016 = ", 859.6461924709671, " | \:2016\[Delta]u\:2016 = ", 
   0.0014540491438764815`, " | p = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.97478922511303*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"4063ff8c-10cc-4ba8-b234-0fe7ff4c3246"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "15.049191386195698`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.2228578123467066`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "457.06969506279995`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.0004291793629514312`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0.9911271959048169`"}],
  SequenceForm[
  "iter ", 4, " | \[Lambda] = ", 15.049191386195698`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.2228578123467066, 
   " | \:2016r\:2016 = ", 457.06969506279995`, " | \:2016\[Delta]u\:2016 = ", 
   0.0004291793629514312, " | p = ", 0.9911271959048169],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789233271616*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"77fa0c45-c07c-4ef8-adbd-0daff902729a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.961700863540397`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.08749052265530079`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "141.8290840399557`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.0002964742511826919`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "1.8525264282147986`"}],
  SequenceForm[
  "iter ", 5, " | \[Lambda] = ", 14.961700863540397`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.08749052265530079, 
   " | \:2016r\:2016 = ", 141.8290840399557, " | \:2016\[Delta]u\:2016 = ", 
   0.0002964742511826919, " | p = ", 1.8525264282147986`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789241251828*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"00f57363-4702-484e-bcae-998b3c37daef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.935626411063739`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.026074452476658388`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "57.60601936484882`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.0000863898613605849`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0.7699414474255366`"}],
  SequenceForm[
  "iter ", 6, " | \[Lambda] = ", 14.935626411063739`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.026074452476658388`, 
   " | \:2016r\:2016 = ", 57.60601936484882, " | \:2016\[Delta]u\:2016 = ", 
   0.0000863898613605849, " | p = ", 0.7699414474255366],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789249485548*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"4bdc5f86-30c9-41a5-ac98-e4e8fed4b206"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.934523046246607`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.0011033648171325464`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "121.0359636005172`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.00007957730593805052`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.8240446769448725`"}]}],
  SequenceForm[
  "iter ", 7, " | \[Lambda] = ", 14.934523046246607`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.0011033648171325464`, 
   " | \:2016r\:2016 = ", 121.0359636005172, " | \:2016\[Delta]u\:2016 = ", 
   0.00007957730593805052, " | p = ", -0.8240446769448725],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789257675996*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"68987dae-dbd6-4be2-994b-41d07b399b68"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.935269370491648`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]",
    "0.000746324245040337`", 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "10.574707302378288`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.00004235437928405887`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "3.2831674712018346`"}]}],
  SequenceForm[
  "iter ", 8, " | \[Lambda] = ", 14.935269370491648`, 
   " | \[CapitalDelta]\[Lambda] = ", 0.000746324245040337, 
   " | \:2016r\:2016 = ", 10.574707302378288`, " | \:2016\[Delta]u\:2016 = ", 
   0.00004235437928405887, " | p = ", -3.2831674712018346`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789266007874*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"95a7748f-f202-4f45-a232-4db95938c27b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.93533740476809`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]",
    "0.00006803427644140322`", 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "0.21093748804027504`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "6.967742345833338`*^-6", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "1.6059329202459767`"}],
  SequenceForm[
  "iter ", 9, " | \[Lambda] = ", 14.93533740476809, 
   " | \[CapitalDelta]\[Lambda] = ", 0.00006803427644140322, 
   " | \:2016r\:2016 = ", 0.21093748804027504`, " | \:2016\[Delta]u\:2016 = ",
    6.967742345833338*^-6, " | p = ", 1.6059329202459767`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789274258583*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"905d8e70-1b65-49a0-bd49-319244d18d86"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.935339899194787`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]",
    "2.4944266968908763`*^-6", 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "0.0002984622671108227`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "1.8402380381567365`*^-7", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "1.6759248821674917`"}],
  SequenceForm[
  "iter ", 10, " | \[Lambda] = ", 14.935339899194787`, 
   " | \[CapitalDelta]\[Lambda] = ", 2.4944266968908763`*^-6, 
   " | \:2016r\:2016 = ", 0.0002984622671108227, 
   " | \:2016\[Delta]u\:2016 = ", 1.8402380381567365`*^-7, " | p = ", 
   1.6759248821674917`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.9747892824919357`*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"69e1487b-6e33-4849-b3b6-ab39a285002e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.93533990750454`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]",
    "8.309753148396346`*^-9", 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "1.6875649907108`*^-9", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "2.4734038624731697`*^-10", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "1.841748713679709`"}],
  SequenceForm[
  "iter ", 11, " | \[Lambda] = ", 14.93533990750454, 
   " | \[CapitalDelta]\[Lambda] = ", 8.309753148396346*^-9, 
   " | \:2016r\:2016 = ", 1.6875649907108*^-9, " | \:2016\[Delta]u\:2016 = ", 
   2.4734038624731697`*^-10, " | p = ", 1.841748713679709],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789290716914*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"1e3c158d-c70c-4410-af85-79567ba259ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"ACEITO em \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" iter | \[CapitalDelta]\[Lambda]_step = \"\>", "\[InvisibleSpace]",
    "0.5550721156465368`", "\[InvisibleSpace]", "\<\" | fac = \"\>", "\[InvisibleSpace]",
    "0.6363636363636364`", "\[InvisibleSpace]", "\<\" | L_novo = \"\>", "\[InvisibleSpace]",
    "0.005`"}],
  SequenceForm[
  "ACEITO em ", 11, " iter | \[CapitalDelta]\[Lambda]_step = ", 
   0.5550721156465368, " | fac = ", 0.6363636363636364, " | L_novo = ", 0.005],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789290717993*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"202a4a78-1f12-44a7-880a-932a11ef7d4d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"=== Step \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.93533990750454`", "\[InvisibleSpace]", "\<\" | L = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"5.\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-3\"\>"]}],
      ShowStringCharacters->False],
     0.005,
     AutoDelete->True],
    ScientificForm[#, 3]& ], "\[InvisibleSpace]", "\<\" ===\"\>"}],
  SequenceForm[
  "=== Step ", 6, " | \[Lambda] = ", 14.93533990750454, " | L = ", 
   ScientificForm[0.005, 3], " ==="],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.9747892907187033`*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"4d856781-e86c-41ad-b55b-e96b0878bd9a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "21.523557512617103`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]",
    "6.588217605112561`", "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", 
   "\[InvisibleSpace]", "531.6199159361285`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.006546894878884983`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm[
  "iter ", 1, " | \[Lambda] = ", 21.523557512617103`, 
   " | \[CapitalDelta]\[Lambda] = ", 6.588217605112561, " | \:2016r\:2016 = ",
    531.6199159361285, " | \:2016\[Delta]u\:2016 = ", 0.006546894878884983, 
   " | p = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789295760339*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"ecbb4ca0-4b97-49e2-820e-2ad3ca90991c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "16.066673777960645`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "5.456883734656459`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "2464.5118550611955`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.0037847007681454116`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm[
  "iter ", 2, " | \[Lambda] = ", 16.066673777960645`, 
   " | \[CapitalDelta]\[Lambda] = ", -5.456883734656459, 
   " | \:2016r\:2016 = ", 2464.5118550611955`, " | \:2016\[Delta]u\:2016 = ", 
   0.0037847007681454116`, " | p = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789303606121*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"582132ef-c7a2-48cc-954a-d491bf9f479b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "15.218313709118814`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.8483600688418306`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "672.2739319838149`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.0015600176868411457`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm[
  "iter ", 3, " | \[Lambda] = ", 15.218313709118814`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.8483600688418306, 
   " | \:2016r\:2016 = ", 672.2739319838149, " | \:2016\[Delta]u\:2016 = ", 
   0.0015600176868411457`, " | p = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789311566587*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"d6591187-400b-456b-ab8a-6577431333c6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "15.042485961202006`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.17582774791680758`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "678.6241922697823`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.0003907631492919126`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.007237110029585499`"}]}],
  SequenceForm[
  "iter ", 4, " | \[Lambda] = ", 15.042485961202006`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.17582774791680758`, 
   " | \:2016r\:2016 = ", 678.6241922697823, " | \:2016\[Delta]u\:2016 = ", 
   0.0003907631492919126, " | p = ", -0.007237110029585499],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.9747893198581657`*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"13f38c09-bfb8-415a-a89e-3365531ab386"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.98939980329953`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.05308615790247536`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "76.26685686234222`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.0003214241268563017`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "232.4952414191801`"}]}],
  SequenceForm[
  "iter ", 5, " | \[Lambda] = ", 14.98939980329953, 
   " | \[CapitalDelta]\[Lambda] = ", -0.05308615790247536, 
   " | \:2016r\:2016 = ", 76.26685686234222, " | \:2016\[Delta]u\:2016 = ", 
   0.0003214241268563017, " | p = ", -232.4952414191801],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789328249413*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"ee5da0ec-ccbb-454d-bb47-955e94541910"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.967883479266892`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.021516324032638205`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "117.21971001164714`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.00017232378960008862`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.1966354939780772`"}]}],
  SequenceForm[
  "iter ", 6, " | \[Lambda] = ", 14.967883479266892`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.021516324032638205`, 
   " | \:2016r\:2016 = ", 117.21971001164714`, " | \:2016\[Delta]u\:2016 = ", 
   0.00017232378960008862`, " | p = ", -0.1966354939780772],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.9747893367908077`*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"18db4633-39a4-489f-bcd4-3464fbead0e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.966646095129628`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.0012373841372641228`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "37.69449236701991`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.00008636168609043344`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "2.639612604728504`"}]}],
  SequenceForm[
  "iter ", 7, " | \[Lambda] = ", 14.966646095129628`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.0012373841372641228`, 
   " | \:2016r\:2016 = ", 37.69449236701991, " | \:2016\[Delta]u\:2016 = ", 
   0.00008636168609043344, " | p = ", -2.639612604728504],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789345015497*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"272ceb7d-c9eb-4ccc-897a-5db3d8737781"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.966895979840176`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]",
    "0.000249884710548663`", 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "3.855301599597886`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.000024712849085215393`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "2.0096891270942296`"}],
  SequenceForm[
  "iter ", 8, " | \[Lambda] = ", 14.966895979840176`, 
   " | \[CapitalDelta]\[Lambda] = ", 0.000249884710548663, 
   " | \:2016r\:2016 = ", 3.855301599597886, " | \:2016\[Delta]u\:2016 = ", 
   0.000024712849085215393`, " | p = ", 2.0096891270942296`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789353540866*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"be021c80-d296-462d-8677-359ced9178dd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.966854421766763`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.0000415580734134198`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "1.1311260055846166`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "2.54583486040199`*^-6", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0.5378073744147629`"}],
  SequenceForm[
  "iter ", 9, " | \[Lambda] = ", 14.966854421766763`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.0000415580734134198, 
   " | \:2016r\:2016 = ", 1.1311260055846166`, " | \:2016\[Delta]u\:2016 = ", 
   2.54583486040199*^-6, " | p = ", 0.5378073744147629],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789362726845*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"8c172012-e988-44fa-904c-e7ccdc2285ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.966852166357375`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "2.25540938893159`*^-6"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "0.0030818964797915214`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "4.2040431109724934`*^-7", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "4.815896348955517`"}],
  SequenceForm[
  "iter ", 10, " | \[Lambda] = ", 14.966852166357375`, 
   " | \[CapitalDelta]\[Lambda] = ", -2.25540938893159*^-6, 
   " | \:2016r\:2016 = ", 0.0030818964797915214`, 
   " | \:2016\[Delta]u\:2016 = ", 4.2040431109724934`*^-7, " | p = ", 
   4.815896348955517],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789371905282*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"242b1d91-735d-461b-98b9-e737432c7ea4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.9668521427484`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "2.360897540129456`*^-8"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "5.773280014660104`*^-8", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "2.2582387018198257`*^-9", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "1.8432598109343294`"}],
  SequenceForm[
  "iter ", 11, " | \[Lambda] = ", 14.9668521427484, 
   " | \[CapitalDelta]\[Lambda] = ", -2.360897540129456*^-8, 
   " | \:2016r\:2016 = ", 5.773280014660104*^-8, 
   " | \:2016\[Delta]u\:2016 = ", 2.2582387018198257`*^-9, " | p = ", 
   1.8432598109343294`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789380731173*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"816434e8-8c18-47ba-b442-e8a8325f0a5f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.966852142747886`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "5.141526786166451`*^-13"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "2.2616306269004947`*^-10", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "4.02325835554459`*^-14", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0.5091600615427516`"}],
  SequenceForm[
  "iter ", 12, " | \[Lambda] = ", 14.966852142747886`, 
   " | \[CapitalDelta]\[Lambda] = ", -5.141526786166451*^-13, 
   " | \:2016r\:2016 = ", 2.2616306269004947`*^-10, 
   " | \:2016\[Delta]u\:2016 = ", 4.02325835554459*^-14, " | p = ", 
   0.5091600615427516],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789389422702*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"cf2d1d55-e530-411c-b4ba-a218f269fbc6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"ACEITO em \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" iter | \[CapitalDelta]\[Lambda]_step = \"\>", "\[InvisibleSpace]",
    "0.0315122352433459`", "\[InvisibleSpace]", "\<\" | fac = \"\>", "\[InvisibleSpace]",
    "0.5833333333333334`", "\[InvisibleSpace]", "\<\" | L_novo = \"\>", "\[InvisibleSpace]",
    "0.005`"}],
  SequenceForm[
  "ACEITO em ", 12, " iter | \[CapitalDelta]\[Lambda]_step = ", 
   0.0315122352433459, " | fac = ", 0.5833333333333334, " | L_novo = ", 0.005],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789389425445*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"3fee100f-7e61-468a-bee0-ff1021546c2b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"=== Step \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.966852142747886`", "\[InvisibleSpace]", "\<\" | L = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"5.\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-3\"\>"]}],
      ShowStringCharacters->False],
     0.005,
     AutoDelete->True],
    ScientificForm[#, 3]& ], "\[InvisibleSpace]", "\<\" ===\"\>"}],
  SequenceForm[
  "=== Step ", 7, " | \[Lambda] = ", 14.966852142747886`, " | L = ", 
   ScientificForm[0.005, 3], " ==="],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.9747893894261017`*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"571bf5ab-5edf-4ca9-95a9-a8c78d444d35"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "21.555069747860447`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]",
    "6.588217605112561`", "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", 
   "\[InvisibleSpace]", "557.2225070841394`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.006452209330470414`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm[
  "iter ", 1, " | \[Lambda] = ", 21.555069747860447`, 
   " | \[CapitalDelta]\[Lambda] = ", 6.588217605112561, " | \:2016r\:2016 = ",
    557.2225070841394, " | \:2016\[Delta]u\:2016 = ", 0.006452209330470414, 
   " | p = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789394571323*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"da517ef1-9db0-4f37-ba70-6a6c605f24df"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "15.93865323478472`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "5.616416513075728`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "2752.0381578962565`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.003832689399182113`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm[
  "iter ", 2, " | \[Lambda] = ", 15.93865323478472, 
   " | \[CapitalDelta]\[Lambda] = ", -5.616416513075728, 
   " | \:2016r\:2016 = ", 2752.0381578962565`, " | \:2016\[Delta]u\:2016 = ", 
   0.003832689399182113, " | p = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789402516616*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"d23ba14b-6324-47a7-9e3d-8b229e5f15ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "15.20928115369464`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.7293720810900798`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "564.8634384655296`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.00140667283353032`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm[
  "iter ", 3, " | \[Lambda] = ", 15.20928115369464, 
   " | \[CapitalDelta]\[Lambda] = ", -0.7293720810900798, 
   " | \:2016r\:2016 = ", 564.8634384655296, " | \:2016\[Delta]u\:2016 = ", 
   0.00140667283353032, " | p = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.97478941054086*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"f097fcff-cfd2-4736-aef8-2d031886908f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "15.05879398952304`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.1504871641716013`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "220.70728579774175`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.00044275125914636974`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0.5934568500279168`"}],
  SequenceForm[
  "iter ", 4, " | \[Lambda] = ", 15.05879398952304, 
   " | \[CapitalDelta]\[Lambda] = ", -0.1504871641716013, 
   " | \:2016r\:2016 = ", 220.70728579774175`, " | \:2016\[Delta]u\:2016 = ", 
   0.00044275125914636974`, " | p = ", 0.5934568500279168],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789419099185*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"9bfee832-41c3-4421-939d-17275cd2741b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.992985685907394`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.065808303615646`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "168.68653673106508`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.0003541044438985482`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0.2860293647850582`"}],
  SequenceForm[
  "iter ", 5, " | \[Lambda] = ", 14.992985685907394`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.065808303615646, 
   " | \:2016r\:2016 = ", 168.68653673106508`, " | \:2016\[Delta]u\:2016 = ", 
   0.0003541044438985482, " | p = ", 0.2860293647850582],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789427719343*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"09cd7a1b-e806-416b-8f7d-b168b405fd67"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.974572921535525`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.018412764371869117`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "63.640961129222035`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.00017116513352365985`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "3.6264973314511946`"}],
  SequenceForm[
  "iter ", 6, " | \[Lambda] = ", 14.974572921535525`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.018412764371869117`, 
   " | \:2016r\:2016 = ", 63.640961129222035`, " | \:2016\[Delta]u\:2016 = ", 
   0.00017116513352365985`, " | p = ", 3.6264973314511946`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789436430689*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"0a0beb48-ed83-4bf9-9717-db36368cc4c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.96995661752505`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.004616304010476375`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "51.6868327847848`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.00010950537722584133`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0.21343605891458522`"}],
  SequenceForm[
  "iter ", 7, " | \[Lambda] = ", 14.96995661752505, 
   " | \[CapitalDelta]\[Lambda] = ", -0.004616304010476375, 
   " | \:2016r\:2016 = ", 51.6868327847848, " | \:2016\[Delta]u\:2016 = ", 
   0.00010950537722584133`, " | p = ", 0.21343605891458522`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.9747894451231203`*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"c3c6bf18-14d1-48b1-a3fb-94ca4a801982"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.968147422755434`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.001809194769615449`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "4.858304974095167`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.00003170412447316463`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "11.364889445559681`"}],
  SequenceForm[
  "iter ", 8, " | \[Lambda] = ", 14.968147422755434`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.001809194769615449, 
   " | \:2016r\:2016 = ", 4.858304974095167, " | \:2016\[Delta]u\:2016 = ", 
   0.00003170412447316463, " | p = ", 11.364889445559681`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789453852766*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"5b76e345-00ae-4613-b5fc-99b6156e75aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.968011707361358`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.00013571539407679443`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "0.08362868133368262`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "3.1015338101109295`*^-6", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "1.7179256614426186`"}],
  SequenceForm[
  "iter ", 9, " | \[Lambda] = ", 14.968011707361358`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.00013571539407679443`, 
   " | \:2016r\:2016 = ", 0.08362868133368262, " | \:2016\[Delta]u\:2016 = ", 
   3.1015338101109295`*^-6, " | p = ", 1.7179256614426186`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789462988336*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"8d628333-2e6e-4b7f-9120-70a2997b8090"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.968010127729439`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1.5796319191160439`*^-6"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "0.0000793724276006859`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "4.1016348375129`*^-8", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "1.7134147708446086`"}],
  SequenceForm[
  "iter ", 10, " | \[Lambda] = ", 14.968010127729439`, 
   " | \[CapitalDelta]\[Lambda] = ", -1.5796319191160439`*^-6, 
   " | \:2016r\:2016 = ", 0.0000793724276006859, 
   " | \:2016\[Delta]u\:2016 = ", 4.1016348375129*^-8, " | p = ", 
   1.7134147708446086`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789472076404*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"b63cb001-140a-41bc-8f4d-50d843eba522"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.968010127951416`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]",
    "2.219763208510086`*^-10", 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "2.662990937108917`*^-10", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "2.388476835351622`*^-11", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "1.811071585248019`"}],
  SequenceForm[
  "iter ", 11, " | \[Lambda] = ", 14.968010127951416`, 
   " | \[CapitalDelta]\[Lambda] = ", 2.219763208510086*^-10, 
   " | \:2016r\:2016 = ", 2.662990937108917*^-10, 
   " | \:2016\[Delta]u\:2016 = ", 2.388476835351622*^-11, " | p = ", 
   1.811071585248019],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789480999587*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"ae38ea21-bcf6-4161-a522-c77b6f1531af"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"ACEITO em \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" iter | \[CapitalDelta]\[Lambda]_step = \"\>", "\[InvisibleSpace]",
    "0.0011579852035303873`", "\[InvisibleSpace]", "\<\" | fac = \"\>", "\[InvisibleSpace]",
    "0.6363636363636364`", "\[InvisibleSpace]", "\<\" | L_novo = \"\>", "\[InvisibleSpace]",
    "0.005`"}],
  SequenceForm[
  "ACEITO em ", 11, " iter | \[CapitalDelta]\[Lambda]_step = ", 
   0.0011579852035303873`, " | fac = ", 0.6363636363636364, " | L_novo = ", 
   0.005],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789481000634*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"43f6088b-0c8c-4518-a914-20a6950898ee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"=== Step \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.968010127951416`", "\[InvisibleSpace]", "\<\" | L = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"5.\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-3\"\>"]}],
      ShowStringCharacters->False],
     0.005,
     AutoDelete->True],
    ScientificForm[#, 3]& ], "\[InvisibleSpace]", "\<\" ===\"\>"}],
  SequenceForm[
  "=== Step ", 8, " | \[Lambda] = ", 14.968010127951416`, " | L = ", 
   ScientificForm[0.005, 3], " ==="],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.9747894810013123`*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"f407a31b-232c-4e43-a750-6ee39e8a9d0a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "21.556227733063977`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]",
    "6.588217605112561`", "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", 
   "\[InvisibleSpace]", "560.7960707259386`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.0064148197359016`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm[
  "iter ", 1, " | \[Lambda] = ", 21.556227733063977`, 
   " | \[CapitalDelta]\[Lambda] = ", 6.588217605112561, " | \:2016r\:2016 = ",
    560.7960707259386, " | \:2016\[Delta]u\:2016 = ", 0.0064148197359016, 
   " | p = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.97478948617675*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"4074a48e-81a6-42d6-abb7-3677e601c985"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "15.918317957213874`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "5.637909775850103`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "2419.140406303079`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.0038042788036364216`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm[
  "iter ", 2, " | \[Lambda] = ", 15.918317957213874`, 
   " | \[CapitalDelta]\[Lambda] = ", -5.637909775850103, 
   " | \:2016r\:2016 = ", 2419.140406303079, " | \:2016\[Delta]u\:2016 = ", 
   0.0038042788036364216`, " | p = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.9747894944961853`*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"b3c30e16-7bd0-46b0-ab7a-8e84fb90bfc8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "15.201433676812766`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.7168842804011091`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "696.876625504233`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.0014561561024182695`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm[
  "iter ", 3, " | \[Lambda] = ", 15.201433676812766`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.7168842804011091, 
   " | \:2016r\:2016 = ", 696.876625504233, " | \:2016\[Delta]u\:2016 = ", 
   0.0014561561024182695`, " | p = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.9747895025022087`*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"eb2a9b76-5947-4afe-b21c-8b7cbb6547b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "15.056971299271993`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.14446237754077207`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "225.18113035690953`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.00044908315257754757`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0.9077136041192164`"}],
  SequenceForm[
  "iter ", 4, " | \[Lambda] = ", 15.056971299271993`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.14446237754077207`, 
   " | \:2016r\:2016 = ", 225.18113035690953`, " | \:2016\[Delta]u\:2016 = ", 
   0.00044908315257754757`, " | p = ", 0.9077136041192164],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789510678841*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"45c45551-d1b0-4e3e-9200-edebd4603609"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.992335871358522`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.06463542791347018`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "115.15188294880335`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.0003413425640573053`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0.5936542212070166`"}],
  SequenceForm[
  "iter ", 5, " | \[Lambda] = ", 14.992335871358522`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.06463542791347018, 
   " | \:2016r\:2016 = ", 115.15188294880335`, " | \:2016\[Delta]u\:2016 = ", 
   0.0003413425640573053, " | p = ", 0.5936542212070166],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789518992674*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"211cdd05-6ba7-4858-a1ee-2414ab819f23"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.968346400962547`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.0239894703959743`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "39.409031410071655`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.00018680740875841824`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "1.5988249759004978`"}],
  SequenceForm[
  "iter ", 6, " | \[Lambda] = ", 14.968346400962547`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.0239894703959743, 
   " | \:2016r\:2016 = ", 39.409031410071655`, " | \:2016\[Delta]u\:2016 = ", 
   0.00018680740875841824`, " | p = ", 1.5988249759004978`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.97478952737049*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"2cc9cd16-a33d-4238-9694-441265f1f8de"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.96509520149774`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.0032511994648078534`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "22.570599091081764`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.00009812131790506469`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0.5197885375053843`"}],
  SequenceForm[
  "iter ", 7, " | \[Lambda] = ", 14.96509520149774, 
   " | \[CapitalDelta]\[Lambda] = ", -0.0032511994648078534`, 
   " | \:2016r\:2016 = ", 22.570599091081764`, " | \:2016\[Delta]u\:2016 = ", 
   0.00009812131790506469, " | p = ", 0.5197885375053843],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789535746428*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"0dfbb2ba-33a2-4fcc-bbf3-25ab4076ac7d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.964302196843667`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.0007930046540725995`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "0.9722280061276902`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "0.000020238540709201942`", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "5.642470026842434`"}],
  SequenceForm[
  "iter ", 8, " | \[Lambda] = ", 14.964302196843667`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.0007930046540725995, 
   " | \:2016r\:2016 = ", 0.9722280061276902, " | \:2016\[Delta]u\:2016 = ", 
   0.000020238540709201942`, " | p = ", 5.642470026842434],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.9747895442894583`*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"45bafac1-5079-4102-9751-6e9898f71b14"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.964278776478979`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.00002342036468760587`"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "0.022223027536573847`", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "9.535080994459439`*^-7", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "1.2014899610801577`"}],
  SequenceForm[
  "iter ", 9, " | \[Lambda] = ", 14.964278776478979`, 
   " | \[CapitalDelta]\[Lambda] = ", -0.00002342036468760587, 
   " | \:2016r\:2016 = ", 0.022223027536573847`, 
   " | \:2016\[Delta]u\:2016 = ", 9.535080994459439*^-7, " | p = ", 
   1.2014899610801577`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789552735067*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"17743a92-18da-48b3-b40d-b27d1e73df69"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.964278571807894`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "2.0467108617989867`*^-7"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "7.180049732251318`*^-7", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "6.738782119021251`*^-9", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "2.7366068367438534`"}],
  SequenceForm[
  "iter ", 10, " | \[Lambda] = ", 14.964278571807894`, 
   " | \[CapitalDelta]\[Lambda] = ", -2.0467108617989867`*^-7, 
   " | \:2016r\:2016 = ", 7.180049732251318*^-7, 
   " | \:2016\[Delta]u\:2016 = ", 6.738782119021251*^-9, " | p = ", 
   2.7366068367438534`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789561132368*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"b2ef85fb-da82-4d24-8a51-40acf3096ff1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"iter \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" | \[Lambda] = \"\>", "\[InvisibleSpace]", 
   "14.964278571797085`", 
   "\[InvisibleSpace]", "\<\" | \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1.0808680739495766`*^-11"}], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   "3.4732413589310656`*^-10", 
   "\[InvisibleSpace]", "\<\" | \:2016\[Delta]u\:2016 = \"\>", "\[InvisibleSpace]",
    "3.577387860987854`*^-13", "\[InvisibleSpace]", "\<\" | p = \"\>", "\[InvisibleSpace]",
    "0.7382836474446091`"}],
  SequenceForm[
  "iter ", 11, " | \[Lambda] = ", 14.964278571797085`, 
   " | \[CapitalDelta]\[Lambda] = ", -1.0808680739495766`*^-11, 
   " | \:2016r\:2016 = ", 3.4732413589310656`*^-10, 
   " | \:2016\[Delta]u\:2016 = ", 3.577387860987854*^-13, " | p = ", 
   0.7382836474446091],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789569666996*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"8b1a93f7-1173-4951-8376-365763676623"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"ACEITO em \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" iter | \[CapitalDelta]\[Lambda]_step = \"\>", "\[InvisibleSpace]",
    "0.003731556154331628`", "\[InvisibleSpace]", "\<\" | fac = \"\>", "\[InvisibleSpace]",
    "0.6363636363636364`", "\[InvisibleSpace]", "\<\" | L_novo = \"\>", "\[InvisibleSpace]",
    "0.005`"}],
  SequenceForm[
  "ACEITO em ", 11, " iter | \[CapitalDelta]\[Lambda]_step = ", 
   0.003731556154331628, " | fac = ", 0.6363636363636364, " | L_novo = ", 
   0.005],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789569667994*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"4b375537-e998-4b71-96d8-ed87734c9c32"],

Cell[BoxData["\<\"\\n\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\
\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\
\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\
\:2550\:2550\:2550\:2550\:2550\:2550\:2550\"\>"], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789569668655*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"b3526e46-95cc-4bdf-b2ec-b3c142a9d72d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \[Lambda] ESTABILIZOU!    \[CapitalDelta]\[Lambda] = \"\>", "\[InvisibleSpace]",
    "0.003731556154331628`", "\[InvisibleSpace]", "\<\" < \"\>", "\[InvisibleSpace]", 
   FractionBox["1", "1000"]}],
  SequenceForm[
  "  \[Lambda] ESTABILIZOU!    \[CapitalDelta]\[Lambda] = ", 
   0.003731556154331628, " < ", 
   Rational[1, 1000]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789569670863*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"b29f1264-2895-4387-ac04-70c50385ba26"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \[Lambda]_final = \"\>", "\[InvisibleSpace]", 
   "14.964278571797085`"}],
  SequenceForm["  \[Lambda]_final = ", 14.964278571797085`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789569673107*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"fb4d4c35-9022-441b-b86d-081f4d86f255"],

Cell[BoxData["\<\"\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\
\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\
\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\:2550\
\:2550\:2550\:2550\:2550\:2550\:2550\"\>"], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.974789569673719*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"1a379780-1a5f-4f70-b0a6-245e771c9771"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\n=== CONCLU\[CapitalIAcute]DO: \"\>", "\[InvisibleSpace]", 
   "8", "\[InvisibleSpace]", "\<\" steps | \[Lambda]_final = \"\>", "\[InvisibleSpace]",
    "14.964278571797085`", "\[InvisibleSpace]", "\<\" ===\"\>"}],
  SequenceForm[
  "\n=== CONCLU\[CapitalIAcute]DO: ", 8, " steps | \[Lambda]_final = ", 
   14.964278571797085`, " ==="],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.973597179125821*^9, 3.9736009553127823`*^9, 3.973607734481534*^9, 
   3.9736078098722277`*^9, 3.97361055056999*^9, 3.973611072197085*^9, 
   3.9736116134448347`*^9, 3.973612351228695*^9, 3.9737487905146313`*^9, {
   3.973749024047526*^9, 3.97374903949713*^9}, 3.973749147501741*^9, 
   3.973749232665442*^9, 3.973749315169033*^9, 3.9737504474136667`*^9, 
   3.9737508159814157`*^9, 3.973750863687628*^9, 3.9737511441279373`*^9, 
   3.973751274084076*^9, 3.973751395117807*^9, 3.9737515170696373`*^9, 
   3.9737515737437763`*^9, {3.973751659296166*^9, 3.973751688908833*^9}, 
   3.973751779991311*^9, 3.9737518406249657`*^9, 3.973752509212323*^9, {
   3.973752552108878*^9, 3.97375256836623*^9}, {3.973752695578298*^9, 
   3.9737527565675497`*^9}, {3.9737528681725607`*^9, 3.973752930893261*^9}, {
   3.973752975242674*^9, 3.97375301134262*^9}, {3.9737530462544403`*^9, 
   3.973753058986135*^9}, 3.973753179314806*^9, 3.973753226571843*^9, 
   3.973753593640513*^9, 3.9737537384669847`*^9, 3.973754021067235*^9, 
   3.973754222838471*^9, 3.973754326091444*^9, 3.9737549840484324`*^9, 
   3.97375536415415*^9, 3.973755395298493*^9, 3.973755937909433*^9, 
   3.973756315121585*^9, 3.97375634679916*^9, 3.97375647198223*^9, 
   3.9737565764227123`*^9, 3.973756694382682*^9, 3.973756759936233*^9, 
   3.9737568462506533`*^9, 3.973756891279913*^9, 3.973756989882373*^9, 
   3.9737574260996847`*^9, 3.973759074402516*^9, 3.973760693203918*^9, 
   3.973760816614946*^9, 3.973760864266152*^9, 3.973764289829053*^9, 
   3.973764345682008*^9, 3.9737644131498413`*^9, 3.9737644840146217`*^9, 
   3.973769933297596*^9, 3.973773839327667*^9, 3.973774399578576*^9, 
   3.97377444887109*^9, 3.973775924137891*^9, 3.9737759765553513`*^9, 
   3.973845438270575*^9, 3.9738455221022387`*^9, 3.973846523198599*^9, 
   3.9738556066373568`*^9, 3.97392250694765*^9, 3.9739225927203503`*^9, 
   3.973922700986671*^9, 3.973933592096016*^9, 3.973936229054866*^9, 
   3.973936263297971*^9, 3.973936301864311*^9, 3.973936414460081*^9, 
   3.9740241407852907`*^9, 3.974107595586886*^9, 3.974109407497699*^9, 
   3.974109670605394*^9, 3.974183188825474*^9, 3.974183753305372*^9, 
   3.97418680320674*^9, 3.974186861116488*^9, 3.974187068230316*^9, 
   3.974187426014542*^9, 3.974190385450601*^9, 3.974192858941717*^9, 
   3.974197909558119*^9, 3.974200824951764*^9, 3.974275477788241*^9, 
   3.974277977578906*^9, 3.974278309217827*^9, 3.9742832211742373`*^9, 
   3.9742859822490177`*^9, 3.9742894568451233`*^9, 3.974292189823598*^9, 
   3.9742943194633503`*^9, 3.974375427364285*^9, 3.97439383628819*^9, 
   3.974443991803618*^9, 3.974444102067417*^9, 3.974450952008456*^9, 
   3.974457488501787*^9, 3.974458521952721*^9, 3.974623471995384*^9, 
   3.9747895696742983`*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"5561b53e-822d-4d4b-844c-c9c7cb8d6aa4"]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[{{}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.24, 0.6, 0.8], PointSize[
           NCache[
            Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[2], 
          LineBox[{{0.00029543480938711643`, 6.562322489296535}, {
           0.0006146962727383243, 10.408935534549569`}, {
           0.0009245446212503409, 12.864614113220572`}, {
           0.0012050175275299731`, 14.380267791858003`}, {
           0.0014408502726306804`, 14.93533990750454}, {
           0.0016531380741382927`, 14.966852142747886`}, {
           0.001863161137597154, 14.968010127951416`}, {
           0.0020703374009542626`, 14.964278571797085`}}]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, 
       TagBox[
        {RGBColor[0.24, 0.6, 0.8], PointSize[
          NCache[
           Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[2], 
         GeometricTransformationBox[InsetBox[
           FormBox[
            StyleBox[
             GraphicsBox[
              {EdgeForm[None], DiskBox[{0, 0}]},
              PlotRangePadding->Scaled[0.15]],
             StripOnInput->False,
             GraphicsBoxOptions->{DefaultBaseStyle->Directive[
               PointSize[
                Rational[7, 360]], 
               RGBColor[0.24, 0.6, 0.8], 
               AbsoluteThickness[2]]}],
            TraditionalForm], {0., 0.}, Automatic, Offset[10.976]], {{{
          0.00029543480938711643`, 6.562322489296535}}, {{
          0.0006146962727383243, 10.408935534549569`}}, {{
          0.0009245446212503409, 12.864614113220572`}}, {{
          0.0012050175275299731`, 14.380267791858003`}}, {{
          0.0014408502726306804`, 14.93533990750454}}, {{
          0.0016531380741382927`, 14.966852142747886`}}, {{
          0.001863161137597154, 14.968010127951416`}}, {{
          0.0020703374009542626`, 14.964278571797085`}}}]},
        Annotation[#, "Charting`Private`Tag#1"]& ]},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     StyleBox[
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{}, {}, 
           Annotation[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              PointSize[
               Rational[7, 360]], 
              RGBColor[0.24, 0.6, 0.8], 
              AbsoluteThickness[2]], 
             
             Line[{{0.00029543480938711643`, 6.562322489296535}, {
              0.0006146962727383243, 10.408935534549569`}, {
              0.0009245446212503409, 12.864614113220572`}, {
              0.0012050175275299731`, 14.380267791858003`}, {
              0.0014408502726306804`, 14.93533990750454}, {
              0.0016531380741382927`, 14.966852142747886`}, {
              0.001863161137597154, 14.968010127951416`}, {
              0.0020703374009542626`, 14.964278571797085`}}]}, 
            "Charting`Private`Tag#1"]}, {
           Annotation[{
             Directive[
              PointSize[
               Rational[7, 360]], 
              RGBColor[0.24, 0.6, 0.8], 
              AbsoluteThickness[2]], 
             GeometricTransformation[
              Inset[
               Style[
                Graphics[{
                  EdgeForm[], 
                  Disk[{0, 0}]}, PlotRangePadding -> Scaled[0.15]], 
                GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                    PointSize[
                    Rational[7, 360]], 
                    RGBColor[0.24, 0.6, 0.8], 
                    AbsoluteThickness[2]]}], {0., 0.}, Automatic, 
               Offset[10.976]], {{{0.00029543480938711643`, 
              6.562322489296535}}, {{0.0006146962727383243, 
              10.408935534549569`}}, {{0.0009245446212503409, 
              12.864614113220572`}}, {{0.0012050175275299731`, 
              14.380267791858003`}}, {{0.0014408502726306804`, 
              14.93533990750454}}, {{0.0016531380741382927`, 
              14.966852142747886`}}, {{0.001863161137597154, 
              14.968010127951416`}}, {{0.0020703374009542626`, 
              14.964278571797085`}}}]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, 
            "PlotRange" -> {{0, 0.0020703374009542626`}, {
              0, 14.968010127951416`}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               PointSize[
                Rational[7, 360]], 
               RGBColor[0.24, 0.6, 0.8], 
               AbsoluteThickness[2]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                (Identity[#]& )[
                 Part[#, 1]], 
                (Identity[#]& )[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListLinePlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{0, 0.0020703374009542626`}, {
             0, 14.968010127951416`}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              PointSize[
               Rational[7, 360]], 
              RGBColor[0.24, 0.6, 0.8], 
              AbsoluteThickness[2]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListLinePlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}],
      Selectable->False]},
    Annotation[{{{}, {}, 
       Annotation[{
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[
           Rational[7, 360]], 
          RGBColor[0.24, 0.6, 0.8], 
          AbsoluteThickness[2]], 
         Line[{{0.00029543480938711643`, 6.562322489296535}, {
          0.0006146962727383243, 10.408935534549569`}, {0.0009245446212503409,
           12.864614113220572`}, {0.0012050175275299731`, 
          14.380267791858003`}, {0.0014408502726306804`, 14.93533990750454}, {
          0.0016531380741382927`, 14.966852142747886`}, {0.001863161137597154,
           14.968010127951416`}, {0.0020703374009542626`, 
          14.964278571797085`}}]}, "Charting`Private`Tag#1"]}, {
       Annotation[{
         Directive[
          PointSize[
           Rational[7, 360]], 
          RGBColor[0.24, 0.6, 0.8], 
          AbsoluteThickness[2]], 
         GeometricTransformation[
          Inset[
           Style[
            Graphics[{
              EdgeForm[], 
              Disk[{0, 0}]}, PlotRangePadding -> Scaled[0.15]], 
            GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                PointSize[
                 Rational[7, 360]], 
                RGBColor[0.24, 0.6, 0.8], 
                AbsoluteThickness[2]]}], {0., 0.}, Automatic, 
           Offset[10.976]], {{{0.00029543480938711643`, 
          6.562322489296535}}, {{0.0006146962727383243, 
          10.408935534549569`}}, {{0.0009245446212503409, 
          12.864614113220572`}}, {{0.0012050175275299731`, 
          14.380267791858003`}}, {{0.0014408502726306804`, 
          14.93533990750454}}, {{0.0016531380741382927`, 
          14.966852142747886`}}, {{0.001863161137597154, 
          14.968010127951416`}}, {{0.0020703374009542626`, 
          14.964278571797085`}}}]}, "Charting`Private`Tag#1"]}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PanelPlotLayout" -> <||>, 
        "PlotRange" -> {{0, 0.0020703374009542626`}, {
          0, 14.968010127951416`}}, 
        "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           PointSize[
            Rational[7, 360]], 
           RGBColor[0.24, 0.6, 0.8], 
           AbsoluteThickness[2]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        ListLinePlot, "GroupHighlight" -> False|>|>, 
     "DynamicHighlight"]], {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox["\"uy_max\"", HoldForm], TraditionalForm], 
    FormBox[
     TagBox["\"\[Lambda]\"", HoldForm], TraditionalForm]},
  AxesOrigin->{0, 0},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageMargins->0.,
  ImageSize->Automatic,
  ImageSizeRaw->Automatic,
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.24, 0.6, 0.8], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.95, 0.627, 0.1425], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.455, 0.7, 0.21], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.578, 0.51, 0.85], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.4, 0.64, 1.], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[1., 0.75, 0.], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.8, 0.4, 0.76], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.637, 0.65, 0.], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
    "RangePadding" -> Scaled[0.05], "OptimizePlotMarkers" -> True, 
    "IncludeHighlighting" -> Automatic, "HighlightStyle" -> Automatic, 
    "OptimizePlotMarkers" -> True, "IncludeHighlighting" -> "CurrentSet", 
    "HighlightStyle" -> Automatic, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotInteractivity:>True,
  PlotRange->{{0, 0.0020703374009542626`}, {0, 14.968010127951416`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->CompressedData["
1:eJwV0F1IUwEcBfDrDLeHjDQIYWk0iFJjlWnNcZPNkWnZls611nTKyNXS/BhU
JmQSjlXOCrKoTKS7dceimcOHkT1IVGhEOWkY0yiTkK3aVkEQWqv/eTj8OI/n
bDC3VjemMAyjoVROW9bpBmLKOVF7Ppwt0m+H5YHiepga1LbDmed8P4zbP/og
1zExBhXGtPRD6L2XWJhd3qKA99nSHpiQW0dh1mlTAPI7VkzAP+rMEHynmV6A
tQnBV2hlXv+Ck59OLsP17FOhnuyO7y2BNlnVysOk6zg/A3Pa1ixCVYXoG3S3
ym8dIVl/0RA0+N0eKDnYPQJFp7yGOvLyiS/KevKZ7acDyqbEV6BT31PWQIZG
Mw7A9L7JXRfI5gJVKXTus4zDqDYkdZAP9pjCHjL4b+1nWNg19AM2LAlUPvzl
ueccJm+2RK/B5t4nN2CQf+OCU5m3z4axI2ArFtyNKb/PJsSp5IL6LQsf7r8j
2US+Gs61wojdsriZHONcMdhZ5hDmkhKzohDaq6R8Hvl+tWkun+x66a+WktvM
wvGtZFYJV1BDJreIm3TkhzNX+6Eo6VzSk6vcj7QGUqFOSTOSx15wxlqyZjnc
WEdyj3WMnezIafvbR0YH5jt5Mq/CexGOnIvMe8mjyt8ZPrLp/MbrML47kp0k
K3fKZZrBmPI/TQ1IwA==
  "],
 CellLabel->"Out[56]=",ExpressionUUID->"7b95fb3a-77b4-492a-9916-0507dad9a0a8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Export", "[", 
  RowBox[{"\"\<mohrlambdau.dat\>\"", ",", "plotx"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<mohrdata.dat\>\"", ",", "convergencepostdata"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.974294326986877*^9, 3.974294333274601*^9}, {
  3.974458664726734*^9, 
  3.974458670406502*^9}},ExpressionUUID->"7dede854-b71d-4352-a4d2-\
478913d8f472"],

Cell[BoxData["\<\"vonlambdau.dat\"\>"], "Output",
 CellChangeTimes->{3.974275996853335*^9, 3.974283742468773*^9, 
  3.9742927386737947`*^9, 3.9742948104949102`*^9, 3.974445968610277*^9},
 CellLabel->
  "Out[136]=",ExpressionUUID->"17baa528-dfac-4d34-af2a-3e902f27d391"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"mcDataSN", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.00050", ",", "8.94171"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.00100", ",", "13.50959"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.00125", ",", "14.82580"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.00150", ",", "14.95820"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.00200", ",", "14.97208"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.00250", ",", "14.98184"}], "}"}]}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"mcAssoc2Data", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.000295435", ",", "6.033265306122449"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.000614696", ",", "10.23404081632653"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.000924544", ",", "13.00138775510204"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.00120502", ",", "14.66934693877551"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.00132293", ",", "14.94661224489796"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.00132293", ",", "14.94661224489796"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.0014408499999999998", ",", "14.956530612244897"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.00165314", ",", "14.963918367346938"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.00186316", ",", "14.969591836734693"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.00207034", ",", "14.974326530612245"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotx", "=", 
     RowBox[{"Prepend", "[", 
      RowBox[{"plot", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"plot2", "=", "plotx"}], ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"feStyle", "=", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", 
       RowBox[{"AbsoluteThickness", "[", "1.1", "]"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"slipStyle", "=", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", "Dashed", ",", 
       RowBox[{"AbsoluteThickness", "[", "1.0", "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"circleMarker", "=", 
     RowBox[{"Style", "[", 
      RowBox[{"\"\<\[EmptyCircle]\>\"", ",", "22"}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"diamondMarker", "=", 
     RowBox[{"Style", "[", 
      RowBox[{"\"\<\[EmptyDiamond]\>\"", ",", "22"}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"triangleMarker", "=", 
     RowBox[{"Style", "[", 
      RowBox[{"\"\<\[EmptyUpTriangle]\>\"", ",", "22"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"plotULambda", "=", 
    RowBox[{"ListLinePlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"plot2", ",", "mcAssoc2Data"}], "}"}], ",", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{"\"\<This code\>\"", ",", "\"\<Souza Neto\>\""}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "->", "Full"}], ",", 
      RowBox[{"PlotMarkers", "->", "Automatic"}]}], "]"}]}], "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotULambda", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"{", "plot2", "}"}], ",", 
       RowBox[{"Joined", "->", "True"}], ",", 
       RowBox[{"PlotStyle", "->", 
        RowBox[{"{", 
         RowBox[{"feStyle", ",", "feStyle"}], "}"}]}], ",", 
       RowBox[{"PlotMarkers", "->", 
        RowBox[{"{", 
         RowBox[{"diamondMarker", ",", "triangleMarker"}], "   ", "}"}]}], ",", 
       RowBox[{"Frame", "->", "True"}], ",", 
       RowBox[{"FrameStyle", "->", "Black"}], ",", 
       RowBox[{"FrameLabel", "->", 
        RowBox[{"{", 
         RowBox[{"\"\<vertical displacement, at (0,5)\>\"", 
          ",", "\"\<Load factor, \[Lambda]\>\""}], "}"}]}], ",", 
       RowBox[{"FrameTicks", "->", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
       RowBox[{"BaseStyle", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FontFamily", "->", "\"\<Times\>\""}], ",", "15"}], "}"}]}],
        ",", 
       RowBox[{"AspectRatio", "->", "1"}], ",", 
       RowBox[{"ImageSize", "->", "400"}], ",", 
       RowBox[{"PlotRange", "->", "All"}], ",", 
       RowBox[{"PlotLegends", "->", 
        RowBox[{"Placed", "[", 
         RowBox[{
          RowBox[{"LineLegend", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"feStyle", ",", "feStyle"}], "}"}], ",", 
            RowBox[{
            "{", "\"\<finite element results \[Dash] Mohr-Coulomb\>\"", "}"}],
             ",", 
            RowBox[{"LegendMarkers", "->", 
             RowBox[{"{", 
              RowBox[{"diamondMarker", ",", "triangleMarker"}], "}"}]}]}], 
           "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"0.52", ",", "0.1"}], "}"}]}], "]"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lambdaLim", "=", "14.8"}], ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotLim", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{"lambdaLim", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"plot2", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
         RowBox[{"plot2", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "->", "slipStyle"}], ",", 
       RowBox[{"PlotRange", "->", "All"}], ",", 
       RowBox[{"PlotLegends", "->", 
        RowBox[{"Placed", "[", 
         RowBox[{
          RowBox[{"LineLegend", "[", 
           RowBox[{
            RowBox[{"{", "slipStyle", "}"}], ",", 
            RowBox[{"{", "\"\<Prandtl's solution  14.8\>\"", "}"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"0.52", ",", "0.22"}], "}"}]}], "]"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"Show", "[", 
    RowBox[{"plotULambda", ",", "plotLim", ",", 
     RowBox[{"PlotRange", "->", "All"}]}], "]"}], "\n"}]}]], "Input",
 CellChangeTimes->{{3.974447661283668*^9, 3.974447785694907*^9}, {
   3.974447824039812*^9, 3.974447868503592*^9}, {3.974450116089517*^9, 
   3.974450123473764*^9}, {3.974450662208621*^9, 3.974450665008219*^9}, {
   3.974450795842018*^9, 3.9744508266906843`*^9}, {3.974457425117053*^9, 
   3.974457425301237*^9}, {3.9744579409453783`*^9, 3.974457941120556*^9}, {
   3.974459355381349*^9, 3.974459363540156*^9}, 3.974789790819726*^9, {
   3.974789855482883*^9, 3.974790092704031*^9}},
 CellLabel->
  "In[234]:=",ExpressionUUID->"bf7a66e7-3b42-4d58-9dbc-7c83d8f596c4"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, 
     InterpretationBox[{
       TagBox[{{{}, {}, 
          TagBox[{
            RGBColor[0.24, 0.6, 0.8], 
            PointSize[
             NCache[
              Rational[7, 360], 0.019444444444444445`]], 
            AbsoluteThickness[2], 
            
            LineBox[{{0., 0.}, {0.00029543480938711643`, 6.562322489296535}, {
             0.0006146962727383243, 10.408935534549569`}, {
             0.0009245446212503409, 12.864614113220572`}, {
             0.0012050175275299731`, 14.380267791858003`}, {
             0.0014408502726306804`, 14.93533990750454}, {
             0.0016531380741382927`, 14.966852142747886`}, {
             0.001863161137597154, 14.968010127951416`}, {
             0.0020703374009542626`, 14.964278571797085`}}]}, 
           Annotation[#, "Charting`Private`Tag#1"]& ], 
          TagBox[{
            RGBColor[0.95, 0.627, 0.1425], 
            PointSize[
             NCache[
              Rational[7, 360], 0.019444444444444445`]], 
            AbsoluteThickness[2], 
            
            LineBox[{{0.000295435, 6.033265306122449}, {0.000614696, 
             10.23404081632653}, {0.000924544, 13.00138775510204}, {
             0.00120502, 14.66934693877551}, {0.00132293, 
             14.94661224489796}, {0.00132293, 14.94661224489796}, {
             0.0014408499999999998`, 14.956530612244897`}, {0.00165314, 
             14.963918367346938`}, {0.00186316, 14.969591836734693`}, {
             0.00207034, 14.974326530612245`}}]}, 
           Annotation[#, "Charting`Private`Tag#2"]& ]}, {
          TagBox[{
            RGBColor[0.24, 0.6, 0.8], 
            PointSize[
             NCache[
              Rational[7, 360], 0.019444444444444445`]], 
            AbsoluteThickness[2], 
            GeometricTransformationBox[
             InsetBox[
              FormBox[
               StyleBox[
                GraphicsBox[{
                  EdgeForm[None], 
                  DiskBox[{0, 0}]}, PlotRangePadding -> Scaled[0.15]], 
                StripOnInput -> False, 
                GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                    PointSize[
                    Rational[7, 360]], 
                    RGBColor[0.24, 0.6, 0.8], 
                    AbsoluteThickness[2]]}], TraditionalForm], {0., 0.}, 
              Automatic, 
              Offset[10.976]], {{{0., 0.}}, {{0.00029543480938711643`, 
             6.562322489296535}}, {{0.0006146962727383243, 
             10.408935534549569`}}, {{0.0009245446212503409, 
             12.864614113220572`}}, {{0.0012050175275299731`, 
             14.380267791858003`}}, {{0.0014408502726306804`, 
             14.93533990750454}}, {{0.0016531380741382927`, 
             14.966852142747886`}}, {{0.001863161137597154, 
             14.968010127951416`}}, {{0.0020703374009542626`, 
             14.964278571797085`}}}]}, 
           Annotation[#, "Charting`Private`Tag#1"]& ], 
          TagBox[{
            RGBColor[0.95, 0.627, 0.1425], 
            PointSize[
             NCache[
              Rational[7, 360], 0.019444444444444445`]], 
            AbsoluteThickness[2], 
            GeometricTransformationBox[
             InsetBox[
              FormBox[
               StyleBox[
                GraphicsBox[{
                  EdgeForm[None], 
                  PolygonBox[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}, 
                 PlotRangePadding -> Scaled[0.15]], StripOnInput -> False, 
                GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                    PointSize[
                    Rational[7, 360]], 
                    RGBColor[0.95, 0.627, 0.1425], 
                    AbsoluteThickness[2]]}], TraditionalForm], {0., 0.}, 
              Automatic, 
              Offset[10.5]], {{{0.000295435, 6.033265306122449}}, {{
             0.000614696, 10.23404081632653}}, {{0.000924544, 
             13.00138775510204}}, {{0.00120502, 14.66934693877551}}, {{
             0.00132293, 14.94661224489796}}, {{0.00132293, 
             14.94661224489796}}, {{0.0014408499999999998`, 
             14.956530612244897`}}, {{0.00165314, 14.963918367346938`}}, {{
             0.00186316, 14.969591836734693`}}, {{0.00207034, 
             14.974326530612245`}}}]}, 
           Annotation[#, "Charting`Private`Tag#2"]& ]}}, {
        "WolframDynamicHighlight", <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
       StyleBox[
        DynamicBox[
         (Charting`HighlightActionBox["DynamicHighlight", {}, 
          Slot["HighlightElements"], 
          Slot["LayoutOptions"], 
          Slot["Meta"], 
          Charting`HighlightActionFunction["DynamicHighlight", {{{}, {}, 
             Annotation[{
               Hue[0.67, 0.6, 0.6], 
               Directive[
                PointSize[
                 Rational[7, 360]], 
                RGBColor[0.24, 0.6, 0.8], 
                AbsoluteThickness[2]], 
               
               Line[{{0., 0.}, {0.00029543480938711643`, 6.562322489296535}, {
                0.0006146962727383243, 10.408935534549569`}, {
                0.0009245446212503409, 12.864614113220572`}, {
                0.0012050175275299731`, 14.380267791858003`}, {
                0.0014408502726306804`, 14.93533990750454}, {
                0.0016531380741382927`, 14.966852142747886`}, {
                0.001863161137597154, 14.968010127951416`}, {
                0.0020703374009542626`, 14.964278571797085`}}]}, 
              "Charting`Private`Tag#1"], 
             Annotation[{
               Hue[0.9060679774997897, 0.6, 0.6], 
               Directive[
                PointSize[
                 Rational[7, 360]], 
                RGBColor[0.95, 0.627, 0.1425], 
                AbsoluteThickness[2]], 
               
               Line[{{0.000295435, 6.033265306122449}, {0.000614696, 
                10.23404081632653}, {0.000924544, 13.00138775510204}, {
                0.00120502, 14.66934693877551}, {0.00132293, 
                14.94661224489796}, {0.00132293, 14.94661224489796}, {
                0.0014408499999999998`, 14.956530612244897`}, {0.00165314, 
                14.963918367346938`}, {0.00186316, 14.969591836734693`}, {
                0.00207034, 14.974326530612245`}}]}, 
              "Charting`Private`Tag#2"]}, {
             Annotation[{
               Directive[
                PointSize[
                 Rational[7, 360]], 
                RGBColor[0.24, 0.6, 0.8], 
                AbsoluteThickness[2]], 
               GeometricTransformation[
                Inset[
                 Style[
                  Graphics[{
                    EdgeForm[], 
                    Disk[{0, 0}]}, PlotRangePadding -> Scaled[0.15]], 
                  GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                    PointSize[
                    Rational[7, 360]], 
                    RGBColor[0.24, 0.6, 0.8], 
                    AbsoluteThickness[2]]}], {0., 0.}, Automatic, 
                 Offset[10.976]], {{{0., 0.}}, {{0.00029543480938711643`, 
                6.562322489296535}}, {{0.0006146962727383243, 
                10.408935534549569`}}, {{0.0009245446212503409, 
                12.864614113220572`}}, {{0.0012050175275299731`, 
                14.380267791858003`}}, {{0.0014408502726306804`, 
                14.93533990750454}}, {{0.0016531380741382927`, 
                14.966852142747886`}}, {{0.001863161137597154, 
                14.968010127951416`}}, {{0.0020703374009542626`, 
                14.964278571797085`}}}]}, "Charting`Private`Tag#1"], 
             Annotation[{
               Directive[
                PointSize[
                 Rational[7, 360]], 
                RGBColor[0.95, 0.627, 0.1425], 
                AbsoluteThickness[2]], 
               GeometricTransformation[
                Inset[
                 Style[
                  Graphics[{
                    EdgeForm[], 
                    Polygon[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}, 
                   PlotRangePadding -> Scaled[0.15]], 
                  GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                    PointSize[
                    Rational[7, 360]], 
                    RGBColor[0.95, 0.627, 0.1425], 
                    AbsoluteThickness[2]]}], {0., 0.}, Automatic, 
                 Offset[10.5]], {{{0.000295435, 6.033265306122449}}, {{
                0.000614696, 10.23404081632653}}, {{0.000924544, 
                13.00138775510204}}, {{0.00120502, 14.66934693877551}}, {{
                0.00132293, 14.94661224489796}}, {{0.00132293, 
                14.94661224489796}}, {{0.0014408499999999998`, 
                14.956530612244897`}}, {{0.00165314, 14.963918367346938`}}, {{
                0.00186316, 14.969591836734693`}}, {{0.00207034, 
                14.974326530612245`}}}]}, "Charting`Private`Tag#2"]}}, <|
           "HighlightElements" -> <|
             "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
            "LayoutOptions" -> <|
             "PanelPlotLayout" -> <||>, 
              "PlotRange" -> {{0, 0.00207034}, {0, 14.974326530612245`}}, 
              "Frame" -> {{False, False}, {False, False}}, 
              "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 432}, 
              "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
              Full, "DefaultStyle" -> {
                Directive[
                 PointSize[
                  Rational[7, 360]], 
                 RGBColor[0.95, 0.627, 0.1425], 
                 AbsoluteThickness[2]], 
                Directive[
                 PointSize[
                  Rational[7, 360]], 
                 RGBColor[0.24, 0.6, 0.8], 
                 AbsoluteThickness[2]]}, 
              "HighlightLabelingFunctions" -> <|
               "CoordinatesToolOptions" -> ({
                  (Identity[#]& )[
                   Part[#, 1]], 
                  (Identity[#]& )[
                   Part[#, 2]]}& ), 
                "ScalingFunctions" -> {{Identity, Identity}, {
                  Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
              False|>, 
            "Meta" -> <|
             "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
              "Function" -> ListLinePlot, "GroupHighlight" -> False|>|>]]& )[<|
          "HighlightElements" -> <|
            "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
           "LayoutOptions" -> <|
            "PanelPlotLayout" -> <||>, 
             "PlotRange" -> {{0, 0.00207034}, {0, 14.974326530612245`}}, 
             "Frame" -> {{False, False}, {False, False}}, 
             "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 432}, 
             "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
             Full, "DefaultStyle" -> {
               Directive[
                PointSize[
                 Rational[7, 360]], 
                RGBColor[0.95, 0.627, 0.1425], 
                AbsoluteThickness[2]], 
               Directive[
                PointSize[
                 Rational[7, 360]], 
                RGBColor[0.24, 0.6, 0.8], 
                AbsoluteThickness[2]]}, 
             "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& ), 
               "ScalingFunctions" -> {{Identity, Identity}, {
                 Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
             False|>, 
           "Meta" -> <|
            "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
             "Function" -> ListLinePlot, "GroupHighlight" -> False|>|>], 
         ImageSizeCache -> {{4.503599627370496*^15, -4.503599627370496*^15}, {
          4.503599627370496*^15, -4.503599627370496*^15}}], Selectable -> 
        False]}, 
      Annotation[{{{}, {}, 
         Annotation[{
           Hue[0.67, 0.6, 0.6], 
           Directive[
            PointSize[
             Rational[7, 360]], 
            RGBColor[0.24, 0.6, 0.8], 
            AbsoluteThickness[2]], 
           
           Line[{{0., 0.}, {0.00029543480938711643`, 6.562322489296535}, {
            0.0006146962727383243, 10.408935534549569`}, {
            0.0009245446212503409, 12.864614113220572`}, {
            0.0012050175275299731`, 14.380267791858003`}, {
            0.0014408502726306804`, 14.93533990750454}, {
            0.0016531380741382927`, 14.966852142747886`}, {
            0.001863161137597154, 14.968010127951416`}, {
            0.0020703374009542626`, 14.964278571797085`}}]}, 
          "Charting`Private`Tag#1"], 
         Annotation[{
           Hue[0.9060679774997897, 0.6, 0.6], 
           Directive[
            PointSize[
             Rational[7, 360]], 
            RGBColor[0.95, 0.627, 0.1425], 
            AbsoluteThickness[2]], 
           
           Line[{{0.000295435, 6.033265306122449}, {0.000614696, 
            10.23404081632653}, {0.000924544, 13.00138775510204}, {0.00120502,
             14.66934693877551}, {0.00132293, 14.94661224489796}, {0.00132293,
             14.94661224489796}, {0.0014408499999999998`, 
            14.956530612244897`}, {0.00165314, 14.963918367346938`}, {
            0.00186316, 14.969591836734693`}, {0.00207034, 
            14.974326530612245`}}]}, "Charting`Private`Tag#2"]}, {
         Annotation[{
           Directive[
            PointSize[
             Rational[7, 360]], 
            RGBColor[0.24, 0.6, 0.8], 
            AbsoluteThickness[2]], 
           GeometricTransformation[
            Inset[
             Style[
              Graphics[{
                EdgeForm[], 
                Disk[{0, 0}]}, PlotRangePadding -> Scaled[0.15]], 
              GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                  PointSize[
                   Rational[7, 360]], 
                  RGBColor[0.24, 0.6, 0.8], 
                  AbsoluteThickness[2]]}], {0., 0.}, Automatic, 
             Offset[10.976]], {{{0., 0.}}, {{0.00029543480938711643`, 
            6.562322489296535}}, {{0.0006146962727383243, 
            10.408935534549569`}}, {{0.0009245446212503409, 
            12.864614113220572`}}, {{0.0012050175275299731`, 
            14.380267791858003`}}, {{0.0014408502726306804`, 
            14.93533990750454}}, {{0.0016531380741382927`, 
            14.966852142747886`}}, {{0.001863161137597154, 
            14.968010127951416`}}, {{0.0020703374009542626`, 
            14.964278571797085`}}}]}, "Charting`Private`Tag#1"], 
         Annotation[{
           Directive[
            PointSize[
             Rational[7, 360]], 
            RGBColor[0.95, 0.627, 0.1425], 
            AbsoluteThickness[2]], 
           GeometricTransformation[
            Inset[
             Style[
              Graphics[{
                EdgeForm[], 
                Polygon[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}, 
               PlotRangePadding -> Scaled[0.15]], 
              GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                  PointSize[
                   Rational[7, 360]], 
                  RGBColor[0.95, 0.627, 0.1425], 
                  AbsoluteThickness[2]]}], {0., 0.}, Automatic, 
             Offset[10.5]], {{{0.000295435, 6.033265306122449}}, {{
            0.000614696, 10.23404081632653}}, {{0.000924544, 
            13.00138775510204}}, {{0.00120502, 14.66934693877551}}, {{
            0.00132293, 14.94661224489796}}, {{0.00132293, 
            14.94661224489796}}, {{0.0014408499999999998`, 
            14.956530612244897`}}, {{0.00165314, 14.963918367346938`}}, {{
            0.00186316, 14.969591836734693`}}, {{0.00207034, 
            14.974326530612245`}}}]}, "Charting`Private`Tag#2"]}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PanelPlotLayout" -> <||>, 
          "PlotRange" -> {{0, 0.00207034}, {0, 14.974326530612245`}}, 
          "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0},
           "ImageSize" -> {360, 432}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> Full, "DefaultStyle" -> {
            Directive[
             PointSize[
              Rational[7, 360]], 
             RGBColor[0.95, 0.627, 0.1425], 
             AbsoluteThickness[2]], 
            Directive[
             PointSize[
              Rational[7, 360]], 
             RGBColor[0.24, 0.6, 0.8], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              (Identity[#]& )[
               Part[#, 1]], 
              (Identity[#]& )[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          ListLinePlot, "GroupHighlight" -> False|>|>, 
       "DynamicHighlight"]], {{}, {}}}, AspectRatio -> Full, 
    Axes -> {True, True}, AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, 
    DefaultBaseStyle -> {"PlotGraphics", "Graphics"}, DisplayFunction -> 
    Identity, Frame -> {{False, False}, {False, False}}, 
    FrameLabel -> {{None, None}, {None, None}}, 
    FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
    GridLines -> {None, None}, GridLinesStyle -> Directive[
      GrayLevel[0.5, 0.4]], 
    Method -> {
     "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
        Directive[
         RGBColor[0.24, 0.6, 0.8], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.95, 0.627, 0.1425], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.455, 0.7, 0.21], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.578, 0.51, 0.85], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.772079, 0.431554, 0.102387], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.4, 0.64, 1.], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[1., 0.75, 0.], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.8, 0.4, 0.76], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.637, 0.65, 0.], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.915, 0.3325, 0.2125], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
         AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
      "RangePadding" -> Scaled[0.05], "OptimizePlotMarkers" -> True, 
      "IncludeHighlighting" -> Automatic, "HighlightStyle" -> Automatic, 
      "OptimizePlotMarkers" -> True, "IncludeHighlighting" -> "CurrentSet", 
      "HighlightStyle" -> Automatic, "OptimizePlotMarkers" -> True, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}}, PlotInteractivity :> True, 
    PlotRange -> {{0, 0.00207034}, {0, 14.974326530612245`}}, 
    PlotRangeClipping -> True, PlotRangePadding -> {{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.02], 
       Scaled[0.05]}}, Ticks -> {Automatic, Automatic}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"This code\"", "\"Souza Neto\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.24, 0.6, 0.8], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.24, 0.6, 0.8], 
                    AbsoluteThickness[2]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    DiskBox[{0, 0}]}, {DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.24, 0.6, 0.8], 
                    AbsoluteThickness[2]]}, PlotRangePadding -> 
                    Scaled[0.15]}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.95, 0.627, 0.1425], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.95, 0.627, 0.1425], 
                    AbsoluteThickness[2]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}, {
                    DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.95, 0.627, 0.1425], 
                    AbsoluteThickness[2]]}, PlotRangePadding -> 
                    Scaled[0.15]}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), Editable -> True, 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["7", "360"], "]"}], ",", 
                   
                   TemplateBox[<|"color" -> RGBColor[0.24, 0.6, 0.8]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["7", "360"], "]"}], ",", 
                   
                   TemplateBox[<|"color" -> RGBColor[0.95, 0.627, 0.1425]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    EdgeForm[], 
                    DiskBox[{0, 0}]}, PlotRangePadding -> Scaled[0.15]], ",", 
                    
                    RowBox[{"Offset", "[", "10.976`", "]"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}, 
                    PlotRangePadding -> Scaled[0.15]], ",", 
                    RowBox[{"Offset", "[", "10.5`", "]"}]}], "}"}]}], "}"}]}],
            ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.9744593586706*^9, 3.974459364371381*^9}, 
   3.974624067701651*^9, 3.974789793723226*^9, {3.974789894764031*^9, 
   3.9747900932086*^9}},
 CellLabel->
  "Out[243]=",ExpressionUUID->"b3d3f389-a65b-4d5d-b3ab-7d1b93876188"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{{}, 
      InterpretationBox[{
        TagBox[{{{}, {}, 
           TagBox[
            {GrayLevel[0], PointSize[0.012833333333333334`], 
             AbsoluteThickness[1.1], 
             
             StyleBox[
              LineBox[{{0., 0.}, {0.00029543480938711643`, 
               6.562322489296535}, {0.0006146962727383243, 
               10.408935534549569`}, {0.0009245446212503409, 
               12.864614113220572`}, {0.0012050175275299731`, 
               14.380267791858003`}, {0.0014408502726306804`, 
               14.93533990750454}, {0.0016531380741382927`, 
               14.966852142747886`}, {0.001863161137597154, 
               14.968010127951416`}, {0.0020703374009542626`, 
               14.964278571797085`}}],
              FontFamily->"Times"]},
            Annotation[#, "Charting`Private`Tag#1"]& ]}, 
          TagBox[
           {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
            1.1], 
            StyleBox[GeometricTransformationBox[InsetBox[
               StyleBox[
                StyleBox["\<\"\[EmptyDiamond]\"\>",
                 StripOnInput->False,
                 FontSize->22],
                StripOnInput->False,
                GraphicsBoxOptions->{DefaultBaseStyle->Directive[
                  PointSize[0.012833333333333334`], FontFamily -> "Times", 
                  GrayLevel[0], 
                  AbsoluteThickness[1.1]]}], {0., 0.}], {{{0., 0.}}, {{
              0.00029543480938711643`, 6.562322489296535}}, {{
              0.0006146962727383243, 10.408935534549569`}}, {{
              0.0009245446212503409, 12.864614113220572`}}, {{
              0.0012050175275299731`, 14.380267791858003`}}, {{
              0.0014408502726306804`, 14.93533990750454}}, {{
              0.0016531380741382927`, 14.966852142747886`}}, {{
              0.001863161137597154, 14.968010127951416`}}, {{
              0.0020703374009542626`, 14.964278571797085`}}}],
             FontFamily->"Times"]},
           Annotation[#, "Charting`Private`Tag#1"]& ]},
         {
         "WolframDynamicHighlight", <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
        StyleBox[
         DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
           Slot["HighlightElements"], 
           Slot["LayoutOptions"], 
           Slot["Meta"], 
           Charting`HighlightActionFunction["DynamicHighlight", {{{}, {}, 
              Annotation[{
                Hue[0.67, 0.6, 0.6], 
                Directive[
                 PointSize[0.012833333333333334`], FontFamily -> "Times", 
                 GrayLevel[0], 
                 AbsoluteThickness[1.1]], 
                
                Line[{{0., 0.}, {0.00029543480938711643`, 
                 6.562322489296535}, {0.0006146962727383243, 
                 10.408935534549569`}, {0.0009245446212503409, 
                 12.864614113220572`}, {0.0012050175275299731`, 
                 14.380267791858003`}, {0.0014408502726306804`, 
                 14.93533990750454}, {0.0016531380741382927`, 
                 14.966852142747886`}, {0.001863161137597154, 
                 14.968010127951416`}, {0.0020703374009542626`, 
                 14.964278571797085`}}]}, "Charting`Private`Tag#1"]}, {
              Annotation[{
                Directive[
                 PointSize[0.012833333333333334`], FontFamily -> "Times", 
                 GrayLevel[0], 
                 AbsoluteThickness[1.1]], 
                GeometricTransformation[
                 Inset[
                  Style[
                   Style["\[EmptyDiamond]", 22], 
                   GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                    PointSize[0.012833333333333334`], FontFamily -> "Times", 
                    GrayLevel[0], 
                    AbsoluteThickness[1.1]]}], {0., 0.}], {{{0., 0.}}, {{
                 0.00029543480938711643`, 6.562322489296535}}, {{
                 0.0006146962727383243, 10.408935534549569`}}, {{
                 0.0009245446212503409, 12.864614113220572`}}, {{
                 0.0012050175275299731`, 14.380267791858003`}}, {{
                 0.0014408502726306804`, 14.93533990750454}}, {{
                 0.0016531380741382927`, 14.966852142747886`}}, {{
                 0.001863161137597154, 14.968010127951416`}}, {{
                 0.0020703374009542626`, 14.964278571797085`}}}]}, 
               "Charting`Private`Tag#1"]}}, <|
            "HighlightElements" -> <|
              "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
             "LayoutOptions" -> <|
              "PanelPlotLayout" -> <||>, 
               "PlotRange" -> {{0, 0.0020703374009542626`}, {
                 0, 14.968010127951416`}}, 
               "Frame" -> {{True, True}, {True, True}}, 
               "AxesOrigin" -> {0, 0}, "ImageSize" -> {400, 400}, 
               "Axes" -> {True, True}, 
               "LabelStyle" -> {FontFamily -> "Times", FontSize -> 15}, 
               "AspectRatio" -> 1, "DefaultStyle" -> {
                 Directive[
                  PointSize[0.012833333333333334`], FontFamily -> "Times", 
                  GrayLevel[0], 
                  AbsoluteThickness[1.1]]}, 
               "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                   (Identity[#]& )[
                    Part[#, 1]], 
                   (Identity[#]& )[
                    Part[#, 2]]}& ), 
                 "ScalingFunctions" -> {{Identity, Identity}, {
                   Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
               False|>, 
             "Meta" -> <|
              "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
               "Function" -> ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
           "HighlightElements" -> <|
             "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
            "LayoutOptions" -> <|
             "PanelPlotLayout" -> <||>, 
              "PlotRange" -> {{0, 0.0020703374009542626`}, {
                0, 14.968010127951416`}}, 
              "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0},
               "ImageSize" -> {400, 400}, "Axes" -> {True, True}, 
              "LabelStyle" -> {FontFamily -> "Times", FontSize -> 15}, 
              "AspectRatio" -> 1, "DefaultStyle" -> {
                Directive[
                 PointSize[0.012833333333333334`], FontFamily -> "Times", 
                 GrayLevel[0], 
                 AbsoluteThickness[1.1]]}, 
              "HighlightLabelingFunctions" -> <|
               "CoordinatesToolOptions" -> ({
                  (Identity[#]& )[
                   Part[#, 1]], 
                  (Identity[#]& )[
                   Part[#, 2]]}& ), 
                "ScalingFunctions" -> {{Identity, Identity}, {
                  Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
              False|>, 
            "Meta" -> <|
             "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
              "Function" -> ListPlot, "GroupHighlight" -> False|>|>],
          
          ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
           4.503599627370496*^15, -4.503599627370496*^15}}],
         Selectable->False]},
       Annotation[{{{}, {}, 
          Annotation[{
            Hue[0.67, 0.6, 0.6], 
            Directive[
             PointSize[0.012833333333333334`], FontFamily -> "Times", 
             GrayLevel[0], 
             AbsoluteThickness[1.1]], 
            
            Line[{{0., 0.}, {0.00029543480938711643`, 6.562322489296535}, {
             0.0006146962727383243, 10.408935534549569`}, {
             0.0009245446212503409, 12.864614113220572`}, {
             0.0012050175275299731`, 14.380267791858003`}, {
             0.0014408502726306804`, 14.93533990750454}, {
             0.0016531380741382927`, 14.966852142747886`}, {
             0.001863161137597154, 14.968010127951416`}, {
             0.0020703374009542626`, 14.964278571797085`}}]}, 
           "Charting`Private`Tag#1"]}, {
          Annotation[{
            Directive[
             PointSize[0.012833333333333334`], FontFamily -> "Times", 
             GrayLevel[0], 
             AbsoluteThickness[1.1]], 
            GeometricTransformation[
             Inset[
              Style[
               Style["\[EmptyDiamond]", 22], 
               GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                   PointSize[0.012833333333333334`], FontFamily -> "Times", 
                   GrayLevel[0], 
                   AbsoluteThickness[1.1]]}], {0., 0.}], {{{0., 0.}}, {{
             0.00029543480938711643`, 6.562322489296535}}, {{
             0.0006146962727383243, 10.408935534549569`}}, {{
             0.0009245446212503409, 12.864614113220572`}}, {{
             0.0012050175275299731`, 14.380267791858003`}}, {{
             0.0014408502726306804`, 14.93533990750454}}, {{
             0.0016531380741382927`, 14.966852142747886`}}, {{
             0.001863161137597154, 14.968010127951416`}}, {{
             0.0020703374009542626`, 14.964278571797085`}}}]}, 
           "Charting`Private`Tag#1"]}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{0, 0.0020703374009542626`}, {
             0, 14.968010127951416`}}, 
           "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0}, 
           "ImageSize" -> {400, 400}, "Axes" -> {True, True}, 
           "LabelStyle" -> {FontFamily -> "Times", FontSize -> 15}, 
           "AspectRatio" -> 1, "DefaultStyle" -> {
             Directive[
              PointSize[0.012833333333333334`], FontFamily -> "Times", 
              GrayLevel[0], 
              AbsoluteThickness[1.1]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>, 
        "DynamicHighlight"]], {{}, {}}}, 
     InterpretationBox[{
       TagBox[{{{}, {}, 
          TagBox[
           {GrayLevel[0], AbsoluteThickness[1.], Opacity[1.], 
            Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ7dhk8SHD6rjtrJkgoOtwS6TrSpjfVzsY/1rr44RQ
P1Z7GP/il9xpO43F4Hz7pcs269YpwPk5v9yEso+rwvnXtaa9iGrWhvOnlGlL
rcozgPOjXR///h9iDOf7Zm6WOKNrBucbhtl8mHPVAs7fsmEO8/Ft1nC+5pWt
F7+m2cH5qcuKc8+2OMD5rZI/+s98coTz5T7e4PfzcIbz2+uX6tbsckGot/iX
8VTVDc7/E7qZ8WKFO5zvrBVikfnCA85nTg4802zvBedPCrL657XZG87fnrPe
11fBF84Pfd3w62KJH5x/WMHOlfmZP5wfcnd1WfT8AIR5++tuBnkEwvkWte7d
C/4j+FK5+7LXrwqC81MstGeLpATD+T8l4iLFpULg/FPa9m63DyP4zFJiTV+r
Q+H8SqvZby6oh8H5VgXPnnpeQPCTGtX1JNvD4fzjR8SWrjSMQMTv499ZE14h
+HNN+uMtpkfC+R9nvXhU6xAF56+9Y75V8geCvzTAdFvZ4mg4n3WBBptWbAyc
v4Hl0ZMq4Vg4f/psz089exH8Z7zL/b6WxsH5RZs23ZRTiofzPXJaPj89heAf
ZlBbx+iYAOc3PHnws2Aagv+l8GmBwjEEP/3/y+fnvyL4AJZikEk=
             "]]},
           Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
        {"WolframDynamicHighlight", <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
       StyleBox[
        DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
          Slot["HighlightElements"], 
          Slot["LayoutOptions"], 
          Slot["Meta"], 
          Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
              Annotation[{
                Directive[
                 Opacity[1.], 
                 GrayLevel[0], 
                 Dashing[{Small, Small}], 
                 AbsoluteThickness[1.]], 
                Line[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ7dhk8SHD6rjtrJkgoOtwS6TrSpjfVzsY/1rr44RQ
P1Z7GP/il9xpO43F4Hz7pcs269YpwPk5v9yEso+rwvnXtaa9iGrWhvOnlGlL
rcozgPOjXR///h9iDOf7Zm6WOKNrBucbhtl8mHPVAs7fsmEO8/Ft1nC+5pWt
F7+m2cH5qcuKc8+2OMD5rZI/+s98coTz5T7e4PfzcIbz2+uX6tbsckGot/iX
8VTVDc7/E7qZ8WKFO5zvrBVikfnCA85nTg4802zvBedPCrL657XZG87fnrPe
11fBF84Pfd3w62KJH5x/WMHOlfmZP5wfcnd1WfT8AIR5++tuBnkEwvkWte7d
C/4j+FK5+7LXrwqC81MstGeLpATD+T8l4iLFpULg/FPa9m63DyP4zFJiTV+r
Q+H8SqvZby6oh8H5VgXPnnpeQPCTGtX1JNvD4fzjR8SWrjSMQMTv499ZE14h
+HNN+uMtpkfC+R9nvXhU6xAF56+9Y75V8geCvzTAdFvZ4mg4n3WBBptWbAyc
v4Hl0ZMq4Vg4f/psz089exH8Z7zL/b6WxsH5RZs23ZRTiofzPXJaPj89heAf
ZlBbx+iYAOc3PHnws2Aagv+l8GmBwjEEP/3/y+fnvyL4AJZikEk=
                 "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
           "HighlightElements" -> <|
             "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
            "LayoutOptions" -> <|
             "PanelPlotLayout" -> <||>, "PlotRange" -> {All, All}, 
              "Frame" -> {{False, False}, {False, False}}, 
              "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
              "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
              GoldenRatio^(-1), "DefaultStyle" -> {
                Directive[
                 Opacity[1.], 
                 GrayLevel[0], 
                 Dashing[{Small, Small}], 
                 AbsoluteThickness[1.]]}, 
              "HighlightLabelingFunctions" -> <|
               "CoordinatesToolOptions" -> ({
                  (Identity[#]& )[
                   Part[#, 1]], 
                  (Identity[#]& )[
                   Part[#, 2]]}& ), 
                "ScalingFunctions" -> {{Identity, Identity}, {
                  Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
              False|>, 
            "Meta" -> <|
             "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
              "Function" -> Plot, "GroupHighlight" -> False|>|>]]& )[<|
          "HighlightElements" -> <|
            "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
           "LayoutOptions" -> <|
            "PanelPlotLayout" -> <||>, "PlotRange" -> {All, All}, 
             "Frame" -> {{False, False}, {False, False}}, 
             "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
             "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
             GoldenRatio^(-1), "DefaultStyle" -> {
               Directive[
                Opacity[1.], 
                GrayLevel[0], 
                Dashing[{Small, Small}], 
                AbsoluteThickness[1.]]}, 
             "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& ), 
               "ScalingFunctions" -> {{Identity, Identity}, {
                 Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
             False|>, 
           "Meta" -> <|
            "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
             "Function" -> Plot, "GroupHighlight" -> False|>|>],
         ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
          4.503599627370496*^15, -4.503599627370496*^15}}],
        Selectable->False]},
      Annotation[{{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             GrayLevel[0], 
             Dashing[{Small, Small}], 
             AbsoluteThickness[1.]], 
            Line[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ7dhk8SHD6rjtrJkgoOtwS6TrSpjfVzsY/1rr44RQ
P1Z7GP/il9xpO43F4Hz7pcs269YpwPk5v9yEso+rwvnXtaa9iGrWhvOnlGlL
rcozgPOjXR///h9iDOf7Zm6WOKNrBucbhtl8mHPVAs7fsmEO8/Ft1nC+5pWt
F7+m2cH5qcuKc8+2OMD5rZI/+s98coTz5T7e4PfzcIbz2+uX6tbsckGot/iX
8VTVDc7/E7qZ8WKFO5zvrBVikfnCA85nTg4802zvBedPCrL657XZG87fnrPe
11fBF84Pfd3w62KJH5x/WMHOlfmZP5wfcnd1WfT8AIR5++tuBnkEwvkWte7d
C/4j+FK5+7LXrwqC81MstGeLpATD+T8l4iLFpULg/FPa9m63DyP4zFJiTV+r
Q+H8SqvZby6oh8H5VgXPnnpeQPCTGtX1JNvD4fzjR8SWrjSMQMTv499ZE14h
+HNN+uMtpkfC+R9nvXhU6xAF56+9Y75V8geCvzTAdFvZ4mg4n3WBBptWbAyc
v4Hl0ZMq4Vg4f/psz089exH8Z7zL/b6WxsH5RZs23ZRTiofzPXJaPj89heAf
ZlBbx+iYAOc3PHnws2Aagv+l8GmBwjEEP/3/y+fnvyL4AJZikEk=
             "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PanelPlotLayout" -> <||>, "PlotRange" -> {All, All}, 
          "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0},
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             GrayLevel[0], 
             Dashing[{Small, Small}], 
             AbsoluteThickness[1.]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              (Identity[#]& )[
               Part[#, 1]], 
              (Identity[#]& )[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]]}, {
     InsetBox[
      TemplateBox[{"\"finite element results \[Dash] Mohr-Coulomb\""},
       "LineLegend",
       DisplayFunction->(StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    GrayLevel[0], 
                    AbsoluteThickness[1.1]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    GrayLevel[0], 
                    AbsoluteThickness[1.1]], {
                    InsetBox[
                    FormBox[
                    StyleBox[
                    StyleBox[
                    "\"\[EmptyDiamond]\"", 22, StripOnInput -> False], 
                    FontSize -> 12.5, StripOnInput -> False], 
                    TraditionalForm], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False]& ),
       Editable->True,
       InterpretationFunction:>(RowBox[{"LineLegend", "[", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                RowBox[{"Directive", "[", 
                  RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.1`", "]"}]}], "]"}], 
                ",", 
                RowBox[{"Directive", "[", 
                  RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.1`", "]"}]}], 
                  "]"}]}], "}"}], ",", 
            RowBox[{"{", #, "}"}], ",", 
            RowBox[{"Joined", "\[Rule]", 
              RowBox[{"{", "True", "}"}]}], ",", 
            RowBox[{"LabelStyle", "\[Rule]", 
              RowBox[{"{", "}"}]}], ",", 
            RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
            RowBox[{"LegendMarkers", "\[Rule]", 
              RowBox[{"{", 
                RowBox[{
                  StyleBox["\"\[EmptyDiamond]\"", 22, StripOnInput -> False], 
                  ",", 
                  StyleBox[
                  "\"\[EmptyUpTriangle]\"", 22, StripOnInput -> False]}], 
                "}"}]}]}], "]"}]& )], Scaled[{0.52, 0.1}], ImageScaled[{0.5, 0.5}],
      BaseStyle->{FontSize -> Larger},
      FormatType->StandardForm], InsetBox[
      TemplateBox[{"\"Prandtl's solution  14.8\""},
       "LineLegend",
       DisplayFunction->(StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    GrayLevel[0], 
                    Dashing[{Small, Small}], 
                    AbsoluteThickness[1.]], {
                    LineBox[{{0, 12.5}, {40, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    GrayLevel[0], 
                    Dashing[{Small, Small}], 
                    AbsoluteThickness[1.]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False]& ),
       Editable->True,
       InterpretationFunction:>(RowBox[{"LineLegend", "[", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{"Directive", "[", 
                RowBox[{
                  
                  TemplateBox[<|"color" -> GrayLevel[0]|>, 
                   "GrayLevelColorSwatchTemplate"], ",", 
                  RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}], ",", 
                  RowBox[{"AbsoluteThickness", "[", "1.`", "]"}]}], "]"}], 
              "}"}], ",", 
            RowBox[{"{", #, "}"}], ",", 
            RowBox[{"LabelStyle", "\[Rule]", 
              RowBox[{"{", "}"}]}], ",", 
            RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
      Scaled[{0.52, 0.22}], ImageScaled[{0.5, 0.5}],
      BaseStyle->{FontSize -> Larger},
      FormatType->StandardForm]}},
   AspectRatio->1,
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0, 0},
   BaseStyle->{FontFamily -> "Times", 15},
   DefaultBaseStyle->{"PlotGraphics", "Graphics"},
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox[
       TagBox["\"Load factor, \[Lambda]\"", HoldForm], TraditionalForm], 
      None}, {
      FormBox[
       TagBox["\"vertical displacement, at (0,5)\"", HoldForm], 
       TraditionalForm], None}},
   FrameStyle->GrayLevel[0],
   FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
   GridLines->{None, None},
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   ImageSize->400,
   Method->{
    "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
     "DefaultGraphicsInteraction" -> {
      "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
       "Effects" -> {
        "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
         "Droplines" -> {
          "freeformCursorMode" -> True, 
           "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
     "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
       Directive[
        RGBColor[0.24, 0.6, 0.8], 
        AbsoluteThickness[2]], 
       Directive[
        RGBColor[0.95, 0.627, 0.1425], 
        AbsoluteThickness[2]], 
       Directive[
        RGBColor[0.455, 0.7, 0.21], 
        AbsoluteThickness[2]], 
       Directive[
        RGBColor[0.922526, 0.385626, 0.209179], 
        AbsoluteThickness[2]], 
       Directive[
        RGBColor[0.578, 0.51, 0.85], 
        AbsoluteThickness[2]], 
       Directive[
        RGBColor[0.772079, 0.431554, 0.102387], 
        AbsoluteThickness[2]], 
       Directive[
        RGBColor[0.4, 0.64, 1.], 
        AbsoluteThickness[2]], 
       Directive[
        RGBColor[1., 0.75, 0.], 
        AbsoluteThickness[2]], 
       Directive[
        RGBColor[0.8, 0.4, 0.76], 
        AbsoluteThickness[2]], 
       Directive[
        RGBColor[0.637, 0.65, 0.], 
        AbsoluteThickness[2]], 
       Directive[
        RGBColor[0.915, 0.3325, 0.2125], 
        AbsoluteThickness[2]], 
       Directive[
        RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
        AbsoluteThickness[2]], 
       Directive[
        RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
        
        AbsoluteThickness[2]], 
       Directive[
        RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
        AbsoluteThickness[2]], 
       Directive[
        RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
        AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
     "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
     "OptimizePlotMarkers" -> True, "IncludeHighlighting" -> Automatic, 
     "HighlightStyle" -> Automatic, "OptimizePlotMarkers" -> True, 
     "IncludeHighlighting" -> "CurrentSet", "HighlightStyle" -> Automatic, 
     "OptimizePlotMarkers" -> True, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& )}},
   PlotInteractivity:>True,
   PlotRange->All,
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.02], 
      Scaled[0.05]}},
   Ticks->{Automatic, Automatic}],
  InterpretTemplate[Legended[
    Graphics[{{{}, 
       Annotation[{{{}, {}, 
          Annotation[{
            Hue[0.67, 0.6, 0.6], 
            Directive[
             PointSize[0.012833333333333334`], FontFamily -> "Times", 
             GrayLevel[0], 
             AbsoluteThickness[1.1]], 
            
            Line[{{0., 0.}, {0.00029543480938711643`, 6.562322489296535}, {
             0.0006146962727383243, 10.408935534549569`}, {
             0.0009245446212503409, 12.864614113220572`}, {
             0.0012050175275299731`, 14.380267791858003`}, {
             0.0014408502726306804`, 14.93533990750454}, {
             0.0016531380741382927`, 14.966852142747886`}, {
             0.001863161137597154, 14.968010127951416`}, {
             0.0020703374009542626`, 14.964278571797085`}}]}, 
           "Charting`Private`Tag#1"]}, {
          Annotation[{
            Directive[
             PointSize[0.012833333333333334`], FontFamily -> "Times", 
             GrayLevel[0], 
             AbsoluteThickness[1.1]], 
            GeometricTransformation[
             Inset[
              Style[
               Style["\[EmptyDiamond]", 22], 
               GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                   PointSize[0.012833333333333334`], FontFamily -> "Times", 
                   GrayLevel[0], 
                   AbsoluteThickness[1.1]]}], {0., 0.}], {{{0., 0.}}, {{
             0.00029543480938711643`, 6.562322489296535}}, {{
             0.0006146962727383243, 10.408935534549569`}}, {{
             0.0009245446212503409, 12.864614113220572`}}, {{
             0.0012050175275299731`, 14.380267791858003`}}, {{
             0.0014408502726306804`, 14.93533990750454}}, {{
             0.0016531380741382927`, 14.966852142747886`}}, {{
             0.001863161137597154, 14.968010127951416`}}, {{
             0.0020703374009542626`, 14.964278571797085`}}}]}, 
           "Charting`Private`Tag#1"]}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{0, 0.0020703374009542626`}, {
             0, 14.968010127951416`}}, 
           "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0}, 
           "ImageSize" -> {400, 400}, "Axes" -> {True, True}, 
           "LabelStyle" -> {FontFamily -> "Times", FontSize -> 15}, 
           "AspectRatio" -> 1, "DefaultStyle" -> {
             Directive[
              PointSize[0.012833333333333334`], FontFamily -> "Times", 
              GrayLevel[0], 
              AbsoluteThickness[1.1]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>, 
        "DynamicHighlight"], {{}, {}}}, {
       Annotation[{{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              GrayLevel[0], 
              Dashing[{Small, Small}], 
              AbsoluteThickness[1.]], 
             Line[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ7dhk8SHD6rjtrJkgoOtwS6TrSpjfVzsY/1rr44RQ
P1Z7GP/il9xpO43F4Hz7pcs269YpwPk5v9yEso+rwvnXtaa9iGrWhvOnlGlL
rcozgPOjXR///h9iDOf7Zm6WOKNrBucbhtl8mHPVAs7fsmEO8/Ft1nC+5pWt
F7+m2cH5qcuKc8+2OMD5rZI/+s98coTz5T7e4PfzcIbz2+uX6tbsckGot/iX
8VTVDc7/E7qZ8WKFO5zvrBVikfnCA85nTg4802zvBedPCrL657XZG87fnrPe
11fBF84Pfd3w62KJH5x/WMHOlfmZP5wfcnd1WfT8AIR5++tuBnkEwvkWte7d
C/4j+FK5+7LXrwqC81MstGeLpATD+T8l4iLFpULg/FPa9m63DyP4zFJiTV+r
Q+H8SqvZby6oh8H5VgXPnnpeQPCTGtX1JNvD4fzjR8SWrjSMQMTv499ZE14h
+HNN+uMtpkfC+R9nvXhU6xAF56+9Y75V8geCvzTAdFvZ4mg4n3WBBptWbAyc
v4Hl0ZMq4Vg4f/psz089exH8Z7zL/b6WxsH5RZs23ZRTiofzPXJaPj89heAf
ZlBbx+iYAOc3PHnws2Aagv+l8GmBwjEEP/3/y+fnvyL4AJZikEk=
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, "PlotRange" -> {All, All}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              GrayLevel[0], 
              Dashing[{Small, Small}], 
              AbsoluteThickness[1.]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]}}, {
     PlotRange -> All, DisplayFunction -> Identity, DisplayFunction -> 
      Identity, PlotInteractivity :> $PlotInteractivity, 
      DefaultBaseStyle -> {"PlotGraphics", "Graphics"}, AspectRatio -> 1, 
      Axes -> {True, True}, AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, 
      BaseStyle -> {FontFamily -> "Times", 15}, DisplayFunction :> Identity, 
      Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
         HoldForm["Load factor, \[Lambda]"], None}, {
         HoldForm["vertical displacement, at (0,5)"], None}}, FrameStyle -> 
      GrayLevel[0], 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {None, None}, GridLinesStyle -> Directive[
        GrayLevel[0.5, 0.4]], ImageSize -> 400, 
      Method -> {
       "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
          Directive[
           RGBColor[0.24, 0.6, 0.8], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.95, 0.627, 0.1425], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.455, 0.7, 0.21], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.922526, 0.385626, 0.209179], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.578, 0.51, 0.85], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.772079, 0.431554, 0.102387], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.4, 0.64, 1.], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[1., 0.75, 0.], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.8, 0.4, 0.76], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.637, 0.65, 0.], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.915, 0.3325, 0.2125], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[
           0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
           AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
        "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
        Scaled[0.05], "OptimizePlotMarkers" -> True, "IncludeHighlighting" -> 
        Automatic, "HighlightStyle" -> Automatic, "OptimizePlotMarkers" -> 
        True, "IncludeHighlighting" -> "CurrentSet", "HighlightStyle" -> 
        Automatic, "OptimizePlotMarkers" -> True, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}}, 
      PlotInteractivity :> <|
       "SystemLimits" -> 3000, "UserLimits" -> 10000, "UserInteractivity" -> 
        True|>, PlotRange -> {{0, 0.0020703374009542626`}, {
        0, 14.968010127951416`}}, PlotRangeClipping -> True, 
      PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.05]}}, Ticks -> {Automatic, Automatic}, 
      PlotInteractivity :> $PlotInteractivity}], 
    Placed[
     Unevaluated[
      Unevaluated[
       LineLegend[{
         Directive[
          GrayLevel[0], 
          Dashing[{Small, Small}], 
          AbsoluteThickness[1.]]}, {"Prandtl's solution  14.8"}, 
        LabelStyle -> {}, LegendLayout -> "Column"]]], {0.52, 0.22}, 
     Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{{3.9744593586706*^9, 3.974459364371381*^9}, 
   3.974624067701651*^9, 3.974789793723226*^9, {3.974789894764031*^9, 
   3.974790093266013*^9}},
 CellLabel->
  "Out[247]=",ExpressionUUID->"2ae179cc-fa46-4e31-9651-556e2535f715"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"IterativeProcessDisplacementControl", "[", 
    RowBox[{"mesh_", ",", "dispSteps_", ",", "bcDirichlet_", ",", 
     RowBox[{"bcDirichletControlled_", ":", 
      RowBox[{"{", "}"}]}]}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "kg", ",", "fint", ",", "fext", ",", "steps", ",", "r", ",", 
       "\[Delta]u", ",", "uTotal", ",", "norm\[Delta]u", ",", 
       RowBox[{"normr", "=", "10000"}], ",", "normr0", ",", "counter", ",", 
       RowBox[{"tolRel", "=", "1*^-5"}], ",", 
       RowBox[{"maxIter", "=", "30"}], ",", 
       RowBox[{"tolMachine", "=", 
        RowBox[{"100", "*", "$MachineEpsilon"}]}], ",", "bcids", ",", 
       "bcidsCtrl", ",", "bcidsDirichlet", ",", "markers", ",", "dir", ",", 
       "val", ",", "converged", ",", 
       RowBox[{"solsvec", "=", 
        RowBox[{"{", "}"}]}], ",", 
       RowBox[{"epspsolsvec", "=", 
        RowBox[{"{", "}"}]}], ",", 
       RowBox[{"plot", "=", 
        RowBox[{"{", "}"}]}], ",", "nNodes", ",", "nodesFixedX", ",", 
       "nodesFixedY", ",", "nodesCtrlY", ",", "reactionX", ",", 
       "reactionYbase", ",", "reactionYtop", ",", "relResidual", ",", "k"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"steps", "=", 
       RowBox[{"Length", "[", "dispSteps", "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"warning", ":", " ", 
        RowBox[{"global", " ", "variables"}]}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Clear", "[", 
       RowBox[{
       "npts", ",", "nglobalpts", ",", "nDofs", ",", "displace", ",", 
        "epspvec", ",", "epspsolitern", ",", "epbarsolintern", ",", 
        "accumulatedplasticstrain", ",", "epbarvec"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"npts", "=", 
       RowBox[{"Length", "[", "intrule", "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"nglobalpts", "=", 
       RowBox[{
        RowBox[{"Length", "[", "topol", "]"}], "*", "npts"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"nDofs", "=", 
       RowBox[{"dim", "*", 
        RowBox[{"Length", "[", "meshnodes", "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"displace", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"0.", ",", 
         RowBox[{"{", "nDofs", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"epspvec", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{"0.", ",", 
           RowBox[{"{", "3", "}"}]}], "]"}], ",", 
         RowBox[{"{", "nglobalpts", "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"epspsolitern", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{"0.", ",", 
           RowBox[{"{", "3", "}"}]}], "]"}], ",", 
         RowBox[{"{", "nglobalpts", "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"epbarsolintern", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"0.", ",", 
         RowBox[{"{", "nglobalpts", "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"accumulatedplasticstrain", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"0.", ",", 
         RowBox[{"{", "nglobalpts", "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"epbarvec", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"0.", ",", 
         RowBox[{"{", "nglobalpts", "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<npts = \>\"", ",", "npts"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<nElements = \>\"", ",", 
        RowBox[{"Length", "[", "topol", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<nglobalpts esperado = \>\"", ",", 
        RowBox[{
         RowBox[{"Length", "[", "topol", "]"}], "*", "npts"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Length[epspvec] = \>\"", ",", 
        RowBox[{"Length", "[", "epspvec", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Coletar", " ", "n\[OAcute]s", " ", "com", " ", "Dirichlet"}], 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"bcidsDirichlet", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"markers", "=", 
          RowBox[{"bc", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"bcidsDirichlet", "=", 
          RowBox[{"Union", "[", 
           RowBox[{"bcidsDirichlet", ",", 
            RowBox[{"Flatten", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"TakeIds", "[", 
                RowBox[{"#", ",", "mesh"}], "]"}], "&"}], "/@", "markers"}], 
             "]"}]}], "]"}]}], ";"}], ",", 
        RowBox[{"{", 
         RowBox[{"bc", ",", "bcDirichlet"}], "}"}]}], "\[IndentingNewLine]", 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"bcidsCtrl", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "bcDirichletControlled", "]"}], ">", "0"}], ",",
         "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"markers", "=", 
          RowBox[{"bcDirichletControlled", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"bcidsCtrl", "=", 
          RowBox[{"DeleteDuplicates", "[", 
           RowBox[{"Flatten", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"TakeIds", "[", 
               RowBox[{"#", ",", "mesh"}], "]"}], "&"}], "/@", "markers"}], 
            "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"bcidsCtrl", "=", 
          RowBox[{"Complement", "[", 
           RowBox[{"bcidsCtrl", ",", "bcidsDirichlet"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<IDs controlados: \>\"", ",", 
           RowBox[{"Length", "[", "bcidsCtrl", "]"}], 
           ",", "\"\< n\[OAcute]s\>\""}], "]"}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"N\[OAcute]s", " ", "para", " ", "rea\[CCedilla]\[OTilde]es"}],
        "*)"}], "\[IndentingNewLine]", 
      RowBox[{"nodesFixedX", "=", 
       RowBox[{"DeleteDuplicates", "[", 
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"TakeIds", "[", 
            RowBox[{"#", ",", "mesh"}], "]"}], "&"}], "/@", 
          RowBox[{"Flatten", "[", 
           RowBox[{
            RowBox[{"Select", "[", 
             RowBox[{"bcDirichlet", ",", 
              RowBox[{
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "==", "1"}], "&"}]}], "]"}], 
            "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", "1"}], "]"}], "]"}], "]"}]}], "]"}], "]"}]}],
       ";", "\[IndentingNewLine]", 
      RowBox[{"nodesFixedY", "=", 
       RowBox[{"DeleteDuplicates", "[", 
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"TakeIds", "[", 
            RowBox[{"#", ",", "mesh"}], "]"}], "&"}], "/@", 
          RowBox[{"Flatten", "[", 
           RowBox[{
            RowBox[{"Select", "[", 
             RowBox[{"bcDirichlet", ",", 
              RowBox[{
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "==", "2"}], "&"}]}], "]"}], 
            "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", "1"}], "]"}], "]"}], "]"}]}], "]"}], "]"}]}],
       ";", "\[IndentingNewLine]", 
      RowBox[{"nodesCtrlY", "=", "bcidsCtrl"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<N\[OAcute]s com ux fixo: \>\"", ",", 
        RowBox[{"Length", "[", "nodesFixedX", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<N\[OAcute]s com uy fixo: \>\"", ",", 
        RowBox[{"Length", "[", "nodesFixedY", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<N\[OAcute]s controlados: \>\"", ",", 
        RowBox[{"Length", "[", "nodesCtrlY", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"uTotal", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"taxa", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"kk", "=", "1"}], ",", 
        RowBox[{"kk", "<=", "steps"}], ",", 
        RowBox[{"kk", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"uTotal", "+=", 
          RowBox[{"dispSteps", "[", 
           RowBox[{"[", "kk", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"Print", "[", 
          
          RowBox[{"\"\<=== Step \>\"", ",", "kk", ",", "\"\</\>\"", ",", 
           "steps", ",", "\"\< | u_total = \>\"", ",", "uTotal", 
           ",", "\"\< ===\>\""}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"counter", "=", "1"}], ";", "\[IndentingNewLine]", 
         RowBox[{"converged", "=", "False"}], ";", "\[IndentingNewLine]", 
         RowBox[{"normr0", "=", "None"}], ";", 
         RowBox[{"(*", 
          RowBox[{"Res\[IAcute]duo", " ", "inicial", " ", "do", " ", "step"}],
           "*)"}], 
         RowBox[{"(*", 
          RowBox[{"Aplicar", " ", "deslocamento", " ", "prescrito"}], "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Length", "[", "bcidsCtrl", "]"}], ">", "0"}], ",", 
           RowBox[{
            RowBox[{"dir", "=", 
             RowBox[{"bcDirichletControlled", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"displace", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"dim", "*", 
                 RowBox[{"(", 
                  RowBox[{"bcidsCtrl", "-", "1"}], ")"}]}], "+", "dir"}], 
               "]"}], "]"}], "=", "uTotal"}], ";"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"kg", ",", "fint", ",", "fext"}], "}"}], "=", 
          RowBox[{"AssemblePlasticity", "[", 
           RowBox[{"mesh", ",", "displace"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{"Newton", "-", "Raphson"}], "*)"}], "\[IndentingNewLine]", 
         RowBox[{"While", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"!", "converged"}], "&&", 
            RowBox[{"counter", "<=", "maxIter"}]}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"r", "=", 
              RowBox[{"fext", "-", "fint"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"(*", 
              RowBox[{"Aplicar", " ", "Dirichlet"}], "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{"Do", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"markers", "=", 
                 RowBox[{"bc", "[", 
                  RowBox[{"[", "1", "]"}], "]"}]}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"dir", "=", 
                 RowBox[{"bc", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"val", "=", 
                 RowBox[{"bc", "[", 
                  RowBox[{"[", "3", "]"}], "]"}]}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"bcids", "=", 
                 RowBox[{"DeleteDuplicates", "[", 
                  RowBox[{"Flatten", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"TakeIds", "[", 
                    RowBox[{"#", ",", "mesh"}], "]"}], "&"}], "/@", 
                    "markers"}], "]"}], "\[IndentingNewLine]", "]"}]}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"kg", ",", "r"}], "}"}], "=", 
                 RowBox[{"ImposeDirichletList", "[", 
                  RowBox[{"kg", ",", "r", ",", 
                   RowBox[{"{", 
                    RowBox[{"bcids", ",", "dir", ",", "val"}], "}"}]}], 
                  "]"}]}], ";"}], ",", 
               RowBox[{"{", 
                RowBox[{"bc", ",", "bcDirichlet"}], "}"}]}], "]"}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"If", "[", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{
                RowBox[{"Length", "[", "bcidsCtrl", "]"}], ">", "0"}], ",", 
               RowBox[{
                RowBox[{"dir", "=", 
                 RowBox[{"bcDirichletControlled", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"kg", ",", "r"}], "}"}], "=", 
                 RowBox[{"ImposeDirichletList", "[", 
                  RowBox[{"kg", ",", "r", ",", 
                   RowBox[{"{", 
                    RowBox[{"bcidsCtrl", ",", "dir", ",", "0"}], "}"}]}], 
                  "]"}]}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"(*", 
              RowBox[{"Guardar", " ", "res\[IAcute]duo", " ", "inicial"}], 
              "*)"}], "\[IndentingNewLine]", 
             RowBox[{"normr", "=", 
              RowBox[{"Norm", "[", "r", "]"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"normr0", "===", "None"}], ",", 
               RowBox[{"normr0", "=", "normr"}]}], "]"}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"(*", 
              RowBox[{
              "Res\[IAcute]duo", " ", "relativo", " ", "em", " ", "%", " ", 
               RowBox[{"(", 
                RowBox[{"como", " ", "o", " ", "livro"}], ")"}]}], "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{"relResidual", "=", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"normr0", ">", "0"}], ",", 
                RowBox[{"100", "*", 
                 RowBox[{"normr", "/", "normr0"}]}], ",", "0"}], "]"}]}], 
             ";"}], "\[IndentingNewLine]", 
            RowBox[{"(*", 
             RowBox[{
              RowBox[{"Print", "[", "\"\<Ap\[OAcute]s BC:\>\"", "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"Print", "[", 
               RowBox[{"\"\<  Max |kgMod| = \>\"", ",", 
                RowBox[{"Max", "[", 
                 RowBox[{"Abs", "[", "kg", "]"}], "]"}]}], "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"Print", "[", 
               RowBox[{"\"\<  kgMod diagonal min = \>\"", ",", 
                RowBox[{"Min", "[", 
                 RowBox[{"Diagonal", "[", "kg", "]"}], "]"}]}], "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"Print", "[", 
               RowBox[{"\"\<  \:2016r\:2016 = \>\"", ",", 
                RowBox[{"Norm", "[", "r", "]"}]}], "]"}], ";"}], "*)"}], ";", 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"\[Delta]u", "=", 
             RowBox[{"LinearSolve", "[", 
              RowBox[{"kg", ",", "r", ",", 
               RowBox[{"Method", "->", "\"\<Banded\>\""}]}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"displace", "+=", "\[Delta]u"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"norm\[Delta]u", "=", 
             RowBox[{"Norm", "[", "\[Delta]u", "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"kg", ",", "fint", ",", "fext"}], "}"}], "=", 
             RowBox[{"AssemblePlasticity", "[", 
              RowBox[{"mesh", ",", "displace"}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"(*", "Rea\[CCedilla]\[OTilde]es", "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"reactionX", "=", 
             RowBox[{"Total", "[", 
              RowBox[{"fint", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"dim", "*", 
                  RowBox[{"(", 
                   RowBox[{"nodesFixedX", "-", "1"}], ")"}]}], "+", "1"}], 
                "]"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"reactionYbase", "=", 
             RowBox[{"Total", "[", 
              RowBox[{"fint", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"dim", "*", 
                  RowBox[{"(", 
                   RowBox[{"nodesFixedY", "-", "1"}], ")"}]}], "+", "2"}], 
                "]"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"reactionYtop", "=", 
             RowBox[{"Total", "[", 
              RowBox[{"fint", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"dim", "*", 
                  RowBox[{"(", 
                   RowBox[{"nodesCtrlY", "-", "1"}], ")"}]}], "+", "2"}], 
                "]"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"Print", "[", 
             
             RowBox[{"\"\<  iter \>\"", ",", "counter", 
              ",", "\"\< | \:2016\[CapitalDelta]u\:2016 = \>\"", ",", 
              RowBox[{"ScientificForm", "[", 
               RowBox[{"norm\[Delta]u", ",", "3"}], "]"}], 
              ",", "\"\< | rel. res.(%) = \>\"", ",", 
              RowBox[{"NumberForm", "[", 
               RowBox[{"relResidual", ",", 
                RowBox[{"{", 
                 RowBox[{"6", ",", "4"}], "}"}]}], "]"}], 
              ",", "\"\< | \:2016r\:2016 = \>\"", ",", 
              RowBox[{"ScientificForm", "[", 
               RowBox[{"normr", ",", "3"}], "]"}], ",", 
              " ", "\"\< Abs[reactionYtop-reactionYbase] = \>\"", ",", " ", 
              RowBox[{
               RowBox[{"Abs", "[", "reactionYtop", "]"}], "-", 
               RowBox[{"Abs", "[", "reactionYbase", "]"}]}], 
              ",", "\"\< taxa = \>\"", ",", "taxa"}], "]"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"conv", "=", "normr"}], ";", "\[IndentingNewLine]", 
            RowBox[{"taxa", "=", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"counter", ">=", "4"}], ",", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"Log", "[", "conv", "]"}], "-", 
                  RowBox[{"Log", "[", "convOld", "]"}]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"Log", "[", "convOld", "]"}], "-", 
                  RowBox[{"Log", "[", "convOldOld", "]"}]}], ")"}]}], ",", 
               "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"convOldOld", "=", "convOld"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"convOld", "=", "conv"}], ";", "\[IndentingNewLine]", 
            RowBox[{"AppendTo", "[", 
             RowBox[{"convergencepostdatadisplacement", ",", 
              RowBox[{"{", 
               RowBox[{
               "kk", ",", "counter", ",", "normr", ",", "norm\[Delta]u", ",", 
                "reactionYbase", ",", "uTotal"}], "}"}]}], "]"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"(*", 
             RowBox[{
             "CRIT\[CapitalEAcute]RIO", " ", "DE", " ", 
              "CONVERG\[CapitalEHat]NCIA", " ", "DO", " ", 
              RowBox[{"LIVRO", ":", 
               RowBox[{"res\[IAcute]duo", " ", "relativo"}]}]}], "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"normr", "<", "tolRel"}], "||", 
               RowBox[{"norm\[Delta]u", "<", "tolMachine"}]}], ",", 
              RowBox[{"converged", "=", "True"}]}], "]"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"counter", "++"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
         ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"converged", ",", 
           RowBox[{
            RowBox[{"Print", "[", 
             RowBox[{"\"\<  \[Checkmark] Convergiu em \>\"", ",", 
              RowBox[{"counter", "-", "1"}], 
              ",", "\"\< itera\[CCedilla]\[OTilde]es\>\""}], "]"}], ";"}], ",", 
           RowBox[{
            RowBox[{
            "Print", 
             "[", "\"\<  \:26a0 M\[AAcute]ximo de itera\[CCedilla]\[OTilde]es\
\>\"", "]"}], ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Print", "[", 
          
          RowBox[{"\"\<  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y base: \>\"",
            ",", "reactionYbase"}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Print", "[", 
          
          RowBox[{"\"\<  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y topo: \>\"",
            ",", "reactionYtop"}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"epspsolitern", "=", "epspvec"}], ";", "\[IndentingNewLine]", 
         RowBox[{"AppendTo", "[", 
          RowBox[{"solsvec", ",", "displace"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"AppendTo", "[", 
          RowBox[{"epspsolsvec", ",", "epspsolitern"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"AppendTo", "[", 
          RowBox[{"plot", ",", 
           RowBox[{"{", 
            RowBox[{"uTotal", ",", "reactionYbase"}], "}"}]}], "]"}], ";"}]}],
        "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"plot", ",", "solsvec", ",", "epspsolsvec"}], "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.973598339619504*^9, 3.973598339619523*^9}, {
   3.973600119281186*^9, 3.973600119490862*^9}, {3.973600629299849*^9, 
   3.97360067486959*^9}, {3.973610592962384*^9, 3.973610613427456*^9}, {
   3.974790101658044*^9, 3.9747901018976927`*^9}, {3.974790939673778*^9, 
   3.974790991320138*^9}, {3.97479102243193*^9, 3.9747910697924547`*^9}, {
   3.9747911020858383`*^9, 3.974791103098731*^9}, {3.974791133897558*^9, 
   3.974791144897471*^9}, {3.974791574561371*^9, 3.974791645089224*^9}, {
   3.974791687485393*^9, 3.974791721057029*^9}, {3.974792486694064*^9, 
   3.974792535696109*^9}, 3.974793603989469*^9, {3.974793767136894*^9, 
   3.9747938067136707`*^9}, 3.974793860342003*^9, {3.974794421961678*^9, 
   3.974794433904869*^9}, {3.974798181534072*^9, 3.974798181750255*^9}, {
   3.97479822003726*^9, 3.974798264566629*^9}, {3.974798479380611*^9, 
   3.9747984839083853`*^9}},
 CellLabel->
  "In[832]:=",ExpressionUUID->"716af247-a266-4771-ba12-e416bafadf02"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"convergencepostdatadisplacement", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plot", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"solsvec", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"epspsolsvec", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"coords", "=", 
   RowBox[{"emesh", "[", "\"\<Coordinates\>\"", "]"}]}], ";"}], "\n", 
 RowBox[{"nodeId", "=", 
  RowBox[{
   RowBox[{"FirstPosition", "[", 
    RowBox[{"coords", ",", 
     RowBox[{"{", 
      RowBox[{"0.", ",", "5."}], "}"}]}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}], "\n", 
 RowBox[{"nodeId", "=", 
  RowBox[{
   RowBox[{"FirstPosition", "[", 
    RowBox[{"coords", ",", 
     RowBox[{"pt_", "/;", 
      RowBox[{
       RowBox[{"Norm", "[", 
        RowBox[{"pt", "-", 
         RowBox[{"{", 
          RowBox[{"0", ",", "5"}], "}"}]}], "]"}], "<", "1*^-6"}]}]}], "]"}], 
   "[", 
   RowBox[{"[", "1", "]"}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"nf", "=", 
   RowBox[{"Nearest", "[", 
    RowBox[{"coords", "->", "\"\<Index\>\""}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"nodeId", "=", 
   RowBox[{
    RowBox[{"nf", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5"}], "}"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], "\[IndentingNewLine]", "\n"}], "\n", 
 RowBox[{
  RowBox[{"idpostproc", "=", "nodeId"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dim", "=", "2"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", "1."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"tri", "=", "True"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"globalcounter", "=", "1"}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"young2", "=", 
   RowBox[{"10", "^", "7"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"nu2", "=", "0.48"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"substtotal", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"young2", ",", "nu2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"20", " ", 
         RowBox[{"Pi", "/", "180"}]}], ",", "490"}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"bodyforce", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"bcDirichlet", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "4"}], "}"}], ",", "1", ",", "0"}], "}"}], ",", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
         RowBox[{"Marker", " ", "1", " ", 
          RowBox[{"(", 
           RowBox[{"face", " ", "esquerda"}], ")"}]}], ":", "ux"}], "=", 
        "0"}], "*)"}], 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "1", "}"}], ",", "2", ",", "0"}], "}"}]}], "     ", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{
        RowBox[{"Marker", " ", "3", " ", 
         RowBox[{"(", 
          RowBox[{"face", " ", "inferior"}], ")"}]}], ":", "uy"}], "=", "0"}],
       "*)"}], "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Deslocamento", " ", 
    RowBox[{"controlado", ":", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "markers", "}"}], ",", "dire\[CCedilla]\[ATilde]o"}], 
      "}"}]}]}], "*)"}], "\n", 
  RowBox[{"(*", 
   RowBox[{
   "O", " ", "valor", " ", "ser\[AAcute]", " ", "dado", " ", "pelos", " ", 
    "dispSteps"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"bcDirichletControlled", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "5", "}"}], ",", "2"}], "}"}]}], ";"}], "  ", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Marker", " ", "5", " ", 
     RowBox[{"(", 
      RowBox[{"face", " ", "superior"}], ")"}]}], ":", 
    RowBox[{"uy", " ", "controlado"}]}], "*)"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"(*", "ANTES", "*)"}], 
  RowBox[{
   RowBox[{"dispSteps", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"-", "0.0001"}], ",", 
      RowBox[{"{", "20", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", "\n", 
  RowBox[{"(*", 
   RowBox[{"DEPOIS", "-", 
    RowBox[{
    "come\[CCedilla]ar", " ", "menor", " ", "e", " ", "aumentar", " ", 
     "gradualmente"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"dispSteps", "=", 
  RowBox[{"Join", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"-", "0.0002"}], ",", 
     RowBox[{"{", "10", "}"}]}], "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dispSteps", "=", 
   RowBox[{"-", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"plot2", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", "1"}], "]"}], "]"}], "[", 
         RowBox[{"[", 
          RowBox[{"i", "+", "1"}], "]"}], "]"}], "-", 
        RowBox[{
         RowBox[{"plot2", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", "1"}], "]"}], "]"}], "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ")"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{
         RowBox[{"Length", "[", 
          RowBox[{"plot2", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "1"}], "]"}], "]"}], "]"}], "-", "1"}]}], 
       "}"}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Total", "[", "dispSteps", "]"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"6.", " ", "RODAR", " ", "A", " ", "AN\[CapitalAAcute]LISE"}], 
   "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"plot3", ",", "solsvec", ",", "epspsolsvec"}], "}"}], "=", 
   RowBox[{"IterativeProcessDisplacementControl", "[", 
    RowBox[{
    "emesh", ",", "dispSteps", ",", "bcDirichlet", ",", 
     "bcDirichletControlled"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{
  3.973598778919738*^9, {3.973598907582891*^9, 3.973598908005995*^9}, 
   3.973598970799819*^9, 3.973599208643807*^9, {3.973599335572418*^9, 
   3.973599340580234*^9}, 3.973599681009453*^9, {3.9736003005091352`*^9, 
   3.973600382652451*^9}, {3.973600423478798*^9, 3.973600439021883*^9}, {
   3.9736105589978743`*^9, 3.973610559189046*^9}, {3.973610699376273*^9, 
   3.973610700426931*^9}, 3.973611152547791*^9, 3.9736124752442207`*^9, 
   3.973612525979974*^9, {3.973758664536849*^9, 3.973758681361908*^9}, 
   3.9737588821851892`*^9, {3.973776924486658*^9, 3.973776926521429*^9}, {
   3.9737773030851593`*^9, 3.9737773925692797`*^9}, {3.9737778619905453`*^9, 
   3.973777874029703*^9}, {3.974459501446425*^9, 3.9744595045344973`*^9}, {
   3.974459901953527*^9, 3.9744599096451797`*^9}, {3.9744604945776587`*^9, 
   3.9744605344085007`*^9}, {3.9744608411171427`*^9, 3.9744608455147657`*^9}, 
   3.974624249678358*^9, {3.974790125679476*^9, 3.974790235942944*^9}, {
   3.974790277791692*^9, 3.974790283122074*^9}, {3.974790995152343*^9, 
   3.974790996821073*^9}},
 CellLabel->
  "In[833]:=",ExpressionUUID->"ce91039c-d25c-4a82-9c77-6225fef2b30e"],

Cell[BoxData["28"], "Output",
 CellChangeTimes->{
  3.9744605356460447`*^9, 3.97446084668882*^9, 3.9746242516142263`*^9, 
   3.974790147384775*^9, {3.974790197821904*^9, 3.974790236392926*^9}, 
   3.974790284019532*^9, {3.97479108413892*^9, 3.974791105942534*^9}, 
   3.974791147147126*^9, 3.974791653005674*^9, {3.974791695905259*^9, 
   3.974791723422551*^9}, 3.974792542103054*^9, 3.974793565621849*^9, 
   3.9747938632060432`*^9, 3.974794440314888*^9, {3.974798242201682*^9, 
   3.9747982676749973`*^9}, 3.974798498033889*^9},
 CellLabel->
  "Out[838]=",ExpressionUUID->"65cb2e21-8045-47da-87d7-8ad9cc4b7d02"],

Cell[BoxData["28"], "Output",
 CellChangeTimes->{
  3.9744605356460447`*^9, 3.97446084668882*^9, 3.9746242516142263`*^9, 
   3.974790147384775*^9, {3.974790197821904*^9, 3.974790236392926*^9}, 
   3.974790284019532*^9, {3.97479108413892*^9, 3.974791105942534*^9}, 
   3.974791147147126*^9, 3.974791653005674*^9, {3.974791695905259*^9, 
   3.974791723422551*^9}, 3.974792542103054*^9, 3.974793565621849*^9, 
   3.9747938632060432`*^9, 3.974794440314888*^9, {3.974798242201682*^9, 
   3.9747982676749973`*^9}, 3.974798498034699*^9},
 CellLabel->
  "Out[839]=",ExpressionUUID->"0cb5e34c-b901-4302-beeb-a2a706865fb2"],

Cell[BoxData["28"], "Output",
 CellChangeTimes->{
  3.9744605356460447`*^9, 3.97446084668882*^9, 3.9746242516142263`*^9, 
   3.974790147384775*^9, {3.974790197821904*^9, 3.974790236392926*^9}, 
   3.974790284019532*^9, {3.97479108413892*^9, 3.974791105942534*^9}, 
   3.974791147147126*^9, 3.974791653005674*^9, {3.974791695905259*^9, 
   3.974791723422551*^9}, 3.974792542103054*^9, 3.974793565621849*^9, 
   3.9747938632060432`*^9, 3.974794440314888*^9, {3.974798242201682*^9, 
   3.9747982676749973`*^9}, 3.974798498035431*^9},
 CellLabel->
  "Out[841]=",ExpressionUUID->"3d517409-30d4-4c83-85e4-b2cb539935e4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.0002`"}], ",", 
   RowBox[{"-", "0.0002`"}], ",", 
   RowBox[{"-", "0.0002`"}], ",", 
   RowBox[{"-", "0.0002`"}], ",", 
   RowBox[{"-", "0.0002`"}], ",", 
   RowBox[{"-", "0.0002`"}], ",", 
   RowBox[{"-", "0.0002`"}], ",", 
   RowBox[{"-", "0.0002`"}], ",", 
   RowBox[{"-", "0.0002`"}], ",", 
   RowBox[{"-", "0.0002`"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9744605356460447`*^9, 3.97446084668882*^9, 3.9746242516142263`*^9, 
   3.974790147384775*^9, {3.974790197821904*^9, 3.974790236392926*^9}, 
   3.974790284019532*^9, {3.97479108413892*^9, 3.974791105942534*^9}, 
   3.974791147147126*^9, 3.974791653005674*^9, {3.974791695905259*^9, 
   3.974791723422551*^9}, 3.974792542103054*^9, 3.974793565621849*^9, 
   3.9747938632060432`*^9, 3.974794440314888*^9, {3.974798242201682*^9, 
   3.9747982676749973`*^9}, 3.974798498036283*^9},
 CellLabel->
  "Out[854]=",ExpressionUUID->"cf42b490-c244-4011-aa02-a12b6c909714"],

Cell[BoxData[
 RowBox[{"-", "0.0020703374009542626`"}]], "Output",
 CellChangeTimes->{
  3.9744605356460447`*^9, 3.97446084668882*^9, 3.9746242516142263`*^9, 
   3.974790147384775*^9, {3.974790197821904*^9, 3.974790236392926*^9}, 
   3.974790284019532*^9, {3.97479108413892*^9, 3.974791105942534*^9}, 
   3.974791147147126*^9, 3.974791653005674*^9, {3.974791695905259*^9, 
   3.974791723422551*^9}, 3.974792542103054*^9, 3.974793565621849*^9, 
   3.9747938632060432`*^9, 3.974794440314888*^9, {3.974798242201682*^9, 
   3.9747982676749973`*^9}, 3.974798498037097*^9},
 CellLabel->
  "Out[856]=",ExpressionUUID->"bc01a4ee-5b27-4c67-a733-4291dd764d1a"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"npts = \"\>", "\[InvisibleSpace]", "7"}],
  SequenceForm["npts = ", 7],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747984980378447`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"c91e76bf-6695-4a24-b4d3-89a987bd895a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"nElements = \"\>", "\[InvisibleSpace]", "291"}],
  SequenceForm["nElements = ", 291],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798498038513*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"0c8f66c9-a553-41c0-a541-e1751c386c3e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"nglobalpts esperado = \"\>", "\[InvisibleSpace]", "2037"}],
  SequenceForm["nglobalpts esperado = ", 2037],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747984980393143`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"41b21264-1c30-4a33-a656-1f6004c851ce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Length[epspvec] = \"\>", "\[InvisibleSpace]", "2037"}],
  SequenceForm["Length[epspvec] = ", 2037],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798498039825*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"60941cc6-ee6e-41be-b5ad-ea3eacb40715"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"IDs controlados: \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" n\[OAcute]s\"\>"}],
  SequenceForm["IDs controlados: ", 10, " n\[OAcute]s"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747984980403833`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"6a41856e-1f2c-471f-add2-c3c0e786b610"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N\[OAcute]s com ux fixo: \"\>", "\[InvisibleSpace]", "38"}],
  SequenceForm["N\[OAcute]s com ux fixo: ", 38],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798498040905*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"fe686d04-5ccc-4539-9a46-5fc5064af315"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N\[OAcute]s com uy fixo: \"\>", "\[InvisibleSpace]", "9"}],
  SequenceForm["N\[OAcute]s com uy fixo: ", 9],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747984980414553`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"741d0fc1-0ee4-4259-ae89-8d677aa8e7c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N\[OAcute]s controlados: \"\>", "\[InvisibleSpace]", "10"}],
  SequenceForm["N\[OAcute]s controlados: ", 10],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798498041998*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"d0cf7224-ebc8-42fa-b93a-af8775c8cfd1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"=== Step \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" | u_total = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.00029543480938711643`"}], 
   "\[InvisibleSpace]", "\<\" ===\"\>"}],
  SequenceForm[
  "=== Step ", 1, "/", 8, " | u_total = ", -0.00029543480938711643`, " ==="],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798498042529*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"568763f3-50cb-4820-85a3-0af2b9626996"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"4.56\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-3\"\>"]}],
      ShowStringCharacters->False],
     0.004558911481445991,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"100.0000\"\>",
      ShowStringCharacters->False],
     99.99999999999999,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.68\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"5\"\>"]}],
      ShowStringCharacters->False],
     167709.2457355717,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "953.9818782026089`"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["  iter ", 1, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.004558911481445991, 3], " | rel. res.(%) = ", 
   NumberForm[99.99999999999999, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[167709.2457355717, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -953.9818782026089, " taxa = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798500415663*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"c6d939e3-7624-47d4-b57c-7648891f6932"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"8.29\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-5\"\>"]}],
      ShowStringCharacters->False],
     0.00008289134969746122,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"1.4984\"\>",
      ShowStringCharacters->False],
     1.498356244999853,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"2.51\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"3\"\>"]}],
      ShowStringCharacters->False],
     2512.881956921088,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "525.0782727091766`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm["  iter ", 2, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.00008289134969746122, 3], " | rel. res.(%) = ", 
   NumberForm[1.498356244999853, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[2512.881956921088, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 525.0782727091766, " taxa = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747985020396233`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"2d80e590-091e-43f4-83c5-2d3ff3597748"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"9.67\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-5\"\>"]}],
      ShowStringCharacters->False],
     0.00009665992309884259,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.2552\"\>",
      ShowStringCharacters->False],
     0.25522618812244396`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"4.28\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"2\"\>"]}],
      ShowStringCharacters->False],
     428.037915019802,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "20.450036766651692`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm["  iter ", 3, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.00009665992309884259, 3], " | rel. res.(%) = ", 
   NumberForm[0.25522618812244396`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[428.037915019802, 3], " Abs[reactionYtop-reactionYbase] = ",
    20.450036766651692`, " taxa = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747985036873827`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"e29970d6-cc68-4b39-a7ea-4a1bcacff526"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"3.03\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-5\"\>"]}],
      ShowStringCharacters->False],
     0.000030332782328757678`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0624\"\>",
      ShowStringCharacters->False],
     0.062352268286312004`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.05\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"2\"\>"]}],
      ShowStringCharacters->False],
     104.57051884199394`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "5.091471642311262`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm["  iter ", 4, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.000030332782328757678`, 3], " | rel. res.(%) = ", 
   NumberForm[0.062352268286312004`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[104.57051884199394`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 5.091471642311262, " taxa = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747985053905907`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"e622e13d-415d-4876-946e-44921157a94c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"3.25\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-6\"\>"]}],
      ShowStringCharacters->False],
     3.2483586643286412`*^-6,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0119\"\>",
      ShowStringCharacters->False],
     0.011894718057805126`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.99\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"1\"\>"]}],
      ShowStringCharacters->False],
     19.94854193711782,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.001925907816939798`"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "0.7962547946055966`"}],
  SequenceForm["  iter ", 5, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[3.2483586643286412`*^-6, 3], " | rel. res.(%) = ", 
   NumberForm[0.011894718057805126`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[19.94854193711782, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -0.001925907816939798, " taxa = ", 
   0.7962547946055966],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798507137532*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"f8a8c102-7850-41bc-a80b-c4475e4afe61"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"5.23\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-8\"\>"]}],
      ShowStringCharacters->False],
     5.231465438417787*^-8,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0003\"\>",
      ShowStringCharacters->False],
     0.00025584180578048696`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"4.29\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-1\"\>"]}],
      ShowStringCharacters->False],
     0.42907036275072097`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "9.485484042670578`*^-8", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "1.1755103258721773`"}],
  SequenceForm["  iter ", 6, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[5.231465438417787*^-8, 3], " | rel. res.(%) = ", 
   NumberForm[0.00025584180578048696`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[0.42907036275072097`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 9.485484042670578*^-8, " taxa = ", 
   1.1755103258721773`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798508914405*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"dcfee7fb-6035-49f0-ad62-a44d2d05d216"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.6\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-9\"\>"]}],
      ShowStringCharacters->False],
     1.59882116134805*^-9,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0000\"\>",
      ShowStringCharacters->False],
     0.000022195973585488436`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"3.72\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-2\"\>"]}],
      ShowStringCharacters->False],
     0.037224699883889385`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "1.659827830735594`*^-11", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "2.3174246458303`"}],
  SequenceForm["  iter ", 7, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[1.59882116134805*^-9, 3], " | rel. res.(%) = ", 
   NumberForm[0.000022195973585488436`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[0.037224699883889385`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 1.659827830735594*^-11, " taxa = ", 
   2.3174246458303],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747985106643*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"bff76019-b8bd-468f-b91d-a583518fe561"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"2.7\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-14\"\>"]}],
      ShowStringCharacters->False],
     2.6985567612644582`*^-14,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"2.0187\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-10\"\>"]}],
      ShowStringCharacters->False],
     2.0187381652135499`*^-10,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"3.39\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-7\"\>"]}],
      ShowStringCharacters->False],
     3.3856105502557637`*^-7,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1.5006662579253316`*^-11"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "0.6367448518326182`"}],
  SequenceForm["  iter ", 8, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[2.6985567612644582`*^-14, 3], " | rel. res.(%) = ", 
   NumberForm[2.0187381652135499`*^-10, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[3.3856105502557637`*^-7, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -1.5006662579253316`*^-11, 
   " taxa = ", 0.6367448518326182],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747985123562737`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"88465d9f-ec88-4b3b-afcd-7b7365320978"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \[Checkmark] Convergiu em \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" itera\[CCedilla]\[OTilde]es\"\>"}],
  SequenceForm[
  "  \[Checkmark] Convergiu em ", 8, " itera\[CCedilla]\[OTilde]es"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798512358362*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"60e5d1ad-be0a-412b-8581-3989083f84f9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y base: \"\>", "\[InvisibleSpace]",
    "1517.3794310426415`"}],
  SequenceForm[
  "  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y base: ", 1517.3794310426415`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747985123594418`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"f5ddc1b1-3d6f-494d-8d92-cd889f233c62"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y topo: \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1517.3794310426265`"}]}],
  SequenceForm[
  "  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y topo: ", -1517.3794310426265`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747985123603153`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"09173ffe-c215-4ef9-bad9-ce2baf94e7d2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"=== Step \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" | u_total = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.0006146962727383243`"}], 
   "\[InvisibleSpace]", "\<\" ===\"\>"}],
  SequenceForm[
  "=== Step ", 2, "/", 8, " | u_total = ", -0.0006146962727383243, " ==="],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798512361228*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"7ebd62ba-458c-463f-a3a8-6f3409f290e2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"4.89\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-3\"\>"]}],
      ShowStringCharacters->False],
     0.004885464857317879,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"100.0000\"\>",
      ShowStringCharacters->False],
     100.,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.82\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"5\"\>"]}],
      ShowStringCharacters->False],
     181503.70058680532`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1403.923656069823`"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "4.748240526364991`"}],
  SequenceForm["  iter ", 1, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.004885464857317879, 3], " | rel. res.(%) = ", 
   NumberForm[100., {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[181503.70058680532`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -1403.923656069823, " taxa = ", 
   4.748240526364991],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798516075602*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"135bd5b3-a171-4ec7-9fd3-f42195e27a4d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.33\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-3\"\>"]}],
      ShowStringCharacters->False],
     0.001331360932127094,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"2.1516\"\>",
      ShowStringCharacters->False],
     2.15164039606883,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"3.91\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"3\"\>"]}],
      ShowStringCharacters->False],
     3905.3069421855216`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "822.4754201278615`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm["  iter ", 2, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.001331360932127094, 3], " | rel. res.(%) = ", 
   NumberForm[2.15164039606883, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[3905.3069421855216`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 822.4754201278615, " taxa = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798518728784*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"fe566e7f-c719-4adf-9706-a1639cc35892"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"4.82\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-4\"\>"]}],
      ShowStringCharacters->False],
     0.00048227001736421144`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.7068\"\>",
      ShowStringCharacters->False],
     0.706774007027076,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.28\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"3\"\>"]}],
      ShowStringCharacters->False],
     1282.8209775397906`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "117.35862910579954`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm["  iter ", 3, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.00048227001736421144`, 3], " | rel. res.(%) = ", 
   NumberForm[0.706774007027076, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[1282.8209775397906`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 117.35862910579954`, " taxa = ", 0],
  
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747985213772717`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"b51d2ce3-d852-4b21-a8b2-6fd7e00e74f0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.53\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-4\"\>"]}],
      ShowStringCharacters->False],
     0.00015325502992690742`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.2425\"\>",
      ShowStringCharacters->False],
     0.2424753826639045,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"4.4\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"2\"\>"]}],
      ShowStringCharacters->False],
     440.1017925470037,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "18.51997508528666`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm["  iter ", 4, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.00015325502992690742`, 3], " | rel. res.(%) = ", 
   NumberForm[0.2424753826639045, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[440.1017925470037, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 18.51997508528666, " taxa = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798524096086*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"97c5fc36-666f-4631-a064-d219b6162ded"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"8.53\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-5\"\>"]}],
      ShowStringCharacters->False],
     0.00008529839228401496,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0958\"\>",
      ShowStringCharacters->False],
     0.09581785196787036,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.74\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"2\"\>"]}],
      ShowStringCharacters->False],
     173.9129471444718,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "1.5168597506853985`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0.9609583675472552`"}],
  SequenceForm["  iter ", 5, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.00008529839228401496, 3], " | rel. res.(%) = ", 
   NumberForm[0.09581785196787036, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[173.9129471444718, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 1.5168597506853985`, " taxa = ", 
   0.9609583675472552],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798526896933*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"3a4f800c-a034-4bb0-a97e-a57d8c2cd335"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"2.29\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-5\"\>"]}],
      ShowStringCharacters->False],
     0.000022894724000238598`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.1066\"\>",
      ShowStringCharacters->False],
     0.106602838197539,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.93\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"2\"\>"]}],
      ShowStringCharacters->False],
     193.48809625909772`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "0.07499106830346136`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0.8678648592541033`"}],
  SequenceForm["  iter ", 6, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.000022894724000238598`, 3], " | rel. res.(%) = ", 
   NumberForm[0.106602838197539, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[193.48809625909772`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 0.07499106830346136, " taxa = ", 
   0.8678648592541033],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798529760639*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"5c9ed30c-a1c5-4a64-b810-288bce0c29c1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"7.44\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-6\"\>"]}],
      ShowStringCharacters->False],
     7.4416174963207*^-6,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0104\"\>",
      ShowStringCharacters->False],
     0.010361357513616437`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.88\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"1\"\>"]}],
      ShowStringCharacters->False],
     18.806247318242836`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.00035858338969774195`"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.11488070129205175`"}]}],
  SequenceForm["  iter ", 7, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[7.4416174963207*^-6, 3], " | rel. res.(%) = ", 
   NumberForm[0.010361357513616437`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[18.806247318242836`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -0.00035858338969774195`, 
   " taxa = ", -0.11488070129205175`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798532567099*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"965bc0a1-4195-4e3e-8b31-688425f37339"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"8.76\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-7\"\>"]}],
      ShowStringCharacters->False],
     8.755305377047496*^-7,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0009\"\>",
      ShowStringCharacters->False],
     0.0009094669655956341,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"1.65\"\>",
      ShowStringCharacters->False],
     1.6507161981706036`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "0.00005088148236609413`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "21.85451290817543`"}]}],
  SequenceForm["  iter ", 8, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[8.755305377047496*^-7, 3], " | rel. res.(%) = ", 
   NumberForm[0.0009094669655956341, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[1.6507161981706036`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 0.00005088148236609413, 
   " taxa = ", -21.85451290817543],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798535354952*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"a3f78fea-cbd0-4f60-96fe-05c5528b8dfc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.96\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-8\"\>"]}],
      ShowStringCharacters->False],
     1.9587676824561867`*^-8,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0000\"\>",
      ShowStringCharacters->False],
     0.00002094964761815193,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"3.8\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-2\"\>"]}],
      ShowStringCharacters->False],
     0.03802438568684127,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "3.533386916387826`*^-9"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "1.043737372988931`"}],
  SequenceForm["  iter ", 9, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[1.9587676824561867`*^-8, 3], " | rel. res.(%) = ", 
   NumberForm[0.00002094964761815193, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[0.03802438568684127, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -3.533386916387826*^-9, " taxa = ", 
   1.043737372988931],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798538157427*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"3c6c7420-7e65-4712-aac5-099927e48161"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.49\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-11\"\>"]}],
      ShowStringCharacters->False],
     1.4901561375736713`*^-11,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.5171\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-8\"\>"]}],
      ShowStringCharacters->False],
     1.5171143722521863`*^-8,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"2.75\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-5\"\>"]}],
      ShowStringCharacters->False],
     0.00002753618727771999,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "9.094947017729282`*^-13"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "1.549843014764947`"}],
  SequenceForm["  iter ", 10, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[1.4901561375736713`*^-11, 3], " | rel. res.(%) = ", 
   NumberForm[1.5171143722521863`*^-8, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[0.00002753618727771999, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -9.094947017729282*^-13, " taxa = ",
    1.549843014764947],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747985409313517`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"c87d46e9-d4c6-4004-9475-041cff257df9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.05\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-17\"\>"]}],
      ShowStringCharacters->False],
     1.0484810175787408`*^-17,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"6.9862\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-14\"\>"]}],
      ShowStringCharacters->False],
     6.986212722064136*^-14,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.27\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-10\"\>"]}],
      ShowStringCharacters->False],
     1.2680234621412593`*^-10,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "4.547473508864641`*^-12"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "1.9175249318734173`"}],
  SequenceForm["  iter ", 11, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[1.0484810175787408`*^-17, 3], " | rel. res.(%) = ", 
   NumberForm[6.986212722064136*^-14, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[1.2680234621412593`*^-10, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -4.547473508864641*^-12, " taxa = ",
    1.9175249318734173`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798543705285*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"c50f9f24-509c-4935-b9f0-b3e78d93f8b0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \[Checkmark] Convergiu em \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" itera\[CCedilla]\[OTilde]es\"\>"}],
  SequenceForm[
  "  \[Checkmark] Convergiu em ", 11, " itera\[CCedilla]\[OTilde]es"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798543706358*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"46569b5c-7779-4193-af41-a8dc97847e1e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y base: \"\>", "\[InvisibleSpace]",
    "2460.9658203360596`"}],
  SequenceForm[
  "  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y base: ", 2460.9658203360596`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798543707017*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"9f37316f-a508-4063-8fb6-4868a1c7ffc4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y topo: \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "2460.965820336055`"}]}],
  SequenceForm[
  "  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y topo: ", -2460.965820336055],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798543707633*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"c9916546-234f-4ee8-8163-e97f3de39e23"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"=== Step \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" | u_total = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.0009245446212503409`"}], 
   "\[InvisibleSpace]", "\<\" ===\"\>"}],
  SequenceForm[
  "=== Step ", 3, "/", 8, " | u_total = ", -0.0009245446212503409, " ==="],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747985437082043`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"d81a99aa-c47b-4106-bb91-068f9b84387d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"4.74\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-3\"\>"]}],
      ShowStringCharacters->False],
     0.004744860139684554,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"100.0000\"\>",
      ShowStringCharacters->False],
     99.99999999999999,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.76\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"5\"\>"]}],
      ShowStringCharacters->False],
     176337.2267208239,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1592.7755858841176`"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "1.69952462201389`"}],
  SequenceForm["  iter ", 1, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.004744860139684554, 3], " | rel. res.(%) = ", 
   NumberForm[99.99999999999999, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[176337.2267208239, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -1592.7755858841176`, " taxa = ", 
   1.69952462201389],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798547699752*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"f16e61de-0e12-46c9-9ab5-536aec943743"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.64\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-3\"\>"]}],
      ShowStringCharacters->False],
     0.0016383234155730368`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"2.6676\"\>",
      ShowStringCharacters->False],
     2.667615577457292,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"4.7\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"3\"\>"]}],
      ShowStringCharacters->False],
     4703.999328860881,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "481.7505967528723`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm["  iter ", 2, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.0016383234155730368`, 3], " | rel. res.(%) = ", 
   NumberForm[2.667615577457292, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[4703.999328860881, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 481.7505967528723, " taxa = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798550782508*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"d7138de3-cae4-4d0e-b07c-2d329a7ac096"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"6.8\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-4\"\>"]}],
      ShowStringCharacters->False],
     0.0006801353911765396,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.8077\"\>",
      ShowStringCharacters->False],
     0.8076997831848485,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.42\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"3\"\>"]}],
      ShowStringCharacters->False],
     1424.2753978982694`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "186.32292486214328`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm["  iter ", 3, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.0006801353911765396, 3], " | rel. res.(%) = ", 
   NumberForm[0.8076997831848485, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[1424.2753978982694`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 186.32292486214328`, " taxa = ", 0],
  
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747985539298067`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"ee35887c-aa2e-433f-a370-bef2650c0e53"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"2.99\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-4\"\>"]}],
      ShowStringCharacters->False],
     0.00029861324121027043`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.1700\"\>",
      ShowStringCharacters->False],
     0.16999984726602235`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"3.\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"2\"\>"]}],
      ShowStringCharacters->False],
     299.7730160985402,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "75.37886927161844`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm["  iter ", 4, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.00029861324121027043`, 3], " | rel. res.(%) = ", 
   NumberForm[0.16999984726602235`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[299.7730160985402, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 75.37886927161844, " taxa = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798557132518*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"16facacc-c05b-409c-a7fc-50b15e80cfae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.95\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-4\"\>"]}],
      ShowStringCharacters->False],
     0.0001948222287603291,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0974\"\>",
      ShowStringCharacters->False],
     0.09736571984147205,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.72\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"2\"\>"]}],
      ShowStringCharacters->False],
     171.6920101452188,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "3.6588607592134395`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "1.3043674884610132`"}],
  SequenceForm["  iter ", 5, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.0001948222287603291, 3], " | rel. res.(%) = ", 
   NumberForm[0.09736571984147205, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[171.6920101452188, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 3.6588607592134395`, " taxa = ", 
   1.3043674884610132`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798560341443*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"c4d2f335-a222-4096-8816-9dd8542b1b1b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"9.88\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-5\"\>"]}],
      ShowStringCharacters->False],
     0.00009879098206327985,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0731\"\>",
      ShowStringCharacters->False],
     0.0730705536081756,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.29\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"2\"\>"]}],
      ShowStringCharacters->False],
     128.8505877822098,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "1.7530349776197909`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0.35762697834926976`"}],
  SequenceForm["  iter ", 6, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.00009879098206327985, 3], " | rel. res.(%) = ", 
   NumberForm[0.0730705536081756, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[128.8505877822098, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 1.7530349776197909`, " taxa = ", 
   0.35762697834926976`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747985635741167`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"73eb9167-f44c-42fe-937a-0be454d8134f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"5.58\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-5\"\>"]}],
      ShowStringCharacters->False],
     0.00005583799590564511,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0282\"\>",
      ShowStringCharacters->False],
     0.028186599177380242`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"4.97\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"1\"\>"]}],
      ShowStringCharacters->False],
     49.70346729630689,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "0.13501589462748598`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0.5150488278568385`"}],
  SequenceForm["  iter ", 7, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.00005583799590564511, 3], " | rel. res.(%) = ", 
   NumberForm[0.028186599177380242`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[49.70346729630689, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 0.13501589462748598`, " taxa = ", 
   0.5150488278568385],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798566735262*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"a06561ea-9454-48f4-8182-e9b2e0702cd6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"2.46\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-5\"\>"]}],
      ShowStringCharacters->False],
     0.000024550412103529247`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0130\"\>",
      ShowStringCharacters->False],
     0.012966677863427247`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"2.29\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"1\"\>"]}],
      ShowStringCharacters->False],
     22.865080142190592`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "0.019793397632383858`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "3.318526404296739`"}],
  SequenceForm["  iter ", 8, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.000024550412103529247`, 3], " | rel. res.(%) = ", 
   NumberForm[0.012966677863427247`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[22.865080142190592`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 0.019793397632383858`, " taxa = ", 
   3.318526404296739],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798569939004*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"f44ca43a-7504-4e5a-b186-c85d6e973924"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"2.66\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-6\"\>"]}],
      ShowStringCharacters->False],
     2.6575874518739107`*^-6,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0032\"\>",
      ShowStringCharacters->False],
     0.0031623713171922752`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"5.58\"\>",
      ShowStringCharacters->False],
     5.576437879351648,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "0.00009980859294955735`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0.8151176890333812`"}],
  SequenceForm["  iter ", 9, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[2.6575874518739107`*^-6, 3], " | rel. res.(%) = ", 
   NumberForm[0.0031623713171922752`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[5.576437879351648, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 0.00009980859294955735, " taxa = ", 
   0.8151176890333812],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747985731379833`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"8fa0f74d-d046-48a6-b0f9-bf0ca71b6a95"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"4.13\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-8\"\>"]}],
      ShowStringCharacters->False],
     4.129965208778993*^-8,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0000\"\>",
      ShowStringCharacters->False],
     0.00003478766737368889,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"6.13\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-2\"\>"]}],
      ShowStringCharacters->False],
     0.06134360788762787,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "7.121343514882028`*^-10", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "1.8172909057257125`"}],
  SequenceForm["  iter ", 10, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[4.129965208778993*^-8, 3], " | rel. res.(%) = ", 
   NumberForm[0.00003478766737368889, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[0.06134360788762787, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 7.121343514882028*^-10, " taxa = ", 
   1.8172909057257125`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798576347185*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"b7389549-0fbf-4efd-b577-85561e06ab00"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"4.\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-11\"\>"]}],
      ShowStringCharacters->False],
     4.004416056136584*^-11,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"5.9578\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-8\"\>"]}],
      ShowStringCharacters->False],
     5.95778412249426*^-8,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.05\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-4\"\>"]}],
      ShowStringCharacters->False],
     0.00010505791295619954`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "2.955857780762017`*^-11"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "3.1960458000481546`"}],
  SequenceForm["  iter ", 11, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[4.004416056136584*^-11, 3], " | rel. res.(%) = ", 
   NumberForm[5.95778412249426*^-8, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[0.00010505791295619954`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -2.955857780762017*^-11, " taxa = ",
    3.1960458000481546`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747985795535307`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"8baabfd1-dec9-4492-8d48-d9775ed0d7e2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"8.55\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-17\"\>"]}],
      ShowStringCharacters->False],
     8.553637971454439*^-17,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.6760\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-13\"\>"]}],
      ShowStringCharacters->False],
     1.6760137339525146`*^-13,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"2.96\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-10\"\>"]}],
      ShowStringCharacters->False],
     2.955436137911992*^-10,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "1.9099388737231493`*^-11", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "1.4124160757192026`"}],
  SequenceForm["  iter ", 12, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[8.553637971454439*^-17, 3], " | rel. res.(%) = ", 
   NumberForm[1.6760137339525146`*^-13, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[2.955436137911992*^-10, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 1.9099388737231493`*^-11, 
   " taxa = ", 1.4124160757192026`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798582782155*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"0e578762-7559-4d02-9eed-c58992393e43"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \[Checkmark] Convergiu em \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" itera\[CCedilla]\[OTilde]es\"\>"}],
  SequenceForm[
  "  \[Checkmark] Convergiu em ", 12, " itera\[CCedilla]\[OTilde]es"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798582783214*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"c6db689c-31b6-4fc7-9be5-c59f6f3a6a6f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y base: \"\>", "\[InvisibleSpace]",
    "3049.204643455404`"}],
  SequenceForm[
  "  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y base: ", 3049.204643455404],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798582783758*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"1d57b183-653e-46b9-bdc7-a32dc1cf845c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y topo: \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "3049.204643455423`"}]}],
  SequenceForm[
  "  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y topo: ", -3049.204643455423],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798582784356*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"bce48e7e-10e5-4400-8d4f-1cda4fe62add"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"=== Step \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" | u_total = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.0012050175275299731`"}], 
   "\[InvisibleSpace]", "\<\" ===\"\>"}],
  SequenceForm[
  "=== Step ", 4, "/", 8, " | u_total = ", -0.0012050175275299731`, " ==="],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798582784895*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"4e4415b2-ee8e-491d-baec-eea783af38e8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"4.28\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-3\"\>"]}],
      ShowStringCharacters->False],
     0.004277146572285612,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"100.0000\"\>",
      ShowStringCharacters->False],
     100.,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.6\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"5\"\>"]}],
      ShowStringCharacters->False],
     159795.64543743065`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1710.3096820146966`"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "2.0065523737919735`"}],
  SequenceForm["  iter ", 1, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.004277146572285612, 3], " | rel. res.(%) = ", 
   NumberForm[100., {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[159795.64543743065`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -1710.3096820146966`, " taxa = ", 
   2.0065523737919735`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798587006714*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"d17edff2-964c-4389-90c5-5500fcfc8c0a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.57\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-3\"\>"]}],
      ShowStringCharacters->False],
     0.0015696249222267808`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"3.2518\"\>",
      ShowStringCharacters->False],
     3.2517765555311122`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"5.2\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"3\"\>"]}],
      ShowStringCharacters->False],
     5196.197335093991,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "746.1452201347302`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm["  iter ", 2, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.0015696249222267808`, 3], " | rel. res.(%) = ", 
   NumberForm[3.2517765555311122`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[5196.197335093991, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 746.1452201347302, " taxa = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747985902667103`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"dbd4959d-6b82-4962-80fa-a98887ecfe5c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"7.72\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-4\"\>"]}],
      ShowStringCharacters->False],
     0.0007722788449057335,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"1.1907\"\>",
      ShowStringCharacters->False],
     1.190670935186631,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.9\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"3\"\>"]}],
      ShowStringCharacters->False],
     1902.6403059173683`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "179.6834196820496`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm["  iter ", 3, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.0007722788449057335, 3], " | rel. res.(%) = ", 
   NumberForm[1.190670935186631, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[1902.6403059173683`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 179.6834196820496, " taxa = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798593668882*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"81e1dbd8-915c-416a-bfed-31a4acfd176f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"3.82\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-4\"\>"]}],
      ShowStringCharacters->False],
     0.00038238616222315556`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.1902\"\>",
      ShowStringCharacters->False],
     0.19018101946560573`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"3.04\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"2\"\>"]}],
      ShowStringCharacters->False],
     303.9009875545503,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "164.1604707584729`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm["  iter ", 4, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.00038238616222315556`, 3], " | rel. res.(%) = ", 
   NumberForm[0.19018101946560573`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[303.9009875545503, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 164.1604707584729, " taxa = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798597164135*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"b386f1ab-b125-4fe4-91f0-02bad2d71900"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"3.06\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-4\"\>"]}],
      ShowStringCharacters->False],
     0.00030626822037721436`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.1442\"\>",
      ShowStringCharacters->False],
     0.14423580442111636`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"2.3\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"2\"\>"]}],
      ShowStringCharacters->False],
     230.48253462659298`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "4.256007295033669`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "1.8257431550961347`"}],
  SequenceForm["  iter ", 5, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.00030626822037721436`, 3], " | rel. res.(%) = ", 
   NumberForm[0.14423580442111636`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[230.48253462659298`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 4.256007295033669, " taxa = ", 
   1.8257431550961347`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798600613171*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"c6097812-ca7b-40a7-8726-9c5fb2b4973a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.5\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-4\"\>"]}],
      ShowStringCharacters->False],
     0.00015022635972704326`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.1234\"\>",
      ShowStringCharacters->False],
     0.12341329441238329`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.97\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"2\"\>"]}],
      ShowStringCharacters->False],
     197.2090703618644,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "4.374093154118327`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0.15075368363380628`"}],
  SequenceForm["  iter ", 6, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.00015022635972704326`, 3], " | rel. res.(%) = ", 
   NumberForm[0.12341329441238329`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[197.2090703618644, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 4.374093154118327, " taxa = ", 
   0.15075368363380628`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798604073748*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"51648863-993b-44e5-bb57-2eda342d2704"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"8.39\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-5\"\>"]}],
      ShowStringCharacters->False],
     0.00008385232527527341,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0752\"\>",
      ShowStringCharacters->False],
     0.07523990684467127,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.2\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"2\"\>"]}],
      ShowStringCharacters->False],
     120.23009476896401`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "3.5737639184289947`"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "0.5638173814124547`"}],
  SequenceForm["  iter ", 7, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.00008385232527527341, 3], " | rel. res.(%) = ", 
   NumberForm[0.07523990684467127, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[120.23009476896401`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -3.5737639184289947`, " taxa = ", 
   0.5638173814124547],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747986075451107`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"49bc7123-9887-4b8a-8c7b-6710f7b285a4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.68\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-5\"\>"]}],
      ShowStringCharacters->False],
     0.000016792598675693714`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0416\"\>",
      ShowStringCharacters->False],
     0.04163835259918417,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"6.65\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"1\"\>"]}],
      ShowStringCharacters->False],
     66.53627428537952,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "0.16231719534061995`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "3.1739786243291896`"}],
  SequenceForm["  iter ", 8, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.000016792598675693714`, 3], " | rel. res.(%) = ", 
   NumberForm[0.04163835259918417, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[66.53627428537952, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 0.16231719534061995`, " taxa = ", 
   3.1739786243291896`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747986110616617`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"b7265a06-d3bb-4268-8c3d-0febe6cd22c7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"2.4\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-6\"\>"]}],
      ShowStringCharacters->False],
     2.4018298345848195`*^-6,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0471\"\>",
      ShowStringCharacters->False],
     0.0470585632237551,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"7.52\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"1\"\>"]}],
      ShowStringCharacters->False],
     75.19753483698084,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "0.0004285917693778174`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "1.1956181245272999`"}],
  SequenceForm["  iter ", 9, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[2.4018298345848195`*^-6, 3], " | rel. res.(%) = ", 
   NumberForm[0.0470585632237551, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[75.19753483698084, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 0.0004285917693778174, " taxa = ", 
   1.1956181245272999`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747986145198517`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"78f468ce-7c58-4212-ad41-26e64cb1fc25"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.89\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-6\"\>"]}],
      ShowStringCharacters->False],
     1.8921662437954932`*^-6,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0108\"\>",
      ShowStringCharacters->False],
     0.010776400202545467`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.72\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"1\"\>"]}],
      ShowStringCharacters->False],
     17.22021825857811,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "0.00007515973220506567`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.20682681646224643`"}]}],
  SequenceForm["  iter ", 10, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[1.8921662437954932`*^-6, 3], " | rel. res.(%) = ", 
   NumberForm[0.010776400202545467`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[17.22021825857811, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 0.00007515973220506567, 
   " taxa = ", -0.20682681646224643`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747986179595833`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"7bc11ed3-25b2-4c00-9533-b9bae72877ce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"5.85\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-8\"\>"]}],
      ShowStringCharacters->False],
     5.8515578233785915`*^-8,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0001\"\>",
      ShowStringCharacters->False],
     0.00008100943488678955,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.29\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-1\"\>"]}],
      ShowStringCharacters->False],
     0.12944954934256048`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "6.401478458428755`*^-9", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "12.045600694542394`"}]}],
  SequenceForm["  iter ", 11, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[5.8515578233785915`*^-8, 3], " | rel. res.(%) = ", 
   NumberForm[0.00008100943488678955, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[0.12944954934256048`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 6.401478458428755*^-9, 
   " taxa = ", -12.045600694542394`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798621510933*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"87d5d5bc-04d7-4ce0-8c36-29fab7f1ebc9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"2.58\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-11\"\>"]}],
      ShowStringCharacters->False],
     2.5764455656424155`*^-11,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"3.8850\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-8\"\>"]}],
      ShowStringCharacters->False],
     3.885046679732283*^-8,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"6.21\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-5\"\>"]}],
      ShowStringCharacters->False],
     0.00006208135417423671,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "2.4101609596982598`*^-11"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "3.3177981743658704`"}],
  SequenceForm["  iter ", 12, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[2.5764455656424155`*^-11, 3], " | rel. res.(%) = ", 
   NumberForm[3.885046679732283*^-8, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[0.00006208135417423671, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -2.4101609596982598`*^-11, 
   " taxa = ", 3.3177981743658704`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798625042358*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"7da9f298-0a39-4b60-b55d-a350ab556bbc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"7.65\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-18\"\>"]}],
      ShowStringCharacters->False],
     7.645692160773757*^-18,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.5017\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-13\"\>"]}],
      ShowStringCharacters->False],
     1.5017232829014164`*^-13,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"2.4\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-10\"\>"]}],
      ShowStringCharacters->False],
     2.399688412596491*^-10,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "4.5929482439532876`*^-11", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "1.5627288514353523`"}],
  SequenceForm["  iter ", 13, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[7.645692160773757*^-18, 3], " | rel. res.(%) = ", 
   NumberForm[1.5017232829014164`*^-13, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[2.399688412596491*^-10, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 4.5929482439532876`*^-11, 
   " taxa = ", 1.5627288514353523`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747986285802717`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"f508182d-9f5f-42d7-bc85-1afd8e150662"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \[Checkmark] Convergiu em \"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\" itera\[CCedilla]\[OTilde]es\"\>"}],
  SequenceForm[
  "  \[Checkmark] Convergiu em ", 13, " itera\[CCedilla]\[OTilde]es"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798628581414*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"f7893f23-d794-4e08-be68-e86ab5688618"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y base: \"\>", "\[InvisibleSpace]",
    "3420.9672097434886`"}],
  SequenceForm[
  "  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y base: ", 3420.9672097434886`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747986285819883`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"05f5ac42-923c-4800-9b2c-b036f103354e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y topo: \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "3420.9672097435346`"}]}],
  SequenceForm[
  "  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y topo: ", -3420.9672097435346`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798628582562*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"4828370d-cfd3-4756-a253-f25152026948"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"=== Step \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" | u_total = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.0014408502726306804`"}], 
   "\[InvisibleSpace]", "\<\" ===\"\>"}],
  SequenceForm[
  "=== Step ", 5, "/", 8, " | u_total = ", -0.0014408502726306804`, " ==="],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798628583144*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"4bf96391-518c-497d-8d77-a18b85814033"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"3.56\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-3\"\>"]}],
      ShowStringCharacters->False],
     0.003564432968462306,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"100.0000\"\>",
      ShowStringCharacters->False],
     100.,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.35\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"5\"\>"]}],
      ShowStringCharacters->False],
     134553.9382775015,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1722.2651596593955`"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "1.6307860978356608`"}],
  SequenceForm["  iter ", 1, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.003564432968462306, 3], " | rel. res.(%) = ", 
   NumberForm[100., {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[134553.9382775015, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -1722.2651596593955`, " taxa = ", 
   1.6307860978356608`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798632870908*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"8c23c08e-cc54-47c9-aa6a-22f4dd52d380"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.33\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-3\"\>"]}],
      ShowStringCharacters->False],
     0.0013334089822545437`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"4.0093\"\>",
      ShowStringCharacters->False],
     4.0092564619420425`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"5.39\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"3\"\>"]}],
      ShowStringCharacters->False],
     5394.612465188236,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "819.2947561379847`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm["  iter ", 2, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.0013334089822545437`, 3], " | rel. res.(%) = ", 
   NumberForm[4.0092564619420425`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[5394.612465188236, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 819.2947561379847, " taxa = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798636345208*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"4c840350-5fac-4563-8807-8aa720c9dcc3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"8.03\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-4\"\>"]}],
      ShowStringCharacters->False],
     0.0008027845571762587,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.9043\"\>",
      ShowStringCharacters->False],
     0.9042834380117734,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.22\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"3\"\>"]}],
      ShowStringCharacters->False],
     1216.74897903603,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "182.17735048052418`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm["  iter ", 3, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.0008027845571762587, 3], " | rel. res.(%) = ", 
   NumberForm[0.9042834380117734, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[1216.74897903603, 3], " Abs[reactionYtop-reactionYbase] = ",
    182.17735048052418`, " taxa = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798639985817*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"43e79ef9-8676-4cc8-aa62-d77c11d7c528"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"4.71\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-4\"\>"]}],
      ShowStringCharacters->False],
     0.00047123526528210837`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.1983\"\>",
      ShowStringCharacters->False],
     0.19825803498427821`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"2.67\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"2\"\>"]}],
      ShowStringCharacters->False],
     266.76399402293305`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "103.73658067022416`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm["  iter ", 4, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.00047123526528210837`, 3], " | rel. res.(%) = ", 
   NumberForm[0.19825803498427821`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[266.76399402293305`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 103.73658067022416`, " taxa = ", 0],
  
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.97479864369409*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"d99a9e71-07a3-49ae-8f52-1f34566c57d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"2.88\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-4\"\>"]}],
      ShowStringCharacters->False],
     0.00028839833860684166`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.1572\"\>",
      ShowStringCharacters->False],
     0.15715017930076342`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"2.11\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"2\"\>"]}],
      ShowStringCharacters->False],
     211.45175525933212`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "6.553452503550943`"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "1.019040343260794`"}],
  SequenceForm["  iter ", 5, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.00028839833860684166`, 3], " | rel. res.(%) = ", 
   NumberForm[0.15715017930076342`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[211.45175525933212`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -6.553452503550943, " taxa = ", 
   1.019040343260794],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747986473810673`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"e344a234-e418-4193-bd8a-a5defedd04f2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.53\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-4\"\>"]}],
      ShowStringCharacters->False],
     0.00015322440643280753`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.1432\"\>",
      ShowStringCharacters->False],
     0.14320536054429914`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.93\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"2\"\>"]}],
      ShowStringCharacters->False],
     192.68845243684973`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "7.365581977149304`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0.15311778390630626`"}],
  SequenceForm["  iter ", 6, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.00015322440643280753`, 3], " | rel. res.(%) = ", 
   NumberForm[0.14320536054429914`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[192.68845243684973`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 7.365581977149304, " taxa = ", 
   0.15311778390630626`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798651132537*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"56ac18b3-30b5-473e-bec0-52ffbee95d42"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"4.89\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-5\"\>"]}],
      ShowStringCharacters->False],
     0.00004886528781235879,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0739\"\>",
      ShowStringCharacters->False],
     0.07393259891026582,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"9.95\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"1\"\>"]}],
      ShowStringCharacters->False],
     99.47922350467181,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "0.6637309537127294`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0.39989336881773335`"}],
  SequenceForm["  iter ", 7, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.00004886528781235879, 3], " | rel. res.(%) = ", 
   NumberForm[0.07393259891026582, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[99.47922350467181, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 0.6637309537127294, " taxa = ", 
   0.39989336881773335`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798654891078*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"67b8d6b0-1aad-4f5d-aab3-cb0f6420ca21"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.06\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-5\"\>"]}],
      ShowStringCharacters->False],
     0.000010618607302320014`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0076\"\>",
      ShowStringCharacters->False],
     0.007644621455707433,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.03\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"1\"\>"]}],
      ShowStringCharacters->False],
     10.286139235061215`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "0.642849745726835`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "7.114830670038025`"}],
  SequenceForm["  iter ", 8, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.000010618607302320014`, 3], " | rel. res.(%) = ", 
   NumberForm[0.007644621455707433, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[10.286139235061215`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 0.642849745726835, " taxa = ", 
   7.114830670038025],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798658590315*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"9fcb221c-b0c4-4e8d-98f3-d079b722c962"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"9.78\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-7\"\>"]}],
      ShowStringCharacters->False],
     9.78207431816328*^-7,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0014\"\>",
      ShowStringCharacters->False],
     0.0013543562098152222`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"1.82\"\>",
      ShowStringCharacters->False],
     1.8223396186122829`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.020763007445111725`"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "3.4322536028479864`"}],
  SequenceForm["  iter ", 9, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[9.78207431816328*^-7, 3], " | rel. res.(%) = ", 
   NumberForm[0.0013543562098152222`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[1.8223396186122829`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -0.020763007445111725`, " taxa = ", 
   3.4322536028479864`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.97479866233797*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"cb1a0f05-8f2b-44aa-b9e9-49184c105a57"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"7.96\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-8\"\>"]}],
      ShowStringCharacters->False],
     7.964315999246582*^-8,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0001\"\>",
      ShowStringCharacters->False],
     0.00012377818322979696`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.67\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-1\"\>"]}],
      ShowStringCharacters->False],
     0.16654842026403371`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "5.492165655596182`*^-6"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "0.7626974579180992`"}],
  SequenceForm["  iter ", 10, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[7.964315999246582*^-8, 3], " | rel. res.(%) = ", 
   NumberForm[0.00012377818322979696`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[0.16654842026403371`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -5.492165655596182*^-6, " taxa = ", 
   0.7626974579180992],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798666068573*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"cfeaa74b-ba54-47f8-95af-4c408c0fde01"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"7.47\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-11\"\>"]}],
      ShowStringCharacters->False],
     7.468807847697975*^-11,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"7.4283\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-8\"\>"]}],
      ShowStringCharacters->False],
     7.428346905136483*^-8,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-4\"\>"]}],
      ShowStringCharacters->False],
     0.00009995133309776036,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "4.3655745685100555`*^-11"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "1.382459938670414`"}],
  SequenceForm["  iter ", 11, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[7.468807847697975*^-11, 3], " | rel. res.(%) = ", 
   NumberForm[7.428346905136483*^-8, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[0.00009995133309776036, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -4.3655745685100555`*^-11, 
   " taxa = ", 1.382459938670414],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798669765325*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"a6eb6435-788c-4fc1-8cf3-6d3370673643"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"9.51\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-17\"\>"]}],
      ShowStringCharacters->False],
     9.508249024897292*^-17,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"2.3438\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-13\"\>"]}],
      ShowStringCharacters->False],
     2.34377595023724*^-13,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"3.15\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-10\"\>"]}],
      ShowStringCharacters->False],
     3.15364284544514*^-10,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1.3142198440618813`*^-10"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "3.100554956221827`"}],
  SequenceForm["  iter ", 12, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[9.508249024897292*^-17, 3], " | rel. res.(%) = ", 
   NumberForm[2.34377595023724*^-13, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[3.15364284544514*^-10, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -1.3142198440618813`*^-10, 
   " taxa = ", 3.100554956221827],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798673493392*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"3ca9bac8-4c5d-43b1-b2c6-ead1ef1d595d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \[Checkmark] Convergiu em \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" itera\[CCedilla]\[OTilde]es\"\>"}],
  SequenceForm[
  "  \[Checkmark] Convergiu em ", 12, " itera\[CCedilla]\[OTilde]es"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747986734945593`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"66631958-7a99-4398-a4cd-a2e6eaa78b6b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y base: \"\>", "\[InvisibleSpace]",
    "3606.2123173817636`"}],
  SequenceForm[
  "  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y base: ", 3606.2123173817636`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798673495328*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"c425bfb8-45ae-48d4-860c-6162deaec716"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y topo: \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "3606.212317381632`"}]}],
  SequenceForm[
  "  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y topo: ", -3606.212317381632],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747986734958887`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"99fa4ae0-ebc3-47fa-b62c-16aaedf6ceac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"=== Step \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" | u_total = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.0016531380741382927`"}], 
   "\[InvisibleSpace]", "\<\" ===\"\>"}],
  SequenceForm[
  "=== Step ", 6, "/", 8, " | u_total = ", -0.0016531380741382927`, " ==="],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798673496558*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"6ee04cc9-267f-4a6e-96af-10d368807d06"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"3.17\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-3\"\>"]}],
      ShowStringCharacters->False],
     0.003174030810826566,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"100.0000\"\>",
      ShowStringCharacters->False],
     99.99999999999999,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.21\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"5\"\>"]}],
      ShowStringCharacters->False],
     121237.96153161138`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1712.8121277636992`"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "1.7074486827438613`"}],
  SequenceForm["  iter ", 1, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.003174030810826566, 3], " | rel. res.(%) = ", 
   NumberForm[99.99999999999999, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[121237.96153161138`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -1712.8121277636992`, " taxa = ", 
   1.7074486827438613`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798677884626*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"3ef9ecdb-7027-4d90-8664-444b2ee67dd2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.22\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-3\"\>"]}],
      ShowStringCharacters->False],
     0.0012160693652935658`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"4.5391\"\>",
      ShowStringCharacters->False],
     4.539084080467997,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"5.5\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"3\"\>"]}],
      ShowStringCharacters->False],
     5503.093011365286,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "764.1097283044337`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm["  iter ", 2, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.0012160693652935658`, 3], " | rel. res.(%) = ", 
   NumberForm[4.539084080467997, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[5503.093011365286, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 764.1097283044337, " taxa = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798681594637*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"6a560c6f-1f95-4d16-9025-046280085b73"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"9.6\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-4\"\>"]}],
      ShowStringCharacters->False],
     0.0009602885682550337,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.7603\"\>",
      ShowStringCharacters->False],
     0.7603410583333051,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"9.22\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"2\"\>"]}],
      ShowStringCharacters->False],
     921.8219998111794,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "219.9673275178393`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm["  iter ", 3, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.0009602885682550337, 3], " | rel. res.(%) = ", 
   NumberForm[0.7603410583333051, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[921.8219998111794, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 219.9673275178393, " taxa = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747986855394573`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"f0e43cbb-3b46-470b-a7a8-d79a05ee867d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"5.36\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-4\"\>"]}],
      ShowStringCharacters->False],
     0.0005355278806480001,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.2337\"\>",
      ShowStringCharacters->False],
     0.23371296890419033`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"2.83\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"2\"\>"]}],
      ShowStringCharacters->False],
     283.34883933444917`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "3.023464946808417`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm["  iter ", 4, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.0005355278806480001, 3], " | rel. res.(%) = ", 
   NumberForm[0.23371296890419033`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[283.34883933444917`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 3.023464946808417, " taxa = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747986894695787`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"71f11b43-4a3d-41db-bb3d-f910bff1a3ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"2.5\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-4\"\>"]}],
      ShowStringCharacters->False],
     0.0002495048540818317,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.2323\"\>",
      ShowStringCharacters->False],
     0.2322710247856801,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"2.82\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"2\"\>"]}],
      ShowStringCharacters->False],
     281.6006556787424,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.8628996293241471`"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "0.660247658167854`"}],
  SequenceForm["  iter ", 5, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.0002495048540818317, 3], " | rel. res.(%) = ", 
   NumberForm[0.2322710247856801, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[281.6006556787424, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -0.8628996293241471, " taxa = ", 
   0.660247658167854],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747986935967007`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"a3932cc0-c013-433f-bef4-c44e662a54b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.33\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-4\"\>"]}],
      ShowStringCharacters->False],
     0.00013302115807641108`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.1512\"\>",
      ShowStringCharacters->False],
     0.1512160118391254,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.83\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"2\"\>"]}],
      ShowStringCharacters->False],
     183.33121026315575`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "1.8984201235130058`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0.005246226546119014`"}],
  SequenceForm["  iter ", 6, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.00013302115807641108`, 3], " | rel. res.(%) = ", 
   NumberForm[0.1512160118391254, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[183.33121026315575`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 1.8984201235130058`, " taxa = ", 
   0.005246226546119014],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798697814866*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"4d6609be-93e9-423d-8721-9a497e124df0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"5.41\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-5\"\>"]}],
      ShowStringCharacters->False],
     0.00005408175753114958,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0411\"\>",
      ShowStringCharacters->False],
     0.041123603794458265`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"4.99\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"1\"\>"]}],
      ShowStringCharacters->False],
     49.85741894873759,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.08918659945811669`"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "69.34998816861928`"}],
  SequenceForm["  iter ", 7, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.00005408175753114958, 3], " | rel. res.(%) = ", 
   NumberForm[0.041123603794458265`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[49.85741894873759, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -0.08918659945811669, " taxa = ", 
   69.34998816861928],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798701985672*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"dd05d04b-5f0b-45c2-a115-880b26db4e7e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"7.89\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-6\"\>"]}],
      ShowStringCharacters->False],
     7.887867957806841*^-6,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0055\"\>",
      ShowStringCharacters->False],
     0.005541029027238481,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"6.72\"\>",
      ShowStringCharacters->False],
     6.71783064049881,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.005386005350374035`"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "3.0338784216400017`"}],
  SequenceForm["  iter ", 8, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[7.887867957806841*^-6, 3], " | rel. res.(%) = ", 
   NumberForm[0.005541029027238481, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[6.71783064049881, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -0.005386005350374035, " taxa = ", 
   3.0338784216400017`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798706156644*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"0e7efa73-ea7a-4678-8929-e009f280a4b6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"3.19\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-7\"\>"]}],
      ShowStringCharacters->False],
     3.1926276491834845`*^-7,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0004\"\>",
      ShowStringCharacters->False],
     0.00043644742689113417`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"5.29\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-1\"\>"]}],
      ShowStringCharacters->False],
     0.529139963519981,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "3.4260992833878845`*^-6"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "1.5393290196512137`"}],
  SequenceForm["  iter ", 9, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[3.1926276491834845`*^-7, 3], " | rel. res.(%) = ", 
   NumberForm[0.00043644742689113417`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[0.529139963519981, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -3.4260992833878845`*^-6, 
   " taxa = ", 1.5393290196512137`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747987103397713`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"8e0b4735-2447-4c18-b225-55e00837e4e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"2.08\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-9\"\>"]}],
      ShowStringCharacters->False],
     2.084713927731649*^-9,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"3.9943\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-6\"\>"]}],
      ShowStringCharacters->False],
     3.994277909058055*^-6,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"4.84\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-3\"\>"]}],
      ShowStringCharacters->False],
     0.004842581114849456,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "3.0468072509393096`*^-11", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "1.2678432490961618`"}],
  SequenceForm["  iter ", 10, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[2.084713927731649*^-9, 3], " | rel. res.(%) = ", 
   NumberForm[3.994277909058055*^-6, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[0.004842581114849456, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 3.0468072509393096`*^-11, 
   " taxa = ", 1.2678432490961618`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747987144528427`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"0c5ada18-ff02-4675-83ab-26d4d2cb7639"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.9\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-13\"\>"]}],
      ShowStringCharacters->False],
     1.8997662612526503`*^-13,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"4.3975\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-10\"\>"]}],
      ShowStringCharacters->False],
     4.3974776310670267`*^-10,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"5.33\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-7\"\>"]}],
      ShowStringCharacters->False],
     5.331412238714258*^-7,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "7.73070496506989`*^-11", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "1.8470330101877244`"}],
  SequenceForm["  iter ", 11, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[1.8997662612526503`*^-13, 3], " | rel. res.(%) = ", 
   NumberForm[4.3974776310670267`*^-10, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[5.331412238714258*^-7, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 7.73070496506989*^-11, " taxa = ", 
   1.8470330101877244`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747987186808853`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"f9df6dd5-eb06-4af3-ab38-568eb3ea62eb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \[Checkmark] Convergiu em \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" itera\[CCedilla]\[OTilde]es\"\>"}],
  SequenceForm[
  "  \[Checkmark] Convergiu em ", 11, " itera\[CCedilla]\[OTilde]es"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798718682006*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"586d065b-8fdb-43ab-b28d-611838c6eeae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y base: \"\>", "\[InvisibleSpace]",
    "3684.0394604198013`"}],
  SequenceForm[
  "  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y base: ", 3684.0394604198013`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798718682602*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"8e6e88a6-78a0-4f8e-aec5-698b62416ef6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y topo: \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "3684.0394604198787`"}]}],
  SequenceForm[
  "  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y topo: ", -3684.0394604198787`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798718683187*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"73cc6e85-5676-4981-97ee-144e5abf17e3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"=== Step \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" | u_total = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.001863161137597154`"}], 
   "\[InvisibleSpace]", "\<\" ===\"\>"}],
  SequenceForm[
  "=== Step ", 7, "/", 8, " | u_total = ", -0.001863161137597154, " ==="],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798718683774*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"973581bb-8f91-46ef-b7f4-24a7745566fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"3.12\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-3\"\>"]}],
      ShowStringCharacters->False],
     0.003116211790399218,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"100.0000\"\>",
      ShowStringCharacters->False],
     99.99999999999999,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.2\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"5\"\>"]}],
      ShowStringCharacters->False],
     119969.6855515652,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1720.6914070171078`"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "1.9417448869248402`"}],
  SequenceForm["  iter ", 1, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.003116211790399218, 3], " | rel. res.(%) = ", 
   NumberForm[99.99999999999999, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[119969.6855515652, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -1720.6914070171078`, " taxa = ", 
   1.9417448869248402`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798723221241*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"62666705-6d26-4906-ac20-d8e9d6dd77c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.33\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-3\"\>"]}],
      ShowStringCharacters->False],
     0.001325787760601897,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"4.6818\"\>",
      ShowStringCharacters->False],
     4.681778220779568,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"5.62\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"3\"\>"]}],
      ShowStringCharacters->False],
     5616.714609690913,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "662.1189536317529`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm["  iter ", 2, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.001325787760601897, 3], " | rel. res.(%) = ", 
   NumberForm[4.681778220779568, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[5616.714609690913, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 662.1189536317529, " taxa = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747987269836617`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"0913de1f-dbab-4b8b-abd4-e4799cfcd660"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"9.92\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-4\"\>"]}],
      ShowStringCharacters->False],
     0.000991730653613903,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.8921\"\>",
      ShowStringCharacters->False],
     0.8921306285117675,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.07\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"3\"\>"]}],
      ShowStringCharacters->False],
     1070.2863097347697`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "264.21647113624385`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm["  iter ", 3, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.000991730653613903, 3], " | rel. res.(%) = ", 
   NumberForm[0.8921306285117675, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[1070.2863097347697`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 264.21647113624385`, " taxa = ", 0],
  
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747987310280952`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"bcfac064-4b70-4241-a15f-8798d814295f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"5.15\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-4\"\>"]}],
      ShowStringCharacters->False],
     0.0005151247628555885,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.2540\"\>",
      ShowStringCharacters->False],
     0.25402767234898804`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"3.05\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"2\"\>"]}],
      ShowStringCharacters->False],
     304.7561997310413,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "41.26196981403427`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm["  iter ", 4, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.0005151247628555885, 3], " | rel. res.(%) = ", 
   NumberForm[0.25402767234898804`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[304.7561997310413, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 41.26196981403427, " taxa = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747987351315527`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"2ebbcf2f-1606-408f-92c5-3a1787054560"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"3.85\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-4\"\>"]}],
      ShowStringCharacters->False],
     0.00038473510163775066`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.2524\"\>",
      ShowStringCharacters->False],
     0.2524204367179442,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"3.03\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"2\"\>"]}],
      ShowStringCharacters->False],
     302.82800419840527`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "0.19912312476753868`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0.7577232868975966`"}],
  SequenceForm["  iter ", 5, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.00038473510163775066`, 3], " | rel. res.(%) = ", 
   NumberForm[0.2524204367179442, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[302.82800419840527`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 0.19912312476753868`, " taxa = ", 
   0.7577232868975966],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798739268814*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"4337f966-31de-44d1-8c9f-580df2c99fbb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.65\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-4\"\>"]}],
      ShowStringCharacters->False],
     0.00016469916759507218`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.2123\"\>",
      ShowStringCharacters->False],
     0.21234635714471747`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"2.55\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"2\"\>"]}],
      ShowStringCharacters->False],
     254.75125694672116`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "2.6774660706660143`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0.0050527505239278256`"}],
  SequenceForm["  iter ", 6, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.00016469916759507218`, 3], " | rel. res.(%) = ", 
   NumberForm[0.21234635714471747`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[254.75125694672116`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 2.6774660706660143`, " taxa = ", 
   0.0050527505239278256`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747987433465443`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"fc645e13-28fd-4b0f-9a55-6f604537929d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"9.71\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-5\"\>"]}],
      ShowStringCharacters->False],
     0.00009707672468633273,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0965\"\>",
      ShowStringCharacters->False],
     0.09648250717899343,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.16\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"2\"\>"]}],
      ShowStringCharacters->False],
     115.74976047490473`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.8649174704810321`"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "27.237181135581185`"}],
  SequenceForm["  iter ", 7, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.00009707672468633273, 3], " | rel. res.(%) = ", 
   NumberForm[0.09648250717899343, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[115.74976047490473`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -0.8649174704810321, " taxa = ", 
   27.237181135581185`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747987475414762`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"9897ccf2-89bd-4f5c-9bda-ae1d3a21893e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"4.56\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-5\"\>"]}],
      ShowStringCharacters->False],
     0.000045567339261250284`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0333\"\>",
      ShowStringCharacters->False],
     0.03328935589031693,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"3.99\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"1\"\>"]}],
      ShowStringCharacters->False],
     39.937135583754674`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.10523840089581427`"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "4.5631008098797485`"}],
  SequenceForm["  iter ", 8, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.000045567339261250284`, 3], " | rel. res.(%) = ", 
   NumberForm[0.03328935589031693, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[39.937135583754674`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -0.10523840089581427`, " taxa = ", 
   4.5631008098797485`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798751576263*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"14040622-0055-41c2-a65e-3f2ad3692809"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"7.04\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-6\"\>"]}],
      ShowStringCharacters->False],
     7.0403718333097085`*^-6,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0104\"\>",
      ShowStringCharacters->False],
     0.010403283241093868`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.25\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"1\"\>"]}],
      ShowStringCharacters->False],
     12.480786191378995`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.002394010566149518`"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "1.3489441556703359`"}],
  SequenceForm["  iter ", 9, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[7.0403718333097085`*^-6, 3], " | rel. res.(%) = ", 
   NumberForm[0.010403283241093868`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[12.480786191378995`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -0.002394010566149518, " taxa = ", 
   1.3489441556703359`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.97479875563935*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"dcc0375e-528e-439b-938f-b0ce3010c974"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"3.72\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-7\"\>"]}],
      ShowStringCharacters->False],
     3.7236417718342085`*^-7,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0011\"\>",
      ShowStringCharacters->False],
     0.0010985902522268984`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"1.32\"\>",
      ShowStringCharacters->False],
     1.317975271096757,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.000011940176591451745`"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "1.0930269711652283`"}],
  SequenceForm["  iter ", 10, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[3.7236417718342085`*^-7, 3], " | rel. res.(%) = ", 
   NumberForm[0.0010985902522268984`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[1.317975271096757, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -0.000011940176591451745`, 
   " taxa = ", 1.0930269711652283`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798759743123*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"205a8fef-549f-43e1-bc38-f80ea47d4896"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"3.9\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-9\"\>"]}],
      ShowStringCharacters->False],
     3.896865636378052*^-9,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"7.7603\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-6\"\>"]}],
      ShowStringCharacters->False],
     7.760342741906962*^-6,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"9.31\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-3\"\>"]}],
      ShowStringCharacters->False],
     0.009310058785189496,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1.248281478183344`*^-9"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "1.9328194261617426`"}],
  SequenceForm["  iter ", 11, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[3.896865636378052*^-9, 3], " | rel. res.(%) = ", 
   NumberForm[7.760342741906962*^-6, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[0.009310058785189496, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -1.248281478183344*^-9, " taxa = ", 
   1.9328194261617426`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798763784471*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"3ee37e1e-7192-4202-af47-c173d4f90632"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"7.27\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-13\"\>"]}],
      ShowStringCharacters->False],
     7.272436322259328*^-13,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.8710\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-9\"\>"]}],
      ShowStringCharacters->False],
     1.8709624711831267`*^-9,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"2.24\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-6\"\>"]}],
      ShowStringCharacters->False],
     2.244587793466191*^-6,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "5.002220859751105`*^-12"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "2.203091705251644`"}],
  SequenceForm["  iter ", 12, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[7.272436322259328*^-13, 3], " | rel. res.(%) = ", 
   NumberForm[1.8709624711831267`*^-9, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[2.244587793466191*^-6, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -5.002220859751105*^-12, " taxa = ",
    2.203091705251644],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747987677948017`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"523d4e89-8cd5-4953-800e-29feb616de70"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \[Checkmark] Convergiu em \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" itera\[CCedilla]\[OTilde]es\"\>"}],
  SequenceForm[
  "  \[Checkmark] Convergiu em ", 12, " itera\[CCedilla]\[OTilde]es"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747987677957993`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"f8d56eb9-b100-41d2-99f8-96a2e42a1742"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y base: \"\>", "\[InvisibleSpace]",
    "3691.0460778793786`"}],
  SequenceForm[
  "  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y base: ", 3691.0460778793786`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798767796365*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"c9970dd6-a194-4c95-ae0f-898d45d51773"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y topo: \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "3691.0460778793736`"}]}],
  SequenceForm[
  "  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y topo: ", -3691.0460778793736`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798767796916*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"7cf5a1eb-f24b-4d23-954a-cb9950390ce5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"=== Step \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" | u_total = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.0020703374009542626`"}], 
   "\[InvisibleSpace]", "\<\" ===\"\>"}],
  SequenceForm[
  "=== Step ", 8, "/", 8, " | u_total = ", -0.0020703374009542626`, " ==="],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.97479876779749*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"aa012a21-4b94-42f1-9403-da680c840237"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"3.06\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-3\"\>"]}],
      ShowStringCharacters->False],
     0.003062574776634788,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"100.0000\"\>",
      ShowStringCharacters->False],
     100.,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.18\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"5\"\>"]}],
      ShowStringCharacters->False],
     118356.9501518993,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1701.4038260664456`"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "1.681958059524115`"}],
  SequenceForm["  iter ", 1, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.003062574776634788, 3], " | rel. res.(%) = ", 
   NumberForm[100., {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[118356.9501518993, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -1701.4038260664456`, " taxa = ", 
   1.681958059524115],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798772367301*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"cc98de70-09eb-4f2c-ab99-47264d4570a4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.33\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-3\"\>"]}],
      ShowStringCharacters->False],
     0.0013271883738375674`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"4.7574\"\>",
      ShowStringCharacters->False],
     4.757352155217579,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"5.63\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"3\"\>"]}],
      ShowStringCharacters->False],
     5630.656918901177,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "584.4116890714063`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm["  iter ", 2, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.0013271883738375674`, 3], " | rel. res.(%) = ", 
   NumberForm[4.757352155217579, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[5630.656918901177, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 584.4116890714063, " taxa = ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798776270007*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"f174b59f-3a23-4bfd-8d3c-fbe506f91053"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.01\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-3\"\>"]}],
      ShowStringCharacters->False],
     0.0010145406981090658`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.8444\"\>",
      ShowStringCharacters->False],
     0.8444110390587379,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"9.99\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"2\"\>"]}],
      ShowStringCharacters->False],
     999.4191525758855,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "235.60693349199573`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm["  iter ", 3, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.0010145406981090658`, 3], " | rel. res.(%) = ", 
   NumberForm[0.8444110390587379, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[999.4191525758855, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 235.60693349199573`, " taxa = ", 0],
  
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798780225585*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"f4a73ae8-ac5b-42a3-9da9-9aef6808334e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"5.22\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-4\"\>"]}],
      ShowStringCharacters->False],
     0.0005220235556407252,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.2481\"\>",
      ShowStringCharacters->False],
     0.24811681301179345`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"2.94\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"2\"\>"]}],
      ShowStringCharacters->False],
     293.66349269484954`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.9668925463229243`"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["  iter ", 4, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.0005220235556407252, 3], " | rel. res.(%) = ", 
   NumberForm[0.24811681301179345`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[293.66349269484954`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -0.9668925463229243, " taxa = ", 0],
  
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798784242671*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"895a33fa-9dde-4625-ae65-b90fff791764"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"3.89\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-4\"\>"]}],
      ShowStringCharacters->False],
     0.0003892484237119581,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.3515\"\>",
      ShowStringCharacters->False],
     0.3514551086442763,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"4.16\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"2\"\>"]}],
      ShowStringCharacters->False],
     415.97154774440963`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "1.3562658954956532`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "0.7084305183685659`"}],
  SequenceForm["  iter ", 5, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.0003892484237119581, 3], " | rel. res.(%) = ", 
   NumberForm[0.3514551086442763, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[415.97154774440963`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 1.3562658954956532`, " taxa = ", 
   0.7084305183685659],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747987882855177`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"b37850b8-086b-4ccf-8267-0789c58cbee3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.65\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-4\"\>"]}],
      ShowStringCharacters->False],
     0.00016502562853898517`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.1998\"\>",
      ShowStringCharacters->False],
     0.19981770271428548`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"2.36\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"2\"\>"]}],
      ShowStringCharacters->False],
     236.49813879621718`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "6.781031104884278`", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.2842908777861436`"}]}],
  SequenceForm["  iter ", 6, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.00016502562853898517`, 3], " | rel. res.(%) = ", 
   NumberForm[0.19981770271428548`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[236.49813879621718`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 6.781031104884278, 
   " taxa = ", -0.2842908777861436],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.97479879238596*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"984059a0-6d60-4c63-8fe7-899ac594f5e8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"8.33\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-5\"\>"]}],
      ShowStringCharacters->False],
     0.00008331111405145753,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.1816\"\>",
      ShowStringCharacters->False],
     0.18162017335154318`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"2.15\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"2\"\>"]}],
      ShowStringCharacters->False],
     214.96009803947908`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1.0459868454818206`"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1.6217839617628647`"}]}],
  SequenceForm["  iter ", 7, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.00008331111405145753, 3], " | rel. res.(%) = ", 
   NumberForm[0.18162017335154318`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[214.96009803947908`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -1.0459868454818206`, 
   " taxa = ", -1.6217839617628647`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798796494401*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"1558ba0d-bfe8-425d-96cf-66572550a37c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"4.61\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-5\"\>"]}],
      ShowStringCharacters->False],
     0.000046074546144300695`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0287\"\>",
      ShowStringCharacters->False],
     0.028748355978445085`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"3.4\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"1\"\>"]}],
      ShowStringCharacters->False],
     34.02567735489881,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.18490865715239124`"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "0.16910197875655364`"}],
  SequenceForm["  iter ", 8, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[0.000046074546144300695`, 3], " | rel. res.(%) = ", 
   NumberForm[0.028748355978445085`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[34.02567735489881, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -0.18490865715239124`, " taxa = ", 
   0.16910197875655364`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798800552106*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"48f87f49-4d32-4690-931d-01236b970418"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"8.8\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-6\"\>"]}],
      ShowStringCharacters->False],
     8.802101087199156*^-6,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0045\"\>",
      ShowStringCharacters->False],
     0.004501466367815854,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"5.33\"\>",
      ShowStringCharacters->False],
     5.327798305060323,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.005067206975581939`"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "19.304400057560876`"}],
  SequenceForm["  iter ", 9, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[8.802101087199156*^-6, 3], " | rel. res.(%) = ", 
   NumberForm[0.004501466367815854, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[5.327798305060323, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -0.005067206975581939, " taxa = ", 
   19.304400057560876`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747988047286997`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"48da3f67-1699-457f-b1b6-f68f66b8f50c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"5.11\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-7\"\>"]}],
      ShowStringCharacters->False],
     5.112438203533481*^-7,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0010\"\>",
      ShowStringCharacters->False],
     0.0009629530548856192,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"1.14\"\>",
      ShowStringCharacters->False],
     1.1397218671571638`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1.8672026271815412`*^-6"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "1.005880864303886`"}],
  SequenceForm["  iter ", 10, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[5.112438203533481*^-7, 3], " | rel. res.(%) = ", 
   NumberForm[0.0009629530548856192, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[1.1397218671571638`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -1.8672026271815412`*^-6, 
   " taxa = ", 1.005880864303886],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798808820525*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"ca1a053d-8637-419c-9ab2-715254cfac2c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"8.37\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-9\"\>"]}],
      ShowStringCharacters->False],
     8.365872802479874*^-9,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0000\"\>",
      ShowStringCharacters->False],
     0.000017662100892139927`,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"2.09\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-2\"\>"]}],
      ShowStringCharacters->False],
     0.020904323948688214`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "3.927652869606391`*^-9"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "0.8317186035361812`"}],
  SequenceForm["  iter ", 11, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[8.365872802479874*^-9, 3], " | rel. res.(%) = ", 
   NumberForm[0.000017662100892139927`, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[0.020904323948688214`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -3.927652869606391*^-9, " taxa = ", 
   0.8317186035361812],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747988128720827`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"aeb00f26-8ada-49ba-870d-22ec9a00b863"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"3.64\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-12\"\>"]}],
      ShowStringCharacters->False],
     3.6371336868916276`*^-12,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"9.3949\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-9\"\>"]}],
      ShowStringCharacters->False],
     9.394909233672867*^-9,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.11\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-5\"\>"]}],
      ShowStringCharacters->False],
     0.000011119528038514379`,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "4.0472514228895307`*^-11"}], 
   "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]", 
   "2.592856469614992`"}],
  SequenceForm["  iter ", 12, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[3.6371336868916276`*^-12, 3], " | rel. res.(%) = ", 
   NumberForm[9.394909233672867*^-9, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[0.000011119528038514379`, 3], 
   " Abs[reactionYtop-reactionYbase] = ", -4.0472514228895307`*^-11, 
   " taxa = ", 2.592856469614992],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.9747988168985243`*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"4294d5ff-1fa7-4084-b4bf-c1373260d873"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  iter \"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\" | \:2016\[CapitalDelta]u\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"8.95\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-18\"\>"]}],
      ShowStringCharacters->False],
     8.953824067622394*^-18,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" | rel. res.(%) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"2.4461\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-13\"\>"]}],
      ShowStringCharacters->False],
     2.4461474434733514`*^-13,
     AutoDelete->True],
    NumberForm[#, {6, 4}]& ], 
   "\[InvisibleSpace]", "\<\" | \:2016r\:2016 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"2.9\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"-10\"\>"]}],
      ShowStringCharacters->False],
     2.895185510313714*^-10,
     AutoDelete->True],
    ScientificForm[#, 3]& ], 
   "\[InvisibleSpace]", "\<\" Abs[reactionYtop-reactionYbase] = \"\>", "\[InvisibleSpace]",
    "1.0459189070388675`*^-11", "\[InvisibleSpace]", "\<\" taxa = \"\>", "\[InvisibleSpace]",
    "1.8854197840685758`"}],
  SequenceForm["  iter ", 13, " | \:2016\[CapitalDelta]u\:2016 = ", 
   ScientificForm[8.953824067622394*^-18, 3], " | rel. res.(%) = ", 
   NumberForm[2.4461474434733514`*^-13, {6, 4}], " | \:2016r\:2016 = ", 
   ScientificForm[2.895185510313714*^-10, 3], 
   " Abs[reactionYtop-reactionYbase] = ", 1.0459189070388675`*^-11, 
   " taxa = ", 1.8854197840685758`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798820980122*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"eb340b48-db9f-4354-8b5b-1dc2b453b945"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \[Checkmark] Convergiu em \"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\" itera\[CCedilla]\[OTilde]es\"\>"}],
  SequenceForm[
  "  \[Checkmark] Convergiu em ", 13, " itera\[CCedilla]\[OTilde]es"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798820981223*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"616e0431-383a-4a8b-8c20-f0bb7b5c85ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y base: \"\>", "\[InvisibleSpace]",
    "3687.6741948358163`"}],
  SequenceForm[
  "  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y base: ", 3687.6741948358163`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798820981863*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"afd8124f-aa43-4a5d-9b4c-33294bf62b3d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y topo: \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "3687.6741948358267`"}]}],
  SequenceForm[
  "  \[RightArrow] Rea\[CCedilla]\[ATilde]o Y topo: ", -3687.6741948358267`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.974790284023243*^9, {3.974791084142336*^9, 3.9747911059459753`*^9}, 
   3.974791147151792*^9, 3.974791653009947*^9, {3.974791695908753*^9, 
   3.974791723425992*^9}, 3.974792542106749*^9, 3.974793565625293*^9, 
   3.974793863209792*^9, 3.97479444031882*^9, {3.9747982422054377`*^9, 
   3.9747982676787777`*^9}, 3.974798820982543*^9},
 CellLabel->
  "During evaluation of \
In[833]:=",ExpressionUUID->"1419c3d1-5112-461f-ab8a-6d258cc99bd2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"plotx", "=", 
   RowBox[{"Prepend", "[", 
    RowBox[{"plot3", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"plotx", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"-", 
    RowBox[{"plotx", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "1"}], "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plotx", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"plotx", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "2"}], "]"}], "]"}], 
    RowBox[{"2", "/", "490."}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"feStyle", "=", 
   RowBox[{"Directive", "[", 
    RowBox[{"Black", ",", 
     RowBox[{"AbsoluteThickness", "[", "1.1", "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"slipStyle", "=", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "Dashed", ",", 
      RowBox[{"AbsoluteThickness", "[", "1.0", "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{"plotULambda", "=", 
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"plot2", ",", "plotx", ",", "mcAssoc2Data"}], "}"}], ",", 
    RowBox[{"PlotLegends", "->", 
     RowBox[{"{", 
      RowBox[{"\"\<ArcLength\>\"", ",", "\"\<Controled Displacement\>\"", 
       ",", "\"\<Souza Neto Controled Displacement\>\""}], "}"}]}], ",", 
    RowBox[{"AspectRatio", "->", "Full"}], ",", 
    RowBox[{"PlotMarkers", "->", "Automatic"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.974459597409671*^9, 3.974459600016912*^9}, {
  3.974459639729644*^9, 3.97445968630541*^9}, {3.974460256380238*^9, 
  3.97446029287584*^9}, {3.974624264858624*^9, 3.9746242897388477`*^9}, {
  3.974790622793435*^9, 3.97479072313752*^9}},
 CellLabel->
  "In[858]:=",ExpressionUUID->"a504b472-af9b-453f-9f13-8a654684b36e"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, 
     InterpretationBox[{
       TagBox[{{{}, {}, 
          TagBox[{
            RGBColor[0.24, 0.6, 0.8], 
            PointSize[
             NCache[
              Rational[7, 360], 0.019444444444444445`]], 
            AbsoluteThickness[2], 
            
            LineBox[{{0., 0.}, {0.00029543480938711643`, 6.562322489296535}, {
             0.0006146962727383243, 10.408935534549569`}, {
             0.0009245446212503409, 12.864614113220572`}, {
             0.0012050175275299731`, 14.380267791858003`}, {
             0.0014408502726306804`, 14.93533990750454}, {
             0.0016531380741382927`, 14.966852142747886`}, {
             0.001863161137597154, 14.968010127951416`}, {
             0.0020703374009542626`, 14.964278571797085`}}]}, 
           Annotation[#, "Charting`Private`Tag#1"]& ], 
          TagBox[{
            RGBColor[0.95, 0.627, 0.1425], 
            PointSize[
             NCache[
              Rational[7, 360], 0.019444444444444445`]], 
            AbsoluteThickness[2], 
            
            LineBox[{{0., 0.}, {0.00029543480938711643`, 
             6.1933854328271085`}, {0.0006146962727383243, 
             10.044758450351264`}, {0.0009245446212503409, 
             12.445733238593487`}, {0.0012050175275299731`, 
             13.963131468340771`}, {0.0014408502726306804`, 
             14.719233948496996`}, {0.0016531380741382927`, 
             15.036895756815516`}, {0.001863161137597154, 
             15.065494195426036`}, {0.0020703374009542626`, 
             15.05173140749313}}]}, 
           Annotation[#, "Charting`Private`Tag#2"]& ], 
          TagBox[{
            RGBColor[0.455, 0.7, 0.21], 
            PointSize[
             NCache[
              Rational[7, 360], 0.019444444444444445`]], 
            AbsoluteThickness[2], 
            
            LineBox[{{0.000295435, 6.033265306122449}, {0.000614696, 
             10.23404081632653}, {0.000924544, 13.00138775510204}, {
             0.00120502, 14.66934693877551}, {0.00132293, 
             14.94661224489796}, {0.00132293, 14.94661224489796}, {
             0.0014408499999999998`, 14.956530612244897`}, {0.00165314, 
             14.963918367346938`}, {0.00186316, 14.969591836734693`}, {
             0.00207034, 14.974326530612245`}}]}, 
           Annotation[#, "Charting`Private`Tag#3"]& ]}, {
          TagBox[{
            RGBColor[0.24, 0.6, 0.8], 
            PointSize[
             NCache[
              Rational[7, 360], 0.019444444444444445`]], 
            AbsoluteThickness[2], 
            GeometricTransformationBox[
             InsetBox[
              FormBox[
               StyleBox[
                GraphicsBox[{
                  EdgeForm[None], 
                  DiskBox[{0, 0}]}, PlotRangePadding -> Scaled[0.15]], 
                StripOnInput -> False, 
                GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                    PointSize[
                    Rational[7, 360]], 
                    RGBColor[0.24, 0.6, 0.8], 
                    AbsoluteThickness[2]]}], TraditionalForm], {0., 0.}, 
              Automatic, 
              Offset[10.976]], {{{0., 0.}}, {{0.00029543480938711643`, 
             6.562322489296535}}, {{0.0006146962727383243, 
             10.408935534549569`}}, {{0.0009245446212503409, 
             12.864614113220572`}}, {{0.0012050175275299731`, 
             14.380267791858003`}}, {{0.0014408502726306804`, 
             14.93533990750454}}, {{0.0016531380741382927`, 
             14.966852142747886`}}, {{0.001863161137597154, 
             14.968010127951416`}}, {{0.0020703374009542626`, 
             14.964278571797085`}}}]}, 
           Annotation[#, "Charting`Private`Tag#1"]& ], 
          TagBox[{
            RGBColor[0.95, 0.627, 0.1425], 
            PointSize[
             NCache[
              Rational[7, 360], 0.019444444444444445`]], 
            AbsoluteThickness[2], 
            GeometricTransformationBox[
             InsetBox[
              FormBox[
               StyleBox[
                GraphicsBox[{
                  EdgeForm[None], 
                  PolygonBox[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}, 
                 PlotRangePadding -> Scaled[0.15]], StripOnInput -> False, 
                GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                    PointSize[
                    Rational[7, 360]], 
                    RGBColor[0.95, 0.627, 0.1425], 
                    AbsoluteThickness[2]]}], TraditionalForm], {0., 0.}, 
              Automatic, 
              Offset[10.5]], {{{0., 0.}}, {{0.00029543480938711643`, 
             6.1933854328271085`}}, {{0.0006146962727383243, 
             10.044758450351264`}}, {{0.0009245446212503409, 
             12.445733238593487`}}, {{0.0012050175275299731`, 
             13.963131468340771`}}, {{0.0014408502726306804`, 
             14.719233948496996`}}, {{0.0016531380741382927`, 
             15.036895756815516`}}, {{0.001863161137597154, 
             15.065494195426036`}}, {{0.0020703374009542626`, 
             15.05173140749313}}}]}, 
           Annotation[#, "Charting`Private`Tag#2"]& ], 
          TagBox[{
            RGBColor[0.455, 0.7, 0.21], 
            PointSize[
             NCache[
              Rational[7, 360], 0.019444444444444445`]], 
            AbsoluteThickness[2], 
            GeometricTransformationBox[
             InsetBox[
              FormBox[
               StyleBox[
                GraphicsBox[{
                  EdgeForm[None], 
                  PolygonBox[{{0, 1}, {1, 0}, {0, -1}, {-1, 0}}]}], 
                StripOnInput -> False, 
                GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                    PointSize[
                    Rational[7, 360]], 
                    RGBColor[0.455, 0.7, 0.21], 
                    AbsoluteThickness[2]]}], TraditionalForm], {0., 0.}, 
              Automatic, 
              Offset[10.2]], {{{0.000295435, 6.033265306122449}}, {{
             0.000614696, 10.23404081632653}}, {{0.000924544, 
             13.00138775510204}}, {{0.00120502, 14.66934693877551}}, {{
             0.00132293, 14.94661224489796}}, {{0.00132293, 
             14.94661224489796}}, {{0.0014408499999999998`, 
             14.956530612244897`}}, {{0.00165314, 14.963918367346938`}}, {{
             0.00186316, 14.969591836734693`}}, {{0.00207034, 
             14.974326530612245`}}}]}, 
           Annotation[#, "Charting`Private`Tag#3"]& ]}}, {
        "WolframDynamicHighlight", <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
       StyleBox[
        DynamicBox[
         (Charting`HighlightActionBox["DynamicHighlight", {}, 
          Slot["HighlightElements"], 
          Slot["LayoutOptions"], 
          Slot["Meta"], 
          Charting`HighlightActionFunction["DynamicHighlight", {{{}, {}, 
             Annotation[{
               Hue[0.67, 0.6, 0.6], 
               Directive[
                PointSize[
                 Rational[7, 360]], 
                RGBColor[0.24, 0.6, 0.8], 
                AbsoluteThickness[2]], 
               
               Line[{{0., 0.}, {0.00029543480938711643`, 6.562322489296535}, {
                0.0006146962727383243, 10.408935534549569`}, {
                0.0009245446212503409, 12.864614113220572`}, {
                0.0012050175275299731`, 14.380267791858003`}, {
                0.0014408502726306804`, 14.93533990750454}, {
                0.0016531380741382927`, 14.966852142747886`}, {
                0.001863161137597154, 14.968010127951416`}, {
                0.0020703374009542626`, 14.964278571797085`}}]}, 
              "Charting`Private`Tag#1"], 
             Annotation[{
               Hue[0.9060679774997897, 0.6, 0.6], 
               Directive[
                PointSize[
                 Rational[7, 360]], 
                RGBColor[0.95, 0.627, 0.1425], 
                AbsoluteThickness[2]], 
               
               Line[{{0., 0.}, {0.00029543480938711643`, 
                6.1933854328271085`}, {0.0006146962727383243, 
                10.044758450351264`}, {0.0009245446212503409, 
                12.445733238593487`}, {0.0012050175275299731`, 
                13.963131468340771`}, {0.0014408502726306804`, 
                14.719233948496996`}, {0.0016531380741382927`, 
                15.036895756815516`}, {0.001863161137597154, 
                15.065494195426036`}, {0.0020703374009542626`, 
                15.05173140749313}}]}, "Charting`Private`Tag#2"], 
             Annotation[{
               Hue[0.1421359549995791, 0.6, 0.6], 
               Directive[
                PointSize[
                 Rational[7, 360]], 
                RGBColor[0.455, 0.7, 0.21], 
                AbsoluteThickness[2]], 
               
               Line[{{0.000295435, 6.033265306122449}, {0.000614696, 
                10.23404081632653}, {0.000924544, 13.00138775510204}, {
                0.00120502, 14.66934693877551}, {0.00132293, 
                14.94661224489796}, {0.00132293, 14.94661224489796}, {
                0.0014408499999999998`, 14.956530612244897`}, {0.00165314, 
                14.963918367346938`}, {0.00186316, 14.969591836734693`}, {
                0.00207034, 14.974326530612245`}}]}, 
              "Charting`Private`Tag#3"]}, {
             Annotation[{
               Directive[
                PointSize[
                 Rational[7, 360]], 
                RGBColor[0.24, 0.6, 0.8], 
                AbsoluteThickness[2]], 
               GeometricTransformation[
                Inset[
                 Style[
                  Graphics[{
                    EdgeForm[], 
                    Disk[{0, 0}]}, PlotRangePadding -> Scaled[0.15]], 
                  GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                    PointSize[
                    Rational[7, 360]], 
                    RGBColor[0.24, 0.6, 0.8], 
                    AbsoluteThickness[2]]}], {0., 0.}, Automatic, 
                 Offset[10.976]], {{{0., 0.}}, {{0.00029543480938711643`, 
                6.562322489296535}}, {{0.0006146962727383243, 
                10.408935534549569`}}, {{0.0009245446212503409, 
                12.864614113220572`}}, {{0.0012050175275299731`, 
                14.380267791858003`}}, {{0.0014408502726306804`, 
                14.93533990750454}}, {{0.0016531380741382927`, 
                14.966852142747886`}}, {{0.001863161137597154, 
                14.968010127951416`}}, {{0.0020703374009542626`, 
                14.964278571797085`}}}]}, "Charting`Private`Tag#1"], 
             Annotation[{
               Directive[
                PointSize[
                 Rational[7, 360]], 
                RGBColor[0.95, 0.627, 0.1425], 
                AbsoluteThickness[2]], 
               GeometricTransformation[
                Inset[
                 Style[
                  Graphics[{
                    EdgeForm[], 
                    Polygon[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}, 
                   PlotRangePadding -> Scaled[0.15]], 
                  GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                    PointSize[
                    Rational[7, 360]], 
                    RGBColor[0.95, 0.627, 0.1425], 
                    AbsoluteThickness[2]]}], {0., 0.}, Automatic, 
                 Offset[10.5]], {{{0., 0.}}, {{0.00029543480938711643`, 
                6.1933854328271085`}}, {{0.0006146962727383243, 
                10.044758450351264`}}, {{0.0009245446212503409, 
                12.445733238593487`}}, {{0.0012050175275299731`, 
                13.963131468340771`}}, {{0.0014408502726306804`, 
                14.719233948496996`}}, {{0.0016531380741382927`, 
                15.036895756815516`}}, {{0.001863161137597154, 
                15.065494195426036`}}, {{0.0020703374009542626`, 
                15.05173140749313}}}]}, "Charting`Private`Tag#2"], 
             Annotation[{
               Directive[
                PointSize[
                 Rational[7, 360]], 
                RGBColor[0.455, 0.7, 0.21], 
                AbsoluteThickness[2]], 
               GeometricTransformation[
                Inset[
                 Style[
                  Graphics[{
                    EdgeForm[], 
                    Polygon[{{0, 1}, {1, 0}, {0, -1}, {-1, 0}}]}], 
                  GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                    PointSize[
                    Rational[7, 360]], 
                    RGBColor[0.455, 0.7, 0.21], 
                    AbsoluteThickness[2]]}], {0., 0.}, Automatic, 
                 Offset[10.2]], {{{0.000295435, 6.033265306122449}}, {{
                0.000614696, 10.23404081632653}}, {{0.000924544, 
                13.00138775510204}}, {{0.00120502, 14.66934693877551}}, {{
                0.00132293, 14.94661224489796}}, {{0.00132293, 
                14.94661224489796}}, {{0.0014408499999999998`, 
                14.956530612244897`}}, {{0.00165314, 14.963918367346938`}}, {{
                0.00186316, 14.969591836734693`}}, {{0.00207034, 
                14.974326530612245`}}}]}, "Charting`Private`Tag#3"]}}, <|
           "HighlightElements" -> <|
             "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
            "LayoutOptions" -> <|
             "PanelPlotLayout" -> <||>, 
              "PlotRange" -> {{0, 0.00207034}, {0, 15.065494195426036`}}, 
              "Frame" -> {{False, False}, {False, False}}, 
              "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 432}, 
              "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
              Full, "DefaultStyle" -> {
                Directive[
                 PointSize[
                  Rational[7, 360]], 
                 RGBColor[0.455, 0.7, 0.21], 
                 AbsoluteThickness[2]], 
                Directive[
                 PointSize[
                  Rational[7, 360]], 
                 RGBColor[0.95, 0.627, 0.1425], 
                 AbsoluteThickness[2]], 
                Directive[
                 PointSize[
                  Rational[7, 360]], 
                 RGBColor[0.24, 0.6, 0.8], 
                 AbsoluteThickness[2]]}, 
              "HighlightLabelingFunctions" -> <|
               "CoordinatesToolOptions" -> ({
                  (Identity[#]& )[
                   Part[#, 1]], 
                  (Identity[#]& )[
                   Part[#, 2]]}& ), 
                "ScalingFunctions" -> {{Identity, Identity}, {
                  Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
              False|>, 
            "Meta" -> <|
             "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
              "Function" -> ListLinePlot, "GroupHighlight" -> False|>|>]]& )[<|
          "HighlightElements" -> <|
            "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
           "LayoutOptions" -> <|
            "PanelPlotLayout" -> <||>, 
             "PlotRange" -> {{0, 0.00207034}, {0, 15.065494195426036`}}, 
             "Frame" -> {{False, False}, {False, False}}, 
             "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 432}, 
             "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
             Full, "DefaultStyle" -> {
               Directive[
                PointSize[
                 Rational[7, 360]], 
                RGBColor[0.455, 0.7, 0.21], 
                AbsoluteThickness[2]], 
               Directive[
                PointSize[
                 Rational[7, 360]], 
                RGBColor[0.95, 0.627, 0.1425], 
                AbsoluteThickness[2]], 
               Directive[
                PointSize[
                 Rational[7, 360]], 
                RGBColor[0.24, 0.6, 0.8], 
                AbsoluteThickness[2]]}, 
             "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& ), 
               "ScalingFunctions" -> {{Identity, Identity}, {
                 Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
             False|>, 
           "Meta" -> <|
            "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
             "Function" -> ListLinePlot, "GroupHighlight" -> False|>|>], 
         ImageSizeCache -> {{4.503599627370496*^15, -4.503599627370496*^15}, {
          4.503599627370496*^15, -4.503599627370496*^15}}], Selectable -> 
        False]}, 
      Annotation[{{{}, {}, 
         Annotation[{
           Hue[0.67, 0.6, 0.6], 
           Directive[
            PointSize[
             Rational[7, 360]], 
            RGBColor[0.24, 0.6, 0.8], 
            AbsoluteThickness[2]], 
           
           Line[{{0., 0.}, {0.00029543480938711643`, 6.562322489296535}, {
            0.0006146962727383243, 10.408935534549569`}, {
            0.0009245446212503409, 12.864614113220572`}, {
            0.0012050175275299731`, 14.380267791858003`}, {
            0.0014408502726306804`, 14.93533990750454}, {
            0.0016531380741382927`, 14.966852142747886`}, {
            0.001863161137597154, 14.968010127951416`}, {
            0.0020703374009542626`, 14.964278571797085`}}]}, 
          "Charting`Private`Tag#1"], 
         Annotation[{
           Hue[0.9060679774997897, 0.6, 0.6], 
           Directive[
            PointSize[
             Rational[7, 360]], 
            RGBColor[0.95, 0.627, 0.1425], 
            AbsoluteThickness[2]], 
           
           Line[{{0., 0.}, {0.00029543480938711643`, 6.1933854328271085`}, {
            0.0006146962727383243, 10.044758450351264`}, {
            0.0009245446212503409, 12.445733238593487`}, {
            0.0012050175275299731`, 13.963131468340771`}, {
            0.0014408502726306804`, 14.719233948496996`}, {
            0.0016531380741382927`, 15.036895756815516`}, {
            0.001863161137597154, 15.065494195426036`}, {
            0.0020703374009542626`, 15.05173140749313}}]}, 
          "Charting`Private`Tag#2"], 
         Annotation[{
           Hue[0.1421359549995791, 0.6, 0.6], 
           Directive[
            PointSize[
             Rational[7, 360]], 
            RGBColor[0.455, 0.7, 0.21], 
            AbsoluteThickness[2]], 
           
           Line[{{0.000295435, 6.033265306122449}, {0.000614696, 
            10.23404081632653}, {0.000924544, 13.00138775510204}, {0.00120502,
             14.66934693877551}, {0.00132293, 14.94661224489796}, {0.00132293,
             14.94661224489796}, {0.0014408499999999998`, 
            14.956530612244897`}, {0.00165314, 14.963918367346938`}, {
            0.00186316, 14.969591836734693`}, {0.00207034, 
            14.974326530612245`}}]}, "Charting`Private`Tag#3"]}, {
         Annotation[{
           Directive[
            PointSize[
             Rational[7, 360]], 
            RGBColor[0.24, 0.6, 0.8], 
            AbsoluteThickness[2]], 
           GeometricTransformation[
            Inset[
             Style[
              Graphics[{
                EdgeForm[], 
                Disk[{0, 0}]}, PlotRangePadding -> Scaled[0.15]], 
              GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                  PointSize[
                   Rational[7, 360]], 
                  RGBColor[0.24, 0.6, 0.8], 
                  AbsoluteThickness[2]]}], {0., 0.}, Automatic, 
             Offset[10.976]], {{{0., 0.}}, {{0.00029543480938711643`, 
            6.562322489296535}}, {{0.0006146962727383243, 
            10.408935534549569`}}, {{0.0009245446212503409, 
            12.864614113220572`}}, {{0.0012050175275299731`, 
            14.380267791858003`}}, {{0.0014408502726306804`, 
            14.93533990750454}}, {{0.0016531380741382927`, 
            14.966852142747886`}}, {{0.001863161137597154, 
            14.968010127951416`}}, {{0.0020703374009542626`, 
            14.964278571797085`}}}]}, "Charting`Private`Tag#1"], 
         Annotation[{
           Directive[
            PointSize[
             Rational[7, 360]], 
            RGBColor[0.95, 0.627, 0.1425], 
            AbsoluteThickness[2]], 
           GeometricTransformation[
            Inset[
             Style[
              Graphics[{
                EdgeForm[], 
                Polygon[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}, 
               PlotRangePadding -> Scaled[0.15]], 
              GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                  PointSize[
                   Rational[7, 360]], 
                  RGBColor[0.95, 0.627, 0.1425], 
                  AbsoluteThickness[2]]}], {0., 0.}, Automatic, 
             Offset[10.5]], {{{0., 0.}}, {{0.00029543480938711643`, 
            6.1933854328271085`}}, {{0.0006146962727383243, 
            10.044758450351264`}}, {{0.0009245446212503409, 
            12.445733238593487`}}, {{0.0012050175275299731`, 
            13.963131468340771`}}, {{0.0014408502726306804`, 
            14.719233948496996`}}, {{0.0016531380741382927`, 
            15.036895756815516`}}, {{0.001863161137597154, 
            15.065494195426036`}}, {{0.0020703374009542626`, 
            15.05173140749313}}}]}, "Charting`Private`Tag#2"], 
         Annotation[{
           Directive[
            PointSize[
             Rational[7, 360]], 
            RGBColor[0.455, 0.7, 0.21], 
            AbsoluteThickness[2]], 
           GeometricTransformation[
            Inset[
             Style[
              Graphics[{
                EdgeForm[], 
                Polygon[{{0, 1}, {1, 0}, {0, -1}, {-1, 0}}]}], 
              GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                  PointSize[
                   Rational[7, 360]], 
                  RGBColor[0.455, 0.7, 0.21], 
                  AbsoluteThickness[2]]}], {0., 0.}, Automatic, 
             Offset[10.2]], {{{0.000295435, 6.033265306122449}}, {{
            0.000614696, 10.23404081632653}}, {{0.000924544, 
            13.00138775510204}}, {{0.00120502, 14.66934693877551}}, {{
            0.00132293, 14.94661224489796}}, {{0.00132293, 
            14.94661224489796}}, {{0.0014408499999999998`, 
            14.956530612244897`}}, {{0.00165314, 14.963918367346938`}}, {{
            0.00186316, 14.969591836734693`}}, {{0.00207034, 
            14.974326530612245`}}}]}, "Charting`Private`Tag#3"]}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PanelPlotLayout" -> <||>, 
          "PlotRange" -> {{0, 0.00207034}, {0, 15.065494195426036`}}, 
          "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0},
           "ImageSize" -> {360, 432}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> Full, "DefaultStyle" -> {
            Directive[
             PointSize[
              Rational[7, 360]], 
             RGBColor[0.455, 0.7, 0.21], 
             AbsoluteThickness[2]], 
            Directive[
             PointSize[
              Rational[7, 360]], 
             RGBColor[0.95, 0.627, 0.1425], 
             AbsoluteThickness[2]], 
            Directive[
             PointSize[
              Rational[7, 360]], 
             RGBColor[0.24, 0.6, 0.8], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              (Identity[#]& )[
               Part[#, 1]], 
              (Identity[#]& )[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          ListLinePlot, "GroupHighlight" -> False|>|>, 
       "DynamicHighlight"]], {{}, {}}}, AspectRatio -> Full, 
    Axes -> {True, True}, AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, 
    DefaultBaseStyle -> {"PlotGraphics", "Graphics"}, DisplayFunction -> 
    Identity, Frame -> {{False, False}, {False, False}}, 
    FrameLabel -> {{None, None}, {None, None}}, 
    FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
    GridLines -> {None, None}, GridLinesStyle -> Directive[
      GrayLevel[0.5, 0.4]], 
    Method -> {
     "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
        Directive[
         RGBColor[0.24, 0.6, 0.8], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.95, 0.627, 0.1425], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.455, 0.7, 0.21], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.578, 0.51, 0.85], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.772079, 0.431554, 0.102387], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.4, 0.64, 1.], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[1., 0.75, 0.], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.8, 0.4, 0.76], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.637, 0.65, 0.], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.915, 0.3325, 0.2125], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
         AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
      "RangePadding" -> Scaled[0.05], "OptimizePlotMarkers" -> True, 
      "IncludeHighlighting" -> Automatic, "HighlightStyle" -> Automatic, 
      "OptimizePlotMarkers" -> True, "IncludeHighlighting" -> "CurrentSet", 
      "HighlightStyle" -> Automatic, "OptimizePlotMarkers" -> True, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}}, PlotInteractivity :> True, 
    PlotRange -> {{0, 0.00207034}, {0, 15.065494195426036`}}, 
    PlotRangeClipping -> True, PlotRangePadding -> {{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.02], 
       Scaled[0.05]}}, Ticks -> {Automatic, Automatic}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"ArcLength\"", "\"Controled Displacement\"", 
       "\"Souza Neto Controled Displacement\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.24, 0.6, 0.8], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.24, 0.6, 0.8], 
                    AbsoluteThickness[2]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    DiskBox[{0, 0}]}, {DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.24, 0.6, 0.8], 
                    AbsoluteThickness[2]]}, PlotRangePadding -> 
                    Scaled[0.15]}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.95, 0.627, 0.1425], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.95, 0.627, 0.1425], 
                    AbsoluteThickness[2]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}, {
                    DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.95, 0.627, 0.1425], 
                    AbsoluteThickness[2]]}, PlotRangePadding -> 
                    Scaled[0.15]}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.455, 0.7, 0.21], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.455, 0.7, 0.21], 
                    AbsoluteThickness[2]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[{{0, 1}, {1, 0}, {0, -1}, {-1, 0}}]}, {
                    DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.455, 0.7, 0.21], 
                    AbsoluteThickness[2]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), Editable -> True, 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["7", "360"], "]"}], ",", 
                   
                   TemplateBox[<|"color" -> RGBColor[0.24, 0.6, 0.8]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["7", "360"], "]"}], ",", 
                   
                   TemplateBox[<|"color" -> RGBColor[0.95, 0.627, 0.1425]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["7", "360"], "]"}], ",", 
                   
                   TemplateBox[<|"color" -> RGBColor[0.455, 0.7, 0.21]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    EdgeForm[], 
                    DiskBox[{0, 0}]}, PlotRangePadding -> Scaled[0.15]], ",", 
                    
                    RowBox[{"Offset", "[", "10.976`", "]"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}, 
                    PlotRangePadding -> Scaled[0.15]], ",", 
                    RowBox[{"Offset", "[", "10.5`", "]"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[{{0, 1}, {1, 0}, {0, -1}, {-1, 0}}]}], ",", 
                    RowBox[{"Offset", "[", "10.2`", "]"}]}], "}"}]}], "}"}]}],
            ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.974460259314013*^9, 3.9744602931047564`*^9}, 
   3.9744611557060423`*^9, 3.974624546083336*^9, 3.9747905909868097`*^9, {
   3.974790628125106*^9, 3.974790644707581*^9}, {3.974790699668086*^9, 
   3.974790724554138*^9}, 3.974791482496128*^9, 3.974798822840366*^9},
 CellLabel->
  "Out[863]=",ExpressionUUID->"eaafa7ed-3dd6-481e-bd29-8b890add4434"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"isol", "=", "8"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"soluu", "=", 
     RowBox[{"solsvec", "[", 
      RowBox[{"[", "isol", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m", "=", "emesh"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabx", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"soluu", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"i", " ", "2"}], "-", "1"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"Length", "[", "meshnodes", "]"}]}], "}"}]}], "]"}], 
      "]"}]}], ";"}], "\n", 
   RowBox[{"ufun", "=", 
    RowBox[{"ElementMeshInterpolation", "[", 
     RowBox[{
      RowBox[{"{", "m", "}"}], ",", "tabx", ",", 
      RowBox[{"\"\<ExtrapolationHandler\>\"", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Function", "[", "Indeterminate", "]"}], ",", 
         RowBox[{"\"\<WarningMessage\>\"", "\[Rule]", "False"}]}], "}"}]}]}], 
     "]"}]}], "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"taby", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"soluu", "[", 
         RowBox[{"[", 
          RowBox[{"i", " ", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"Length", "[", "meshnodes", "]"}]}], "}"}]}], "]"}], 
      "]"}]}], ";"}], "\n", 
   RowBox[{"vfun", "=", 
    RowBox[{"ElementMeshInterpolation", "[", 
     RowBox[{
      RowBox[{"{", "m", "}"}], ",", "taby", ",", 
      RowBox[{"\"\<ExtrapolationHandler\>\"", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Function", "[", "Indeterminate", "]"}], ",", 
         RowBox[{"\"\<WarningMessage\>\"", "\[Rule]", "False"}]}], "}"}]}]}], 
     "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabmag", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"soluu", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"i", " ", "2"}], "-", "1"}], "]"}], "]"}], "^", "2"}], "+", 
          RowBox[{
           RowBox[{"soluu", "[", 
            RowBox[{"[", 
             RowBox[{"i", " ", "2"}], "]"}], "]"}], "^", "2"}]}], "]"}], ",", 
        
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"Length", "[", "meshnodes", "]"}]}], "}"}]}], "]"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"vfunmag", "=", 
    RowBox[{"ElementMeshInterpolation", "[", 
     RowBox[{
      RowBox[{"{", "m", "}"}], ",", "tabmag", ",", 
      RowBox[{"\"\<ExtrapolationHandler\>\"", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Function", "[", "Indeterminate", "]"}], ",", 
         RowBox[{"\"\<WarningMessage\>\"", "\[Rule]", "False"}]}], "}"}]}]}], 
     "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"vfunmag", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], "\[Element]", "m"}], ",", 
      RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
      RowBox[{"Contours", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "Full"}]}], "]"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"normepsp", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Norm", "[", 
        RowBox[{
         RowBox[{"epspsolsvec", "[", 
          RowBox[{"[", 
           RowBox[{"4", ",", "All"}], "]"}], "]"}], "[", 
         RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", 
          RowBox[{"epspsolsvec", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "All"}], "]"}], "]"}], "]"}]}], "}"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"normepsp", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"Length", "[", "meshnodes", "]"}]}], "}"}]}], "]"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", 
    RowBox[{"epspfun", "=", 
     RowBox[{
      RowBox[{"ElementMeshInterpolation", "[", 
       RowBox[{
        RowBox[{"{", "m", "}"}], ",", "tab", ",", 
        RowBox[{"\"\<ExtrapolationHandler\>\"", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Function", "[", "Indeterminate", "]"}], ",", 
           RowBox[{"\"\<WarningMessage\>\"", "\[Rule]", "False"}]}], 
          "}"}]}]}], "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Show", "[", 
       RowBox[{
        RowBox[{"ContourPlot", "[", 
         RowBox[{"epspfun", ",", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x", ",", "y"}], "}"}], "\[Element]", "m"}], ",", 
          RowBox[{"AspectRatio", "->", "Automatic"}]}], "]"}], ",", 
        RowBox[{"m", "[", "\"\<Wireframe\>\"", "]"}]}], "]"}]}]}], "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"scale", "=", "100"}], ";"}], "  ", "\n", 
   RowBox[{
    RowBox[{"dmesh", "=", 
     RowBox[{"ElementMeshDeformation", "[", 
      RowBox[{"m", ",", 
       RowBox[{"{", 
        RowBox[{"ufun", ",", "vfun"}], "}"}], ",", 
       RowBox[{"\"\<ScalingFactor\>\"", "\[Rule]", "scale"}]}], "]"}]}], 
    ";"}], "\n", 
   RowBox[{"Show", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"m", "[", "\"\<Wireframe\>\"", "]"}], ",", 
      RowBox[{"dmesh", "[", 
       RowBox[{"\"\<Wireframe\>\"", "[", 
        RowBox[{"\"\<ElementMeshDirective\>\"", "\[Rule]", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"EdgeForm", "[", 
            RowBox[{"{", 
             RowBox[{"Red", ",", "Dashed"}], "}"}], "]"}], ",", 
           RowBox[{"FaceForm", "[", "]"}]}], "]"}]}], "]"}], "]"}]}], "}"}], 
    "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"n\[OAcute]s", " ", "da", " ", "malha"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"coords", "=", 
     RowBox[{"m", "[", "\"\<Coordinates\>\"", "]"}]}], ";"}], "          ", 
   RowBox[{"(*", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x1", ",", "y1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x2", ",", "y2"}], "}"}], ",", "..."}], "}"}], "*)"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "valores", " ", "de", " ", "deslocamento", " ", "em", " ", "cada", " ", 
     "n\[OAcute]"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"uvals", "=", 
     RowBox[{"ufun", "/@", "coords"}]}], ";"}], "             ", 
   RowBox[{"(*", 
    RowBox[{"{", 
     RowBox[{"ux1", ",", "ux2", ",", "..."}], "}"}], "*)"}], "\n", 
   RowBox[{
    RowBox[{"vvals", "=", 
     RowBox[{"vfun", "/@", "coords"}]}], ";"}], "             ", 
   RowBox[{"(*", 
    RowBox[{"{", 
     RowBox[{"uy1", ",", "uy2", ",", "..."}], "}"}], "*)"}], "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"disp", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"uvals", ",", "vvals"}], "}"}], "]"}]}], ";"}], "  ", 
   RowBox[{"(*", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ux1", ",", "uy1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ux2", ",", "uy2"}], "}"}], ",", "..."}], "}"}], "*)"}], "\n", 
   "\[IndentingNewLine]", "                       ", 
   RowBox[{"(*", 
    RowBox[{"fator", " ", "pra", " ", "alongar", " ", "as", " ", "setas"}], 
    "*)"}], "\n", 
   RowBox[{
    RowBox[{"scale", "=", "100"}], ";"}], "  ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vecPlot", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Opacity", "[", "1", "]"}], ",", 
         RowBox[{"Arrowheads", "[", "0.012", "]"}], ",", 
         RowBox[{"Arrow", "/@", 
          RowBox[{"Thread", "[", 
           RowBox[{"{", 
            RowBox[{"coords", ",", 
             RowBox[{"coords", "+", 
              RowBox[{"scale", " ", "disp"}]}]}], "}"}], "]"}]}]}], "}"}], ",", 
       RowBox[{"PlotRange", "->", "All"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"m", "[", "\"\<Wireframe\>\"", "]"}], ",", "vecPlot"}], "}"}], 
     ",", 
     RowBox[{"AspectRatio", "->", "Automatic"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.974790791931038*^9, 3.9747908005715637`*^9}},
 CellLabel->
  "In[864]:=",ExpressionUUID->"f1f8a0ae-101e-4807-847b-991799431cde"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox["InterpolatingFunction",
    "SummaryHead"], "[", 
   DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
    
    TemplateBox[{
      PaneSelectorBox[{False -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource["FEBitmaps", "SummaryBoxOpener"]], 
              ButtonFunction :> (Typeset`open$$ = True), Appearance -> None, 
              BaseStyle -> {}, Evaluator -> Automatic, Method -> 
              "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}]], 
            GraphicsBox[{{
               GrayLevel[0.6], 
               AbsolutePointSize[5], 
               PointBox[{1, 1}], 
               PointBox[{2, 4}], 
               PointBox[{3, 2}], 
               PointBox[{4, 3}]}, {{}, {}, {
                AbsoluteThickness[1], 
                Opacity[1.], 
                LineBox[CompressedData["
1:eJwBMQPO/CFib1JlAgAAADIAAAACAAAA4ScLwZmZ6T/ACPskWpOYv4AjHgZ5
3Os/cnpQh5xu1j/qWn1XCVDuP5K7ih5ptuc/r+pongFN8D/CUK87BHLxP46d
cUQ/bPE/ujUa8/qu9j9TbqBw1aPyP/TWyyAhFfw/neDJZqDG8z+QAqdF9GsA
QM1wGePDAfU/VsVD/9nXAkCidscSKDf2P6Bp73exDQVA/B1wDMFX9z+TpM3k
wfUGQDzjPoyykPg/7M3Z+O7ZCEABSgjW2LT5P3pl9LwNcgpAbCYw0z/T+j86
ypori9cLQL0gflb/Cfw/lpOs9xIqDUCTvMaj8yv9Pw4alcoYNg5AT3Y1d0Bm
/j+pB2LLtyIPQLClAv7Nmv8/NnA5bbjSD0BLO2UnSF0AQFrcILXmpw9AsTLc
klX5AED+sDHBQukOQNp6UGP9igFAbZ+lR/sLDkD10dd20SgCQNHi3Mj38wxA
42MO5MXDAkAZdr6AZb8LQJRGQrZUVANArv7zEMKHCkA4OInLD/EDQLBlMO3M
IglAnnrNRWWDBEA3d8OX6skHQNf3wBnbEgVAD3D3ndNyBkADhMcwfa4FQHOK
7Wak/wRA8WDLrLk/BkC/MhCgYawDQNJM4msi3QZAwss/TmVLAkCGc6iEq3cH
QIsIg92+BgFA/OprAs8HCECrPCvgePD/P2VxQsMepAhAKXVLE0Xg/j+RSBbp
CDYJQPRz0a7WJ/4/kFqZaBPFCUDN4sX5uLj9P4J7LytKYApAvh1MbRmT/T82
7cJSG/EKQHzT1YZwwv0/3W1pvRiOC0B2LZ/10lT+P0c/DY2wIAxAVrX8MJA7
/z+DS2C2aLAMQElWzbMzPQBAsmbGIk1MDUCi9bAadCABQKTSKfTL3Q1AYexd
q+EpAkCJTaAId3sOQFyS/ndEhgNAQAPGdkIWD0BHWcLdahwFQLoJ6Umopg9A
vd1CiejSBkCTjw8wnSEQQPiVkXD08QhAq0KpbbNqEEBsk2Azxi4LQCyTGthZ
shBAYCBYjj+gDUAnaxVkFgARQMwfdA9ySBBAg+uOIqBIEUBj/5rHgMsRQNFn
q5SZmRFAL++xNeOlE0Dwt3AR
                 "]]}}}, AspectRatio -> 1, Axes -> False, Background -> 
             GrayLevel[0.93], Frame -> True, FrameStyle -> Directive[
               GrayLevel[0.7], 
               Thickness[Tiny]], FrameTicks -> None, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}], PlotRange -> {{0, 5}, {0, 5}}], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "5.`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "5.`"}], "}"}]}], "}"}], 
                  "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"scalar\"", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}], True -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource["FEBitmaps", "SummaryBoxCloser"]], 
              ButtonFunction :> (Typeset`open$$ = False), Appearance -> None, 
              BaseStyle -> {}, Evaluator -> Automatic, Method -> 
              "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}]], 
            GraphicsBox[{{
               GrayLevel[0.6], 
               AbsolutePointSize[5], 
               PointBox[{1, 1}], 
               PointBox[{2, 4}], 
               PointBox[{3, 2}], 
               PointBox[{4, 3}]}, {{}, {}, {
                AbsoluteThickness[1], 
                Opacity[1.], 
                LineBox[CompressedData["
1:eJwBMQPO/CFib1JlAgAAADIAAAACAAAA4ScLwZmZ6T/ACPskWpOYv4AjHgZ5
3Os/cnpQh5xu1j/qWn1XCVDuP5K7ih5ptuc/r+pongFN8D/CUK87BHLxP46d
cUQ/bPE/ujUa8/qu9j9TbqBw1aPyP/TWyyAhFfw/neDJZqDG8z+QAqdF9GsA
QM1wGePDAfU/VsVD/9nXAkCidscSKDf2P6Bp73exDQVA/B1wDMFX9z+TpM3k
wfUGQDzjPoyykPg/7M3Z+O7ZCEABSgjW2LT5P3pl9LwNcgpAbCYw0z/T+j86
ypori9cLQL0gflb/Cfw/lpOs9xIqDUCTvMaj8yv9Pw4alcoYNg5AT3Y1d0Bm
/j+pB2LLtyIPQLClAv7Nmv8/NnA5bbjSD0BLO2UnSF0AQFrcILXmpw9AsTLc
klX5AED+sDHBQukOQNp6UGP9igFAbZ+lR/sLDkD10dd20SgCQNHi3Mj38wxA
42MO5MXDAkAZdr6AZb8LQJRGQrZUVANArv7zEMKHCkA4OInLD/EDQLBlMO3M
IglAnnrNRWWDBEA3d8OX6skHQNf3wBnbEgVAD3D3ndNyBkADhMcwfa4FQHOK
7Wak/wRA8WDLrLk/BkC/MhCgYawDQNJM4msi3QZAwss/TmVLAkCGc6iEq3cH
QIsIg92+BgFA/OprAs8HCECrPCvgePD/P2VxQsMepAhAKXVLE0Xg/j+RSBbp
CDYJQPRz0a7WJ/4/kFqZaBPFCUDN4sX5uLj9P4J7LytKYApAvh1MbRmT/T82
7cJSG/EKQHzT1YZwwv0/3W1pvRiOC0B2LZ/10lT+P0c/DY2wIAxAVrX8MJA7
/z+DS2C2aLAMQElWzbMzPQBAsmbGIk1MDUCi9bAadCABQKTSKfTL3Q1AYexd
q+EpAkCJTaAId3sOQFyS/ndEhgNAQAPGdkIWD0BHWcLdahwFQLoJ6Umopg9A
vd1CiejSBkCTjw8wnSEQQPiVkXD08QhAq0KpbbNqEEBsk2Azxi4LQCyTGthZ
shBAYCBYjj+gDUAnaxVkFgARQMwfdA9ySBBAg+uOIqBIEUBj/5rHgMsRQNFn
q5SZmRFAL++xNeOlE0Dwt3AR
                 "]]}}}, AspectRatio -> 1, Axes -> False, Background -> 
             GrayLevel[0.93], Frame -> True, FrameStyle -> Directive[
               GrayLevel[0.7], 
               Thickness[Tiny]], FrameTicks -> None, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}], PlotRange -> {{0, 5}, {0, 5}}], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "5.`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "5.`"}], "}"}]}], "}"}], 
                  "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"scalar\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["2", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"Unstructured\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["False", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}]}, 
       Dynamic[Typeset`open$$], ImageSize -> Automatic]},
     "SummaryPanel"],
    DynamicModuleValues:>{}], "]"}],
  InterpolatingFunction[{{0., 5.}, {0., 5.}}, {
   5, 4224, 0, {622, 0}, {3, 0}, 0, 0, 0, 0, Indeterminate& , {}, {}, False}, {
    NDSolve`FEM`ElementMesh[CompressedData["
1:eJxlenc8l+/3v73H63XfUigl7VB2JOeUoghtUoqMShqKykhSpCLaKSQNoxLZ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     "], {
      NDSolve`FEM`TriangleElement[CompressedData["
1:eJwtmXfcj+UXx+/rRio7ipBN9uaJkr2TnaTskRFFj5KQlsw2LfKraO9opz1I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       "]]}, {
      NDSolve`FEM`LineElement[CompressedData["
1:eJwtkT0rxWEYxu/7Ud7K6KQYvNWZTCYDETkpFgOKk4NEh4NNGWQw+AAGk6J8
CLvxpCizbyK/q+s//Lqu576e93vi8HLzokREHXrgDE6hTfEI3YdF/CQ6Bn0Z
cYWeay71AfQJXqjfoLtQo76B3sEP9Sn0EbowXJ01TX08nM2m96jBX5XrvN50
TWtG0udrzSe+g95Dh7NW0FVl+GX0AT6Ys4C+wjN+EO2H23Su7D2dK1tK53rP
G349/IZuem/t+51+h7Iv/Ba6Db/pt2o8VFzTX4wW31H3q+Ob4T+dw++FxzPF
f6bxPL6FXkMD30ZPoFXcB2VrxTX1oFk8Vz07KFXfYKe4P/qjY/w//vEr3Q==

       "], {1, 2, 5, 4, 3, 2, 2, 2, 5, 2, 5, 5, 5, 2, 3, 3, 3, 3, 3, 3, 3, 3, 
       2, 3, 2, 2, 2, 2, 3, 2, 2, 2, 1, 4, 1, 4, 1, 4, 3}]}, {
      NDSolve`FEM`PointElement[CompressedData["
1:eJwNz7tKggEAgNFfh8ygUQlq0BScnJwcDEUxBHVwUKHEG5F4qy1wiIaGHsDB
KSjoIdwbJShw7k2iM5z9+5Kju9YyHARBkxCHRDkiRpwzEpyTIsMFZSpUqdOg
TYcrrunRZ8CYWyZMmTFnwT0PrHjimRfWbHhnxx8HQiOckCZHiUdeeeODLZ/s
+OKbH/b8cmw8zikJMmTJU6DIJTW69Bgw5IYpMxb8A7crH1U=
       "], {3, 3, 3, 3, 3, 7, 2, 3, 2, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 5, 
       1, 2, 4, 6, 4, 1, 8, 3, 4, 1, 2, 2, 3, 3, 2, 3, 3, 2, 3, 3, 3, 3, 3, 2,
        3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 3, 2, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 1, 
       1, 4, 4, 4, 1, 3, 1, 4, 3}]}]}, CompressedData["
1:eJxlV3c81e37R0ZWHHtzHNlkZGSct3GWczjnEJWGUSktKykapFTG09JQSmVW
VslqJ1tCkZRUpBQlkmSU3/nj93j++N7/fF6f+7ru9+u+r/m+iGtDvYL4+fj4
QgT4+HSr+jw69dgo5OoP5lWysLBRbUSnlItci+tnLq7wxOZ+54frVnDx1/Tq
oSN0d7gHk7qYv7whHmT0WYPhAS0S12DRCzc8NIpqkplhgquy5mDMcTbcmMdu
VtOWI3X1uH7xjBu6glYRFHOM8ObQhy3ZQsDxNXxeW6oV8Hub36KBx5J4VVn1
tDPSBJfkjH2FM0wRqiNofcTCCaJX624vyFLFtM/alOPvNLBWpD0ifIQEIbl3
zNHrZkj6kqlZ3a6Be2KtU4kycthVWfaY7KYCvv9fP63zH1yiDZBLN0yqMXol
Meohc2dZ1wj5X/m98arXdx98IZuErVSIaZOaO6dStnmN7aAsAhRitjKDJeBe
Z0AuqFGEIkO4cn63IrTFfC7HOGqh3WR81YiCCq78LprOZ/NBYIdTBWMtP1bf
sjeP2awH7+3+rQwVJWTbrPJ/e8cNUqe02hUoHmhrHLdLi/DAvagjYfUqHKyb
ig33s/WAhExWDt2EBRVvEdGiFRykrbogl6vARaZr5VFlSTbWRj6dXDHCwbbh
jfJBolwE9hi7xzPZmHfrieyvcgY8q6XChp4wYNqV/UF4BQ2OuWN2bEcqLgSt
FjYwouFxU/RNv0IqIgTL8k44UxFv3NHoL0wDf8yv2B3rafBuJU7I8btC9KhA
Y84/jmiZff6idqsz4qZm+zIvOCPzA+XsfgkKbiolJ/hVUGBS/f2E1agrHlwZ
qe2a5wrf2I9fFp1wmbPjv+tlkde8l3GLEF3q86PD0gINJd7SVYlukCnYNP22
mI4hLXlXWX435Ifp7tRpoqJq2oNE3MJAaan+pjin/8VrmowuHc4zR2vn+HP+
F4uhvGLbuR2xdv+j9++Ke6QetecVcU6+UzH574dpNejuft1tcU8RkyECoq1l
C+fkf+LiUwL8FbFEuWdkUTsRleb+hO5S+//Bb3MuiD1uKza3P6JOHd7+Qnru
v4lsG1qhbYCUdL+lwQ2ayLs/NdrkZzAnf5gmNPXnmgqsDjdMZ7qaw9+02v7j
LlukZYg+IzkZIZ+PHBggaIK6U5dDykRUMXAmtOR+gQaie1PCpGcc4C5p2u4d
ZjKHV/+46kuBtSXqeuq3aP8gY+LLP09yI1zB0d/Yc03ABc4ae83OHKLO6TeW
jgUfI1EgGtWWs3KIgpDiZNPJYzaIn5TsDPW1heaOZNx+R4P7ATH5W/rAPerd
IQU/FzQZtRBlGikYKZQryxKgYtaF8nPoKBV+M0E9GevokC+4n25Yx8Tp9Z6n
n0dQoLj/tmrEDibkCHGrvRpYODySsVgtloOPgtbCUr1MvBefKdCaZEJaxJ9i
me8xdz8FXU4+t4wAZ4qwtH+0My5zh8wOf2LgHAfDoRpsVDiregVGu8IuWU7L
WYGBPfXOtQoBHpiNsv89FcdB2YTRzy1lRrD7GFLtcZqLt1YdNTe9PWHxR24q
9DcXqvtTBDP+4YI0SMwafuoG2bO/J9Ii3WG44p1PoiYXYnt/3hB+TMeSifx+
T0uARh4QfFUhC7U9p2v+1Mqje0w/bm8zAe4ZpK8mU04wvUzOHxF0RRzfBfFs
TydsPNvgFVJEgoeGb3AgRRYFF9QZ2hnqWChtOMG4zEXOPnI5YykXFv4/gg8F
c7Em6HOvXI09JPhkc9zOLYZxwP224xk2uKJdPKZUQMHqa50a/VudsL4lpPlu
JwX0o+KVo3YcBB7yE/Kcz0FGtpQfeYKLEsMDGV6bPWFSmNQ0PsTF62nv3gU7
CUhdvO320mASGN/eB6TJD5PvUSLrhHT5QZAny9Q5fCNH6tdub/DXRnFP3EiL
tiHYAR2XVWq1EOJ3dfzFgQmyVAlfvNC4ENoeCcbnac6SzVTjJEtuaqFMVc6b
IEyCd1Ny21FJ2Tn