(* ::Package:: *)

<<NumericalDifferentialEquationAnalysis`
<<NDSolve`FEM`
SetDirectory[NotebookDirectory[]]
ComputeKG[subst_]:=Block[{K,G,young,nu},
{young,nu}=subst;
K=young/(3(1-2nu));
G=young/(2(1+nu));
{K,G}
]
XX=1;XY=2;XZ=3;YY=4;YZ=5;ZZ=6;
Cmat=Table[0,{6},{6}];
Cmatrix[subst_]:=Block[{Cmat=Table[0,{6},{6}],c1,c2,c12,K,G,young,nu},
{K,G}=ComputeKG[subst];
c1=(4 G)/3+K;
c12=-((2 G)/3)+K;
c2=G;
Cmat[[XX,XX]]=c1;Cmat[[XX,YY]]=c12;Cmat[[XX,ZZ]]=c12;
Cmat[[YY,XX]]=c12;Cmat[[YY,YY]]=c1;Cmat[[YY,ZZ]]=c12;
Cmat[[ZZ,XX]]=c12;Cmat[[ZZ,YY]]=c12;Cmat[[ZZ,ZZ]]=c1;
Cmat[[XY,XY]]=c2;Cmat[[XZ,XZ]]=c2;Cmat[[YZ,YZ]]=c2;
Return[Cmat]
]
FromVoigtToCart[v_]:={{v[[XX]],v[[XY]],v[[XZ]]},{v[[XY]],v[[YY]],v[[YZ]]},{v[[XZ]],v[[YZ]],v[[ZZ]]}};
FromCartToVoigt[T_]:={T[[1,1]],T[[1,2]],T[[1,3]],T[[2,2]],T[[2,3]],T[[3,3]]};
FromCartToVoigtEps[T_]:={T[[1,1]],2T[[1,2]],2T[[1,3]],T[[2,2]],2T[[2,3]],T[[3,3]]};
EBasis[k_]:=Switch[k,
XX,{{1,0,0},{0,0,0},{0,0,0}},
XY,{{0,1,0},{1,0,0},{0,0,0}},
XZ,{{0,0,1},{0,0,0},{1,0,0}},
YY,{{0,0,0},{0,1,0},{0,0,0}},
YZ,{{0,0,0},{0,0,1},{0,1,0}},
ZZ,{{0,0,0},{0,0,0},{0,0,1}}
];
EigenSystem[m_]:=Block[{epstprincipalvals,epstprincipaldir,orderedvalues,index,oderedvectors,cart},
cart=FromVoigtToCart[m];
{epstprincipalvals,epstprincipaldir}=Eigensystem[cart];
orderedvalues=Sort[epstprincipalvals,Greater];
index=Table[Position[epstprincipalvals,orderedvalues[[i]]],{i,1,3}]//Flatten;
oderedvectors=Table[epstprincipaldir[[index[[i]]]],{i,1,3}];
{orderedvalues,oderedvectors}
]
Cep[K_,G_]:={{K+4G/3,K-2G/3,K-2G/3},{K-2G/3,K+4G/3,K-2G/3},{K-2G/3,K-2G/3,K+4G/3}};
InverseCep[K_,G_]:={{(G+3 K)/(9 G K),-(1/(6 G))+1/(9 K),-(1/(6 G))+1/(9 K)},{-(1/(6 G))+1/(9 K),(G+3 K)/(9 G K),-(1/(6 G))+1/(9 K)},{-(1/(6 G))+1/(9 K),-(1/(6 G))+1/(9 K),(G+3 K)/(9 G K)}}
Rot=\!\(\*
TagBox[
RowBox[{"(", "", GridBox[{
{
FractionBox["1", 
SqrtBox["3"]], 
FractionBox["1", 
SqrtBox["3"]], 
FractionBox["1", 
SqrtBox["3"]]},
{
SqrtBox[
FractionBox["2", "3"]], 
RowBox[{"-", 
FractionBox["1", 
SqrtBox["6"]]}], 
RowBox[{"-", 
FractionBox["1", 
SqrtBox["6"]]}]},
{"0", 
FractionBox["1", 
SqrtBox["2"]], 
RowBox[{"-", 
FractionBox["1", 
SqrtBox["2"]]}]}
},
GridBoxAlignment->{"Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
GridBoxSpacings->{"Columns" -> {Offset[0.27999999999999997`], {Offset[0.7]}, Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {Offset[0.2], {Offset[0.4]}, Offset[0.2]}, "RowsIndexed" -> {}}], "", ")"}],
Function[BoxForm`e$, MatrixForm[BoxForm`e$]]]\);
HW[{xi_,rho_,beta_}]:=Block[{sig1,sig2,sig3},
sig1=xi /Sqrt[3]+Sqrt[2/3]rho Cos[beta];
sig2=xi/Sqrt[3] +Sqrt[2/3]rho Cos[beta-2Pi/3];
sig3=xi/Sqrt[3] +Sqrt[2/3] rho Cos[beta+2Pi/3];
{sig1,sig2,sig3}
];
HWSpherical[{xi_,theta_,beta_}]:=Block[{sig1,sig2,sig3},
{sig1,sig2,sig3}={xi/Sqrt[3]+Sqrt[2/3] xi Cos[beta] Tan[theta],
xi/Sqrt[3]-(xi Cos[beta] Tan[theta])/Sqrt[6]+(xi Sin[beta] Tan[theta])/Sqrt[2],
xi/Sqrt[3]-(xi Cos[beta] Tan[theta])/Sqrt[6]-(xi Sin[beta] Tan[theta])/Sqrt[2]};
{sig1,sig2,sig3}
];
HWCart[xi_,rho_,beta_]:=Block[{sig1star,sig2star,sig3star},
sig1star=xi;
sig2star=rho Cos[beta];
sig3star=rho Sin[beta];
{sig1star,sig2star,sig3star}
]
HWCartSpherical[xi_,theta_,beta_]:=Block[{sig1star,sig2star,sig3star},
sig1star=xi;
sig2star=xi Tan[theta] Cos[beta];
sig3star=xi Tan[theta]  Sin[beta];
{sig1star,sig2star,sig3star}
]

ComputeDist[{xi_,rho_,beta_}]:=Block[{parametric,parametrictrial,Rot,EM,diff,distf1,distsqr},
Rot=\!\(\*
TagBox[
RowBox[{"(", "", GridBox[{
{
FractionBox["1", 
SqrtBox["3"]], 
FractionBox["1", 
SqrtBox["3"]], 
FractionBox["1", 
SqrtBox["3"]]},
{
SqrtBox[
FractionBox["2", "3"]], 
RowBox[{"-", 
FractionBox["1", 
SqrtBox["6"]]}], 
RowBox[{"-", 
FractionBox["1", 
SqrtBox["6"]]}]},
{"0", 
FractionBox["1", 
SqrtBox["2"]], 
RowBox[{"-", 
FractionBox["1", 
SqrtBox["2"]]}]}
},
GridBoxAlignment->{"Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
GridBoxSpacings->{"Columns" -> {Offset[0.27999999999999997`], {Offset[0.7]}, Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {Offset[0.2], {Offset[0.4]}, Offset[0.2]}, "RowsIndexed" -> {}}], "", ")"}],
Function[BoxForm`e$, MatrixForm[BoxForm`e$]]]\);
parametric=HWCart[xi,rho,beta];
parametrictrial=Rot . {s1,s2,s3};
EM={{1/(3K),0,0},{0,1/(2G),0},{0,0,1/(2G)}};
diff=(parametrictrial-parametric);
distf1= (diff . EM . diff);
distf1
]
J2[{s1_,s2_,s3_}]:=1/3 (s1^2+s2^2-s2 s3+s3^2-s1 (s2+s3))
I1[{s1_,s2_,s3_}]:=s1+s2+s3
eqs={
sig1star==xi,
sig2star==rho Cos[beta],
sig3star==rho Sin[beta],
sig1==xi /Sqrt[3]+Sqrt[2/3]rho Cos[beta],
sig2==xi/Sqrt[3] +Sqrt[2/3]rho Cos[beta-2Pi/3],
sig3==xi/Sqrt[3] +Sqrt[2/3] rho Cos[beta+2Pi/3]}/.rho->xi Tan[theta];
Solve[eqs,{sig1,sig2,sig3,xi,theta,beta}];
ClearAll[ComputeResJac];

ComputeResJac[dist_, vars_List] := Block[{res, Jac},
  res = Table[D[dist, vars[[i]]], {i, Length[vars]}];
  Jac = Table[D[res[[i]], vars[[j]]],{i, Length[vars]}, {j, Length[vars]}];
  {res, Jac}
];

(* varsAndRange = {
     {xi,   xiMin,   xiMax,   dxi},
     {beta, betaMin, betaMax, dbeta},
     {\[Alpha],    \[Alpha]Min,    \[Alpha]Max,    d\[Alpha]}
   } *)

InitialGuess[distFun_, str_,varsAndRange_] := Block[
  {vars, ranges, gridPoints, data, bestRow},

  (* vari\[AAcute]veis: {xi, beta, \[Alpha]} *)
  vars   = varsAndRange[[All, 1]];
  (* { {min,max,step}, ... } *)
  ranges = varsAndRange[[All, {2, 3, 4}]];

  (* grade de pontos *)
  gridPoints = Tuples[Range @@@ ranges];

  (* avalia distnum em cada ponto *)
  data = Table[
    {distFun[str,vars] /. Thread[vars -> pt], pt},
    {pt, gridPoints}
  ];

  (* pega o ponto com menor dist *)
  bestRow = First @ MinimalBy[data, First];

  (* devolve apenas os valores das vari\[AAcute]veis *)
  bestRow[[2]]
];

NewtonRaphson[sigVals_,\[Alpha]n_,resFun_, jacFun_, x0_,verbose_:True] :=
 Block[{xn = x0, x, iter = 1, resv, JacEval, normres = Infinity, maxiter= 30, tol=10^-6},
    resv    = resFun[sigVals,\[Alpha]n, xn];
   JacEval = jacFun [sigVals, \[Alpha]n,xn];

  While[iter < maxiter && normres > tol,
   resv    = resFun[sigVals,\[Alpha]n, xn];
   JacEval = jacFun [sigVals, \[Alpha]n,xn];
   normres = Norm[resv];
   If[verbose,
   Print[
     "Iter ", iter,
     "  Norm[res] = ", normres,
     "  xn = ", xn
   ];
   ];
   x= xn - LinearSolve[JacEval, resv];
   xn = x;
   iter++;
   ];
   xn
];
ComputedDep[sigPproj_,EpsPtr_,Dproj_,EigenVecs_,subst_]:=Block[{Cmat,sij,sji,colA,colR,fac,Sij,Dep,icol,\[Delta]E,i,j,K,G,R,projii,projjj,tempmat,depstr,dsigproj},
{K,G}=ComputeKG[subst];
Dep=Table[0,{6}];
R=Table[0,{6},{6}];
Cmat=Cmatrix[subst];

For[icol=1,icol<=6,icol++,
\[Delta]E=EBasis[icol];
colA=Table[0,{6}];
colR=Table[0,{6}];
For[i=1,i<=3,i++,
For[j=1,j<=3,j++,
projii=FromCartToVoigt[Outer[Times,EigenVecs[[i]],EigenVecs[[i]]]];
projjj=FromCartToVoigtEps[Outer[Times,EigenVecs[[j]],EigenVecs[[j]]]];
tempmat=Outer[Times,projii,projjj];
tempmat=((Dproj[[i,j]]tempmat) . Cmat) . FromCartToVoigt[\[Delta]E];
colA+=tempmat;
If[j<=i,Continue[];];
depstr=(EpsPtr[[i]]-EpsPtr[[j]]);
dsigproj=(sigPproj[[i]]-sigPproj[[j]]) ;
If[(Abs[depstr])<10^-15,
fac=G (Dproj[[i,i]]-Dproj[[i,j]]-Dproj[[j,i]]+Dproj[[j,j]]);
,
fac=dsigproj/depstr;
];
Sij=1/2(Outer[Times,EigenVecs[[i]],EigenVecs[[j]]]+Outer[Times,EigenVecs[[j]],EigenVecs[[i]]]);
sij=FromCartToVoigt[Sij];
sji=FromCartToVoigt[Sij];
tempmat=Outer[Times,sij,sji];
colR+=2fac tempmat . FromCartToVoigt[\[Delta]E];
];
];
Dep[[icol]]=colA;
R[[icol]]=colR;
];
Dep+=R;
Dep
];

