# Reproducibility package (Communications Physics submission)

This folder contains:

- `main.tex` / `refs.bib` / `main.bbl`: LaTeX source of the manuscript.
- `main.pdf`: compiled manuscript PDF (figures embedded).
- `fig*.pdf`: figure files used by `main.tex`.
- `generate_figures.ipynb`: **Supplementary Software 1** (Jupyter notebook) that reproduces all figures.
- `requirements.txt`: minimal Python dependency list (tested versions).

## Reproducing the figures

1. Create a clean Python environment (e.g., `python -m venv venv`) and install dependencies:

   `pip install -r requirements.txt`

2. Open and run the notebook top-to-bottom:

   `jupyter notebook generate_figures.ipynb`

The notebook writes the figure PDFs (`fig1_...pdf` through `fig17_...pdf`) to the working directory.

## Compiling the manuscript

Compile twice to resolve cross-references:

- `pdflatex main.tex`
- `pdflatex main.tex`

(If you modify `refs.bib`, run BibTeX as usual.)
