c
c.... Program Tfpickproc.f
c.... --------------------
c.... By Adrian Nankivell , BAS and University of Oxford
c....
c....
c....

      implicit none
c
      integer lpl, ltfpk, ldt, lpr
      integer ios, lunsc, iter, npoles
      integer totpicks, ma, na


      character * 2  ch_iter
      character * 6  pairid
      character * 40 direc
      character * 80 openfile

c....  max # poles
      parameter (  lpl = 40 ) 

c....  # params to solve for. 
      parameter (  lpr = 3 * lpl )

c....  max # tf data points
      parameter (  ltfpk = 200 )

c....  # data points: 
      parameter (  ldt = 5000 )

c....  logical unit number for small circle plot output
      parameter (  lunsc = 2 ) 

c --------------- declare arrays -----------------


c....   Finite rotation poles (lat,lon,angle )
      double precision FPOLES(lpl,3)
c....   Anomaly ID for finite rotation poles 
      character*4 IDPOL(lpl)

c....   Lat./lon. of set of tf picks
      double precision TFPICK(ltfpk,2)

c....   Lat./lon. of set of closest points on small circle
      double precision S(ltfpk,2)

c....   Lat./lon. of all picks
      double precision PK_LOC(ldt,2)

c....   Partial derivative matrix A, error vector B 
      double precision A(ldt,lpr), B(ldt)

c....   Weight matrix W 
      double precision W(ldt)


c....   Define data directory path
c     data direc /'/home/piglet_data2/adriann/recon/data/'/
      data direc /'data/'/

c
c --------------------- start of real code ------------------
c
      write(*, '(a)') '-- TFPICKPROC --'


c.... Determine iteration no.
c
      call strcat( direc, 'iter.dat', openfile)
      open( unit = 1, file = openfile, status = 'old',iostat=ios)

      if( ios .ne. 0 ) then

        write( 6, 10 ) openfile, ios
10      format(/,5x,'error occurred opening file : ',a80,/,
     .           5x,'iostat error code = ',i8,//)

        stop

      end if

      read( 1, 20 ) iter
20    format(20x,i2)

      close( 1 )
c
c.... convert integer iter to character ch_iter
c
      call int2char( iter, ch_iter )

c ...... open poles file

      call strcat( direc, 'poles_'//ch_iter//'.dat', openfile)
      write( 6, '(a)' ) 'opening file '//openfile

      open( unit = 1, file = openfile, status = 'old', iostat = ios )

      if( ios .ne. 0 ) then
        write( 6, 10 ) openfile, ios
        stop
      end if        
c
c.... read finite rotation poles from file
c:
c
      call readpolesfile( 1, lpl, npoles, FPOLES, IDPOL, pairid)

      close( 1 )

c
c.. .. .. .. .. open tf data file for output

      call strcat( direc, 'tfplot.dat', openfile)
      open( lunsc, file = openfile, status = 'unknown', iostat=ios )
      if( ios .ne. 0 ) then
        write( 6, 10 ) openfile, ios
        stop
      end if

      totpicks = 0

c.... Process tf pick data
c

      call tfpickproc( pairid, ltfpk, ldt, totpicks, lunsc,
     .         FPOLES(1,1), FPOLES(1,2), TFPICK, S, PK_LOC,
     .          A, B, W)

c

      write( 6, 1111 ) totpicks
1111  format(/,2x,'Total number of transform picks:- ',i4,/)


c...  Close tf data output file

      close( lunsc )


c
c.... Specify total number of picks and number of params
c
      ma = totpicks
      na = 3 * npoles


c.... OUTPUT partial derivative matrix a, error vector b and the
c.... fracture zone pick coordinates.
c
c
      write( 6, 301 ) ma, na 
301   format(/,5x,'tf partial derivative matrix dimensions ',//,
     .         5x,'m = ',i4,' n = ',i2,//)



      call strcat( direc, 'tf_a.dat', openfile)
      open( unit = 1, file = openfile, status ='unknown',iostat = ios )

      if( ios .ne. 0 ) then

        write( 6, 10 ) openfile, ios

        stop

      end if

      call writematrix( 1, ldt, lpr, ma, na , A )

      close( 1 )
c
c.... output error vector
c
c
      call strcat( direc, 'tf_b.dat', openfile)
      open( 1, file = openfile, status = 'unknown',iostat = ios )

      if( ios .ne. 0 ) then
        write( 6, 10 ) openfile, ios
        stop
      end if

      call writevector( 1, ldt, ma, B )

      close( 1 )
c
c..   output weight vector
c
      call strcat( direc, 'tf_w.dat', openfile)
      open( 1, file = openfile, status = 'unknown' ,iostat = ios )

      if( ios .ne. 0 ) then
        write( 6, 10 ) openfile, ios
        stop
      end if

      call writevector( 1, ldt, ma, W )

      close( 1 )
c
c.... output fz pick latitude, longitude data arrays as matrix
c
      call strcat( direc, 'tf_loc.dat', openfile)
      open( 1, file = openfile, status = 'unknown', iostat = ios )

      if( ios .ne. 0 ) then
        write( 6, 10 ) openfile, ios
        stop
      end if

      call writematrix( 1, ldt, 2, ma, 2, PK_LOC )

      close( 1 )

5000  stop ' ** tfpickproc finished **'

      end
