c
      subroutine x2poles2stpds(lpl, npoles, FPOLES12, FPOLES23,
     .                                                 iside, DSTDP)
c
c
c     subroutine x2poles2stpds         Aug 95          A Nankivell
c
c
c     the subroutine creates the partial derivative d(ST)i/d(P)
c     for a set of either A->B (iside=1) or B->A (iside=-1) stage poles 
c      - the first array dimension is the pole number
c      - the second array dimension is the index of the peturbed 
c            pole parameter - as follows
c
c   |            PLATE PAIR 12          |           PLATE PAIR 23           |
C   |     POLE A      |     POLE B      |     POLE A      |     POLE B      |
C   | LAT | LON | ANG | LAT | LON | ANG | LAT | LON | ANG | LAT | LON | ANG |
C   |  1  |  2  |  3  |  4  |  5  |  6  |  7  |  8  |  9  | 10  | 11  | 12  | 
c
c     - the last index represents the i'th component of Stage pole 3-vector 
c     the calculations are carried out in double precision.
c
c          all angles in degrees
c 
c
c GE: march 2013
c NB calculations here using half angles for stage poles - no changes made
c
      implicit none

      integer lpl, npoles, iside

      double precision  FPOLES12(lpl,4), FPOLES23(lpl,4)
      double precision  DSTDP(lpl,12,3)

c
      integer i, j, k

      double precision flat, flon, fang
      double precision ID(3,3)
      double precision F12A(3,3), F23A(3,3), F13A(3,3)
      double precision F12B(3,3), F23B(3,3), F13B(3,3)
      double precision H13A(3,3), H13B(3,3), ST13(3,3)
      double precision DHDp(3,3), DFDlat(3,3), DFDlon(3,3), DFDang(3,3) 
C

c.......... zero array first ..........

      do 1 i =1,npoles
        do 1 j = 1, 12
          do 1 k = 1,3
          DSTDP(i,j,k) = 0.
1     continue

      do 2 i=1,3
        do 2 j = 1,3
          ID(i,j) = 0.
          if (i .eq. j) ID(i,j) = 1.
2     continue


c........ treat first stage pole as slightly special case, as first
c            half of this stage pole is NULL rotation, and cannot change
c

   
      call pol2mat( FPOLES12(1,1), FPOLES12(1,2), 
     .                            FPOLES12(1,3) , F12B)
      call pol2mat( FPOLES23(1,1), FPOLES23(1,2), 
     .                            FPOLES23(1,3) , F23B)

      call sumrots( F12B, F23B, F13B)
      call mat2pol( F13B, flat, flon, fang)
      call pol2mat(flat, flon, dble(iside*0.5*fang), H13B)


c......... errors wrt F12B

      call pol2pdmats(FPOLES12(1,1), FPOLES12(1,2), FPOLES12(1,3),
     .                      DFDlat, DFDlon, DFDang)

      call rotnpd2scpd( DFDlat, F23B, F13B, dble(iside*0.5), DHDp)
      call stpdarraybld( lpl, 12, ID, DHDp, H13B, DSTDP, 1,4)

      call rotnpd2scpd( DFDlon, F23B, F13B, dble(iside*0.5), DHDp)
      call stpdarraybld( lpl, 12, ID, DHDp, H13B, DSTDP, 1,5)

      call rotnpd2scpd( DFDang, F23B, F13B, dble(iside*0.5), DHDp)
      call stpdarraybld( lpl, 12, ID, DHDp, H13B, DSTDP, 1,6)


      call pol2pdmats(FPOLES23(1,1), FPOLES23(1,2), FPOLES23(1,3),
     .                      DFDlat, DFDlon, DFDang)

c......... errors wrt F23B

      call rotnpd2scpd( F12B, DFDlat, F13B, dble(iside*0.5), DHDp)
      call stpdarraybld( lpl, 12, ID, DHDp, H13B, DSTDP, 1,10)

      call rotnpd2scpd( F12B, DFDlon, F13B, dble(iside*0.5), DHDp)
      call stpdarraybld( lpl, 12, ID, DHDp, H13B, DSTDP, 1,11)

      call rotnpd2scpd( F12B, DFDang, F13B, dble(iside*0.5), DHDp)
      call stpdarraybld( lpl, 12, ID, DHDp, H13B, DSTDP, 1,12)


c............ now for rest of poles

      do  10 i = 2, npoles

c.......... calculate the relevant rotation matrices F12A, F12B, F23A, F23B

        call pol2mat( FPOLES12(i-1,1), FPOLES12(i-1,2), 
     .                            FPOLES12(i-1,3) , F12A)
 
        call pol2mat( FPOLES23(i-1,1), FPOLES23(i-1,2), 
     .                            FPOLES23(i-1,3) , F23A)
 
        call pol2mat( FPOLES12(i,1), FPOLES12(i,2), 
     .                            FPOLES12(i,3) , F12B)

        call pol2mat( FPOLES23(i,1), FPOLES23(i,2), 
     .                            FPOLES23(i,3) , F23B)


c........... calculate finite rotation for third plate pair F13A
c             and associated half rotation H13A

        call sumrots( F12A, F23A, F13A)
        call mat2pol( F13A, flat, flon, fang)
        call pol2mat(flat, flon, dble(-iside*0.5*fang), H13A)

c........... calculate finite rotation for third plate pair F13B
c             and associated half rotation H13B

        call sumrots( F12B, F23B, F13B)
        call mat2pol( F13B, flat, flon, fang)
        call pol2mat(flat, flon, dble(iside*0.5*fang), H13B)

c............. calculate stage rotation matrix ST13

        call sumrots( H13A, H13B, ST13)


c........... now calculate partial derivatives - the routine rotnpd2scpd
c               calculates the pd's for the relevant half-rotation matrices
c               and stdpdarraybld adds the final touch and stores the result
c               in the correct place in the array

c......... errors wrt F12A

        call pol2pdmats(FPOLES12(i-1,1), FPOLES12(i-1,2),
     .        FPOLES12(i-1,3),  DFDlat, DFDlon, DFDang)

        call rotnpd2scpd( DFDlat, F23A, F13A, dble(-iside*0.5), DHDp)
        call stpdarraybld( lpl, 12, DHDp, H13B, ST13, DSTDP, i,1)

        call rotnpd2scpd( DFDlon, F23A, F13A, dble(-iside*0.5), DHDp)
        call stpdarraybld( lpl, 12, DHDp, H13B, ST13, DSTDP, i,2)

        call rotnpd2scpd( DFDang, F23A, F13A, dble(-iside*0.5), DHDp)
        call stpdarraybld( lpl, 12, DHDp, H13B, ST13, DSTDP, i,3)


c......... errors wrt F12B

        call pol2pdmats(FPOLES12(i,1), FPOLES12(i,2),
     .        FPOLES12(i,3),  DFDlat, DFDlon, DFDang)

        call rotnpd2scpd( DFDlat, F23B, F13B, dble(iside*0.5), DHDp)
        call stpdarraybld( lpl, 12, H13A, DHDp, ST13, DSTDP, i,4)

        call rotnpd2scpd( DFDlon, F23B, F13B, dble(iside*0.5), DHDp)
        call stpdarraybld( lpl, 12, H13A, DHDp, ST13, DSTDP, i,5)

        call rotnpd2scpd( DFDang, F23B, F13B, dble(iside*0.5), DHDp)
        call stpdarraybld( lpl, 12, H13A, DHDp, ST13, DSTDP, i,6)


c......... errors wrt F23A

      call pol2pdmats(FPOLES23(i-1,1), FPOLES23(i-1,2),
     .        FPOLES23(i-1,3),  DFDlat, DFDlon, DFDang)

        call rotnpd2scpd( F12A, DFDlat, F13A, dble(-iside*0.5), DHDp)
        call stpdarraybld( lpl, 12, DHDp, H13B, ST13, DSTDP, i,7)

        call rotnpd2scpd( F12A, DFDlon, F13A, dble(-iside*0.5), DHDp)
        call stpdarraybld( lpl, 12, DHDp, H13B, ST13, DSTDP, i,8)

        call rotnpd2scpd( F12A, DFDang, F13A, dble(-iside*0.5), DHDp)
        call stpdarraybld( lpl, 12, DHDp, H13B, ST13, DSTDP, i,9)


c......... errors wrt F23B

        call pol2pdmats(FPOLES23(i,1), FPOLES23(i,2),
     .        FPOLES23(i,3),  DFDlat, DFDlon, DFDang)

        call rotnpd2scpd( F12B, DFDlat, F13B, dble(iside*0.5), DHDp)
        call stpdarraybld( lpl, 12, H13A, DHDp, ST13, DSTDP, i,10)

        call rotnpd2scpd( F12B, DFDlon, F13B, dble(iside*0.5), DHDp)
        call stpdarraybld( lpl, 12, H13A, DHDp, ST13, DSTDP, i,11)

        call rotnpd2scpd( F12B, DFDang, F13B, dble(iside*0.5), DHDp)
        call stpdarraybld( lpl, 12, H13A, DHDp, ST13, DSTDP, i,12)



10    continue    

      return
      end
