c
c
      subroutine writematrix( iunit, mmax, nmax, m, n, MAT )
c      -----------------------------------------------
c
c      This subroutine outputs a m x n matrix MAT
c      to a file opened on unit iunit.
c      The subroutine is slightly complicated because the exact
c      number of rows and columns is uncertain. therefore,
c      a variable output format is required.
c
c      real variables are written out using an f11.6
c      format which i hope will be sufficient.
c
c
      implicit none

      integer iunit, mmax, nmax, m, n

      double precision  MAT( mmax, nmax )
c
      integer ilngth, i, j

      character * 1  aone
      character * 2  atwo
      character * 13 ofmt1
      character * 14 ofmt2
c
c----  synthesize output format
c
      call intch( n, aone, atwo, ilngth )

      if( ilngth .eq. 1 ) then
        ofmt1 = '('//aone//'(1x,f11.6))'
      else if( ilngth .eq. 2 ) then
        ofmt2 = '('//atwo//'(1x,f11.6))'
      end if

c----  output array dimensions
c
      write( iunit, 10 ) m, n
10    format(2(1x,i5))

c----  output array elements
c
      do 20 i = 1, m

        if( ilngth .eq. 1 ) then
          write( iunit, ofmt1 ) ( MAT( i, j ), j = 1, n )
        else if( ilngth .eq. 2 ) then
          write( iunit, ofmt2 ) ( MAT( i, j ), j = 1, n )
        end if

20    continue

      return
      end 
