      subroutine tfpickproc(  pairid, ltfpk, ldt, totpicks, lunsc,
     .         fplat, fplon, TFPICK, S, PK_LOC, A, B, W)

c
c   main processing routine for determination of transform fault errors
c   and partial derivatives for ALL of the transform faults in the
c   dataset of one plate pair
c
c
      implicit none
c
c .......... passed variables .........
c
      integer ltfpk, ldt, totpicks, lunsc

      double precision fplat, fplon 

      character * 6  pairid

c....   Lat./lon. of set of tf picks
      double precision TFPICK(ltfpk,2)

c....   Lat./lon. of set of closest points on small circle
      double precision S(ltfpk,2)

c....   Lat./lon. of all picks
      double precision PK_LOC(ldt,2)

c....   Partial derivative matrix A, error vector B 
      double precision A(ldt,2), B(ldt)

c....   Weight matrix W 
      double precision W(ldt)
c
c ........ variables used in subroutine ...............
c

      integer irow, iwrow, ios
      integer i, npicks

      double precision angsep, sepsum, latpdsum, lonpdsum 
      double precision alpha, dalphadplat, dalphadplon, err, sse
      double precision rlat, rlon
      double precision vangsep, vecdprod, angpdcalc

      character * 1  charin
      character * 40 direc
      character * 80 openfile


c --------------- declare arrays -----------------

c....   Instantaneous pole pd's
      double precision DPDTHETA(3), DPDPHI(3)

c....   working vectors 
      double precision P(3), V(3), PxV(3)


c....   Define data directory path
c      data direc /'/home/piglet_data2/adriann/recon/data/'/
      data direc /'data/'/

c
c --------------------- start of real code ------------------
c


c.... Set pick count "irow" , and weight count iwrow
      irow = 0
      iwrow = 0
c

      call pnt2vec( fplat, fplon, P )
      call pnt2pdvecs( fplat, fplon, DPDTHETA, DPDPHI)

	print *,' '
c
c.... Process tf pick data
c
c.... Open file containing tf groups 
c
      call strcat( direc, 'tfpicks_'//pairid//'.dat', openfile)
      print *, openfile
      open(unit = 1, file=openfile, status='old', iostat = ios )

      if( ios .ne. 0 ) then
        write( 6, 10 ) openfile, ios
10      format(/,5x,'error occurred opening file : ',a80,/,
     .           5x,'iostat error code = ',i8,//)
        stop
      end if
c


      totpicks = 0

c
c.... loop through tfs : start of loop for each tf data set              
c

100   continue

      i=1
      sepsum = 0.
      latpdsum = 0.
      lonpdsum = 0.

c... read in next line 

200       continue

c..................... check for end of tf group

		read(1,'(a1)',err=9999,end=1000) charin
		if(charin .eq. '>' ) then
		  goto 500
		else
		  backspace(1)
		endif

		read(1,*,end=1000) TFPICK(i,1), TFPICK(i,2)

		call pnt2vec(TFPICK(i,1), TFPICK(i,2), V)
		angsep = vangsep( P, V )

		sepsum = sepsum + angsep
		latpdsum = latpdsum + angpdcalc( P, V,  DPDTHETA)
		lonpdsum = lonpdsum + angpdcalc( P, V,  DPDPHI)

		i=i+1


c---------------------go to read next line

	   goto 200

c
c.....................  end of tf group - process

500	   npicks = i-1

cd          print *,'read in picks'

	   if(npicks .eq. 0) goto 100

c... determine average (best) angle alpha and respective pd's

	   alpha = sepsum / dble(npicks)

	   dalphadplat = latpdsum / dble(npicks)
	   dalphadplon = lonpdsum / dble(npicks)


c.... loop for errors and pd's

	   do 600 i = 1, npicks

		irow = irow + 1

		call pnt2vec(TFPICK(i,1), TFPICK(i,2), V)

		A( irow, 1) = dalphadplat - angpdcalc( P, V,  DPDTHETA) 
		A( irow, 2) = dalphadplon - angpdcalc( P, V,  DPDPHI) 

		err = alpha - vangsep( P, V )
		B(irow)= -err

		sse = sse + err**2

		PK_LOC(irow, 1)= TFPICK(i,1)
		PK_LOC(irow, 2)= TFPICK(i,2)


c....... in addition, for use in displaying , calculate closest points
c						 on small circle

		call vecxprod( P, V, PxV)
		call vec2pnt( PxV, rlat, rlon)
		call rotatepnt(rlat, rlon, err,
     .		  TFPICK(i,1), TFPICK(i,2), S(i,1), S(i,2) )
600	   continue

cd          print *,'calculated all errors'
c
c...   all errors and pd's calculated
c....		now write weight array

	   do 700 i = 1, npicks
		iwrow = iwrow + 1
		W(iwrow)= dsqrt(sse/dble(npicks))

700	   continue


c................. sort small circle points


	   call sortpnts( S, ltfpk, npicks)

 	   write(lunsc, '(a1)') '>'
	   do 800 i = 1, npicks
		write(lunsc,'(2(f9.4,x))') S(i,2), S(i,1)
800	   continue


c...  finished for this tf set - onto next

	   write( 6, 801 ) npicks , alpha
801	   format(5x,'Transform section - ',i4,' picks, ', f6.2,
     . ' angle of small circle from pole')


	   totpicks = totpicks + npicks

      goto 100



c............ finished reading file

1000  continue

c
c...  Close tf file
      close( 1 )

      if (irow .gt. ldt) stop ' too many tf data points'


      return

 9999 stop 'sub_tfpickproc:ERROR'
      end
