      subroutine sumrots( R1MAT, R2MAT, S)
c
c     the subroutine sums rotations R1 followed by R2 to yield an equivalent 
c     pole, S.
c     the individual rotations are latitude,
c     longitude, angle in decimal degrees.
c     the sign conventions are:
c                  latitude positive north
c                  longitude positive east
c                  angle positive in the right handed sense
c     calculations are carried out in double precision.
c
      implicit none

      double precision R1MAT(3,3), R2MAT(3,3), S(3,3)
c
      integer i, j, k
      double precision sum
c
 
      do 10 i = 1 , 3 
        do 20 j = 1 , 3 
          sum = 0.
          do 30 k = 1 ,  3 
            sum =  sum + R2MAT(i,k) * R1MAT(k,j)
30        continue
          S(i,j) = sum
20      continue
10    continue 

c
      return
      end
