c
      subroutine stpdarraybld(lpl, nppars, C, D, S, DVSDP, ipole, ipos)
c
c
c     subroutine stpdarraybld         Aug 95          A Nankivell
c
c
c     the subroutine builds the partial derivative 3-vector
c     d(VS)/d(P) where VS is the vector stage pole for the rotation
c     matrix S. One of C and D is a partial derivative matrix
c     d(R)/p(P), where P is a peturbed pole parameter
c
c     d(VS)/d(P) is a large array, lpl x nppars (x 3-vector)
c
c     the calculations are carried out in double precision.
c
c
      implicit none

      integer lpl, nppars, ipole, ipos
      double precision C(3,3), D(3,3), S(3,3)
      double precision DVSDP(lpl,nppars,3)
c
      double precision dalphadp, DSDP(3,3), DEDP(3)


      if (ipos .lt. 1 .or. ipos .gt. nppars) 
     .     stop 'building stage pds - bad pole peturb identifier'

      call sumrots( C, D, DSDP)
  
      call mats2vecpds(S, DSDP, DEDP, dalphadp)

      DVSDP(ipole,ipos,1) = DEDP(1)

      DVSDP(ipole,ipos,2) = DEDP(2)

      DVSDP(ipole,ipos,3) = DEDP(3)


      return
      end
