c
c
      subroutine std( ARRAY, nmax, n, mean, stdev )
c      ---------------------------------------------
c
c      subroutine std is designed to calculate the
c      mean and standard deviation of a series of
c      n real numbers in the ARRAY "ARRAY".
c
c
      implicit none

      integer nmax, n

      double precision  mean, stdev
      double precision ARRAY( nmax )
c
      integer i

      double precision sum
c
c----  check number of input points n
c
      if( n .gt. nmax ) then

        write( 6, 10 ) n, nmax
10      format(/,5x,'error : error occurred in subroutine std',/,
     .           5x,'number of input points ',i5,' exceeds initial',/,
     .           5x,'size of ARRAY. nmax = ',i5,/)

        stop

      end if

      if( n .lt. 2 ) then

        write( 6, 20 ) n
20      format(/,5x,'error : error occurred in subroutine std',/,
     .           5x,'number of input points ',i5,' is too few',/,
     .           5x,'for standard deviation to be determined',/)

c       stop  ->  statement removed, so inversions can be carried out
c                 with only one type of data

        mean = 0.
        stdev = 999.9
        return


      end if
c
c----  calculate mean
c
      sum = 0.0

      do 30 i = 1, n

        sum = sum + ARRAY( i )

30    continue

      mean = sum / dble( n )
c
c----  calculate standard deviation
c
      sum = 0.0

      do 40 i = 1, n

        sum = sum + ( ARRAY( i ) - mean ) ** 2

40    continue

      stdev = dsqrt( sum / dble( n - 1 ) )

      return
      end 
