c
      subroutine sortpnts( POINTS, maxpts, npts )
c
c      Routine which given a group of points, sorts them in terms
c      	of spacing from each other along an axis between
c      	the two furthest points
c
c	Written by A P Nankivell Feb '97
c
c
      implicit none
c
      integer maxpts, npts

      double precision POINTS(maxpts, 2)
c
      integer i, j, imax1, imax2

      double precision V1(3), V2(3)
      double precision sep, maxsep, sepi, sepj, templat, templon
      double precision pangsep
c

      maxsep = 0.
      do 100 i = 1, npts
        do 100 j = i+1, npts

      		sep = pangsep( POINTS(i,1), POINTS(i,2),
     .                POINTS(j,1), POINTS(j,2))

      		if ( sep .gt. maxsep )then
      			maxsep = sep
      			imax1 = i
      			imax2 = j
      		endif
100   continue


c........... have determined two most seperated points, now order rest
c  through swapping procedure

      call pnt2vec( POINTS(imax1,1), POINTS(imax1,2), V1)

      do 200 i = 1, npts-1

                sepi = pangsep(POINTS(imax1,1), POINTS(imax1,2),
     .                POINTS(i,1), POINTS(i,2) )

		do 121 j = i+1, npts

                        sepj = pangsep(POINTS(imax1,1), POINTS(imax1,2),
     .                         POINTS(j,1), POINTS(j,2) )
  

			if ( sepj .lt. sepi ) then

				templat = POINTS(i,1)
				templon = POINTS(i,2)
				POINTS(i,1) = POINTS(j,1)
				POINTS(i,2) = POINTS(j,2)
				POINTS(j,1) = templat
				POINTS(j,2) = templon

			endif

121		continue


200   continue



      return
      end
