      subroutine seedinv( lpl, npoles, spole, FPOLES, STAGE,
     .                        PICKLOCS, nvec, SEED, iside, nloops,
     .                        FLOW, DEDP, lfpk, A_S, B_S ) 
c
c written by ADRIAN NANKIVELL
c
c  Calculates the best seed for a flowline on side (iside)
c
      implicit none

      integer lpl, npoles, spole, nvec, iside, nloops, lfpk
      double precision FPOLES(lpl,3), STAGE(lpl,3)
      double precision PICKLOCS(lfpk,2)
      double precision SEED(2), FLOW(0:lpl,3), DEDP(lpl)
      double precision A_S(lfpk,1), B_S(lfpk)
c
      integer loop, nuse
      double precision radplat, radplon, resq, raddeg
      double precision d2km, dseedtot, vecdprod
      double precision OSEEDV(3), VSEED(3), NSEED(3)
      double precision STP(3), RADP(3), X(1), R(3,3)
c
      parameter ( d2km = 111.2 )
      raddeg = 0.1745329251994329D-01
c
      call pnt2vec( SEED(1), SEED(2), OSEEDV)

c......... if seed is off-axis, find zero-age seed

      if (spole .ne. 0) then

          call pol2mat(FPOLES(spole,1),FPOLES(spole,2),
     .           dble(-0.5*iside*FPOLES(spole,3)) , R)
          call rotatevec( R, OSEEDV, VSEED)
          call vec2pnt(VSEED, SEED(1), SEED(2) )
c graeme 
          write(6,*)SEED(1),SEED(2)

c......... SEED now contains zero-age seed

      endif

c......... carry out nloops iterations to find best seed


      do 8000 loop = 1,nloops

c......... calculate synthetic fz flowlines:

        call flowline( lpl, npoles, FPOLES, SEED, FLOW, iside)

c....  calculate change in errors due to a 1 degree change in (spole) seed
c....   position - radially AWAY from stage pole of pole spole+1

        call pdflowseedx( lpl, npoles, spole, FPOLES, STAGE, FLOW,
     .                                                    iside, DEDP)

c
c....   locate each pick within flowline framework, and measure error:
c....    (and build pd matrix a):
c

        call fzpickcalc_seed( lpl, npoles, spole, STAGE, FLOW, 
     .                 PICKLOCS, nvec, DEDP, lfpk, A_S, B_S, nuse)


c... if all fz picks are outside range of inversion, exit      
	if (nuse .eq. 0 ) then
          write(*, '(a)' ) '--- NO fz picks within range for seed shift'
	  go to 8001
	endif

c
c.... solve for radial perturbation of spole seed:
c

        call dqr( nuse, 1, A_S, B_S, X, resq )
        if(resq.lt.0.) stop 'bad resq'

c....
c.... X(1) holds the radial pert. to seed 
c
c...  limit X(1) to 0.05 degree ~ 5km, to avoid excessive seed shifts
c
	if( dabs(X(1)) .gt. 0.05 ) X(1) = dsign( dble(0.05), X(1) )

c......... now find new spole seed 

        call pnt2vec( STAGE(spole+1,1), STAGE(spole+1,2), STP )

        VSEED(1) = FLOW(spole,1) 
        VSEED(2) = FLOW(spole,2) 
        VSEED(3) = FLOW(spole,3) 

        call vecxprod( STP, VSEED, RADP)
        call vec2pnt( RADP, radplat, radplon)
        call pol2mat( radplat, radplon, X(1), R)

        call rotatevec( R, VSEED, NSEED)

        if ( spole .eq. 0) then

          call vec2pnt(NSEED, SEED(1), SEED(2))

        else
c............. convert change in spole seed to zero-age seed

          call pol2mat(FPOLES(spole,1),FPOLES(spole,2),
     .           dble(-0.5*iside*FPOLES(spole,3)) , R)
          call rotatevec( R, NSEED, VSEED)
          call vec2pnt(VSEED, SEED(1), SEED(2) )

        endif

8000  continue

cd       write(*,'( a, 2(x,f10.4) )') 'new zero-age seed:',
cd     .                                     SEED(1), SEED(2)

c      write(21,'(2f10.4,a)') SEED(2), SEED(1),' r'
c
c....   Determine difference in position between old and
c....   new (spole) seed points
c      
      dseedtot = dacos( vecdprod( OSEEDV, NSEED ) )/raddeg
      if ( nloops .eq. 0 ) dseedtot = 0.

      write(*,'(a,f10.4)') 'seed shift, km:', d2km * dseedtot

      if( dabs( dseedtot ) .ge. 0.25 ) then
         write(*,'(a,f10.4)') '$$ warning: total seed pert.',dseedtot
      endif

8001  return
      end
