c
      subroutine rotnpd2scpd(MA, MB, S, scale, DCDp)
c
c ... A rotation S is the sum of two rotations A and B. The matrix C
c     is the same lat/lon pole as S, but with a scaled angle of rotation,
c     such as x0.5 for a half rotation.  
c
c     The routine is passed the matrices MA and MB, where one of MA and MB
c     is of the form dM/Dp, where p is a parameter of M, such that when
c     the matrices MA and MB are summed, the resultant matrix is dS/Dp.
c
c     This subroutine calculates the matrix dC/dp
c
c  EXAMPLE (for a half rotation, useful for stage poles)
c   call rotnpd2scpd( d[F12]/d[f12lat , F23, F13, 0.5, D[H13+]/D[f12lat] )
c or
c   call rotnpd2scpd(  F12, d[F23]/d[f23ang], F13, -0.5, D[H13-]/D[f23ang] )
c

      implicit none

      double precision scale
      double precision MA(3,3), MB(3,3), S(3,3), DCDp(3,3)
c
      double precision slat, slon, sang,  dsangdp
      double precision dclatdp, dclondp, dcangdp
      double precision DSDp(3,3)
      double precision DCDclat(3,3), DCDclon(3,3), DCDcang(3,3)
      double precision TEMP1(3,3), TEMP2(3,3), TEMP3(3,3)
c
      call sumrots( MA, MB, DSDp)

      call mat2pol( S, slat, slon, sang)
      call pol2pdmats( slat, slon, dble(scale*sang),
     .                        DCDclat, DCDclon, DCDcang)

      call mats2polpds( S, DSDp, dclatdp, dclondp, dsangdp)
      dcangdp = dsangdp*scale


      call matscal(DCDclat, dclatdp, TEMP1)    
      call matscal(DCDclon, dclondp, TEMP2)    
      call matscal(DCDcang, dcangdp, TEMP3)
      call add3mats( TEMP1, TEMP2, TEMP3, DCDp)    

      return
      end
