c
      subroutine readpolesfile(lun, lpl, npoles, FPOLES, IDPOL, pairid)
c
c.... reads a set of finite rotation poles for one plate pair
c.... from a file (logical unit lun)

c
      implicit none

      integer lun, lpl, npoles

      double precision FPOLES( lpl, 3 )

      character * 6 pairid
      character * 4 IDPOL( lpl )
c
      integer nexpoles, i
c
c   
      read(lun,'(a6,x,i2)' ,err=999) pairid, nexpoles

      i=0

10    continue

         i=i+1

         read(lun,'(3f10.0, 2x, a4)',end=20, err=999) 
     .      FPOLES(i,1), FPOLES(i,2), FPOLES(i,3), IDPOL(i)

      go to 10

20    continue

      npoles = i - 1

      if( npoles .gt. lpl ) then
        stop 'readpolesfile::too many poles '
      else if( npoles .ne. nexpoles ) then
        stop 'readpolesfile::npoles .ne. nexpoles '
      else
        write(*,'(a,i2,a)') ' - read ',npoles,
     .           ' poles from file for plate pair '//pairid
      endif

      return

999   stop  ' error reading poles file'

      end
