c
      subroutine readpolesagefile(lun, lpl, npoles, FPOLES, IDPOL, AGE,
     .						 pairid)
c
c.... reads a set of finite rotation pole parameters from a file
c      (including the age of the poles)
c
      implicit none

      integer lun, lpl, npoles

      double precision FPOLES( lpl, 3 ), AGE(lpl)

      character * 6 pairid
      character * 4 IDPOL( lpl )
c
      integer nexpoles, i
c
c   
      read(lun,'(a6,x,i2)' ,err=999) pairid, nexpoles

      i=0

10    continue

         i=i+1

         read(lun,'(3f10.0, 2x, a4, f10.0)',end=20, err=999) 
     .      FPOLES(i,1), FPOLES(i,2), FPOLES(i,3), IDPOL(i), AGE(i)

      go to 10

20    continue

      npoles = i - 1

      if( npoles .gt. lpl ) then
        stop 'readpolesfile::too many poles '
      else if( npoles .ne. nexpoles ) then
        stop 'readpolesfile::npoles .ne. nexpoles '
      else
        write(*,'(a,i2,a)') ' - read ',npoles,
     .           ' poles from file for plate pair '//pairid
      endif

      return

999   stop  ' error reading poles file'

      end
