      subroutine read3polesfile( lun, lpl, npoles,
     .                                 FPOLES ,IDPOL, pairid)
c
c.... reads a set of finite rotation poles for one plate pair
c.... of a 3 plate set, from a file (logical unit lun)
c
      implicit none

      integer lun, lpl, npoles
      double precision FPOLES( lpl, 3 )
      character * 6 pairid
      character * 4 IDPOL( lpl )
c
      integer i
c
c   

      npoles = 0

      read( lun, '(a6,x,i2)', err=999) pairid, npoles

      if ( pairid.eq.'  ' ) goto 999

      if ( npoles.eq.0 .or. npoles.gt.lpl ) goto 999

      do 666 i = 1, npoles

        read( lun, 40, err=999) FPOLES(i,1), FPOLES(i,2),
     .                            FPOLES(i,3), IDPOL(i)
  40    format(3(1x,f9.4), 2x, a4)

666   continue

      write(*,'(a,i2,a)') ' - read ',npoles,
     .          ' poles from file for plate pair '//pairid

      return
c
999   stop  ' error reading 3 poles file / too many poles'
      end
