c
      subroutine poles2stpds(lpl, npoles, FPOLES, DST12DP, DST21DP)
c
c
c     subroutine poles2stpds         Aug 95          A Nankivell
c
c
c     the subroutine creates the partial derivative d(ST)/d(P)
c     for the set of east and west stage poles
c      - the first array dimension is the pole number
c      - the second array dimension is the index of the peturubed 
c            pole parameter - for a stage pole between finite poles
c            A and B , 1-3 are the lat,lon, angle for pole A, 
c                      4-6 are the lat,lon, angle for pole B
c      - the calculated partial derivative 3-vector is the last index
c     the calculations are carried out in double precision.
c
c     12 and 21 represent notation for the different stage poles
c     on the opposing flanks - the finite rotation poles are for
c     the motion of plate 2 wrt 1, and the `12' stage poles detail
c     the motion on the 2nd plate, and 21 on the 1st plate.
c
c          all angles in degrees
c
      implicit none

      integer lpl, npoles
      double precision  FPOLES(lpl,3)
      double precision  DST12DP(lpl,6,3), DST21DP(lpl,6,3)
c
      integer i, j, k, m, n
      double precision DPDTHETA(3), DPDPHI(3), dsign
      double precision HA(3,3), HB(3,3), S(3,3)
      double precision DHADTHETA(3,3), DHADPHI(3,3), DHADANG(3,3) 
      double precision DHBDTHETA(3,3), DHBDPHI(3,3), DHBDANG(3,3)
C


c.......... zero array first ..........

      do 1 i =1,npoles
        do 1 j = 1, 6
          do 1 k = 1,3
          DST12DP(i,j,k) = 0.
          DST21DP(i,j,k) = 0.
1     continue


c...... ensure consider stage poles as always having positive angles
c...... so if fpoles has neg angle, consider analogous fpole* with pos rot.
c...... theta* = -theta , phi* = phi +/- 180 


c--------- calculate current (first) stage poles first - easier calculation

      if ( FPOLES(1,3) .gt. 0.) then
        call pnt2pdvecs(FPOLES(1,1),FPOLES(1,2),DPDTHETA,DPDPHI)
      else 
        call pnt2pdvecs( dble(-FPOLES(1,1)), dble(FPOLES(1,2)+180.),
     .                                            DPDTHETA,DPDPHI)
      endif

      do 4 i = 1,3
        DST12DP(1,4,i) = dsign( DPDTHETA(i), FPOLES(1,3))
        DST12DP(1,5,i) = DPDPHI(i)
        DST12DP(1,6,i) = 0.
4     continue     


      if ( FPOLES(1,3) .gt. 0.) then
        call pnt2pdvecs( dble(-FPOLES(1,1)), dble(FPOLES(1,2)+180.),
     .                                            DPDTHETA,DPDPHI)
      else 
        call pnt2pdvecs(FPOLES(1,1),FPOLES(1,2),DPDTHETA,DPDPHI)
      endif

      do 6 i = 1,3
        DST21DP(1,4,i) = -dsign( DPDTHETA(i), FPOLES(1,3))
        DST21DP(1,5,i) = DPDPHI(i)
        DST21DP(1,6,i) = 0.

6     continue     

c----------------- now calculate for rest of poles set
c--------- stage rotations are equivalent of two half rotations, HA and HB
c--------- of which only one will be peturbed in each calculation


      do  10 i = 2, npoles

c -------------- 1->2 first --------------

        call pol2mat(FPOLES(i-1,1),FPOLES(i-1,2),
     .                              dble(-.5*FPOLES(i-1,3)),HA)
        call pol2pdmats(FPOLES(i-1,1),FPOLES(i-1,2),
     .                              dble(-.5*FPOLES(i-1,3)),  
     .                  DHADTHETA, DHADPHI, DHADANG)


        call pol2mat(FPOLES(i,1),FPOLES(i,2), dble(.5*FPOLES(i,3)),HB)
        call pol2pdmats(FPOLES(i,1),FPOLES(i,2),dble(.5*FPOLES(i,3)),
     .                  DHBDTHETA, DHBDPHI, DHBDANG)


c--- must convert to d/d(finite pole angle) for st. pole

        do 7 m = 1,3
          do 7 n = 1,3
            DHADANG(m,n) = -.5*DHADANG(m,n) 
            DHBDANG(m,n) = .5*DHBDANG(m,n)
7       continue

        call sumrots( HA, HB, S)
  
        call stpdarraybld( lpl, 6, DHADTHETA, HB, S, DST12DP, i,1)  
        call stpdarraybld( lpl, 6, DHADPHI, HB, S, DST12DP, i,2)
        call stpdarraybld( lpl, 6, DHADANG, HB, S, DST12DP, i,3)
        call stpdarraybld( lpl, 6, HA, DHBDTHETA, S, DST12DP, i,4)
        call stpdarraybld( lpl, 6, HA, DHBDPHI, S, DST12DP, i,5)
        call stpdarraybld( lpl, 6, HA, DHBDANG, S, DST12DP, i,6)

c -------------- now 2->1 --------------

        call pol2mat(FPOLES(i-1,1),FPOLES(i-1,2),
     .                             dble(.5*FPOLES(i-1,3)),HA)
        call pol2pdmats(FPOLES(i-1,1),FPOLES(i-1,2),
     .                             dble(.5*FPOLES(i-1,3)),  
     .                  DHADTHETA, DHADPHI, DHADANG)


        call pol2mat(FPOLES(i,1),FPOLES(i,2),dble(-.5*FPOLES(i,3)),HB)
        call pol2pdmats(FPOLES(i,1),FPOLES(i,2),dble(-.5*FPOLES(i,3)),
     .                  DHBDTHETA, DHBDPHI, DHBDANG)

c--- must convert to d/d(finite pole angle)
        do 9 m = 1,3
          do 9 n = 1,3
            DHADANG(m,n) = .5*DHADANG(m,n)
            DHBDANG(m,n) = -.5*DHBDANG(m,n)
9       continue

        call sumrots( HA, HB, S)
  
        call stpdarraybld( lpl, 6, DHADTHETA, HB, S, DST21DP, i,1)  
        call stpdarraybld( lpl, 6, DHADPHI, HB, S, DST21DP, i,2)
        call stpdarraybld( lpl, 6, DHADANG, HB, S, DST21DP, i,3)
        call stpdarraybld( lpl, 6, HA, DHBDTHETA, S, DST21DP, i,4)
        call stpdarraybld( lpl, 6, HA, DHBDPHI, S, DST21DP, i,5)
        call stpdarraybld( lpl, 6, HA, DHBDANG, S, DST21DP, i,6)

10    continue    

      return
      end
