c
      subroutine pol2pdmats(theta,phi,alpha, DRDTHETA, DRDPHI, DRDANG)
c
c
c     subroutine pol2pdmats         Aug 95          A Nankivell
c
c
c     the subroutine creates the 3*3 rotation matrix partial derivative
c     matrices dR/d(theta) drR/d(phi) dR/d(alpha) for a rotation
c     by angle alpha about pole with latitude theta and longitude phi.
c
c     the calculations are carried out in double precision.
c
c          all angles passed in degrees, worked in radians
c
      implicit none

      double precision theta, phi, alpha, raddeg
      double precision DRDTHETA(3,3), DRDPHI(3,3), DRDANG(3,3)
c
      integer i, j, k
      double precision DRDP(3,3,3), DPDTHETA(3), DPDPHI(3)
      double precision sum1, sum2, P(3)
c
      raddeg=0.1745329251994329D-01

      call pnt2vec(theta, phi, P)
      call pnt2pdvecs(theta, phi, DPDTHETA, DPDPHI)

c......... easiest to calculate pds wrt 3-vector P initially

      DRDP(1,1,1) = 2.0*P(1)*(1. - dcos(alpha*raddeg))
      DRDP(1,1,2) = P(2)*(1. - dcos(alpha*raddeg)) 
      DRDP(1,1,3) = P(3)*(1. - dcos(alpha*raddeg)) 

      DRDP(1,2,1) = P(2)*(1. - dcos(alpha*raddeg)) 
      DRDP(1,2,2) = 0.
      DRDP(1,2,3) = -dsin(alpha*raddeg)

      DRDP(1,3,1) = P(3)*(1. - dcos(alpha*raddeg)) 
      DRDP(1,3,2) = dsin(alpha*raddeg)
      DRDP(1,3,3) = 0.


      DRDP(2,1,1) = 0.
      DRDP(2,1,2) = P(1)*(1. - dcos(alpha*raddeg)) 
      DRDP(2,1,3) = dsin(alpha*raddeg)

      DRDP(2,2,1) = P(1)*(1. - dcos(alpha*raddeg))
      DRDP(2,2,2) = 2.0*P(2)*(1. - dcos(alpha*raddeg))
      DRDP(2,2,3) = P(3)*(1. - dcos(alpha*raddeg))

      DRDP(2,3,1) = -dsin(alpha*raddeg)
      DRDP(2,3,2) = P(3)*(1. - dcos(alpha*raddeg)) 
      DRDP(2,3,3) = 0.


      DRDP(3,1,1) = 0.
      DRDP(3,1,2) = -dsin(alpha*raddeg)
      DRDP(3,1,3) = P(1)*(1. - dcos(alpha*raddeg)) 

      DRDP(3,2,1) = dsin(alpha*raddeg)
      DRDP(3,2,2) = 0.
      DRDP(3,2,3) = P(2)*(1. - dcos(alpha*raddeg)) 

      DRDP(3,3,1) = P(1)*(1. - dcos(alpha*raddeg))
      DRDP(3,3,2) = P(2)*(1. - dcos(alpha*raddeg))
      DRDP(3,3,3) = 2.0*P(3)*(1. - dcos(alpha*raddeg))
 
      do 11 i = 1,3
        do 11 j= 1,3
          sum1 = 0.
          sum2 = 0.
	  do 22 k = 1,3
            sum1 = sum1 + DRDP(k,i,j)*DPDTHETA(k)
            sum2 = sum2 + DRDP(k,i,j)*DPDPHI(k)
22        continue
          DRDTHETA(i,j) = sum1
          DRDPHI(i,j) = sum2
11    continue

                                                                   
      DRDANG(1,1) = (P(1)*P(1) - 1.)*dsin(alpha*raddeg)
      DRDANG(1,2) = P(1)*P(2)*dsin(alpha*raddeg) - 
     .                                 P(3)*dcos(alpha*raddeg)
      DRDANG(1,3) = P(1)*P(3)*dsin(alpha*raddeg) + 
     .                                 P(2)*dcos(alpha*raddeg)

      DRDANG(2,1) = P(2)*P(1)*dsin(alpha*raddeg) + 
     .                                 P(3)*dcos(alpha*raddeg)
      DRDANG(2,2) = (P(2)*P(2) - 1.)*dsin(alpha*raddeg)
      DRDANG(2,3) = P(2)*P(3)*dsin(alpha*raddeg) - 
     .                                 P(1)*dcos(alpha*raddeg)

      DRDANG(3,1) = P(3)*P(1)*dsin(alpha*raddeg) - 
     .                                 P(2)*dcos(alpha*raddeg)
      DRDANG(3,2) = P(3)*P(2)*dsin(alpha*raddeg) + 
     .                                 P(1)*dcos(alpha*raddeg)
      DRDANG(3,3) = (P(3)*P(3) - 1.)*dsin(alpha*raddeg) 


cd      print *, 'angle ', alpha


      return
      end
