c
      subroutine pol2mat(t,p,a, R)
c
c
c     subroutine pol2mat         Aug 95          A Nankivell
c
c
c     the subroutine creates the 3*3 rotation matrix R for a rotation
c     by angle a about pole with latitude theta=t, longitude phi=p.
c
c     the calculations are carried out in double precision.
c
c          all angles passed in degrees, worked in radians
c
      implicit none

      double precision t, p, a, R(3,3), raddeg
c
      double precision PVEC(3)
C
      raddeg=0.1745329251994329D-01

      call pnt2vec(t, p, PVEC)
                                                                    
      R(1,1) = PVEC(1)*PVEC(1)*(1 - dcos(a*raddeg)) + dcos(a*raddeg)
      R(1,2) = PVEC(1)*PVEC(2)*(1 - dcos(a*raddeg)) - 
     .                                       PVEC(3)*dsin(a*raddeg)
      R(1,3) = PVEC(1)*PVEC(3)*(1 - dcos(a*raddeg)) + 
     .                                       PVEC(2)*dsin(a*raddeg)

      R(2,1) = PVEC(2)*PVEC(1)*(1 - dcos(a*raddeg)) + 
     .                                       PVEC(3)*dsin(a*raddeg)
      R(2,2) = PVEC(2)*PVEC(2)*(1 - dcos(a*raddeg)) + dcos(a*raddeg)
      R(2,3) = PVEC(2)*PVEC(3)*(1 - dcos(a*raddeg)) - 
     .                                       PVEC(1)*dsin(a*raddeg)

      R(3,1) = PVEC(3)*PVEC(1)*(1 - dcos(a*raddeg)) - 
     .                                       PVEC(2)*dsin(a*raddeg)
      R(3,2) = PVEC(3)*PVEC(2)*(1 - dcos(a*raddeg)) + 
     .                                       PVEC(1)*dsin(a*raddeg)
      R(3,3) = PVEC(3)*PVEC(3)*(1 - dcos(a*raddeg)) + dcos(a*raddeg)


      return
      end
