c
      subroutine pnt2pdvecs(theta,phi, DPDTHETA, DPDPHI)
c
c
c     subroutine pnt2pdvecs         Aug 95          A Nankivell
c
c
c     the subroutine creates the 3-vector partial derivative
c     matrices dP/d(theta) dP/d(phi)  for the unit vector P representation
c     of the point theta,phi.
c
c     the calculations are carried out in double precision.
c
c          all angles passed in degrees, worked in radians
c
      implicit none

      double precision theta, phi, DPDTHETA(3), DPDPHI(3), raddeg

      raddeg=0.1745329251994329D-01


      DPDTHETA(1) = -dsin(theta*raddeg)*dcos(phi*raddeg)
      DPDTHETA(2) =  -dsin(theta*raddeg)*dsin(phi*raddeg)
      DPDTHETA(3) =  dcos(theta*raddeg)

      DPDPHI(1) = -dcos(theta*raddeg)*dsin(phi*raddeg)
      DPDPHI(2) = dcos(theta*raddeg)*dcos(phi*raddeg)
      DPDPHI(3) = 0.

      return
      end
