      subroutine pdflowseedx( lpl, npoles, spole, FPOLES, 
     .                       STAGE, FLOW, iside, DEDp)
c
c   - used in the detemination of the best fit seed point for a fracture zone
c
c---- given a flowline (FLOW), the set of stage poles (STAGE) that define the 
c      flowline, given the seed point (SEED), calculates the partial
c      derivatives for the angular distance of each flowline section from
c      the vector representation of each stage pole, wrt a seed
c      peturbation - DEDP
c 
c --- allows seed point to be at any of the flowpoints along the flowline
c
c.... ADRIAN NANKIVELL 1995
c
      implicit none

      integer lpl, npoles, spole, iside
      double precision FPOLES(lpl,3), STAGE(lpl,3)
      double precision FLOW(0:lpl,3), DEDp(lpl)
c
      integer i

      double precision SEED(3), STP(3), RADP(3)
      double precision radplat, radplon
      double precision DUMMY(3,3), DRRADDp(3,3)
      double precision DROTDp(3,3), DCSEEDDp(3)
      double precision R(3,3), F(3), DFDp(3)
      double precision vecdprod
c


c....... calculate DCSEED/Dpeturb (DSDp), for radial peturb away from pole
c    CSEED is zero age, but if spole >0, SEED is seedpoint for flowline 
c...  starting at pole spole - iside indicates which side of plate boundary
c....first calculate pole for radial rotations of SEED away from stage pole
c..   spole->spole+1


      call pnt2vec( STAGE(spole+1,1), STAGE(spole+1,2), STP )

      SEED(1) = FLOW(spole,1) 
      SEED(2) = FLOW(spole,2) 
      SEED(3) = FLOW(spole,3) 

      call vecxprod( STP, SEED, RADP)
      call vec2pnt( RADP, radplat, radplon)

c........ calculate changes in resultant rotation matrix for changes
c.        in rotation angle(peturbation) away from pole

      call pol2pdmats(radplat, radplon, dble(0.), DUMMY, DUMMY, DRRADDp)

c......... now depending on whether seed is central or not, calculate 
c            d(CSEED)/Dp 

      if ( spole .gt. 0 ) then

        call pol2mat( FPOLES(spole,1), FPOLES(spole,2),
     .                        dble(-0.5*iside*FPOLES(spole,3)) , R)
        call sumrots(DRRADDp, R, DROTDp)
        call rotatevec(DROTDp, SEED, DCSEEDDp)

      else if (spole .eq. 0) then

        call rotatevec(DRRADDp, SEED, DCSEEDDp)

      end if


c....... now propogate this seed shift throughout flowline

      do 11 i =  1, npoles

        call pnt2vec( STAGE(i,1), STAGE(i,2), STP )

        F(1) = FLOW(i,1)
        F(2) = FLOW(i,2)
        F(3) = FLOW(i,3)


        call pol2mat( FPOLES(i,1), FPOLES(i,2),
     .                        dble(iside*FPOLES(i,3)/2.) , R)

cc.........error is calculated as err= acos(STP.F) - acos(STP.PICK)
c.....     so De/Dp = D( acos(STP.F) )/Dp
c......... with D(F)/Dp = D( R x CSEED)/Dp = R x DCSEEDDp

        call rotatevec(R, DCSEEDDp, DFDp)


        DEDp(i) = - vecdprod(STP, DFDp) /
     .                     dsqrt( 1 - (vecdprod(STP,F))**2 )

cd        write(*, '( a,i2,x,f8.4 )' ) 'DEDP ',i, DEDp(i)

11    continue
c....
      return
      end
