      subroutine pdflowseed( lpl, npoles, FPOLES, 
     .                       STAGE, FLOW, iew, DEDp)
c
c   - used in the detemination of the best fot seed point for a fracture zone
c
c---- given a flowline (FLOW), the set of stage poles (STAGE) that define the 
c      flowline, given the seed point (SEED), calculates the partial
c      derivatives for the angular distance of each flowline section from
c      the vector representation of each stage pole, wrt a seed
c      peturbation - DEDP
c 
c
c.... ADRIAN NANKIVELL 1995
c
      implicit none

      integer lpl, npoles, iew
      double precision FPOLES(lpl,3), STAGE(lpl,3)
      double precision FLOW(0:lpl,3), DEDp(lpl)
c
      integer i

      double precision SEED(3), STP(3), RADP(3), radplat, radplon
      double precision DUMMY(3,3), DRDp(3,3), DSDp(3)
      double precision R(3,3), F(3), DFDp(3)
      double precision vecdprod
c
c.... loop to allow perturbation w.r.t. seed point.
c
c
      SEED(1) = FLOW(0,1)
      SEED(2) = FLOW(0,2)
      SEED(3) = FLOW(0,3)

c....... calculate DSEED/Dpeturb (DSDp), for radial peturb away from pole
c       
      call pnt2vec( STAGE(1,1), STAGE(1,2), STP )

c     
c........ calculate pole for radial rotations of SEED away from stage pole
      call vecxprod( STP, SEED, RADP)
      call vec2pnt( RADP, radplat, radplon)

c........ calculate changes in resultant rotation matrix for changes
c.        in rotation angle(peturbation) away from pole

      call pol2pdmats(radplat, radplon, 0., DUMMY, DUMMY, DRDp)

      call rotatevec(DRDp, SEED, DSDp)

c....... now propogate this seed shift throughout flowline

      do 11 i = 1, npoles

        call pnt2vec( STAGE(i,1), STAGE(i,2), STP )
        F(1) = FLOW(i,1)
        F(2) = FLOW(i,2)
        F(3) = FLOW(i,3)

        call pol2mat( FPOLES(i,1), FPOLES(i,2),
     .                            iew*FPOLES(i,3)/2. , R)

cc.........error is calculated as err= acos(STP.F) - acos(STP.PICK)
c.....     so De/Dp = D( acos(STP.F) )/Dp
c......... with D(F)/Dp = D( R x SEED)/Dp = R x DSDp

        call rotatevec(R, DSDp, DFDp)


        DEDp(i) = - vecdprod(STP, DFDp) /
     .                     dsqrt( 1 - (vecdprod(STP,F))**2 )


11    continue
c....
      return
      end
