c
      subroutine normvec(V)
c
c     subroutine normvec        Aug 95        Adrian Nankivell
c
c     normalises a vector on a unit sphere
c
c     calculations carried out in double precision
c
c     all angles in degrees
c
      implicit none

      double precision V(3)
c
      integer n
      double precision vectmod, TEMP(3)


      do 10 n=1, 3
        TEMP(n) = V(n)
10    continue
 

      vectmod = dsqrt( V(1)*TEMP(1) + V(2)*TEMP(2) + V(3)*TEMP(3) )

      if (vectmod .eq. 0.) then
        do 20 n=1, 3 
          V(n) = 0.
20      continue
      else
        do 30 n=1, 3 
          V(n) = TEMP(n)/vectmod
30      continue
      end if

      return
      end
