c
c
      subroutine mtxvtr( R, mrmax, nrmax, mr, nr, X, mxmax, mx,
     .                 Y, mymax )
c      --------------------------------------------------------
c
c      subroutine mtxvtr pre-multiplies the mx length vector X
c      by the mr * nr matrix R to determine the mr length vector
c      Y. that is,
c
c      y = r * x
c
c
c
      implicit none
c
      integer mrmax, nrmax, mr, nr
      integer mxmax, mx,  mymax

      double precision R( mrmax, nrmax ), X( mxmax ), Y( mymax )
c
      integer i, j

      double precision sum

c
c----  check matrix and vector dimensions
c
      if( nr .ne. mx ) then

        write( 6, 5 ) nr, mx
5       format(/,5x,'error : matrix / vector multiplication in',/,
     .           5x,'subroutine mtxvtr cannot proceed because the',/,
     .           5x,'number of columns in the matrix R ',i3,' and',/,
     .           5x,'the number of rows in the vector X ',i3,/,
     .           5x,'are incompatible',/)

        stop

      end if

      if( mr .gt. mymax ) then

        write( 6, 10 )
10      format(/,5x,'error : error occurred in subroutine mtxvtr.',/,
     .           5x,'predicted length of vector Y exceeds array',/,
     .           5x,'dimensions',/)

        stop

      end if
c
c----  clean output vector array
c
      do 20 i = 1, mymax
        Y( i ) = 0.0d0
20    continue

c----  perform multiplication
c
      do 40 i = 1, mr

        sum = 0.0d0

        do 30 j = 1, nr
          sum = sum + R( i, j ) * X( j )
30      continue

        Y( i ) = sum

40    continue

      return
      end     
