c
c
      subroutine mtxmul( A, mamax, namax, ma, na, B, mbmax, nbmax, mb,
     .                 nb, C, mcmax, ncmax )
c      ---------------------------------------------------------------
c
c      subroutine mtxmul multiplies the ma * na matrix A
c      and the mb * nb matrix B to produce the ma * nb
c      matrix C defined by
c
c      C = A * B
c
c
      implicit none
c
      integer mamax, namax, ma, na
      integer mbmax, nbmax, mb, nb
      integer mcmax, ncmax

      double precision  A( mamax, namax ), B( mbmax, nbmax )
      double precision  c( mcmax, ncmax )
c
      integer i, j, k

      double precision sum

c
c----  check dimensions of matrices
c
      if( na .ne. mb ) then

        write( 6, 5 ) na, mb
5       format(/,5x,'error : matrix multiplication in subroutine',/,
     .           5x,'mtxmul cannot proceed because the number of',/,
     .           5x,'rows in matrix A ',i3,' and the number of',/,
     .           5x,'columns in matrix B ',i3,' are incompatible',/)

        stop

      end if
c
c----  check size of output matrix C
c
      if( ma .gt. mcmax .or. nb .gt. ncmax ) then

        write( 6, 10 )
10      format(/,5x,'error : error in subroutine mtxmul.',/,
     .           5x,'predicted dimensions of matrix C',/,
     .           5x,'exceed dimensions of array C',/)

        stop

      end if
c
c----  clean output array
c
      do 20 i = 1, mcmax
        do 20 j = 1, ncmax

          C( i,j ) = 0.0d0

20    continue

c
c----  perform matrix multiplication
c
      do 40 i = 1, ma
        do 40 j = 1, nb

        sum = 0.0d0

        do 30 k = 1, na
          sum = sum + A( i, k ) * B( k, j )
30      continue

        C( i, j ) = sum

40    continue

      return
      end
