c
      subroutine mats2vecpds(R, DRDP, DEDP, dalphadp)
c
c
c     subroutine mats2vecpds          Aug 95          A.Nankivell
c
c
c     Given a rotation matrix ,R [ which represents a rotation of alpha
c     around a pole E (a 3-vector) ], and the partial derivative of
c     this matrix wrt an unknown peturbation p, d(R)/dp, this subroutine 
c     calculates the partial derivatives d(E)/dp and d(alpha)/dp 
c
c     the calculations are carried out in double precision.
c
c	all angles in degrees
c
      implicit none

      double precision R(3,3), DRDP(3,3), DEDP(3)
      double precision dalphadp
c
      double precision s, u, v, w, z
      double precision dsdp, dudp, dvdp, dwdp, dzdp

      s = R(1,1) + R(2,2) + R(3,3) - 1
      dsdp = DRDP(1,1) + DRDP(2,2) + DRDP(3,3)

      u = R(3,2) - R(2,3)
      dudp = DRDP(3,2) - DRDP(2,3)

      v = R(1,3) - R(3,1)
      dvdp = DRDP(1,3) - DRDP(3,1)

      w = R(2,1) - R(1,2)
      dwdp = DRDP(2,1) - DRDP(1,2)

      z = dsqrt(u**2 + v**2 + w**2)

      dzdp = ((u**2 + v**2 + w**2)**(-0.5)) *
     .                             (u*dudp + v*dvdp + w*dwdp)


      DEDP(1) = (z*dudp - u*dzdp)/ z**2

      DEDP(2) =  (z*dvdp - v*dzdp) / z**2

      DEDP(3) = (z*dwdp - w*dzdp) / z**2

      dalphadp = (( 1 + (z/s)**2 )**(-1)) * (s*dzdp - z*dsdp) / s**2
c
      return
      end
