c
      subroutine mats2polpds(R, DRDP, dthetadp, dphidp, dalphadp)
c
c
c     subroutine mats2polpds          Aug 95          A.Nankivell
c
c
c     the subroutine calculates the partial derivatives of the parameters 
c     (latitude theta, longitude phi and angle alpha) of the rotation 
c     represented by the matrix R, with respect to a peturbation p.
c     These are determined from the matrix R and the pertial derivative
c     of this matrix (dR/dp).
c
c     the calculations are carried out in double precision.
c
c	all angles in degrees
c
      implicit none

      double precision R(3,3), DRDP(3,3)
      double precision dthetadp, dphidp, dalphadp
c
      double precision s, u, v, w, z
      double precision dsdp, dudp, dvdp, dwdp, dzdp

      s = R(1,1) + R(2,2) + R(3,3) - 1
      dsdp = DRDP(1,1) + DRDP(2,2) + DRDP(3,3)

      u = R(3,2) - R(2,3)
      dudp = DRDP(3,2) - DRDP(2,3)

      v = R(1,3) - R(3,1)
      dvdp = DRDP(1,3) - DRDP(3,1)

      w = R(2,1) - R(1,2)
      dwdp = DRDP(2,1) - DRDP(1,2)

      z = dsqrt(u**2 + v**2 + w**2)

      dzdp = ((u**2 + v**2 + w**2)**(-0.5)) *
     .                             (u*dudp + v*dvdp + w*dwdp)


      dthetadp = (( 1 - (w/z)**2. )**(-0.5)) * (z*dwdp - w*dzdp)/ z**2

      dphidp = (( 1 + (v/u)**2 )**(-1)) * (u*dvdp - v*dudp) / u**2

      dalphadp = (( 1 + (z/s)**2 )**(-1)) * (s*dzdp - z*dsdp) / s**2
c
      return
      end
