c
      subroutine mat2vec(R,P,alpha)
c
c
c     subroutine mat2vec          Aug 95          A.Nankivell
c
c
c     the subroutine calculates the rotation axis (as a 3-vector P)
c     and rotation angle (alpha) of the rotation matrix R.
c
c     the calculations are carried out in double precision.
c
c	all angles passed in degrees, worked in radians
c
      implicit none

      double precision P(3), alpha, R(3,3), raddeg
c
      double precision s,u,v,w,z
      raddeg=0.1745329251994329D-01


c
      s = R(1,1) + R(2,2) + R(3,3) - 1

      u = R(3,2) - R(2,3)
      v = R(1,3) - R(3,1)
      w = R(2,1) - R(1,2)

      z = dsqrt(u**2 + v**2 + w**2)

      P(1) =  u/z
      P(2) =  v/z
      P(3) =  w/z
 
      alpha = datan2 ( z , s )/raddeg

         
c
      return
      end
