c
      subroutine mat2pol(R,theta,phi,alpha)
c
c
c     subroutine mat2pol          Aug 95          A.Nankivell
c
c
c     the subroutine calculates the rotation axis (latitude theta, longitude phi)
c     and rotation angle (alpha) of the rotation matrix R.
c
c     the calculations are carried out in double precision.
c
c	all angles passed in degrees, worked in radians
c
      implicit none

      double precision theta, phi, alpha, R(3,3)
c
      double precision s,u,v,w,z, raddeg

      raddeg=0.1745329251994329D-01


c
      s = R(1,1) + R(2,2) + R(3,3) - 1

      u = R(3,2) - R(2,3)
      v = R(1,3) - R(3,1)
      w = R(2,1) - R(1,2)

      z = dsqrt(u**2 + v**2 + w**2)

 
      if ( z .eq. 0.) then
        theta = 0.
      else
        theta = dasin( w / z )/raddeg
      endif

      phi= datan2( v , u )/raddeg
 
      alpha = datan2 ( z , s )/raddeg

         
c
      return
      end
