c
      subroutine magpickproc(pairid, lpl, npoles, FPOLES, IDPOL, 
     .  NPERPOLE, lmpk, S_LOC, S_ID, F_LOC, lgout, ldt, lpr, npickstot,
     .    PK_LOC, A, B, W)
c..
c
c
      implicit none
c

      integer lpl, lmpk, lpr, ldt, lgout
      integer npoles, npickstot

      integer NPERPOLE(0:lpl), S_ID(lmpk) 

      double precision FPOLES(lpl,3)
      double precision S_LOC(lmpk, 2),F_LOC(lmpk,2), PK_LOC(ldt, 3)
      double precision A(ldt,lpr), B(ldt), W(ldt) 

      character pairid*6
      character*4 IDPOL(0:lpl)
c
      integer irow, iwpoint, nspicks, nrotgcs, n0
      integer jpkhit, jgchit, ipol, igcloop
      integer sgn_pk, sgn_gc
      integer i, j, ios

      double precision gcp_lat, gcp_lon, rms_e, emax, css
      double precision signrot, wfactor

      character*3  plpk, plgc
      character*4  line, idpk, idgc
      character*40 direc
      character*80 openfile

      character*3 PLATE(2)

c
c......... define directory containing data files
c
c      data direc /'/home/piglet_data2/adriann/recon/data/'/
       data direc /'data/'/
      
c........... set up and clear out

      PLATE(1) = pairid(1:3)
      PLATE(2) = pairid(4:6)

      do 5 i = 0, npoles
         NPERPOLE(i)= 0
 5    continue

c..   input magnetic pick data
c
      call strcat( direc, 'magpicks_'//pairid//'.dat', openfile)
      write(*,'(a)') ' opening file '//openfile

      open( 1, file = openfile, status = 'old', iostat = ios )

      if( ios .ne. 0 ) then
        write( 6, 10 ) openfile, ios
10      format(/,5x,'error occurred opening file : ',a80,/,
     .           5x,'iostat error code = ',i8,//)
        stop
      end if
cc
c..   input magnetic pick data
c
      irow=0
      iwpoint=0

  100 continue

      nrotgcs = -1

c.................. read in information about pick group
      read(1,'(a4,x,a3,2x,i6,x,i2)',end=1000) 
     .                     idpk, plpk, nspicks, nrotgcs

      if (idpk.eq.'none') goto 1000
      if (nspicks .gt. lmpk) stop 'too many picks in anom group'
      if (nrotgcs.le.0) goto 1000

cd      write(*,'(a)') ':anom:ew: - pick:'//
cd     .           idpk//':'//plpk//': - gc :'//idgc//':'//plgc//':'


      jpkhit = -1
      do 110 i=0,npoles
         if(IDPOL(i).eq.idpk) jpkhit=i
110   continue

cd       write(*,'(a,i2,a,i2)') 'jpkhit: ', jpkhit

c..   ignore data if rotation pole not known

      if(jpkhit.eq.-1 ) then
        write(*,'(a)') 'unknown pick mag. id '//idpk
	do 115 igcloop = 1, nrotgcs+1
            read(1,'(a)') line
115	continue
        go to 100
      endif


c..   enter data points
c
      do 120 j=1,nspicks

        read(1,'(2f10.4, x, i6)')  S_LOC(j,1), S_LOC(j,2), S_ID(j)

120   continue

c......... rotate for number of gcs

      do 500 igcloop = 1, nrotgcs


          read(1,'(a4,x,a3,2x,2f10.4, 2f6.2, i6)') idgc, plgc,
     .                      gcp_lat, gcp_lon, rms_e, emax, n0


          css =  dble(n0) * ( (rms_e/111.2)**2 )

c.. .. .. .. .. .. determine relevant rotation pole
c
          jgchit = -1
          do 210 i=0,npoles
             if(IDPOL(i).eq.idgc) jgchit=i
210       continue

cd       write(*,'(a,i2,a,i2)') 'jpkhit: ', jpkhit,' jgchit: ', jgchit


c.. .. .. .. .. ..  ignore data if rotation pole not known

          if( jgchit.eq.-1) then
            write(*,'(a)') 'unknown gc mag. id '//idgc
            go to 499
          endif

          write(*,'( a,i2,3(x,a))' ) 'rotating ',nspicks, IDPOL(jpkhit),
     .     plpk//' picks to '//IDPOL(jgchit),plgc//' great circle'



          wfactor = dble(nrotgcs)

c.. .. .. .. .. determine error in rotated point and partial
c.. .. .. .. .. differential matrix w.r.t. rotation pole parameters
c
c.................. first deal with case of rotating one point to another

          if( n0 .eq. 1) then

             print *,'hmm I dont know yet - 1 point to another?'
c 
c Adrian          else if ( jpkhit.eq.0 .XOR. jgchit.eq. 0) then          
          else if ( jpkhit.eq.0 .NEQV. jgchit.eq. 0) then

c............ rotating picks to/from current ridge axis

	    if( jpkhit.eq.0 .and. plgc.eq.PLATE(2) ) then
		signrot = 0.5
		ipol = jgchit
            else if( jpkhit.eq.0 .and. plgc.eq. PLATE(1) ) then
		signrot = -0.5
		ipol = jgchit
            else if( jgchit.eq.0 .and. plpk.eq.PLATE(2) ) then
		signrot = -0.5
		ipol = jpkhit
            else if( jgchit.eq.0 .and. plpk.eq. PLATE(1) ) then
		signrot = 0.5
		ipol = jpkhit
            else
		stop 'signrot gc'
            endif

            call  magpickcalc( irow, lmpk, nspicks, S_LOC, S_ID, F_LOC,
     .        ipol, FPOLES(ipol,1),FPOLES(ipol,2), FPOLES(ipol,3),
     .        signrot,gcp_lat, gcp_lon, css, ldt, lpr, A, B, PK_LOC)

	    wfactor = wfactor * 1.5

          else if ( jpkhit.eq.jgchit) then

c............ rotating picks to conjugate pair

            if( plgc .eq. PLATE(2) ) then
		signrot = 1.
            else if( plgc.eq. PLATE(1) ) then
		signrot = -1.
            else
		stop 'signrot gc'
            endif

            call  magpickcalc( irow, lmpk, nspicks, S_LOC, S_ID, F_LOC,
     .      jpkhit, FPOLES(jpkhit,1),FPOLES(jpkhit,2), FPOLES(jpkhit,3),
     .           signrot, gcp_lat, gcp_lon, css, ldt, lpr, A, B, PK_LOC)


        else

c............ rotating picks to different anomaly

            if( plpk .eq. PLATE(1) ) then
		sgn_pk = 1
            else if( plpk .eq. PLATE(2) ) then
		sgn_pk = -1
            else
		stop 'signrot pk'
            endif

            if( plgc .eq. PLATE(2) ) then
		sgn_gc = 1
            else if( plgc .eq. PLATE(1) ) then
		sgn_gc = -1
            else
		stop 'signrot gc'
            endif

            call  magpickcalc_2pol(irow, lmpk, nspicks, S_LOC, S_ID,
     .          F_LOC, jpkhit, FPOLES(jpkhit,1), FPOLES(jpkhit,2),
     .          FPOLES(jpkhit,3), sgn_pk,jgchit, FPOLES(jgchit,1),
     .          FPOLES(jgchit,2),FPOLES(jgchit,3), sgn_gc, gcp_lat, 
     .          gcp_lon, css, ldt, lpr, A, B, PK_LOC)

	    wfactor = wfactor * 2.

        endif


c............. determine weights

        if ( n0 .eq. 2) then

c........... different weighting if only 2 picks used for greatcircle

          rms_e=dsqrt(css/dble(nspicks))

	  wfactor = wfactor * 2.

        else
          rms_e=dsqrt(css/dble(n0+nspicks))
        endif

        do 145 i=1,nspicks
          W(iwpoint+i) = rms_e * wfactor
145     continue

        iwpoint=iwpoint+nspicks 

c.. .. .. .. .. write rotated points to file

        do 150 i = 1, nspicks
	  write(lgout,'(6(a,x))') '>', IDPOL(jpkhit), plpk, '->',
     .				       IDPOL(jgchit), plgc
	  write(lgout, 151 )S_LOC(i,2), S_LOC(i,1),
     .                            PK_LOC(iwpoint-nspicks+i,3)
	  write(lgout, 152 )F_LOC(i,2), F_LOC(i,1)
150     continue
151     format(2(f9.4,x),f8.6)
 152    format(2(f9.4,x))

499     continue
500   continue


      NPERPOLE(jpkhit) = NPERPOLE(jpkhit) + nspicks

      read(1,'(a)') line

c...... next set of picks

      go to 100

c.......... FINISHED processing all data    
c

1000  close( 1 )


      npickstot = irow

      if (npickstot .gt. ldt) stop 'too many magnetic data points'



      return
 9999 stop 'sub_magpickproc:ERROR'

      end
