c
      subroutine magpickcalc_2pol( irow, lmpk, npicks, S_LOC, S_ID,
     .               F_LOC, pc_ipol, pc_lat, pc_lon, pc_ang, pc_sign,
     .                      cg_ipol, cg_lat, cg_lon, cg_ang, cg_sign,
     .                gcp_lat, gcp_lon, css, ldt, lpr, A, B , PK_LOC)
c
c
c  ---- for a set of anomaly picks, rotate and fit to a great circle,
c   calculating errors (B), and partial derivatives (A) wrt the parameters
c   of the TWO consituent finite rotations from which the fitting rotation
c   pole is derived (fitting rotation comprises of rotation pc - pick to
c   centre, then cg - centre to great circle).
c
c Written by  A. Nankivell 1995-97 
c
c G Eagles 2013:
c changed to calculate stage poles without using half angles
c
c
c   INPUT VARIABLES
c
c  S_LOC           -- array of coordinates of unrotated (starting) points.
c
c  S_ID            -- array storing identifier for magnetics pick
c
c  F_LOC           -- array of coordinates of rotated (final) points.
c
c  pc_ipol         -- index for pole rotating
c                      from pick to centre(current ridge)
c  pc_lat/lon/ang  -- (finite) rotation parameters for pc_ipol'th pole
c  pc_sign         -- positive/negative rotation for angle pc_ang
c
c  cg_ipol         -- index for pole rotating
c                      from centre(current ridge) to great circle
c  cg_lat/lon/ang  -- (finite) rotation parameters for cg_ipol'th pole
c  cg_sign         -- positive/negative rotation for angle cg_ang
c  gcp_lat/lon     -- coordinates of pole whose great-circle best fits
c                      the anomalies to be matched. 
c  css            -- cumulative sum of squared errors
c


      implicit none
c
      integer irow, lmpk, npicks, lpr, ldt
      integer pc_ipol, pc_sign, cg_ipol, cg_sign
      integer S_ID(lmpk)

      double precision pc_lat, pc_lon, pc_ang
      double precision cg_lat, cg_lon, cg_ang, gcp_lat, gcp_lon
      double precision css
      double precision S_LOC(lmpk,2), F_LOC(lmpk,2)
      double precision A(ldt,lpr), B(ldt), PK_LOC(ldt,3)
c
      integer j, jcol_pc, jcol_cg, ipk

      double precision pangsep, vecdprod
      double precision gcpt_lat, gcpt_lon, e
      double precision pc_rang, cg_rang
      double precision Rpc(3,3), Rcg(3,3), ST(3,3)
      double precision DRDPLAT(3,3), DRDPLON(3,3), DRDPANG(3,3)
      double precision S(3), F(3), DEDF(3), GCPT(3), DFDP(3)
      double precision DSTDP1(3,3), DSTDP2(3,3), DSTDP3(3,3)
      double precision DSTDP4(3,3), DSTDP5(3,3), DSTDP6(3,3)


c
c.............. FIRST carry out general routines common to each pick


c.......... Construct a working pole "gcpt", such that
c     gcpt and s are on the same side of great-circle:
c              taking first point as reference

      if (pangsep(S_LOC(1,1),S_LOC(1,2), gcp_lat, gcp_lon).gt.90.) then
        call diamg( gcp_lat, gcp_lon, gcpt_lat, gcpt_lon )
      else
        gcpt_lat = gcp_lat
        gcpt_lon = gcp_lon
      endif


      call pnt2vec(gcpt_lat, gcpt_lon, GCPT)

c........ get rotation matrix for 1st rotation pole (pick to centre)
c    
c Adrian      pc_rang = pc_ang*pc_sign*0.5
c
c Graeme:

      pc_rang = pc_ang*pc_sign
      call pol2mat(pc_lat, pc_lon, pc_rang, Rpc)

cd      write(*, '( 3(a,f9.4) )') 'pc - Rotation of ',pc_rang,' around ',
cd     .                                        pc_lat, ',' ,pc_lon

c........ get rotation matrix for 2nd rotation pole (centre to gcircle)
c    
c Adrian      cg_rang = cg_ang*cg_sign*0.5
c
c Graeme:

      cg_rang = cg_ang*cg_sign

      call pol2mat(cg_lat, cg_lon, cg_rang, Rcg)

cd      write(*, '( 3(a,f9.4) )') 'cg - Rotation of ',cg_rang,' around ',
cd     .                                           cg_lat, ',' ,cg_lon


c....... obtain resultant rotation matrix for 'stage'
c       rotation pole (pick to gcircle)
    
      call sumrots(Rpc, Rcg, ST)

c  Graeme - now need to halve the angle for this to be stage pole
c
        call mat2pol(ST,ST(1,1),ST(1,2),ST(1,3))
        call pol2mat(ST(1,1),ST(1,2),dble(.5*ST(1,3)),ST)
c graeme done

c........ find partial derivatives of this stage pole matrix
c here the angle is 2* too much

      call pol2pdmats(pc_lat,pc_lon,pc_rang,DRDPLAT,DRDPLON,DRDPANG)
      call sumrots(DRDPLAT, Rcg, DSTDP1)
      call sumrots(DRDPLON, Rcg, DSTDP2)
      call sumrots(DRDPANG, Rcg, DSTDP3)

      call pol2pdmats(cg_lat,cg_lon,cg_rang,DRDPLAT,DRDPLON,DRDPANG)
      call sumrots(Rpc, DRDPLAT, DSTDP4)
      call sumrots(Rpc, DRDPLON, DSTDP5)
      call sumrots(Rpc, DRDPANG, DSTDP6)

c.......... set column pointer for pd matrix A

      jcol_pc = (pc_ipol-1)*3
      jcol_cg = (cg_ipol-1)*3

c............ NOW, loop for each pick

      do 100 ipk = 1, npicks

c....... find rotated point F in vector form
c converts point to vector, multiplies vector by stage rot matrix
c normalizes resulting vector with rotated point
c
        call pnt2vec( S_LOC(ipk,1), S_LOC(ipk,2), S)
        call matxvec(ST, S, F )
        call normvec(F)

c converts rotated point vector back to ll-lt
c
        call vec2pnt(F, F_LOC(ipk,1), F_LOC(ipk,2))

cd        write(*,'(4(a,f9.4),a)') '(',S_LOC(ipk,1), ':',S_LOC(ipk,2),
cd     .              ') rotated to (',F_LOC(ipk,1), ':',F_LOC(ipk,2),')'


c  ............calculate error +ve if on side of target gt.circle pole
c             -  and pds wrt F
c

        call epdcalc(F, GCPT, e, DEDF)

        css=css+e**2


cd        write(*,'(a,f10.6)') 'error ', e

c........... finally, increment irow and write to matrices A and B 
c
       
        irow = irow +1

        do 50 j = 1, lpr
          A(irow, j) = 0.
50      continue

        call matxvec(DSTDP1, S, DFDP)
        A(irow, jcol_pc+1) = vecdprod ( DEDF, DFDP) 


        call matxvec(DSTDP2, S, DFDP )
        A(irow, jcol_pc+2) = vecdprod ( DEDF, DFDP) 


        call matxvec(DSTDP3, S, DFDP )
c Adrian half angle:
c       A(irow, jcol_pc+3) = vecdprod ( DEDF, DFDP) *pc_sign*0.5
       A(irow, jcol_pc+3) = vecdprod ( DEDF, DFDP) *pc_sign

cd      write(*, '( a,3(x,f9.4) )') 'pd wrt p->c lat,lon,angle ',
cd     .      A(irow,jcol_pc+1), A(irow, jcol_pc+2), A(irow, jcol_pc+3)

c......... then obtain pd's for pole centre->great circle


        call matxvec(DSTDP4, S, DFDP )
        A(irow, jcol_cg+1) = vecdprod ( DEDF, DFDP)


        call matxvec(DSTDP5, S, DFDP )
        A(irow, jcol_cg+2) = vecdprod ( DEDF, DFDP)


        call matxvec(DSTDP6, S, DFDP)
c Adrian half angle
c        A(irow, jcol_cg+3) = vecdprod ( DEDF, DFDP) *cg_sign*0.5
        A(irow, jcol_cg+3) = vecdprod ( DEDF, DFDP) *cg_sign


cd      write(*, '( a,3(x,f9.4) )') 'pd wrt c->g lat,lon,angle ',
cd     .      A(irow,jcol_cg+1), A(irow, jcol_cg+2), A(irow, jcol_cg+3)

        B(irow) = -e 

        PK_LOC(irow,1) = S_LOC(ipk,1)
        PK_LOC(irow,2) = S_LOC(ipk,2)
        PK_LOC(irow,3) = dble( S_ID(ipk) )/ 1000000.


100   continue

c
      return
      end


