c
      subroutine magpickcalc3p_2pol( irow, lmpk, npicks, S_LOC, S_ID,
     .        F_LOC, pc_ipol, pc_12lat, pc_12lon, pc_12ang,
     .               pc_23lat, pc_23lon,  pc_23ang, pc_sign,
     .               cg_ipol, cg_12lat, cg_12lon, cg_12ang,
     .               cg_23lat, cg_23lon, cg_23ang,  cg_sign,
     .     gcp_lat, gcp_lon, css, ldt, lpr, npars1p, A, B , PK_LOC)
c
c
c - magpickcalc_2pol for 3rd plate pair in 3-plate problem
c
c  ---- for a set of anomaly picks, rotate and fit to a great circle,
c   calculating errors (B), and partial derivatives (A) wrt the parameters
c   of the FOUR consituent finite rotations from which the fitting rotation
c   pole is derived (fitting rotation comprises of rotation pc - pick to
c   centre, then cg - centre to great circle, and for 3rd plate, each of these
c   is derived from finite rotation poles of the first 2 plate pairs).
c
c Written by  A. Nankivell 1995-97
c
c   INPUT VARIABLES
c
c  S_LOC           -- array of coordinates of unrotated (starting) points.
c
c  S_ID            -- array storing identifier for magnetics pick
c
c  F_LOC           -- array of coordinates of rotated (final) points.
c
c  pc_ipol         -- index for pole rotating
c                      from pick to centre(current ridge)
c  pc_lat/lon/ang  -- (finite) rotation parameters for pc_ipol'th pole
c  pc_sign         -- positive/negative rotation for angle pc_ang
c
c  cg_ipol         -- index for pole rotating
c                      from centre(current ridge) to great circle
c  cg_lat/lon/ang  -- (finite) rotation parameters for cg_ipol'th pole
c  cg_sign         -- positive/negative rotation for angle cg_ang
c  gcp_lat/lon     -- coordinates of pole whose great-circle best fits
c                      the anomalies to be matched. 
c  css            -- cumulative sum of squared errors
c


      implicit none
c
      integer irow, lmpk, npicks, lpr, ldt, npars1p
      integer pc_ipol, pc_sign, cg_ipol, cg_sign
      integer S_ID(lmpk)

      double precision pc_12lat, pc_12lon, pc_12ang
      double precision pc_23lat, pc_23lon, pc_23ang
      double precision cg_12lat, cg_12lon, cg_12ang
      double precision cg_23lat, cg_23lon, cg_23ang
      double precision gcp_lat, gcp_lon, css
      double precision pangsep, vecdprod
      double precision S_LOC(lmpk,2), F_LOC(lmpk,2)
      double precision A(ldt,lpr), B(ldt), PK_LOC(ldt,3)
c

      integer j, jcol_pc, jcol_cg, ipk

      double precision gcpt_lat, gcpt_lon, e
      double precision pc_13lat, pc_13lon, pc_13ang
      double precision cg_13lat, cg_13lon, cg_13ang
      double precision R12pc(3,3), R23pc(3,3), R13pc(3,3), Rpc(3,3)
      double precision R12cg(3,3), R23cg(3,3), R13cg(3,3), Rcg(3,3)
      double precision DRDp(3,3), ST(3,3)
      double precision DMDlat(3,3), DMDlon(3,3), DMDang(3,3)
      double precision S(3), F(3), DEDF(3), GCPT(3), DFDP(3)
      double precision DSTDp1(3,3), DSTDp2(3,3), DSTDp3(3,3)
      double precision DSTDp4(3,3), DSTDp5(3,3), DSTDp6(3,3)
      double precision DSTDp7(3,3), DSTDp8(3,3), DSTDp9(3,3)
      double precision DSTDp10(3,3), DSTDp11(3,3), DSTDp12(3,3)

c
c.............. FIRST carry out general routines common to each pick


c.......... Construct a working pole "gcpt", such that
c     gcpt and s are on the same side of great-circle:
c              taking first point as reference

      if (pangsep(S_LOC(1,1),S_LOC(1,2), gcp_lat, gcp_lon).gt.90.) then
        call diamg( gcp_lat, gcp_lon, gcpt_lat, gcpt_lon )
      else
        gcpt_lat = gcp_lat
        gcpt_lon = gcp_lon
      endif


      call pnt2vec(gcpt_lat, gcpt_lon, GCPT)

c........ get rotation matrices for 1st rotation pole (pick to centre)
c    
      call pol2mat(pc_12lat, pc_12lon, pc_12ang, R12pc)
      call pol2mat(pc_23lat, pc_23lon, pc_23ang, R23pc)
      call sumrots(R12pc, R23pc, R13pc)

      call mat2pol(R13pc, pc_13lat, pc_13lon, pc_13ang)

      call pol2mat(pc_13lat, pc_13lon, pc_13ang*pc_sign*0.5, Rpc)

cd      write(*, '( 3(a,f10.5),a )' ) 'Rot p->c : ',pc_13ang*pc_sign*0.5,
cd     .    ' about (',pc_13lon, ',' ,pc_13lat, ')'

c........ get rotation matrix for 2nd rotation pole (centre to gcircle)
c    
      call pol2mat(cg_12lat, cg_12lon, cg_12ang, R12cg)
      call pol2mat(cg_23lat, cg_23lon, cg_23ang, R23cg)
      call sumrots(R12cg, R23cg, R13cg)

      call mat2pol(R13cg, cg_13lat, cg_13lon, cg_13ang)

      call pol2mat(cg_13lat, cg_13lon, cg_13ang*cg_sign*0.5, Rcg)

cd      write(*, '( 3(a,f10.5),a )' ) 'Rot c->g : ',cg_13ang*cg_sign*0.5,
cd     .    ' about (',cg_13lon, ',' ,cg_13lat, ')'

c....... obtain resultant rotation matrix for 'stage'
c       rotation pole (pick to gcircle)
    
      call sumrots(Rpc, Rcg, ST)

c........ find partial derivatives of this rotation matrix

c......... w.r.t. poles of plate pair 1-2


      call pol2pdmats(pc_12lat,pc_12lon,pc_12ang,DMDlat,DMDlon,DMDang)

      call rotnpd2scpd( DMDlat, R23pc, R13pc, dble(0.5*pc_sign), DRDp)
      call sumrots( DRDp, Rcg, DSTDp1)

      call rotnpd2scpd( DMDlon, R23pc, R13pc, dble(0.5*pc_sign), DRDp)
      call sumrots( DRDp, Rcg, DSTDp2)

      call rotnpd2scpd( DMDang, R23pc, R13pc, dble(0.5*pc_sign), DRDp)
      call sumrots( DRDp, Rcg, DSTDp3)


      call pol2pdmats(cg_12lat,cg_12lon,cg_12ang,DMDlat,DMDlon,DMDang)

      call rotnpd2scpd( DMDlat, R23cg, R13cg, dble(0.5*cg_sign), DRDp)
      call sumrots( Rpc, DRDp, DSTDp4)

      call rotnpd2scpd( DMDlon, R23cg, R13cg, dble(0.5*cg_sign), DRDp)
      call sumrots( Rpc, DRDp, DSTDp5)

      call rotnpd2scpd( DMDang, R23cg, R13cg, dble(0.5*cg_sign), DRDp)
      call sumrots( Rpc, DRDp, DSTDp6)


c......... w.r.t. poles of plate pair 2-3

      call pol2pdmats(pc_23lat,pc_23lon,pc_23ang,DMDlat,DMDlon,DMDang)

      call rotnpd2scpd( R12pc, DMDlat, R13pc, dble(0.5*pc_sign), DRDp)
      call sumrots( DRDp, Rcg, DSTDp7)

      call rotnpd2scpd( R12pc, DMDlon, R13pc, dble(0.5*pc_sign), DRDp)
      call sumrots( DRDp, Rcg, DSTDp8)

      call rotnpd2scpd( R12pc, DMDang, R13pc, dble(0.5*pc_sign), DRDp)
      call sumrots( DRDp, Rcg, DSTDp9)


      call pol2pdmats(cg_23lat,cg_23lon,cg_23ang,DMDlat,DMDlon,DMDang)

      call rotnpd2scpd( R12cg, DMDlat, R13cg, dble(0.5*cg_sign), DRDp)
      call sumrots( Rpc, DRDp, DSTDp10)

      call rotnpd2scpd( R12cg, DMDlon, R13cg, dble(0.5*cg_sign), DRDp)
      call sumrots( Rpc, DRDp, DSTDp11)

      call rotnpd2scpd( R12cg, DMDang, R13cg, dble(0.5*cg_sign), DRDp)
      call sumrots( Rpc, DRDp, DSTDp12)


c.......... set column pointer for pd matrix A

      jcol_pc = (pc_ipol-1)*3
      jcol_cg = (cg_ipol-1)*3

c............ NOW, loop for each pick

      do 100 ipk = 1, npicks

c....... find rotated point F in vector form
c
        call pnt2vec( S_LOC(ipk,1), S_LOC(ipk,2), S)
        call matxvec(ST, S, F )
        call normvec(F)


        call vec2pnt(F, F_LOC(ipk,1), F_LOC(ipk,2))

cd        write(*,'(4(a,f9.4),a)') '(',S_LOC(ipk,1), ':',S_LOC(ipk,2),
cd     .              ') rotated to (',F_LOC(ipk,1), ':',F_LOC(ipk,2),')'

c  ............calculate error +ve if on side of target gt.circle pole
c             -  and pds wrt F
c

        call epdcalc(F, GCPT, e, DEDF)

        css=css+e**2

c
c........... finally, increment irow and write to matrices A and B 
c
       
        irow = irow +1

        do 50 j = 1, lpr
          A(irow, j) = 0.
50      continue

c......... first for poles of plate pair 1-2

        call matxvec(DSTDP1, S, DFDP)
        A(irow, jcol_pc+1) = vecdprod ( DEDF, DFDP) 


        call matxvec(DSTDP2, S, DFDP )
        A(irow, jcol_pc+2) = vecdprod ( DEDF, DFDP) 


        call matxvec(DSTDP3, S, DFDP )
        A(irow, jcol_pc+3) = vecdprod ( DEDF, DFDP)


        call matxvec(DSTDP4, S, DFDP )
        A(irow, jcol_cg+1) = vecdprod ( DEDF, DFDP)


        call matxvec(DSTDP5, S, DFDP )
        A(irow, jcol_cg+2) = vecdprod ( DEDF, DFDP)


        call matxvec(DSTDP6, S, DFDP)
        A(irow, jcol_cg+3) = vecdprod ( DEDF, DFDP) 

c......... now for poles of plate pair 2-3

        call matxvec(DSTDP7, S, DFDP)
        A(irow, npars1p+jcol_pc+1) = vecdprod ( DEDF, DFDP) 


        call matxvec(DSTDP8, S, DFDP )
        A(irow, npars1p+jcol_pc+2) = vecdprod ( DEDF, DFDP) 


        call matxvec(DSTDP9, S, DFDP )
        A(irow, npars1p+jcol_pc+3) = vecdprod ( DEDF, DFDP) 


        call matxvec(DSTDP10, S, DFDP )
        A(irow, npars1p+jcol_cg+1) = vecdprod ( DEDF, DFDP)


        call matxvec(DSTDP11, S, DFDP )
        A(irow, npars1p+jcol_cg+2) = vecdprod ( DEDF, DFDP)


        call matxvec(DSTDP12, S, DFDP)
        A(irow, npars1p+jcol_cg+3) = vecdprod ( DEDF, DFDP)

        B(irow) = -e 

        PK_LOC(irow,1) = S_LOC(ipk,1)
        PK_LOC(irow,2) = S_LOC(ipk,2)
        PK_LOC(irow,3) = dble( S_ID(ipk) )/ 1000000.

100   continue

c
      return
      end


