c
c
      subroutine magpickcalc3p( irow, lmpk, npicks, S_LOC, S_ID, F_LOC,
     .   ipol, r12lat, r12lon, r12ang, r23lat, r23lon, r23ang, signrot,
     .    gcp_lat, gcp_lon, css, ldt, lpr, npars1p, A, B, PK_LOC)
c
c - magpickcalc for 3rd plate pair in 3-plate problem
c
c  ---- for a set of anomaly picks, rotate and fit to a great circle,
c   calculating errors (B), and partial derivatives (A) wrt the parameters
c   of the two consituent finite rotations from which the 3rd finite rotation
c   pole is derived
c
c Written by  A. Nankivell 8/95 
c
c   INPUT VARIABLES
c
c  s_lat, s_lon   -- coordinates of unrotated (starting) point.
c  ipol           -- index of pole required to rotate pick to g-c
c  r12lat/lon/ang -- finite rotation pole parameters (plate pair 1-2)
c  r23lat/lon/ang -- finite rotation pole parameters (plate pair 2-3)
c  signrot           -- positive or negative rotation, +-1 if matching a 
c		      conjugate pair, or +-0.5 if rotating to/from ridge
c  gcp_lat/lon    -- coordinates of pole whose great-circle best fits
c                      the anomalies to be matched. 
c                    Error criterion: distance between rotated point
c                      ("s" rotated by "rp"), and "gcp".
c  css            -- cumulative sum of squared errors
c

      implicit none

      integer irow, lmpk, npicks, ipol, lpr, ldt, npars1p
      integer S_ID(lmpk)

      double precision r12lat, r12lon, r12ang
      double precision r23lat, r23lon, r23ang
      double precision signrot, gcp_lat, gcp_lon, css
      double precision pangsep, vecdprod
      double precision S_LOC(lmpk,2),  F_LOC(lmpk,2)
      double precision A(ldt,lpr), B(ldt), PK_LOC(ldt,3)
c
      integer i, j, jcol, ipk

      double precision gcpt_lat, gcpt_lon
      double precision r13lat, r13lon, r13ang, e
      double precision R12(3,3), R23(3,3), R13(3,3), R(3,3)
      double precision DMDlat(3,3), DMDlon(3,3), DMDang(3,3)
      double precision S(3), F(3), DEDF(3), GCPT(3)
      double precision DRDP1(3,3), DRDP2(3,3), DRDP3(3,3) 
      double precision DRDP4(3,3), DRDP5(3,3), DRDP6(3,3) 
      double precision DFDP(3)
cd      double precision rlat, rlon, rang
c
c.............. FIRST carry out general routines common to each pick

c......... Construct a working pole "gcpt", such that
c            gcpt and s are on the same side of great-circle:
c              taking first point as reference

      if (pangsep( S_LOC(1,1),S_LOC(1,2), gcp_lat,gcp_lon).gt.90.) then
        call diamg( gcp_lat, gcp_lon, gcpt_lat, gcpt_lon )
      else
        gcpt_lat = gcp_lat
        gcpt_lon = gcp_lon
      endif


      call pnt2vec(gcpt_lat, gcpt_lon, GCPT)

c.......... get rotation matrix for given rotation
c    
      call pol2mat(r12lat, r12lon, r12ang, R12)
      call pol2mat(r23lat, r23lon, r23ang, R23)
      call sumrots(R12, R23, R13)


      if (signrot .eq. 1.) then

        do 10 i =1,3
          do 10 j = 1,3
            R(i,j) = R13(i,j)
10      continue

      else  

        call mat2pol(R13, r13lat, r13lon, r13ang)
        call pol2mat(r13lat, r13lon, r13ang*signrot, R)

      endif


cd      call mat2pol(R, rlat, rlon, rang)
cd      write(*, '( 3(a,f10.5),a )' ) 'rotation of ',rang,
cd     .     ' about (' ,rlon, ',' ,rlat, ')'

c........... get partial derivative matrices for the rotation poles
c

      call pol2pdmats(r12lat,r12lon,r12ang,DMDlat,DMDlon,DMDang)
      call rotnpd2scpd( DMDlat, R23, R13, signrot, DRDp1)
      call rotnpd2scpd( DMDlon, R23, R13, signrot, DRDp2)
      call rotnpd2scpd( DMDang, R23, R13, signrot, DRDp3)

      call pol2pdmats(r23lat,r23lon,r23ang,DMDlat,DMDlon,DMDang)
      call rotnpd2scpd( R12, DMDlat, R13, signrot, DRDp4)
      call rotnpd2scpd( R12, DMDlon, R13, signrot, DRDp5)
      call rotnpd2scpd( R12, DMDang, R13, signrot, DRDp6)

c.......... set column pointer for pd matrix A

      jcol = (ipol-1)*3

c
c....... NOW, loop for each pick
c

      do 100 ipk = 1, npicks

c........... find rotated point F in vector form
c
        call pnt2vec( S_LOC(ipk,1), S_LOC(ipk,2), S)
        call matxvec(R, S, F )
        call normvec(F)


        call vec2pnt(F, F_LOC(ipk,1), F_LOC(ipk,2))

cd        write(*,'(4(a,f9.4),a)') '(',S_LOC(ipk,1), ':',S_LOC(ipk,2),
cd     .              ') rotated to (',F_LOC(ipk,1), ':',F_LOC(ipk,2),')'


c........... calculate error +ve if on side of target gt.circle pole
c             and pds wrt F

        call epdcalc(F, GCPT, e, DEDF)

        css=css+e**2

c
c........... finally, increment irow and write to matrices A and B 
c

        irow = irow +1

        do 50 j = 1, lpr
          A(irow, j) = 0.
50      continue

        call matxvec(DRDp1, S, DFDP)
        A(irow, jcol+1) = vecdprod ( DEDF, DFDP)

        call matxvec(DRDp2, S, DFDP)
        A(irow, jcol+2) = vecdprod ( DEDF, DFDP)

        call matxvec(DRDp3, S, DFDP)
        A(irow, jcol+3) = vecdprod ( DEDF, DFDP) 

        call matxvec(DRDp4, S, DFDP)
        A(irow, npars1p+jcol+1) = vecdprod ( DEDF, DFDP)

        call matxvec(DRDp5, S, DFDP)
        A(irow, npars1p+jcol+2) = vecdprod ( DEDF, DFDP)

        call matxvec(DRDp6, S, DFDP)
        A(irow, npars1p+jcol+3) = vecdprod ( DEDF, DFDP) 

        B(irow) = -e 

        PK_LOC(irow,1) = S_LOC(ipk,1)
        PK_LOC(irow,2) = S_LOC(ipk,2)
        PK_LOC(irow,3) = dble( S_ID(ipk) )/ 1000000.

100   continue
c
      return
      end
