c
c
      subroutine magpickcalc( irow, lmpk, npicks, S_LOC, S_ID, F_LOC,
     .             ipol, p_lat, p_lon, p_ang, signrot, gcp_lat, gcp_lon,
     .                css, ldt, lpr, A, B, PK_LOC)
c
c
c  ---- for a set of anomaly picks, rotate and fit to a great circle
c   calculating errors (B) and partial derivatives (A) wrt the rotation pole
c
c Written by  A. Nankivell 8/95 
c
c  MAIN INPUT VARIABLES
c
c  S_LOC           -- array of coordinates of unrotated (starting) points.
c  ipol           -- index for pole rotating pick to great circle
c  p_lat/lon/ang  -- finite rotation  parameters for ipol'th pole
c  signrot           -- positive or negative rotation, +-1 if matching a 
c		      conjugate pair, or +-0.5 if rotating to/from ridge
c  gcp_lat/lon    -- coordinates of pole whose great-circle best fits
c                      the anomalies to be matched. 
c                    Error criterion: distance between rotated point
c                      ("s" rotated by "rp"), and "gcp".
c  css            -- cumulative sum of squared errors
c


      implicit none

      integer irow, lmpk, npicks, ipol, lpr, ldt
      integer S_ID(lmpk)

      double precision p_lat, p_lon, p_ang, signrot
      double precision gcp_lat, gcp_lon, css
      double precision S_LOC(lmpk,2), F_LOC(lmpk,2)
      double precision A(ldt,lpr), B(ldt), PK_LOC(ldt,3)
c
      integer j, jcol, ipk

      double precision pangsep, vecdprod
      double precision gcpt_lat, gcpt_lon, p_rang, e
      double precision R(3,3), DRDPLAT(3,3), DRDPLON(3,3), DRDPANG(3,3)
      double precision S(3), F(3), DEDF(3), GCPT(3)
      double precision DFDP(3)
c


c.............. FIRST carry out general routines common to each pick

c......... Construct a working pole "gcpt", such that
c            gcpt and picks are on the same side of great-circle:
c              taking first point as reference

      if (pangsep( S_LOC(1,1),S_LOC(1,2), gcp_lat, gcp_lon).gt.90.) then
        call diamg( gcp_lat, gcp_lon, gcpt_lat, gcpt_lon )
      else
        gcpt_lat = gcp_lat
        gcpt_lon = gcp_lon
      endif


      call pnt2vec(gcpt_lat, gcpt_lon, GCPT)

c.......... get rotation matrix for given rotation pole
c    
      p_rang = p_ang*signrot

      call pol2mat(p_lat, p_lon, p_rang, R)

cd      write(*, '( 3(a,f9.4) )') 'Rotation of ',p_rang,' around ',
cd     .                                              p_lat, ',' ,p_lon

c........... get partial derivative matrices for the rotation pole
c

      call pol2pdmats(p_lat,p_lon,p_rang,DRDPLAT,DRDPLON,DRDPANG)

c.......... set column pointer for pd matrix A

      jcol = (ipol-1)*3

c
c....... NOW, loop for each pick
c

      do 100 ipk = 1, npicks


c........... find rotated point F in vector form
c
        call pnt2vec( S_LOC(ipk,1), S_LOC(ipk,2), S)
        call matxvec(R, S, F )
        call normvec(F)


        call vec2pnt(F, F_LOC(ipk,1), F_LOC(ipk,2))

cd        write(*,'(4(a,f9.4),a)') '(',S_LOC(ipk,1), ':',S_LOC(ipk,2),
cd     .              ') rotated to (',F_LOC(ipk,1), ':',F_LOC(ipk,2),')'


c........... calculate error +ve if on side of target gt.circle pole
c             and pds wrt F

        call epdcalc(F, GCPT, e, DEDF)

        css=css+e**2

cd        write(*,'(a,f10.6)') 'error ', e

c
c........... finally, increment irow and write to matrices A and B 
c

        irow = irow +1

        do 50 j = 1, lpr
          A(irow, j) = 0.
50      continue

        call matxvec(DRDPLAT, S, DFDP)
        A(irow, jcol+1) = vecdprod ( DEDF, DFDP) 

        call matxvec(DRDPLON, S, DFDP)
        A(irow, jcol+2) =  vecdprod ( DEDF, DFDP) 

        call matxvec(DRDPANG, S, DFDP)
        A(irow, jcol+3) = vecdprod ( DEDF, DFDP) * signrot

 
cd      write(*, '( a,3(x,f9.4) )') 'pd wrt lat,lon,angle ',
cd     .	         A(irow, jcol+1), A(irow, jcol+2), A(irow, jcol+3)

       B(irow) = -e 

        PK_LOC(irow,1) = S_LOC(ipk,1)
        PK_LOC(irow,2) = S_LOC(ipk,2)
        PK_LOC(irow,3) = dble( S_ID(ipk) )/ 1000000.


100   continue

c
      return
      end
