c
      subroutine gcfit( PLAT, PLON, n, gclat, gclon,
     .			gp1lat, gp1lon, gp2lat, gp2lon )
c
c
c Fits a great circle to a series of points on a sphere.
c
c Peter Shaw, Woods Hole Oceanographic Institution
c             December 1988
c
c Adapted by A Nankivell for double precision operation
c
c INPUT VARIABLES: PLAT(i), PLON(i) -- coordinates of points
c                  n  -- number of points
c
c OUTPUT VARIABLES: gclat, gclon -- coordinates of pole of best-fitting
c                                 great circle.
c
c Method of eigenvalues; G. S. Watson, J. Geol., 74:786-797, 1966.
c
      implicit none
c
      integer n

      double precision gclat, gclon
      double precision PLAT(n), PLON(n)
      double precision gp1lat, gp1lon, gp2lat, gp2lon 
c
      integer i, j, job, info, imax1, imax2

      double precision GCP(3), S(4), WORK(3), E(3), TMP(3), P(3)
      double precision C(3,3), U(3,3), V(3,3), GC_PT(3, 500)
      double precision vecdprod, sep, maxsep, raddeg
c
c.... Make symmetric 3x3 correlation matrix c:

      raddeg=0.1745329251994329D-01
		

      call dcmake( PLAT, PLON, n, C )

c
c.... Compute singular value decomp; same as eigenvalue decomp
c.... because c is symmetric:

      job=10

c....   compute only left singular vectors.

      call dssvdc( C,3,3,3,S,E,U,3,V,3,WORK,job,info)
 
      if(info.ne.0) print*, 'bad call to dssvdc. (gcfit)'

c....
c.... sing. values are arranged in s in decreasing size.
c.... Need the smallest of these, pointing toward the pole
c.... of the great circle.

      GCP(1) = U(1,3)
      GCP(2) = U(2,3)
      GCP(3) = U(3,3)


      call vec2pnt( GCP, gclat, gclon )

c

c....... in addition, for use in displaying , calculate points on gc closest
c          to the points given, and find start and end points for plotting gc


      do 1001 i = 1, n

        call pnt2vec( PLAT(i), PLON(i), P)

	call vecxprod( GCP, P, TMP)
	call vecxprod( TMP, GCP, P)


	GC_PT(1,i) = P(1)
	GC_PT(2,i) = P(2)
	GC_PT(3,i) = P(3)

c	      	  	      			print *, 'wrote GC_PT'

1001  continue


      maxsep = 0.
      do 2001 i = 1, n

	do 2001 j = i+1, n
	  sep = dacos( vecdprod( GC_PT(1,i) , GC_PT(1,j) ) )/raddeg

	  if ( sep .gt. maxsep )then
		maxsep = sep
		imax1 = i
		imax2 = j
	  endif

2001  continue

      call vec2pnt( GC_PT(1,imax1), gp1lat, gp1lon )
      call vec2pnt( GC_PT(1,imax2), gp2lat, gp2lon )


      return
      end
