c
c
      subroutine gauss( ARRAY, nmax, n, mean, stdev, scale )
c      ---------------------------------------------
c
c      subroutine gauss is designed to calculate the
c      mean and standard deviation for the best-fit
c      gaussian distribution for the a series of
c      n real numbers in the ARRAY "ARRAY".
c
c   ---- provided by H v.Heijst, but before that.....?
c
      implicit none
c
c   .... input variables

      integer nmax, n

      double precision mean, stdev, scale
      double precision ARRAY(nmax)
c
c   .... internal variables

      integer nbins, npar, bnr
      integer iter,i, k, ii, kk

      parameter (nbins=100)
      parameter (npar=3)

      integer nrhts(nbins)

      double precision avg, sig, armin, armax, rmax
      double precision r2pi, r, binwid
      double precision tot, sigin, rkin, calc, rmnin
      double precision res1, c1, c2, c3, ydat

      double precision ata(npar,npar),atd(npar),afunc(npar)
      double precision x(nbins),y(nbins)

      double precision calcgauss

c----  check number of input points n
c

      if( n .lt. 2 ) then

        write( 6, 11 ) n
 11     format(/,5x,'error : error occurred in subroutine gauss',/,
     .           5x,'number of input points ',i5,' is too few',/,
     .           5x,'for standard deviation to be determined',/)

c       stop  ->  statement removed, so inversions can be carried out
c                 with only one type of data

        mean = 0.
        stdev = 999.9
        return


      end if
      
      r2pi=sqrt(2.0*3.141592654)


      sig=0.
      avg=0.
      armin=9999.
      armax=-9999.
  
      
c determine average and standard deviation
      Do i=1,n
       avg=avg+ARRAY(i)
       armin=Min(ARRAY(i),armin)
       armax=Max(ARRAY(i),armax)
      Enddo
      avg=avg/dble(n)
      Do i=1,n
       sig=sig+(ARRAY(i)-avg)**2
      Enddo
      sig=sqrt(sig/dble(n-1))

cd      write(6,21) 'number of points= ',n,' mean= ',avg,' sigma= ',sig
cd      write(6,22) 'min= ',armin,' max= ',armax
cd 21   format(a,i5,2(a,f9.4))
cd 22   format(2(a,f9.4))
c..... now bin data 


      r=armax-armin
      binwid=r/dble(nbins)
      
     
      Do i=1,nbins
       nrhts(i)=0
      Enddo

      Do i=1,n
       bnr=Nint((ARRAY(i)-armin)/binwid)+1
       nrhts(bnr)=nrhts(bnr)+1
      Enddo

      rmax = 0.

      Do i=1,nbins
       x(i)=((dble(i)-.5)*binwid)+ armin
       y(i)=dble(nrhts(i))
       rmax=Max(rmax,y(i))
      Enddo

      sigin=sig
      rmnin=avg
      rkin=rmax*r2pi*sigin

      res1  = 0.
      do i=1,nbins
          calc=calcgauss(x(i),rmnin,sigin,rkin)
c          write(13,'(2f11.3)') x(i),calc
          res1=res1+(y(i)-calc)**2
      enddo

c
c     FITTING f(x)=y=(1.0/(sigin*r2pi))*exp{-((x-rmnin)**2)/(2*sigin**2)}
c
      do iter=1,19
          do ii=1,npar
              do kk=1,npar
                  ata(ii,kk)=0.0
              enddo
              atd(ii)=0.0
          enddo
          do i=1,nbins
              c1=-1.0*((x(i)-rmnin)**2)/(2.0*sigin*sigin)
              c2=1.0/(sigin*r2pi)
              c3=exp(c1)
              afunc(1)=(rkin/sigin)*c2*c3*((-2.0*c1)-1.0)
              afunc(2)=c2*rkin*c3*(x(i)-rmnin)/(sigin*sigin)
              afunc(3)=c2*c3
              ydat=y(i)- calcgauss(x(i),rmnin,sigin,rkin)
              do ii=1,npar
                  do kk=1,npar
                      ata(ii,kk)=ata(ii,kk)+afunc(ii)*afunc(kk)
                  enddo
                  atd(ii)=atd(ii)+afunc(ii)*ydat
              enddo
          enddo
          call gaussj(ata,npar,npar,atd,1,1)

c ................singular flag
          if(ata(1,1) .eq. 12345.6789) then
             mean  =  12345.6789
             stdev =  12345.6789
             scale =  12345.6789
             return
          endif

          sigin=sigin+atd(1)
          if(sigin.lt.0.0) then
              sigin=0.5
          else
              rmnin=rmnin+atd(2)
              rkin=rkin+atd(3)
          endif
          tot=0.0
          do k=1,npar
              tot=tot+abs(atd(k))
          enddo
          if(tot.lt.0.001) goto 4000
          res1=0.0
          do i=1,nbins
              calc=calcgauss(x(i),rmnin,sigin,rkin)
              res1=res1+(y(i)-calc)**2
          enddo
cd          write(6,"( 'parameter perturbations ',3f12.3,' resid ',
cd     .                                            e12.4)") atd,res1
      enddo
 4000 continue

cd      write(6,*) 'new parameters          ',rmnin,sigin,rkin

      mean = rmnin
      stdev = sigin
      scale = rkin

      return
      end



c ---------------------------------------------------------------------

      double precision function calcgauss(x,rmean,sigma,rkin)

      implicit none
      double precision  x, rmean, sigma, rkin
      double precision rnum

      rnum=-((x-rmean)**2)/(2.0*sigma*sigma)
      calcgauss=(rkin/(sigma*2.5066283))*exp(rnum)

      return
      end

c ----------------------------------------------------------------------

      SUBROUTINE gaussj(a,n,np,b,m,mp)

      implicit none

      INTEGER m,mp,n,np,NMAX
      DOUBLE PRECISION a(np,np),b(np,mp)
      PARAMETER (NMAX=50)
      INTEGER i,icol,irow,j,k,l,ll,indxc(NMAX),indxr(NMAX),ipiv(NMAX)
      DOUBLE PRECISION big,dum,pivinv
      do 11 j=1,n
        ipiv(j)=0
11    continue
      do 22 i=1,n
        big=0.
        do 13 j=1,n
          if(ipiv(j).ne.1)then
            do 12 k=1,n
              if (ipiv(k).eq.0) then
                if (abs(a(j,k)).ge.big)then
                  big=abs(a(j,k))
                  irow=j
                  icol=k
                endif
              else if (ipiv(k).gt.1) then
                 a(1,1) = 12345.6789
                 print *, 'singular matrix in gaussj'
                 return
              endif
12          continue
          endif
13      continue
        ipiv(icol)=ipiv(icol)+1
        if (irow.ne.icol) then
          do 14 l=1,n
            dum=a(irow,l)
            a(irow,l)=a(icol,l)
            a(icol,l)=dum
14        continue
          do 15 l=1,m
            dum=b(irow,l)
            b(irow,l)=b(icol,l)
            b(icol,l)=dum
15        continue
        endif
        indxr(i)=irow
        indxc(i)=icol
        if (a(icol,icol).eq.0.)then
                 a(1,1) = 12345.6789
                 print *, 'singular matrix in gaussj'
                 return
        endif
        pivinv=1./a(icol,icol)
        a(icol,icol)=1.
        do 16 l=1,n
          a(icol,l)=a(icol,l)*pivinv
16      continue
        do 17 l=1,m
          b(icol,l)=b(icol,l)*pivinv
17      continue
        do 21 ll=1,n
          if(ll.ne.icol)then
            dum=a(ll,icol)
            a(ll,icol)=0.
            do 18 l=1,n
              a(ll,l)=a(ll,l)-a(icol,l)*dum
18          continue
            do 19 l=1,m
              b(ll,l)=b(ll,l)-b(icol,l)*dum
19          continue
          endif
21      continue
22    continue
      do 24 l=n,1,-1
        if(indxr(l).ne.indxc(l))then
          do 23 k=1,n
            dum=a(k,indxr(l))
            a(k,indxr(l))=a(k,indxc(l))
            a(k,indxc(l))=dum
23        continue
        endif
24    continue
  
      return
      end 


