      subroutine fzpickproc( pairid, lpl, npoles, lfpk,
     .        ldt, lpr, npicks, FPOLES, IDPOL, STAGEAB, STAGEBA, FLOW,
     .        DSTABDP, DSTBADP, SEEDPD, NPERPOLE, PICKLOCS,
     .        PK_LOC, A_S, B_S, nloops, A, B, W)

c
c   main processing routine for determination of fracture zone errors
c   and partial derivatives for ALL of the fracture zones in the
c   dataset of one plate pair
c
c
      implicit none
c
c .......... passed variables .........

      integer lpl, lfpk, ldt, lpr
      integer npoles, npicks, nloops

      character*6 pairid

c --------------- declare arrays -----------------

c....   Number of fz picks per stage
      integer NPERPOLE(lpl)

c....   Finite poles (lat,lon,angle )
      double precision FPOLES(lpl,3)
c....   Anomaly ID for finite rotation poles 
      character*4 IDPOL(0:lpl)

c....   Stage poles (lat,lon,angle)
      double precision STAGEAB(lpl,3), STAGEBA(lpl,3)

c....   Flowline points( 3-vectors)
      double precision  FLOW(0:lpl,3)

c....   Partial derivative matrices for the stage poles
      double precision DSTABDP(lpl,6,3), DSTBADP(lpl,6,3)

c....   Radial partial derivatives of flowline points
      double precision SEEDPD(lpl)

c....   Location of zero age flowline, or seed, points
      double precision SEED(2)

c....   Lat./lon. of picks for a fz
      double precision PICKLOCS(lfpk, 2)

c....   Lat./lon. of all picks
      double precision PK_LOC(ldt,2)

c....   Partial derivative matrix A, error vector B 
      double precision A(ldt,lpr), B(ldt)

c....   Partial derivative matrix A_S, error vector B_S for seed inv.
      double precision A_S(lfpk,1), B_S(lfpk)

c....   Weight matrix W 
      double precision W(ldt)

c
c ........ variables used in subroutine ...............
c
      integer i
      integer iside, irow, iwrow, ios
      integer nfiles, ifiles, nvec, nuse
      integer jpole, spole

      double precision sse

      character * 3  plid
      character * 4  spolid
      character * 40 direc
      character * 40 fz_file
      character * 80 openfile

c -----------------------------------------------------

c....   Define data directory path
c      data direc /'/home/piglet_data2/adriann/recon/data/'/
      data direc /'data/'/

c
c --------------------- start of real code ------------------
c
c
c.... Calculate Stage poles from the Finite rotation poles:
c
      call fpoles2stage( lpl, npoles, FPOLES, STAGEAB, STAGEBA )
c
c
c.....  for Adrian - outputs stage poles to screen

      write(6,'(a)') 'calculated stage poles' 

cd      do 666 jpole = 1, npoles
cd         print *, jpole
cd         print *,'Finite pole', FPOLES(jpole,1), FPOLES(jpole,2),
cd     .                                        FPOLES(jpole,3) 
cd         print *,'Stage pole '//pairid(4:6), STAGEAB(jpole,1),
cd     .                              STAGEAB(jpole,2), STAGEAB(jpole,3)
cd         print *,'Stage pole '//pairid(1:3), STAGEBA(jpole,1),
cd     .                              STAGEBA(jpole,2), STAGEBA(jpole,3)
cd666   continue

c  --- now get partial deriv matrices for stage poles
c

      call poles2stpds( lpl, npoles, FPOLES, DSTABDP, DSTBADP)

cd      write(*,'(a)' ) pairid(4:6)
cd      do 616 i=4,6
cd      write(*, '(3f10.5)' )DSTABDP(1,i,1),DSTABDP(1,i,2),DSTABDP(1,i,3)
cd616   continue
cd      write(*,'(a)' ) pairid(1:3)
cd      do 626 i=4,6
cd      write(*, '(3f10.5)' )DSTBADP(1,i,1),DSTBADP(1,i,2),DSTBADP(1,i,3)
cd626   continue

c
c.... Process fz pick data
c
c.... Open file containing list of fz pick files
c
      call strcat( direc, 'fz_flist_'//pairid//'.dat', openfile)
      open(unit = 11, file=openfile, status='old', iostat = ios )

      if( ios .ne. 0 ) then
        write( 6, 10 ) openfile, ios
10      format(/,5x,'error occurred opening file : ',a80,/,
     .           5x,'iostat error code = ',i8,//)
        stop
      end if
c
c.... enter number of fz pick files

      read( 11, * ) nfiles

      write(*,'(a,/,i3,a)') 'Opened '//openfile,
     .            nfiles, ' fracture zones to process'




c.. .. .. .. .. open seed data file for output

      call strcat( direc, 'seeds_'//pairid//'.dat', openfile)
      open( 21, file = openfile, status = 'unknown', iostat=ios )
      if( ios .ne. 0 ) then
        write( 6, 10 ) openfile, ios
        stop
      end if


c.... Set pick count "irow" , and weight count iwrow
      irow = 0
      iwrow = 0 

      npicks = 0
c
c.... loop through files : 


      do 100 ifiles = 1, nfiles



        read( 11, 41 ) fz_file
 41     format(a40)

        call strcat( direc, fz_file, openfile)
        open( unit=12, file=openfile, status='old', iostat = ios)

        if( ios .ne. 0 ) then

          write( 6, 51 ) openfile, ios
 51       format(/,5x,'error occurred opening fzfile : ',a60,/,
     .             5x,'iostat error code = ',i8,//,
     .             5x,'exiting fracture zone pick input section',//)

          go to 110

        else
c
c....
c....     input the data picks from disk:
c
          call readpickfile(12,lfpk,PICKLOCS,nvec,SEED,plid,spolid)

          close( 12 )

        end if


cd      write(*,'(a)' ) ' stage pd 1->2'
cd      do 8 i =1, npoles
cd        do 8 j = 1,6
cd           write(*, '(3(x,f10.5))' ) DSTABDP(i,j,1),
cd     .                       DSTABDP(i,j,2), DSTABDP(i,j,3) 
cd8     continue


c......... find relevant index for seed pole

c	i=len(spolid)

c      write(*,'(i3,a)') i, ':'//spolid//':'

        if ( spolid .eq. '    ' ) then
          spolid = '  c1'
        endif


        do 60 jpole = 0, npoles
          if ( spolid .eq. IDPOL(jpole) ) then
            spole = jpole
            go to 61
          endif
60      continue

        write (*, '(a)') 'Seed pole '//spolid//' not known'
        stop  

61      continue
        

        write (*, '(/,a)') 'Read input file '//fz_file
        write (*, '(a)') 'plate '//plid//' - '//spolid//' seed'


cc
c....  --------------- if on side of second plate : ----------------
c
        if (plid .eq. pairid(4:6) ) then

          iside = 1

c
c....   Use fz picks and flowline points to estimate new
c....   zero age flowline point. This is an iterative process
c....   using "nloops" iterations.
c
          call seedinv( lpl, npoles, spole, FPOLES, STAGEAB,
     .                    PICKLOCS, nvec, SEED, iside, nloops,
     .                    FLOW, SEEDPD, lfpk, A_S, B_S )
 

c.. .. .. .. .. .. output seed data to file
	write(21, '(2(f9.4,x),a3,x,a4, 2x, a40)' ) 
     .           SEED(1), SEED(2), plid, spolid, fz_file

c
c....   Calculate synthetic FZ flowlines with last seed solution:
c
          call flowline( lpl, npoles, FPOLES, SEED, FLOW, iside)

c
c....   Locate each pick within flowline framework, measure error
c....    and calculate partial derivs
c

          call fzpickcalc(irow, lpl, npoles, STAGEAB, FLOW, 
     .                   lfpk, PICKLOCS, nvec, DSTABDP,
     .                ldt, lpr, sse, nuse, A, B, NPERPOLE, PK_LOC)


c
c.... ------------- if on side of first plate : --------------------
c
        else if ( plid .eq. pairid(1:3) ) then


          iside = -1

c
c....   Use fz picks and flowline points to estimate new
c....   zero age flowline point. This is an iterative process
c....   using "nloops" iterations.
c
          call seedinv( lpl, npoles, spole, FPOLES, STAGEBA, 
     .                    PICKLOCS, nvec, SEED, iside, nloops, 
     .                    FLOW, SEEDPD, lfpk, A_S, B_S )
 


c.. .. .. .. .. .. output seed data to file
	write(21, '(2(f9.4,x),a3,x,a4, 2x, a40)' ) 
     .           SEED(1), SEED(2), plid, spolid, fz_file

c
c....   Calculate synthetic FZ flowlines with last seed solution:
c
          call flowline( lpl, npoles, FPOLES, SEED, FLOW, iside )
c....
c

          call fzpickcalc(irow, lpl, npoles, STAGEBA, FLOW, 
     .                   lfpk, PICKLOCS, nvec, DSTBADP,
     .                ldt, lpr, sse, nuse, A, B, NPERPOLE, PK_LOC)


c....---------------- if neither side -------------

        else
          write(6,'(a)') 'In file  '//fz_file
          write(6,'(a)') 
     .     'plate id ('//plid//') incorrect, plate pair is '//pairid
          stop
        endif

c............. determine weights

        do 90 i=1, nuse
          W(iwrow+i) = dsqrt(sse/dble(nuse))
c          W(iwrow+i) = 1.0
90      continue

	iwrow = iwrow + nuse

c....   Process next fz pick file      
c     
100    continue

c.... Close fz file list file
c
      close( 11 )

c...  Close seed output file
c

      close( 21 )

110    continue

c.... Specify total number of picks
c
      npicks = irow

      if (npicks .gt. ldt) stop 'too many data points - exceeded array'

      return
      end
