      subroutine fzpickcalc_seed( lpl, npoles, spole, STAGE, FLOW, 
     .                   PICKLOCS, nvec, DEDP, lfpk, A_S, B_S, nuse)
c
c ------ determines the errors and pds wrt to the seed point of a fz
c
c      Takes a set of picks for a fracture zone (in PICKLOCS), and 
c      a synthetic flowline (in FLOW) and fits the picks, calculating
c      the errors and storing them in B_S, then determining the partial 
c      derivatives with respect to a peturbation to the seed point, and
c      storing them in A_S, making use of DEDP, which stores the partial
c      derivatives for the angular distance of each flowline section from
c      the vector representation of each stage pole, wrt a seed
c      peturbation.
c
c.... initially written by Peter R. Shaw and adapted by A.Nankivell 
c
      implicit none

      integer lpl, npoles, spole, nvec, lfpk, nuse
      double precision  STAGE(lpl,3), FLOW(0:lpl,3)
      double precision  PICKLOCS(lfpk,2), DEDP(lpl)
      double precision  A_S(lfpk,1), B_S(lfpk)
c
      integer ipick, itest
      double precision dpick, dtest, dotf, dotp, error, sum
      double precision PK(3), SEED(3), FLOWPT(3), ST(3)
      double precision vangsep, vecdprod, raddeg
c
      nuse  = 0
      sum = 0.
      raddeg=0.1745329251994329D-01
c
      do 5000 ipick = 1, nvec

c
c....    (0) convert pick to vector
c
         call pnt2vec( PICKLOCS(ipick,1), PICKLOCS(ipick,2), PK)
c 
c....    (1) Decide which segment this pick lies within:
c

         SEED(1) = FLOW(0,1)
         SEED(2) = FLOW(0,2)
         SEED(3) = FLOW(0,3)

         dpick = vangsep(PK, SEED )

c.............. if pick is same as seed, all is zero
         if( dpick .eq. 0.) goto 4999

         itest = 1
  100    continue
         FLOWPT(1) = FLOW(itest,1)
         FLOWPT(2) = FLOW(itest,2)
         FLOWPT(3) = FLOW(itest,3)
         dtest = vangsep( FLOWPT, SEED  )
         if(dtest.lt.dpick) then
            itest = itest+1
            if(itest.gt.npoles) goto 5000
            go to 100
         endif
c
c...     now know that pick lies between (itest-1) and (itest)'th point
c
c........... want only to use adjoining picks for seed peturbation
c	 if ( itest .lt. spole .or. itest .gt. spole+1 ) goto 4999

c	 if ( itest .lt. spole-3 .or. itest .gt. spole+3 ) goto 4999

         nuse = nuse +1

         A_S(nuse,1) = DEDP(itest)
c
         call pnt2vec( STAGE(itest,1), STAGE(itest,2), ST )

         dotf = vecdprod( FLOWPT, ST )
         dotp = vecdprod( PK, ST )

         error =  (dacos( dotf )/raddeg) - (dacos( dotp )/raddeg)

         B_S(nuse) =  - error

c
 4999 continue
 5000 continue
c
c
      return
      end
