      subroutine fzpickcalc3p( irow, lpl, npoles, STAGE, FLOW, 
     .                     lfpk, PICKLOCS, nvec, DSTDP,
     .                ldt, lpr, sse, nuse, A, B, NPERPOLE, PK_LOC)
c
c      Takes a set of picks for a fracture zone (in PICKLOCS), and 
c      a synthetic flowline (in FLOW) and fits the picks, calculating
c      the errors and storing them in B, then determining the partial 
c      derivatives and storing them in A, making use of DSTDP, which
c      stores the partial derivatives for the vector representation of
c      each stage pole.
c  -    special version for 3-plate problem, where each stage pole is
c      dependant on 12 parameters - so DSTDP is large.
c
c.... written by A.Nankivell 
c
      implicit none

      integer irow, lpl, npoles, lfpk, nvec, ldt, lpr, nuse
      integer NPERPOLE(lpl)

      double precision sse

      double precision STAGE(lpl,3), FLOW(0:lpl,3)
      double precision PICKLOCS(lfpk,2), DSTDP(lpl,12,3)
      double precision A(ldt,lpr), B(ldt), PK_LOC(ldt,2)
c
      integer ipick, itest, j, ipt, npars1p

      double precision dpick, dtest, dotf, dotp, error, partf, partp
      double precision PK(3), FLOWPTA(3), FLOWPTB(3)
      double precision VST(3), DVSTDP(3)
      double precision vangsep, vecdprod, raddeg
c
      nuse = 0
      sse = 0.

      npars1p = 3*npoles
      raddeg=0.1745329251994329D-01


      do 5000 ipick = 1, nvec
c
c....    (0) convert pick to vector
c
         call pnt2vec( PICKLOCS(ipick,1), PICKLOCS(ipick,2), PK)
c 
c....    (1) Decide which segment this pick lies within:
c
         FLOWPTA(1) = FLOW(0,1)
         FLOWPTA(2) = FLOW(0,2)
         FLOWPTA(3) = FLOW(0,3)
         dpick = vangsep( PK, FLOWPTA )
         itest = 1
  100    continue
         FLOWPTB(1) = FLOW(itest,1)
         FLOWPTB(2) = FLOW(itest,2)
         FLOWPTB(3) = FLOW(itest,3)
         dtest = vangsep( FLOWPTB, FLOWPTA  )
         if(dtest.lt.dpick) then
            itest = itest+1

c...    if point is beyond scope of inversion poles, skip
            if(itest.gt.npoles) go to 5000

            go to 100
         endif
c
c....       now know that pick lies between (itest-1) and (itest)'th point
c
         NPERPOLE(itest) = NPERPOLE(itest) + 1

         FLOWPTA(1) = FLOW(itest-1,1)
         FLOWPTA(2) = FLOW(itest-1,2)
         FLOWPTA(3) = FLOW(itest-1,3)

c         
c....       increment irow
c
         irow = irow + 1

         nuse = nuse + 1

c
c....      calculate error - convention +ve error towards stage pole
c
         call pnt2vec( STAGE(itest,1), STAGE(itest,2), VST )

         dotf = vecdprod( FLOWPTB, VST )
         dotp = vecdprod( PK, VST )

         error =  (dacos( dotf )/raddeg) - (dacos( dotp )/raddeg)

         B(irow) = -error

         sse = sse + error**2

d         write(*, '(a,i2,a,f10.5)' ) 'Stage ',itest,' error: ',error
c
c....    build partial derivative matrix
c

         do 11 j= 1, 2*npars1p
           A(irow, j) = 0.
11       continue

         ipt = (itest-2)*3

c........... loop (j) for pole param (lat, lon, angle)

         do 22 j=1,3

           if(itest .gt. 1) then

c---   calculate pd's for changes to 1st pole

c.............. firstly for plate pair 12

             DVSTDP(1) = DSTDP(itest,j,1)
             DVSTDP(2) = DSTDP(itest,j,2)
             DVSTDP(3) = DSTDP(itest,j,3)

             partf = -vecdprod( DVSTDP, FLOWPTB )
     .                                   /dsqrt( 1. - dotf**2)
             partp = -vecdprod( DVSTDP, PK )
     .                                   /dsqrt( 1. - dotp**2)

             A( irow, ipt+j) = partf - partp

c.............. then for plate pair 23

             DVSTDP(1) = DSTDP(itest,6+j,1)
             DVSTDP(2) = DSTDP(itest,6+j,2)
             DVSTDP(3) = DSTDP(itest,6+j,3)

             partf = -vecdprod( DVSTDP, FLOWPTB )
     .                                   /dsqrt( 1. - dotf**2)
             partp = -vecdprod( DVSTDP, PK )
     .                                   /dsqrt( 1. - dotp**2)

             A( irow, npars1p+ipt+j) = partf - partp

           endif

c---   now calculate pd's for changes to 2nd pole

c.............. firstly for plate pair 12

           DVSTDP(1) = DSTDP(itest,3+j,1)
           DVSTDP(2) = DSTDP(itest,3+j,2)
           DVSTDP(3) = DSTDP(itest,3+j,3)

           partf = -vecdprod( DVSTDP, FLOWPTA )
     .                                   /dsqrt( 1. - dotf**2)
           partp = -vecdprod( DVSTDP, PK )
     .                                  /dsqrt( 1. - dotp**2)

           A( irow, ipt+3+j) = partf - partp

c.............. then for plate pair 23

           DVSTDP(1) = DSTDP(itest,9+j,1)
           DVSTDP(2) = DSTDP(itest,9+j,2)
           DVSTDP(3) = DSTDP(itest,9+j,3)

           partf = -vecdprod( DVSTDP, FLOWPTA )
     .                                   /dsqrt( 1. - dotf**2)
           partp = -vecdprod( DVSTDP, PK )
     .                                  /dsqrt( 1. - dotp**2)

           A( irow, npars1p+ipt+3+j) = partf - partp

22       continue

c     write position vector for relevance in importance calculations

       PK_LOC(irow,1) = PICKLOCS(ipick,1)
       PK_LOC(irow,2) = PICKLOCS(ipick,2)


5000  continue

c
      return
      end
