       subroutine fzpickcalc( irow, lpl, npoles, STAGE, FLOW, 
     .                     lfpk, PICKLOCS, nvec, DSTDP,
     .                  ldt, lpr, sse, nuse, A, B, NPERPOLE, PK_LOC)
c
c      Takes a set of picks for a fracture zone (in PICKLOCS), and 
c      a synthetic flowline (in FLOW) and fits the picks, calculating
c      the errors and storing them in B, then determining the partial 
c      derivatives and storing them in A, making use of DSTDP, which
c      stores the partial derivatives for the vector representation of
c      each stage pole.
c
c.... initially written by Peter R. Shaw and adapted by A.Nankivell 
c
      implicit none

      integer irow, lpl, npoles, lfpk, nvec, ldt, lpr, nuse
      integer NPERPOLE(lpl)

      double precision sse
      double precision STAGE(lpl,3), FLOW(0:lpl,3)
      double precision PICKLOCS(lfpk,2), DSTDP(lpl,6,3)
      double precision A(ldt,lpr), B(ldt)
      double precision PK_LOC(ldt,2)
c
      integer ipick, itest, j, icol

      double precision dpick, dtest, dotf, dotp, error, partf, partp
      double precision PK(3), FLOWPTA(3), FLOWPTB(3)
      double precision ST(3), DSTVECDP(3)
      double precision vangsep, vecdprod, raddeg
c
      nuse = 0
      sse = 0.
      raddeg=0.1745329251994329D-01



      do 5000 ipick = 1, nvec
c
c....    (0) convert pick to vector
c
         call pnt2vec( PICKLOCS(ipick,1), PICKLOCS(ipick,2), PK)
c 
c....    (1) Decide which segment this pick lies within:
c
         FLOWPTA(1) = FLOW(0,1)
         FLOWPTA(2) = FLOW(0,2)
         FLOWPTA(3) = FLOW(0,3)
         dpick = vangsep( PK, FLOWPTA )
         itest = 1
  100    continue
         FLOWPTB(1) = FLOW(itest,1)
         FLOWPTB(2) = FLOW(itest,2)
         FLOWPTB(3) = FLOW(itest,3)
         dtest = vangsep( FLOWPTB, FLOWPTA )
         if(dtest.lt.dpick) then
            itest = itest+1

c...    if point is beyond scope of inversion poles, skip
            if(itest.gt.npoles) go to 5000

            go to 100
         endif
c
c....       now know that pick lies between (itest-1) and (itest)'th point
c
         NPERPOLE(itest) = NPERPOLE(itest) + 1

         FLOWPTA(1) = FLOW(itest-1,1)
         FLOWPTA(2) = FLOW(itest-1,2)
         FLOWPTA(3) = FLOW(itest-1,3)

c         
c....       increment irow
c
         irow = irow + 1

         nuse = nuse + 1
c
c....      calculate error - convention +ve error towards stage pole
c
         call pnt2vec( STAGE(itest,1), STAGE(itest,2), ST )

         dotf = vecdprod( FLOWPTA, ST )
         dotp = vecdprod( PK, ST )

         error =  (dacos( dotf )/raddeg) - (dacos( dotp )/raddeg)

         B(irow) = -error

         sse = sse + error**2


cd	print *,'angles st.fl ',dacosd( dotf ),' st.pk ',dacosd( dotp )

c
c....    build partial derivative matrix
c
cd        print *, 'pick num - ',irow, ' stage ', itest

         do 11 j= 1, 3*npoles
           A(irow, j) = 0.
11       continue

         icol = (itest-1)*3

c........... loop (j) for pole param (lat, lon, angle)

         do 22 j=1,3

cd	if ( j .eq. 1) print *,'wrt lat'
cd	if ( j .eq. 2) print *,'wrt lon'
cd	if ( j .eq. 3) print *,'wrt ang'

           if(itest .gt. 1) then

             DSTVECDP(1) = DSTDP(itest,j,1)
             DSTVECDP(2) = DSTDP(itest,j,2)
             DSTVECDP(3) = DSTDP(itest,j,3)

cd	print *,'pds rel 1st pole'
cd	print *,DSTDP(itest,j,1), DSTDP(itest,j,2), DSTDP(itest,j,3)

             partf = -vecdprod( DSTVECDP, FLOWPTB )
     .                                   /dsqrt( 1. - dotf**2)
             partp = -vecdprod( DSTVECDP, PK )
     .                                   /dsqrt( 1. - dotp**2)

cd	print *,'st.fl ',partf,' st.pk ',partp

             A( irow, icol-3 +j) = partf - partp 

           endif

           DSTVECDP(1) = DSTDP(itest,3+j,1)
           DSTVECDP(2) = DSTDP(itest,3+j,2)
           DSTVECDP(3) = DSTDP(itest,3+j,3)

cd 	print *,'pds rel 2nd pole'
cd	print *,DSTVECDP(1), DSTVECDP(2), DSTVECDP(3)

           partf = -vecdprod( DSTVECDP, FLOWPTA )
     .                                   /dsqrt( 1. - dotf**2)
           partp = -vecdprod( DSTVECDP, PK )
     .                                  /dsqrt( 1. - dotp**2)

cd	print *,'st.fl ',partf,' st.pk ',partp

           A( irow, icol+j) =  partf - partp 

22      continue

c
c     write position vector for relevance in importance calculations

        PK_LOC(irow,1) = PICKLOCS(ipick, 1)
        PK_LOC(irow,2) = PICKLOCS(ipick, 2)

5000  continue

c

      return
      end
