      subroutine fpoles2stage(lpl,npoles,FPOLES,STAGE12,STAGE21)
c
c....  converts sequence of finite rotation poles for plate 1->plate 2 
c.... to flowline stage poles for both sides of plate boundary
c.... (lat, lon and rotation angle)
c
c     12 and 21 represent notation for the different stage poles
c     on the opposing flanks - the finite rotation poles are for
c     the motion of plate 2 wrt 1, and the `12' stage poles detail
c     the motion on the 2nd plate, and 21 on the 1st plate.
c
      implicit none

      integer lpl, npoles

      integer j
 
      double precision FPOLES(lpl,3)
      double precision STAGE12(lpl,3), STAGE21(lpl,3)

      double precision HA(3,3), HB(3,3), S(3,3)

      write(6,*)'NOT using half angles to calculate old stage rots!'

      do 50 j=1,npoles
        if(FPOLES(j,3).lt.0.) then
          write(*,'(a,i2)'),'Warning. negative fin. rot. pole: ',j
        endif
50    continue

c...... for first pole,  ensures that 
c.      the stage pole will be the same as all of the other spherical
c.      routines will calculate, i.e. pos rot angle., irrelevant of
c.      the sign of the angle of the first rotation pole

      if (FPOLES(1,3) .ge. 0.0 ) then 

         STAGE12(1,1) = FPOLES(1,1)
         STAGE12(1,2) = FPOLES(1,2)
         STAGE12(1,3) = .5*FPOLES(1,3)

         call diamg(FPOLES(1,1),FPOLES(1,2),STAGE21(1,1),STAGE21(1,2) )
         STAGE21(1,3) = .5*FPOLES(1,3)

      else 

         call diamg(FPOLES(1,1),FPOLES(1,2),STAGE12(1,1),STAGE12(1,2) )
         STAGE12(1,3) = .5*FPOLES(1,3)

         STAGE21(1,1) = FPOLES(1,1)
         STAGE21(1,2) = FPOLES(1,2)
         STAGE21(1,3) = .5*FPOLES(1,3)

      endif

c  --more complicated (more calculations) way of doing same thing
c
c     call pol2mat(FPOLES(1,1), FPOLES(1,2),
c    .                             dble(.5*FPOLES(1,3)), HA)
c     call mat2pol(HA, STAGE12(1,1),STAGE12(1,2),STAGE12(1,3))
c
c     call pol2mat(FPOLES(1,1), FPOLES(1,2),
c    .                             dble(-.5*FPOLES(1,3)), HA)
c     call mat2pol(HA, STAGE21(1,1),STAGE21(1,2), STAGE21(1,3))


      if ( npoles.eq.1) then
        goto 100
      endif
c

c----------------- now calculate for rest of poles set
c--------- stage rotations are equivalent of two half rotations, HA and HB


c      do 99 j=2,npoles
       
c        call pol2mat(FPOLES(j-1,1),FPOLES(j-1,2),
c     .                             dble(-.5*FPOLES(j-1,3)),HA)
c        call pol2mat(FPOLES(j,1), FPOLES(j,2),
c     .                             dble(.5*FPOLES(j,3)), HB)
c        call sumrots(HA, HB, S)
c        call mat2pol(S, STAGE12(j,1),STAGE12(j,2),STAGE12(j,3))

c        call pol2mat(FPOLES(j-1,1),FPOLES(j-1,2),
c     .                              dble(.5*FPOLES(j-1,3)),HA)
c        call pol2mat(FPOLES(j,1), FPOLES(j,2),
c     .                            dble(-.5*FPOLES(j,3)), HB)
c        call sumrots(HA, HB, S)
c        call mat2pol(S, STAGE21(j,1),STAGE21(j,2), STAGE21(j,3))

c   99 continue
c  100 continue

c----------ADRIAN- now calculate for rest of poles set
c--------- stage rotations are equivalent of two half rotations, HA and HB
c----------------- GRAEME: stage poles NOT with present day as end point 
c of stage need to calculate differently - don't use half angles?


      do 99 j=2,npoles

        call pol2mat(FPOLES(j-1,1),FPOLES(j-1,2),
     .                             dble(-1.0*FPOLES(j-1,3)),HA)
        call pol2mat(FPOLES(j,1), FPOLES(j,2),FPOLES(j,3), HB)
        call sumrots(HA, HB, S)
        call mat2pol(S, STAGE12(j,1),STAGE12(j,2),
     .                                   dble(.5*STAGE12(j,3)))

        call pol2mat(FPOLES(j-1,1),FPOLES(j-1,2),
     .                              FPOLES(j-1,3),HA)
        call pol2mat(FPOLES(j,1), FPOLES(j,2),
     .                            dble(-1.0*FPOLES(j,3)), HB)
        call sumrots(HA, HB, S)
        call mat2pol(S, STAGE21(j,1),STAGE21(j,2), 
     .                                   dble(.5*STAGE21(j,3)))

   99 continue
  100 continue

      return
      end
