      subroutine flowline(lpl,npoles,POLES,SEED,FLOW,iside)
c
c.... Calculates a flowline and stores the ith flowpoint in 
c.... the FLOW array as indices (i,1) and (i,2). 
c.... POLES(*,1-3) are the POLES - lat, lon, angle;
c.... SEED(1-2) is the seed lat, lon
c....
c..... iside is 1/-1 for flowline on pos/neg side of plate boundary
c
      implicit none

      integer lpl, npoles, iside
      double precision POLES(lpl,3), SEED(2), FLOW(0:lpl,3)
c      double precision flopll, floplt
c
      integer i
      double precision VSEED(3), RMAT(3,3), TEMP(3)
c
c      write(6,*)'Entered flowline'
      call pnt2vec( SEED(1), SEED(2), VSEED )
 
c
c.... seed location becomes zeroth point of flowline
c
      FLOW(0,1) = VSEED(1) 
      FLOW(0,2) = VSEED(2) 
      FLOW(0,3) = VSEED(3) 

c
c.... now get rest of flowline, rotating seed point by half-rotation each time
c GRAEME is the half rotation really right? Can't get back a set of useful 
c full stages from ridge crest stage poles calculated in this way...
c
c Doing things this way the reference frame is the present ridge
c
c The ridge is moving with respect to both plates
c
c In the rest of the scheme, the reference frame is one of those plates 
c 
c
       do 10 i = 1, npoles

        call pol2mat(POLES(i,1),POLES(i,2),dble(iside*POLES(i,3)/2.)
     .							, RMAT)
        call rotatevec( RMAT, VSEED, TEMP)
        FLOW(i,1) = TEMP(1)
        FLOW(i,2) = TEMP(2)
        FLOW(i,3) = TEMP(3)

c      call vec2pnt(TEMP,flopll,floplt)
c      write(6,*) 'Flowline picks lon lat:',
c     .   flopll, floplt

10    continue
 
      return
      end
