c
      subroutine epdcalc(F, G, error, DEDF)
c
c     subroutine epdcalc         Aug 95        Adrian Nankivell
c
c     calculates the error (great circle/angular distance) from a rotated
c     point F to a great circle
c     with pole G and the partial derivative vector d(error)/d(F) - here
c     called DEDF
c
c     calculations carried out in double precision
c
c     all angles in degrees
c
      implicit none

      double precision error, F(3), G(3), DEDF(3), raddeg

      integer i

      double precision fdotg, denom
      double precision vecdprod
c
      raddeg=0.1745329251994329D-01

      fdotg = vecdprod(F, G)

c......... error +ve when rotated point is on far side of g.c.
c                    with respect to the g.c. pole

      error = dacos( fdotg )/raddeg - 90.

c      GE Aug '09: took raddeg out of brackets
c      write (6,*)error

      denom = dsqrt( 1. - fdotg**2 ) 

      do 10 i = 1, 3
        DEDF(i) = - G(i)/denom
10    continue

      return
      end
