      subroutine dqr( m, n, A, B, X, resq)
c
c  solves over-determined least-squares problem  ax = b
c  where  a  is an  m by n  matrix,  b  is an m-vector .
c  resq  is the sum of squared residuals of optimal solution.  also used
c  to signal error conditions - if -2 , system is underdetermined,  if
c  -1,  system is singular.
c  method - successive householder rotations.  see lawson+hanson - solv
c  -ing least squares problems.
c  routine will also work when m=n.
c
c*****   caution -  a and b  are overwritten by this routine.
c
c  Written by ? - not APN anyhow
c
      implicit none
c
      integer m, n
      double precision resq, A(m,n), B(m), X(n)
c
      integer i, i1, ii, j, j1, jj
      double precision sq, qv1, u1, dot, const, sum
c     
c
      resq=-2.0
      if (m.lt.n) return
c   loop ending on 1800 rotates  a  into upper triangular form
      do 1800 j=1,n
c  find constants for rotation and diagonal entry
      sq=0.0
      do 1100 i=j,m
 1100 sq=A(i,j)**2 + sq
      qv1=-dsign(dsqrt(sq),A(j,j))
      u1=A(j,j) - qv1
      A(j,j)=qv1
      j1=j + 1
      if (j1.gt.n) go to 1500
c  rotate remaining columns of sub-matrix
      do 1400 jj=j1,n
      dot=u1*A(j,jj)
      do 1200 i=j1,m
 1200 dot=A(i,jj)*A(i,j) + dot
      const=dot/dabs(qv1*u1)
      do 1300 i=j1,m
 1300 A(i,jj)=A(i,jj) - const*A(i,j)
      A(j,jj)=A(j,jj) - const*u1
 1400 continue
c  rotate  b  vector
 1500 dot=u1*B(j)
      if (j1.gt.m) go to 1610
      do 1600 i=j1,m
 1600 dot=B(i)*A(i,j) + dot
 1610 const=dot/dabs(qv1*u1)
      B(j)=B(j) - const*u1
      if (j1.gt.m) go to 1800
      do 1700 i=j1,m
 1700 B(i)=B(i) - const*A(i,j)
 1800 continue
c  solve triangular system by back-substitution.
      resq=-1.0
      do 2200 ii=1,n
      i=n-ii+1
      sum=B(i)
      if (ii.eq.1) go to 2110
      i1=i+1
      do 2100 j=i1,n
 2100 sum=sum - A(i,j)*X(j)
 2110 if (A(i,i).eq. 0.0) return
 2200 X(i)=sum/A(i,i)
c  find residual in overdetermined case.
      resq=0.0
      if (m.eq.n) return
      i1=n+1
      do 2300 i=i1,m
 2300 resq=B(i)**2 + resq
      return
      end                                                               
