      subroutine dcmake( RLAT, RLON, n, C)
c
c.... Builds correlation matrix C for a set of 3-vectors stored in
c      RLAT, RLON for use in the determination of best-fit
c      great circles 
c
      implicit none
c
      integer n
      double precision RLAT(n), RLON(n)
      double precision C(3,3)
c
      integer j
      double precision xx, xy, xz, yy, yz, zz 
      double precision X(3)

      xx=0.
      yy=0.
      zz=0.
      xy=0.
      xz=0.
      yz=0.
      do 100 j=1,n
         call pnt2vec( RLAT(j), RLON(j), X )
         xx = xx + X(1)**2
         yy = yy + X(2)**2
         zz = zz + X(3)**2
         xy = xy + X(1)*X(2)
         xz = xz + X(1)*X(3)
         yz = yz + X(2)*X(3)
  100 continue
c
      C(1,1) = xx
      C(2,2) = yy
      C(3,3) = zz
c
      C(2,1) = xy
      C(1,2) = xy
c
      C(3,1) = xz
      C(1,3) = xz
c
      C(2,3) = yz
      C(3,2) = yz
c
      return
      end
