      subroutine calc3rdpoles(lpl, npoles, FPOLES_12, FPOLES_23,
     .                                                 FPOLES_13)
c
c.... subroutine calc3rdpoles takes 2 sets of finite rotation
c.... pole parameters, between plates 1 and 2, and between 2 and 3
c.... and then calculates the rotation poles between plates 1 and 3
c
      implicit none

      integer lpl, npoles
      double precision FPOLES_12( lpl, 3 ), FPOLES_23( lpl, 3 )
      double precision FPOLES_13( lpl, 3 ), S13(3,3)
c
      integer i
      double precision R12(3,3), R23(3,3)
      double precision plat, plon, pang
c
c   
      do  111 i = 1, npoles

        call pol2mat( FPOLES_12(i,1),FPOLES_12(i,2),FPOLES_12(i,3), R12) 
        call pol2mat( FPOLES_23(i,1),FPOLES_23(i,2),FPOLES_23(i,3), R23) 

        call sumrots( R12, R23, S13)
        call mat2pol( S13, plat, plon, pang)

        FPOLES_13(i,1) = plat
        FPOLES_13(i,2) = plon
        FPOLES_13(i,3) = pang

111   continue

      return
      end
