C
C
       SUBROUTINE APROD( MODE, M, N, X, Y, RWORK, LRWORK, IWORK, 
     1                   LIWORK )
C      ---------------------------------------------------------
C
C      Subroutine Aprod is required by the Nag subroutine
C      F04QAF (PDA_LSQR). A matrix A( m, n ) is stored in the
C      array RWORK( LRWORK ) where LRWORK = IWORK( 1 ) *
C      IWORK( 2 ). When mode equals 1 the subroutine
C      returns
C
C      y = y + A * x
C
C      When mode equals 2 the subroutine returns
C
C      x = x + AT * y
C
C      where AT is the transpose of A.
c
c		THIS SUBROUTINE NOT IN USE IN THIS FORM, AS CALLS TO NAG
c		SUBROUTINES: SEE SUBROUTINES LISTED AT END OF PDA_LSQR
c 		FOR THE ALTERNATIVE WITH DEMGV
C
C
       IMPLICIT REAL * 8  ( A - H, O - Z )
C
       CHARACTER * 1  MXMODE
C
       INTEGER    IWORK( LIWORK )
C
       REAL * 8   X( N ), Y( M ), RWORK( LRWORK )
C
C----  CHECK MODE
C
       IF( MODE .LT. 1 .OR. MODE .GT. 2 ) THEN
C
         WRITE( 6, 10 ) MODE
  10     FORMAT(/,5X,'Error : Variable MODE incorrectly specified',/,
     1            5X,'on entry into subroutine Aprod. MODE = ',I3,//,
     2            5X,'Resetting MODE to error status -1',/)
C
         MODE = -1
C
         RETURN
C
       END IF
C
C----  PERFORM CALCULATIONS
C
       IF( MODE .EQ. 1 ) THEN
C
         MXMODE = 'N'
C
         CALL F06PAF( MXMODE, M, N, 1.0D0, RWORK, IWORK( 1 ), X, 1, 
     1                1.0D0, Y, 1 )
C
       ELSE IF( MODE .EQ. 2 ) THEN
C
         MXMODE = 'T'
C
         CALL F06PAF( MXMODE, M, N, 1.0D0, RWORK, IWORK( 1 ), Y, 1, 
     1                1.0D0, X, 1 )
C
       END IF
C
       RETURN
       END 
