c
c      program std_calc.f
c      ------------------
c
c      program  std_calc.f calculates the
c      mean and standard deviation in km of
c      the residuals in the files mag_b.dat
c      tf_b.dat and flow_b.dat 
c
c      program details
c      ---------------
c
c      os vms
c      language fortran 77
c
c      subroutine libraries : pssub:sub_lib.olb
c
c      original author r. w. woollett
c      date 1 st february 1993 
c
c      rebuilt / added to by
c          Adrian P Nankivell 95/96
c
      implicit none

      integer lgin, i, iternum, icount, iloopmax
      integer nmax, mmag, mtf, mfz

      double precision  pi, d2km, tol
      double precision  magmean, tfmean, fzmean 
      double precision  magstd, tfstd, fzstd
      double precision  datawin, xsq, xsqn, old_xsqn
      double precision  fzwin, tfwin,  magwin


      character * 40  direc 
      character * 60  openfile 
      character * 4  convstr
      character * 80  dummystr

      parameter ( nmax = 50000 )
      parameter (  pi = 3.141592654 ) 
      parameter (  d2km = 111.2 ) 
      parameter (  tol = 1.0D-06 ) 

c ..... declare arrays

      double precision BFZ( nmax ), BTF( nmax ), BMAG( nmax )
c
c----  define directory path to data files
c
c     data direc /'/home/piglet_data2/adriann/recon/data/'/
      data direc /'data/'/
c
c----  define input unit
c
      data lgin / 7 /
c
c----  input magnetic isochron residuals
c
      call strcat( direc, 'mag_b.dat', openfile)
      open( lgin, file = openfile, status = 'old' )

      read( lgin, * ) mmag

      if( mmag .gt. nmax ) then

        write( 6, 10 ) mmag, nmax
10      format(/,5x,'error : number of input magnetic residuals',/,
     .           5x,i5,' exceeds initial array size ',i5,/)
c
        stop
c
      end if
c
c----  convert degrees to km
c
      do 20 i = 1, mmag

        read( lgin, * ) BMAG( i )

         BMAG( i ) = BMAG( i ) * d2km

20    continue

      close( lgin )

c----  determine mean and standard deviation
c
      call std( BMAG, nmax, mmag, magmean, magstd )

      write( 6, 30 ) magmean, magstd
30    format(/,5x,'mean value of magnetic residuals = ',f9.4,' km',/,
     .         5x,'standard deviation             = ',f9.4,' km',/)

c----  input fz pick residuals
c
      call strcat( direc, 'flow_b.dat', openfile)
      open( lgin, file = openfile, status = 'old' )

      read( lgin, * ) mfz

      if( mfz .gt. nmax ) then

        write( 6, 40 ) mfz, nmax
40      format(/,5x,'error : number of input fz pick residuals ',i5,/,
     .           5x,'exceeds initial array size ',i5,/)

        stop

      end if
c
c----  input data and convert from degrees to km

      do 50 i = 1, mfz
 
        read( lgin, * ) BFZ( i )

        BFZ( i  ) = BFZ( i ) * d2km

50    continue

      close( lgin )
c
c----  calculate mean and standard deviation of fz pick residuals
c
      call std( BFZ, nmax, mfz, fzmean, fzstd )

      write( 6, 60 ) fzmean, fzstd
60    format(/,5x,'mean value of fz pick residuals = ',f9.4,' km',/,
     .         5x,'standard deviation            = ',f9.4,' km',/)



c----  input transform pick residuals
c
      call strcat( direc, 'tf_b.dat', openfile)
      open( lgin, file = openfile, status = 'old' )

      read( lgin, * ) mtf

      if( mtf .gt. nmax ) then

        write( 6, 70 ) mtf, nmax
70      format(/,5x,'error : number of input transform residuals ',i5,/,
     .           5x,'exceeds initial array size ',i5,/)

        stop

      end if
c
c----  input data and convert from degrees to km

      do 80 i = 1, mtf
 
        read( lgin, * ) BTF( i )

        BTF( i  ) = BTF( i ) * d2km

80    continue

      close( lgin )
c
c----  calculate mean and standard deviation of transform pick residuals
c
      call std( BTF, nmax, mtf, tfmean, tfstd )

      write( 6, 90 ) tfmean, tfstd
90    format(/,5x,'mean value of transform residuals = ',f9.4,' km',/,
     .         5x,'standard deviation                = ',f9.4,' km',/)

c
c----- calculate chi-squared for data within datawin, and check convergence
c
c      call strcat( direc, 'inv.dat', openfile)
c      open( lgin, file = openfile, status = 'old' )
c
c      read( lgin, '(a)' ) dummystr
c      read( lgin, '(16x,f)' ) datawin
c
c      close( lgin )

c----- calculate chi-squared for data within datawin, and check convergence
c ---- this block lifted from gstd_calc - Graeme
c
      call strcat( direc, 'inv.dat', openfile)
      open( lgin, file = openfile, status = 'old' )

      read( lgin, '(a)' ) dummystr
      read( lgin, '(a)' ) dummystr
      read( lgin, '(a)' ) dummystr
      read( lgin, '(3f8.0)' ) magwin, fzwin, tfwin

      close( lgin )


c............. read in data , rejecting outliers

      xsq = 0.
      icount = 0
      do 100 i = 1, mmag

        if( abs( BMAG( i )/ magstd ) .le. datawin ) then
          icount = icount + 1
          xsq = xsq + (BMAG( i )/magstd)**2
        endif

100   continue

      do 200 i = 1, mfz
 
        if( abs( BFZ( i )/ fzstd ) .le. datawin ) then
          icount = icount + 1
          xsq = xsq + (BFZ( i )/fzstd)**2
        endif

200   continue

      do 300 i = 1, mtf
 
        if( abs( BTF( i )/ tfstd ) .le. datawin ) then
          icount = icount + 1
          xsq = xsq + (BTF( i )/tfstd)**2
        endif

300   continue

	xsqn = xsq/icount

c------------ first find iteration number ---

	call strcat( direc, 'iter.dat', openfile)
	open(unit = 11, file = openfile ,status='old')
	read(11,'(19x,i4)') iternum
	close(11)

	if(iternum.eq.1) then
c
c-------------- create/write std files ---

 	  call strcat( direc, 'std.dat', openfile)
 	  open(unit = 13, file= openfile, status='unknown')
 	  write(13,'(3(2x,f9.4))') fzstd, magstd, tfstd
 	  close(13)

	  call strcat( direc, 'stdconv.dat', openfile)
	  open(unit = 12, file = openfile, status = 'unknown')
	  write(12,909)
909	  format('iter : fz> res ;     std : tf> res ;     std :',
     .            '  mag> res ;     std :    xsq/n    :')
	  convstr = '----'

	else

c-------------- just open and write to std files ---
c
 	  call strcat( direc, 'std.dat', openfile)
 	  open(unit = 13, file= openfile, status='old')
 	  write(13,'(3(2x,f9.4))') fzstd, magstd, tfstd
 	  close(13)

	  call strcat( direc, 'stdconv.dat', openfile)
	  open(unit = 12, file = openfile, status = 'old')
	  read(12,'(a4)') dummystr
	  iloopmax = iternum - 1
	  do 707 icount = 1, iloopmax
	    read(12,'(71x,f9.6)')  old_xsqn
707	  continue

          if ( old_xsqn-xsqn .gt. tol) then
	    convstr = 'conv'
	  else if ( old_xsqn-xsqn .lt. -tol) then
	    convstr = 'dive'
          else 
            convstr = '----'
	  endif

	endif

	write(12,'(i2, 3x, 6(f9.4,2x), f9.6, 2x, a4)') iternum, fzmean,
     .    fzstd, tfmean, tfstd, magmean, magstd, xsqn, convstr
	close(12)

c -------------------------end of adrian bit -----------------------

      stop ' ** std_calc finished **'
      end 
