c..   Program sort_magerr
c..
c
c
c
      implicit none
c
      integer mxmag, nmagloc, nmagerr, nmagpicks
      integer lginloc, lginerr, lgout

      integer i,j

c....  max # magnetic data points :  
      parameter  ( mxmag = 99999 )

      character * 40  direc
      character * 60  openfile

      integer NPICKS(mxmag)

      double precision ERR_IN(mxmag), LOC_IN(mxmag,3)
      double precision LOCE_OUT(mxmag,4)


c      data direc /'/home/piglet_data2/adriann/recon/data/'/
      data direc /'data/'/

      data lginloc, lginerr, lgout / 7, 8, 9 /
c
      write(*,'(a)') '-- SORT_MAGERR --'

c----  enter magnetics pick locations
c
      call STRCAT( direc, 'mag_loc.dat', openfile)
      open( lginloc, file = openfile, status = 'old' )

      call STRCAT( direc, 'mag_b.dat', openfile)
      open( lginerr, file = openfile, status = 'old' )

      read( lginloc, * ) nmagloc
      read( lginerr, * ) nmagerr

      if( nmagloc .ne. nmagerr ) then
        write( 6, 111 ) nmagloc, nmagerr
111     format(/,5x,'error : number of rows in input magnetic',/,
     .           5x,'locations different from errors',/,
     .           5x,'nmagloc = ',i4,' nmagerr = ',i4,/)

        stop

      end if


      if( nmagloc .gt. mxmag ) then

        write( 6, 200 ) nmagloc, mxmag
200     format(/,5x,'error : number of rows in input magnetic',/,
     .           5x,'isochron pick misfit partial derivative',/,
     .           5x,'matrix exceeds initial array dimension',/,
     .           5x,'nmagloc = ',i4,' mxmag = ',i4,/)

        stop

      end if

      nmagpicks = 0

      do 1000 i = 1, nmagloc

          read( lginloc, * ) LOC_IN(i,1), LOC_IN(i,2), LOC_IN(i,3)
          read( lginerr, * ) ERR_IN(i)

	  do 500 j = 1, nmagpicks

        	if(  LOC_IN(i,1) .eq. LOCE_OUT(j,1) .and.
     .			LOC_IN(i,2) .eq. LOCE_OUT(j,2)  .and.
     .			LOC_IN(i,3) .eq. LOCE_OUT(j,4) ) then

			LOCE_OUT(j,3) = LOCE_OUT(j,3)
     .						 + dabs(ERR_IN(i))
			NPICKS(j) = NPICKS(j) + 1
			goto 999
        	endif
500	  continue

	  nmagpicks = nmagpicks +1

	  NPICKS(nmagpicks) = 1
	  LOCE_OUT(nmagpicks,1) = LOC_IN(i,1)
	  LOCE_OUT(nmagpicks,2) = LOC_IN(i,2)
	  LOCE_OUT(nmagpicks,3) = dabs(ERR_IN(i))
	  LOCE_OUT(nmagpicks,4) = LOC_IN(i,3)


999	  continue

1000  continue

      close( lginloc )
      close( lginerr )

      write( *, '(a,/)' ) ' Magnetic data Errors sorted'
      write( *, '(a,/)' ) ' ...now averaging'

      do 2000 j = 1, nmagpicks
	LOCE_OUT(j,3) = LOCE_OUT(j,3) / NPICKS(j) 
2000  continue

      write( *, '(a,/)' ) ' DONE '

c

      call strcat( direc, 'mag_err.dat', openfile)
      open( lgout, file = openfile, status = 'unknown', err = 9999 )

      call writematrix( lgout, mxmag, 4, nmagpicks, 4, LOCE_OUT )

      close( lgout )
   


      stop ' ** sort_magerr finished **'
 9999 stop 'oops'
      end       
