c
c      program poles_inv.f
c      -------------------
c
c      program poles_inv.for uses the partial
c      derivative matrices, residual and magnetic
c      isochron pick weight vectors produced by the
c      programs magpickproc.for and fzpickproc.f
c      to solve for the perturbations of the associated
c      finite rotation pole parameters.
c
c      a series of linear equations are solved using
c      the least squares criterion by the nag subroutine
c      F04QAF.
c
c      During the procedure, data importances are calculated for
c      the fracture zone data and magnetics data as separate
c      groups of data, and error ellipses for each of the poles
c      are calculated.
c
c      note the value of the damping variable DAMP must be
c      chosen carefully. the current value of 0.5 ( 16/2/93 )
c      has been chosen only for test purposes. similarly, i
c      have taken the values of ATOL, BTOL and CONLIM from
c      a related example program in the nag documentation.
c
c      for advice on how to define these values properly you
c      should consult the nag documentation, associated
c      references, and
c
c      lawson, c. l. and hanson, r. j., solving least squares
c      problems, prentice-hall inc., englewood cliffs, nj, 
c      1974, 340pp.
c
c      program details
c      ---------------
c August 2002. Graeme Eagles. Replaced calls to F04QAF with
C calls to public domain alternative PDA_LSQR.
c
c
      implicit none
c
      integer mdat, mdatmax, nparmax
      integer lgin, lgout
      integer mrow, mfz, mbfz, nfz, mwfz, mfzrj, mfzrw
      integer mtf, mbtf, ntf, mwtf
      integer mtfrw, mtfrj
      integer mmag, mbmag, nmag, mwmag
      integer mmagrw, mmagrj
      integer i,j

      double precision  fzwin, tfwin,  magwin
      double precision  fzbias, tfbias,  magbias
      double precision  d2km,  test
      double precision  fzstd, tfstd, magstd
      double precision  weight

c----  define maximum array dimensions
c

c....  max # data points (fz or tf or mag) :  
      parameter  ( mdat = 100000 )

c....  max # total data points :  
      parameter  ( mdatmax = 200000)

c....  max # params to solve for. 
      parameter  ( nparmax = 180 )

      parameter (  d2km = 111.2 ) 
c
c----  define main variables
c
      character * 40  direc
      character * 60  openfile
      character * 40  dummy
c
c
c
c----  define main arrays
c
c----  common arrays

      double precision A_IN( mdat, nparmax ), A_INNM( mdat, nparmax )
      double precision B_IN( mdat ), B_INNM( mdat )
      double precision W_IN( mdat )

c----  specific arrays
 
      double precision WFZNM( mdat )
      double precision WTFNM(mdat)
      double precision WMAGNM( mdat )

      double precision A( mdatmax, nparmax ), B( mdatmax )

c
c----  define additional arrays required for inversion
c
      integer LIWORK, LRWORK
      integer ITNLIM, MSGLVL, ITN, INFORM, IFAIL

      parameter  ( LIWORK = 2 )
      integer  IWORK( LIWORK )
      double precision  ATOL, BTOL, CONLIM, DAMP
      double precision  ANORM, ACOND, RNORM, ARNORM, XNORM
      double precision  X(nparmax), SE(nparmax), WORK(2 * nparmax)
      double precision  WWORK(2 * nparmax)
c


c----  declare external subroutines
c
      external APROD, PDA_LSQR, DSYTRI, DSYTRF, DSYEV
c
c----  define directory path to data files
c
c     data direc /'/home/piglet_data2/adriann/recon/data/'/
      data direc /'data/'/
c
c----  define i/o units + nag error flag
c
      data lgin, lgout, IFAIL / 7, 8, 0 /
c
c----  define variables required by nag subroutine
c
c----  integer variables
c
      write(*,'(a)') '-- POLES_INV --'


      IWORK( 1 ) = mdatmax
      IWORK( 2 ) = nparmax

      LRWORK = mdatmax * nparmax

      ITNLIM = 100

      msglvl = 2  
c
c----  real variables
c
c      DAMP = 2.0D+00
c
c      ATOL = 5.0D-04 
c      BTOL = 5.0D-04 
c
c
c
c........... get values for DAMP, ATOL and datawin from file inv.dat

      call STRCAT( direc, 'inv.dat', openfile)
      open( lgin, file = openfile, status = 'old' )

      read( lgin, '(a)' ) dummy
      read( lgin, '(2f8.0)' ) DAMP, ATOL
      read( lgin, '(a)' ) dummy
      read( lgin, '(3f8.0)' ) magwin, fzwin, tfwin
      read( lgin, '(a)' ) dummy
      read( lgin, '(3f8.0)' ) magbias, fzbias, tfbias

      close( lgin )

c     if set to 0 (or negative), or unset, use default values


      if ( DAMP .le. 0.) DAMP = 1.0D0
      if ( ATOL .le. 0.) ATOL = 5.0D-04 
      if ( magwin .le. 0.) magwin = 3.0D0
      if ( fzwin .le. 0.) fzwin = 3.0D0
      if ( tfwin .le. 0.) tfwin = 3.0D0

      write(*,'(2(x,a,x,f8.5))') 'DAMP =', DAMP, 'ATOL =', ATOL
      write(*,'(3(x,a,x,f8.5))') 'magnetics window =', magwin,
     .     'fz window =', fzwin, 'transform window =', tfwin
      write(*,'(3(x,a,x,f8.5))') 'magnetics bias =', magbias,
     .     'fz bias =', fzbias, 'transform bias =', tfbias

c    set BTOL equal to ATOL, and set CONLIM

      BTOL = ATOL
      CONLIM = 1.0D0 / ATOL 
 
c
c.......... enter estimated standard deviations of magnetic
c               isochron and fracture zone picks
c
      call STRCAT( direc, 'std.dat', openfile)
      open( lgin, file = openfile, status = 'old' )

      read( lgin, * ) fzstd, magstd, tfstd

      close( lgin )


c.......... first process FRACTURE ZONE inversion input data ............
c
c........  enter fracture zone pick misfit partial derivative matrix

      call STRCAT( direc, 'flow_a.dat', openfile)
      open( lgin, file = openfile, status = 'old' )

      read( lgin, * ) mfz, nfz
      if( mfz .gt. mdat .or. nfz .gt. nparmax ) then

        write( 6, 11 ) mfz, nfz, mdat, nparmax
11      format(/,5x,'error : input dimensions of matrix afz',/,
     .           5x,'exceed initial array size',/,
     .           5x,'mfz  = ',i4,' nfz    = ',i4,/,
     .           5x,'mdat = ',i4,' nparmax = ',i4,/)

        stop

      end if

      do 20 i = 1, mfz

        read( lgin, * ) ( A_IN( i, j ), j = 1, nfz )
c       Testing - Graeme's
c        write(6,*)A_IN

20     continue

      close( lgin )
c
c.............. enter fracture zone pick residuals ( misfit )

      call STRCAT( direc, 'flow_b.dat', openfile)
      open( lgin, file = openfile, status = 'old' )

      read( lgin, * ) mbfz

      if( mbfz .ne. mfz ) then

        write( 6, 31 ) mbfz, mfz
31      format(/,5x,'error : incompatible number of rows in',/,
     .           5x,'data files flow_a.dat and flow_b.dat',/,
     .           5x,'mbfz = ',i4,' mfz = ',i4,/)

        stop

      end if

      do 40 i = 1, mfz

        read( lgin, * ) B_IN( i )

40     continue

      close( lgin )

c----  enter rms error of fracture zone
c
      call STRCAT(  direc, 'flow_w.dat', openfile)
      open( lgin, file = openfile, status = 'old' )
 
      read( lgin, * ) mwfz
 
      if( mwfz .ne. mfz ) then
 
        write( 6, 51 ) mwfz, mfz
51      format(/,5x,'error : incompatible number of rows in',/,
     .           5x,'data files flow_a.dat and flow_w.dat',/,
     .           5x,'mwfz = ',i4,' mfz = ',i4,/)

        stop

      end if


      do 60 i = 1, mfz

        read( lgin, * ) W_IN( i )

60    continue

      close( lgin )



c
c----  determine relative weights 
c
      if(fzwin .eq. 5.0) then
         test = fzwin*fzstd / d2km
      else
         test = fzstd / d2km
      endif

      do 90 i = 1, mfz

        if( W_IN( i ) .lt. test ) W_IN( i ) = test
        W_IN( i ) = test / W_IN( i )

90    continue

c............... normalize fz pick derivative matrix and residual vector
c
      do 110 i = 1, mfz

        B_IN( i ) = B_IN( i ) * d2km / fzstd

        do 100 j = 1, nfz

          A_IN( i, j ) = A_IN( i, j ) * d2km / fzstd

100      continue

110    continue

c
c----  transfer matrix and vector to temporary storage
c----  removing outliers
c
      mrow = 0
      mfzrj = 0

      do 130 i = 1, mfz

        if( abs( B_IN( i ) ) .le. fzwin ) then

          mrow = mrow + 1

          do 120 j = 1, nfz
            A_INNM( mrow, j ) = A_IN( i, j )
120       continue

          B_INNM( mrow ) = B_IN( i )
          WFZNM( mrow ) = W_IN( i )

        else
          mfzrj = mfzrj + 1
        end if

130   continue

      mfzrw = mrow

      write( 6, 141 ) mfz, mfzrw, mfzrj
141   format(/,5x,'results of fracture zone pick residual',/,
     .         5x,'outlier removal',//,
     .         5x,'total number of rows     ',i4,/,
     .         5x,'number of good residuals ',i4,/,
     .         5x,'number of outliers      ',i4,/)


c---- premultiply A_INNM and B_INNM matrix by weights 
c (avoiding large diagonal matrix to save memory space and computation time)
c----  storing result straight into A and B
c


      do 155 i = 1, mfzrw
    
            weight  = WFZNM( i ) * fzbias

            B(i) = B_INNM(i) * weight

            do 150 j = 1, nfz
               A(i,j) = A_INNM(i,j) * weight
 150        continue
     
 155  continue

c
c............now process TRANSFORM inversion input data ............
c
c----  enter transform pick misfit partial derivative matrix
c
      call STRCAT( direc, 'tf_a.dat', openfile)
      open( lgin, file = openfile, status = 'old' )

      read( lgin, * ) mtf, ntf 

      if( mtf .gt. mdat ) then

        write( 6, 201 ) mtf, mdat
201     format(/,5x,'error : number of rows in input transform',/,
     .           5x,'pick misfit partial derivative',/,
     .           5x,'matrix exceeds initial array dimension',/,
     .           5x,'mtf = ',i4,' mdat = ',i4,/)

        stop

      end if

      if( ntf .ne. nfz ) then

        write( 6, 211 ) ntf, nfz
211     format(/,5x,'error : number of columns in input misfit',/,
     .           5x,'partial derivative matrices are incompatible',/,
     .           5x,'ntf = ', i3,' nfz = ',i3,/)

        stop

      end if

      do 220 i = 1, mtf

        read( lgin, * ) ( A_IN( i, j ), j = 1, ntf )

220   continue

      close( lgin )
c
c----  enter transform isochron pick residuals ( misfit )
c
      call STRCAT( direc, 'tf_b.dat', openfile)
      open( lgin, file = openfile, status = 'old' )

      read( lgin, * ) mbtf

      if( mbtf .ne. mtf ) then

        write( 6, 231 ) mbtf, mtf
231     format(/,5x,'error : incompatible number of rows in',/,
     .           5x,'data files tf_a.dat and tf_b.dat',/)
 
        stop
 
      end if
 
      do 240 i = 1, mtf
 
        read( lgin, * ) B_IN( i )
 
240   continue
 
      close( lgin )
c
c----  enter weights 
c
      call STRCAT(  direc, 'tf_w.dat', openfile)
      open( lgin, file = openfile, status = 'old' )
 
      read( lgin, * ) mwtf
 
      if( mwtf .ne. mtf ) then
 
        write( 6, 250 ) mwtf, mtf
250    format(/,5x,'error : incompatible number of rows in',/,
     .           5x,'data files tf_a.dat and tf_w.dat',/,
     .           5x,'mwtf = ',i4,' mtf = ',i4,/)

        stop

      end if


      do 260 i = 1, mtf

        read( lgin, * ) W_IN( i )

260   continue

      close( lgin )

c
c.............onto data processing .....................
c
c----  determine relative weights  
c
      if(tfwin .eq. 5.0) then
         test = tfwin*tfstd / d2km
      else
         test = tfstd / d2km
      endif

      do 290 i = 1, mtf

        if( W_IN( i ) .lt. test ) W_IN( i ) = test
        W_IN( i ) = test / W_IN( i )

290   continue
c
c----  normalize transform pick partial derivative
c----  matrix and residual vector
c
      do 310 i = 1, mtf

        B_IN( i ) = B_IN( i ) * d2km / tfstd

        do 300 j = 1, ntf
          A_IN( i, j ) = A_IN( i, j ) *  d2km / tfstd
300     continue

310   continue
c
c----  transfer matrix and vector to temporary storage
c----  removing outliers
c
      mtfrw = 0
      mtfrj = 0

      do 330 i = 1, mtf

        if( abs( B_IN( i ) ) .le. tfwin ) then

          mtfrw = mtfrw + 1

          do 320 j = 1, ntf
            A_INNM( mtfrw, j ) = A_IN( i, j )
320       continue

          B_INNM( mtfrw ) = B_IN( i )
          WTFNM( mtfrw ) = W_IN( i )

        else
          mtfrj = mtfrj + 1
        end if

330   continue

      write( 6, 341 ) mtf, mtfrw, mtfrj
341   format(/,5x,'results of transform pick residual',/,
     .         5x,'outlier removal',//,
     .         5x,'total number of rows    ',i4,/,
     .         5x,'number of good residuals',i4,/,
     .         5x,'number of outliers      ',i4,/)


c
c---- premultiply A_INNM and B_INNM matrices by weights 
c (avoiding large diagonal matrix to save memory space and computation time)
c----  storing results straight into A and B


      do 360 i = 1, mtfrw
    
            weight  = WTFNM( i ) * tfbias
            mrow = mrow + 1

            B( mrow ) = B_INNM( i ) * weight

            do 350 j = 1, ntf
               A(mrow,j) = A_INNM(i,j) * weight
 350        continue
     
 360  continue


c
c............now process MAGNETIC inversion input data ............
c
c----  enter magnetic isochron pick misfit partial derivative matrix
c
      call STRCAT( direc, 'mag_a.dat', openfile)
      open( lgin, file = openfile, status = 'old' )

      read( lgin, * ) mmag, nmag 

      if( mmag .gt. mdat ) then

        write( 6, 501 ) mmag, mdat
501     format(/,5x,'error : number of rows in input magnetic',/,
     .           5x,'isochron pick misfit partial derivative',/,
     .           5x,'matrix exceeds initial array dimension',/,
     .           5x,'mmag = ',i4,' mdat = ',i4,/)

        stop

      end if

      if( nmag .ne. nfz ) then

        write( 6, 511 ) nmag, nfz
511     format(/,5x,'error : number of columns in input misfit',/,
     .           5x,'partial derivative matrices are incompatible',/,
     .           5x,'nmag = ', i3,' nfz = ',i3,/)

        stop

      end if

      do 520 i = 1, mmag

        read( lgin, * ) ( A_IN( i, j ), j = 1, nmag )

520   continue

      close( lgin )
c
c----  enter magnetic isochron pick residuals ( misfit )
c
      call STRCAT( direc, 'mag_b.dat', openfile)
      open( lgin, file = openfile, status = 'old' )

      read( lgin, * ) mbmag

      if( mbmag .ne. mmag ) then

        write( 6, 531 ) mbmag, mmag
531     format(/,5x,'error : incompatible number of rows in',/,
     .           5x,'data files mag_a.dat and mag_b.dat',/)
 
        stop
 
      end if
 
      do 540 i = 1, mmag
 
        read( lgin, * ) B_IN( i )
 
540   continue
 
      close( lgin )
c
c----  enter combined misfit of rotated and non - rotated isochron
c----  picks about best fit great circle through non - rotated picks
c
      call STRCAT(  direc, 'mag_w.dat', openfile)
      open( lgin, file = openfile, status = 'old' )
 
      read( lgin, * ) mwmag
 
      if( mwmag .ne. mmag ) then
 
        write( 6, 550 ) mwmag, mmag
550    format(/,5x,'error : incompatible number of rows in',/,
     .           5x,'data files mag_a.dat and mag_w.dat',/,
     .           5x,'mwmag = ',i4,' mmag = ',i4,/)

        stop

      end if


      do 560 i = 1, mmag

        read( lgin, * ) W_IN( i )

560   continue

      close( lgin )

c.............onto data processing .....................
c
c----  determine relative weights of isochron equations
c
      if(magwin .eq.5.0) then
         test = magwin*magstd / d2km
      else
         test = magstd / d2km
      endif

      do 590 i = 1, mmag

        if( W_IN( i ) .lt. test ) W_IN( i ) = test
        W_IN( i ) = test / W_IN( i )

590   continue
c
c----  normalize magnetic isochron pick partial derivative
c----  matrix and residual vector
c
      do 610 i = 1, mmag

        B_IN( i ) = B_IN( i ) * d2km / magstd

        do 600 j = 1, nmag
          A_IN( i, j ) = A_IN( i, j ) *  d2km / magstd
600     continue

610   continue
c
c----  transfer matrix and vector to temporary storage
c----  removing outliers
c
      mmagrw = 0
      mmagrj = 0

      do 630 i = 1, mmag

        if( abs( B_IN( i ) ) .le. magwin ) then

          mmagrw = mmagrw + 1

          do 620 j = 1, nmag
            A_INNM( mmagrw, j ) = A_IN( i, j )
620       continue

          B_INNM( mmagrw ) = B_IN( i )
          WMAGNM( mmagrw ) = W_IN( i )

        else
          mmagrj = mmagrj + 1
        end if

630   continue

      write( 6, 641 ) mmag, mmagrw, mmagrj
641   format(/,5x,'results of magnetic isochron pick residual',/,
     .         5x,'outlier removal',//,
     .         5x,'total number of rows    ',i4,/,
     .         5x,'number of good residuals',i4,/,
     .         5x,'number of outliers      ',i4,/)


c---- premultiply A_INNM and B_INNM matrices by weights 
c (avoiding large diagonal matrix to save memory space and computation time)
c----  storing results straight into A and B


      do 660 i = 1, mmagrw
    
            weight  = WMAGNM( i ) * magbias
            mrow = mrow + 1

            B( mrow ) = B_INNM( i ) * weight

            do 650 j = 1, nmag
               A(mrow,j) = A_INNM(i,j) * weight
 650        continue
     
 660  continue

c----------------- All data entered into final matrix -----------
c------------------ now proceed with actual inversion -----------

      write( 6, 1001 ) mrow, nfz
1001  format(/,5x,'dimensions of final joint misfit partial',/,
     .         5x,'derivative matrix',//,
     .         5x,' m = ',i4,' n = ',i3,//)
c
c----  solve system of linear equations 
c
C
C Adrian used calls to f04qaf, from NAG library. This is
C replaced by calls to PDA_LSQR which is public domain and does
C the same job.
C
C      call F04QAF( mrow, nfz, B, X, SE, APROD, DAMP, ATOL, BTOL,
C     .            CONLIM, ITNLIM, msglvl, ITN, ANORM, ACOND,
C     .            RNORM, ARNORM, XNORM, WORK, A, LRWORK, IWORK,
C     .            LIWORK, INFORM, IFAIL )
C
C NB Variables and parameters passed to PDA_LSQR differ slightly
C from those passed to F04QAF. See the relevant documentation.
C The only "new" item is workspace array WWORK.
C
      call PDA_LSQR( mrow, nfz, APROD, DAMP, LIWORK, LRWORK, 
     .            IWORK, A, B, WORK, WWORK, X, SE, ATOL, BTOL,
     .            CONLIM, ITNLIM, INFORM, ITN, ANORM, ACOND,
     .            RNORM, ARNORM, XNORM )

c
c----  check error status
C IFAIL is a NAG feature, commented out here.
c
C      if( IFAIL .ne. 0 ) then
C
C        write( 6, 1011 ) IFAIL
C1011    format(/,5x,'error : error detected within subroutine',/,
C     .           5x,'F04QAF. error code = ',i3,/)
C
C        if( IFAIL .lt. 0 .or. IFAIL .eq. 1 ) stop 
C
C      end if
Cc
c----  output subroutine information
c
      write( 6, 1021 ) ITN, ANORM, ACOND, RNORM, ARNORM, XNORM, INFORM
1021  format(/,5x,'subroutine PDA_LSQR : output arguments',//,
     .         5x,'number of iterations = ',i3,/,
     .         5x,'norm of matrix a     = ',d12.6,/,
     .         5x,'cond( a )           = ',d12.6,/,
     .         5x,'norm of r           = ',d12.6,/,
     .         5x,'norm of at * r      = ',d12.6,/,
     .         5x,'norm of x           = ',d12.6,/,
     .         5x,'value of INFORM      = ',i5,//)


c-------------- OUTPUT TO FILES ------------>
c


c................ output solution pole perturbations x
c
      call STRCAT( direc, 'x.dat', openfile)
      open( lgout, file = openfile, status = 'unknown' )

      call writevector( lgout, nparmax, nfz, X)

      close( lgout )
c
c................ output standard errors of solution
c
      call STRCAT( direc, 'se.dat', openfile)
      open( lgout, file = openfile, status = 'unknown')

      call writevector( lgout, nparmax, nfz, SE)

      close( lgout )

c..   output weight vectors
c
      call strcat( direc, 'flow_wfin.dat', openfile)
      open( lgout, file = openfile, status = 'unknown' , err = 9999 )

      call writevector( lgout, mdat, mfzrw, WFZNM )

      close( lgout )

      call strcat( direc, 'tf_wfin.dat', openfile)
      open( lgout, file = openfile, status = 'unknown' , err = 9999 )

      call writevector( lgout, mtf, mtfrw, WTFNM )

      close( lgout )

      call strcat( direc, 'mag_wfin.dat', openfile)
      open( lgout, file = openfile, status = 'unknown' , err = 9999 )

      call writevector( lgout, mdat, mmagrw, WMAGNM )

      close( lgout )


      stop ' ** poles_inv finished **'
 9999 stop 'oops'
      end       
